# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FileSystemArgs', 'FileSystem']

@pulumi.input_type
class FileSystemArgs:
    def __init__(__self__, *,
                 file_system_name: pulumi.Input[_builtins.str],
                 protocol_type: pulumi.Input[_builtins.str],
                 space_capacity: pulumi.Input[_builtins.int],
                 storage_type: pulumi.Input[_builtins.str],
                 data_redundancy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_number: Optional[pulumi.Input[_builtins.int]] = None,
                 provisioned_throughput_in_mi_bps: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 throughput_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FileSystem resource.
        :param pulumi.Input[_builtins.str] file_system_name: The file system name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
        :param pulumi.Input[_builtins.str] protocol_type: The protocol type. Value: `HDFS`, `PANGU`.
        :param pulumi.Input[_builtins.int] space_capacity: File system capacity.  When the actual amount of data stored reaches the capacity of the file system, data cannot be written.  Unit: GiB.
        :param pulumi.Input[_builtins.str] storage_type: The storage media type. Value: STANDARD (default): STANDARD PERFORMANCE: PERFORMANCE type.
        :param pulumi.Input[_builtins.str] data_redundancy_type: Redundancy mode of the file system. Value:
               - LRS (default): Local redundancy.
               - ZRS: Same-City redundancy. When ZRS is selected, zoneId is a string consisting of multiple zones that are expected to be redundant in the same city, for example,  'zoneId1,zoneId2 '.
        :param pulumi.Input[_builtins.str] dedicated_cluster_id: Dedicated cluster id, which is used to support scenarios such as group cloud migration.
        :param pulumi.Input[_builtins.str] description: The description of the file system resource. No more than 32 characters in length.
        :param pulumi.Input[_builtins.int] partition_number: Save set sequence number, the user selects the content of the specified sequence number in the Save set.
        :param pulumi.Input[_builtins.int] provisioned_throughput_in_mi_bps: Provisioned throughput. This parameter is required when ThroughputMode is set to Provisioned. Unit: MB/s Value range: 1~5120.
        :param pulumi.Input[_builtins.str] storage_set_name: Save set identity, used to select a user-specified save set.
        :param pulumi.Input[_builtins.str] throughput_mode: The throughput mode. Value: Standard (default): Standard throughput Provisioned: preset throughput.
        :param pulumi.Input[_builtins.str] zone_id: Zone Id, which is used to create file system resources to the specified zone.
        """
        pulumi.set(__self__, "file_system_name", file_system_name)
        pulumi.set(__self__, "protocol_type", protocol_type)
        pulumi.set(__self__, "space_capacity", space_capacity)
        pulumi.set(__self__, "storage_type", storage_type)
        if data_redundancy_type is not None:
            pulumi.set(__self__, "data_redundancy_type", data_redundancy_type)
        if dedicated_cluster_id is not None:
            pulumi.set(__self__, "dedicated_cluster_id", dedicated_cluster_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if partition_number is not None:
            pulumi.set(__self__, "partition_number", partition_number)
        if provisioned_throughput_in_mi_bps is not None:
            pulumi.set(__self__, "provisioned_throughput_in_mi_bps", provisioned_throughput_in_mi_bps)
        if storage_set_name is not None:
            pulumi.set(__self__, "storage_set_name", storage_set_name)
        if throughput_mode is not None:
            pulumi.set(__self__, "throughput_mode", throughput_mode)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> pulumi.Input[_builtins.str]:
        """
        The file system name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
        """
        return pulumi.get(self, "file_system_name")

    @file_system_name.setter
    def file_system_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file_system_name", value)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Input[_builtins.str]:
        """
        The protocol type. Value: `HDFS`, `PANGU`.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol_type", value)

    @_builtins.property
    @pulumi.getter(name="spaceCapacity")
    def space_capacity(self) -> pulumi.Input[_builtins.int]:
        """
        File system capacity.  When the actual amount of data stored reaches the capacity of the file system, data cannot be written.  Unit: GiB.
        """
        return pulumi.get(self, "space_capacity")

    @space_capacity.setter
    def space_capacity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "space_capacity", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[_builtins.str]:
        """
        The storage media type. Value: STANDARD (default): STANDARD PERFORMANCE: PERFORMANCE type.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter(name="dataRedundancyType")
    def data_redundancy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Redundancy mode of the file system. Value:
        - LRS (default): Local redundancy.
        - ZRS: Same-City redundancy. When ZRS is selected, zoneId is a string consisting of multiple zones that are expected to be redundant in the same city, for example,  'zoneId1,zoneId2 '.
        """
        return pulumi.get(self, "data_redundancy_type")

    @data_redundancy_type.setter
    def data_redundancy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_redundancy_type", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedClusterId")
    def dedicated_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dedicated cluster id, which is used to support scenarios such as group cloud migration.
        """
        return pulumi.get(self, "dedicated_cluster_id")

    @dedicated_cluster_id.setter
    def dedicated_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the file system resource. No more than 32 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="partitionNumber")
    def partition_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Save set sequence number, the user selects the content of the specified sequence number in the Save set.
        """
        return pulumi.get(self, "partition_number")

    @partition_number.setter
    def partition_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "partition_number", value)

    @_builtins.property
    @pulumi.getter(name="provisionedThroughputInMiBps")
    def provisioned_throughput_in_mi_bps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Provisioned throughput. This parameter is required when ThroughputMode is set to Provisioned. Unit: MB/s Value range: 1~5120.
        """
        return pulumi.get(self, "provisioned_throughput_in_mi_bps")

    @provisioned_throughput_in_mi_bps.setter
    def provisioned_throughput_in_mi_bps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "provisioned_throughput_in_mi_bps", value)

    @_builtins.property
    @pulumi.getter(name="storageSetName")
    def storage_set_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Save set identity, used to select a user-specified save set.
        """
        return pulumi.get(self, "storage_set_name")

    @storage_set_name.setter
    def storage_set_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_set_name", value)

    @_builtins.property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The throughput mode. Value: Standard (default): Standard throughput Provisioned: preset throughput.
        """
        return pulumi.get(self, "throughput_mode")

    @throughput_mode.setter
    def throughput_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "throughput_mode", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone Id, which is used to create file system resources to the specified zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _FileSystemState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_redundancy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_number: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_throughput_in_mi_bps: Optional[pulumi.Input[_builtins.int]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 space_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 throughput_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FileSystem resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the file system instance.
        :param pulumi.Input[_builtins.str] data_redundancy_type: Redundancy mode of the file system. Value:
               - LRS (default): Local redundancy.
               - ZRS: Same-City redundancy. When ZRS is selected, zoneId is a string consisting of multiple zones that are expected to be redundant in the same city, for example,  'zoneId1,zoneId2 '.
        :param pulumi.Input[_builtins.str] dedicated_cluster_id: Dedicated cluster id, which is used to support scenarios such as group cloud migration.
        :param pulumi.Input[_builtins.str] description: The description of the file system resource. No more than 32 characters in length.
        :param pulumi.Input[_builtins.str] file_system_name: The file system name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
        :param pulumi.Input[_builtins.int] partition_number: Save set sequence number, the user selects the content of the specified sequence number in the Save set.
        :param pulumi.Input[_builtins.str] protocol_type: The protocol type. Value: `HDFS`, `PANGU`.
        :param pulumi.Input[_builtins.int] provisioned_throughput_in_mi_bps: Provisioned throughput. This parameter is required when ThroughputMode is set to Provisioned. Unit: MB/s Value range: 1~5120.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.242.0) The region ID of the File System.
        :param pulumi.Input[_builtins.int] space_capacity: File system capacity.  When the actual amount of data stored reaches the capacity of the file system, data cannot be written.  Unit: GiB.
        :param pulumi.Input[_builtins.str] storage_set_name: Save set identity, used to select a user-specified save set.
        :param pulumi.Input[_builtins.str] storage_type: The storage media type. Value: STANDARD (default): STANDARD PERFORMANCE: PERFORMANCE type.
        :param pulumi.Input[_builtins.str] throughput_mode: The throughput mode. Value: Standard (default): Standard throughput Provisioned: preset throughput.
        :param pulumi.Input[_builtins.str] zone_id: Zone Id, which is used to create file system resources to the specified zone.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_redundancy_type is not None:
            pulumi.set(__self__, "data_redundancy_type", data_redundancy_type)
        if dedicated_cluster_id is not None:
            pulumi.set(__self__, "dedicated_cluster_id", dedicated_cluster_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_system_name is not None:
            pulumi.set(__self__, "file_system_name", file_system_name)
        if partition_number is not None:
            pulumi.set(__self__, "partition_number", partition_number)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if provisioned_throughput_in_mi_bps is not None:
            pulumi.set(__self__, "provisioned_throughput_in_mi_bps", provisioned_throughput_in_mi_bps)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if space_capacity is not None:
            pulumi.set(__self__, "space_capacity", space_capacity)
        if storage_set_name is not None:
            pulumi.set(__self__, "storage_set_name", storage_set_name)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if throughput_mode is not None:
            pulumi.set(__self__, "throughput_mode", throughput_mode)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the file system instance.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dataRedundancyType")
    def data_redundancy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Redundancy mode of the file system. Value:
        - LRS (default): Local redundancy.
        - ZRS: Same-City redundancy. When ZRS is selected, zoneId is a string consisting of multiple zones that are expected to be redundant in the same city, for example,  'zoneId1,zoneId2 '.
        """
        return pulumi.get(self, "data_redundancy_type")

    @data_redundancy_type.setter
    def data_redundancy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_redundancy_type", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedClusterId")
    def dedicated_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dedicated cluster id, which is used to support scenarios such as group cloud migration.
        """
        return pulumi.get(self, "dedicated_cluster_id")

    @dedicated_cluster_id.setter
    def dedicated_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the file system resource. No more than 32 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The file system name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
        """
        return pulumi.get(self, "file_system_name")

    @file_system_name.setter
    def file_system_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_name", value)

    @_builtins.property
    @pulumi.getter(name="partitionNumber")
    def partition_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Save set sequence number, the user selects the content of the specified sequence number in the Save set.
        """
        return pulumi.get(self, "partition_number")

    @partition_number.setter
    def partition_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "partition_number", value)

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol type. Value: `HDFS`, `PANGU`.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol_type", value)

    @_builtins.property
    @pulumi.getter(name="provisionedThroughputInMiBps")
    def provisioned_throughput_in_mi_bps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Provisioned throughput. This parameter is required when ThroughputMode is set to Provisioned. Unit: MB/s Value range: 1~5120.
        """
        return pulumi.get(self, "provisioned_throughput_in_mi_bps")

    @provisioned_throughput_in_mi_bps.setter
    def provisioned_throughput_in_mi_bps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "provisioned_throughput_in_mi_bps", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.242.0) The region ID of the File System.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="spaceCapacity")
    def space_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        File system capacity.  When the actual amount of data stored reaches the capacity of the file system, data cannot be written.  Unit: GiB.
        """
        return pulumi.get(self, "space_capacity")

    @space_capacity.setter
    def space_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "space_capacity", value)

    @_builtins.property
    @pulumi.getter(name="storageSetName")
    def storage_set_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Save set identity, used to select a user-specified save set.
        """
        return pulumi.get(self, "storage_set_name")

    @storage_set_name.setter
    def storage_set_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_set_name", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage media type. Value: STANDARD (default): STANDARD PERFORMANCE: PERFORMANCE type.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The throughput mode. Value: Standard (default): Standard throughput Provisioned: preset throughput.
        """
        return pulumi.get(self, "throughput_mode")

    @throughput_mode.setter
    def throughput_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "throughput_mode", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone Id, which is used to create file system resources to the specified zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:dfs/fileSystem:FileSystem")
class FileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_redundancy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_number: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_throughput_in_mi_bps: Optional[pulumi.Input[_builtins.int]] = None,
                 space_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 throughput_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Apsara File Storage for HDFS (DFS) File System resource.

        For information about Apsara File Storage for HDFS (DFS) File System and how to use it, see [What is File System](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).

        > **NOTE:** Available since v1.140.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.dfs.FileSystem("default",
            storage_type="PERFORMANCE",
            zone_id="cn-hangzhou-b",
            protocol_type="PANGU",
            description=name,
            file_system_name=name,
            throughput_mode="Provisioned",
            space_capacity=1024,
            provisioned_throughput_in_mi_bps=512)
        ```

        ## Import

        Apsara File Storage for HDFS (DFS) File System can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dfs/fileSystem:FileSystem example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_redundancy_type: Redundancy mode of the file system. Value:
               - LRS (default): Local redundancy.
               - ZRS: Same-City redundancy. When ZRS is selected, zoneId is a string consisting of multiple zones that are expected to be redundant in the same city, for example,  'zoneId1,zoneId2 '.
        :param pulumi.Input[_builtins.str] dedicated_cluster_id: Dedicated cluster id, which is used to support scenarios such as group cloud migration.
        :param pulumi.Input[_builtins.str] description: The description of the file system resource. No more than 32 characters in length.
        :param pulumi.Input[_builtins.str] file_system_name: The file system name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
        :param pulumi.Input[_builtins.int] partition_number: Save set sequence number, the user selects the content of the specified sequence number in the Save set.
        :param pulumi.Input[_builtins.str] protocol_type: The protocol type. Value: `HDFS`, `PANGU`.
        :param pulumi.Input[_builtins.int] provisioned_throughput_in_mi_bps: Provisioned throughput. This parameter is required when ThroughputMode is set to Provisioned. Unit: MB/s Value range: 1~5120.
        :param pulumi.Input[_builtins.int] space_capacity: File system capacity.  When the actual amount of data stored reaches the capacity of the file system, data cannot be written.  Unit: GiB.
        :param pulumi.Input[_builtins.str] storage_set_name: Save set identity, used to select a user-specified save set.
        :param pulumi.Input[_builtins.str] storage_type: The storage media type. Value: STANDARD (default): STANDARD PERFORMANCE: PERFORMANCE type.
        :param pulumi.Input[_builtins.str] throughput_mode: The throughput mode. Value: Standard (default): Standard throughput Provisioned: preset throughput.
        :param pulumi.Input[_builtins.str] zone_id: Zone Id, which is used to create file system resources to the specified zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Apsara File Storage for HDFS (DFS) File System resource.

        For information about Apsara File Storage for HDFS (DFS) File System and how to use it, see [What is File System](https://www.alibabacloud.com/help/en/aibaba-cloud-storage-services/latest/apsara-file-storage-for-hdfs).

        > **NOTE:** Available since v1.140.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.dfs.FileSystem("default",
            storage_type="PERFORMANCE",
            zone_id="cn-hangzhou-b",
            protocol_type="PANGU",
            description=name,
            file_system_name=name,
            throughput_mode="Provisioned",
            space_capacity=1024,
            provisioned_throughput_in_mi_bps=512)
        ```

        ## Import

        Apsara File Storage for HDFS (DFS) File System can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dfs/fileSystem:FileSystem example <id>
        ```

        :param str resource_name: The name of the resource.
        :param FileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_redundancy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_number: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioned_throughput_in_mi_bps: Optional[pulumi.Input[_builtins.int]] = None,
                 space_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 throughput_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileSystemArgs.__new__(FileSystemArgs)

            __props__.__dict__["data_redundancy_type"] = data_redundancy_type
            __props__.__dict__["dedicated_cluster_id"] = dedicated_cluster_id
            __props__.__dict__["description"] = description
            if file_system_name is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_name'")
            __props__.__dict__["file_system_name"] = file_system_name
            __props__.__dict__["partition_number"] = partition_number
            if protocol_type is None and not opts.urn:
                raise TypeError("Missing required property 'protocol_type'")
            __props__.__dict__["protocol_type"] = protocol_type
            __props__.__dict__["provisioned_throughput_in_mi_bps"] = provisioned_throughput_in_mi_bps
            if space_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'space_capacity'")
            __props__.__dict__["space_capacity"] = space_capacity
            __props__.__dict__["storage_set_name"] = storage_set_name
            if storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_type'")
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["throughput_mode"] = throughput_mode
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
        super(FileSystem, __self__).__init__(
            'alicloud:dfs/fileSystem:FileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_redundancy_type: Optional[pulumi.Input[_builtins.str]] = None,
            dedicated_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            file_system_name: Optional[pulumi.Input[_builtins.str]] = None,
            partition_number: Optional[pulumi.Input[_builtins.int]] = None,
            protocol_type: Optional[pulumi.Input[_builtins.str]] = None,
            provisioned_throughput_in_mi_bps: Optional[pulumi.Input[_builtins.int]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            space_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            storage_set_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            throughput_mode: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'FileSystem':
        """
        Get an existing FileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the file system instance.
        :param pulumi.Input[_builtins.str] data_redundancy_type: Redundancy mode of the file system. Value:
               - LRS (default): Local redundancy.
               - ZRS: Same-City redundancy. When ZRS is selected, zoneId is a string consisting of multiple zones that are expected to be redundant in the same city, for example,  'zoneId1,zoneId2 '.
        :param pulumi.Input[_builtins.str] dedicated_cluster_id: Dedicated cluster id, which is used to support scenarios such as group cloud migration.
        :param pulumi.Input[_builtins.str] description: The description of the file system resource. No more than 32 characters in length.
        :param pulumi.Input[_builtins.str] file_system_name: The file system name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
        :param pulumi.Input[_builtins.int] partition_number: Save set sequence number, the user selects the content of the specified sequence number in the Save set.
        :param pulumi.Input[_builtins.str] protocol_type: The protocol type. Value: `HDFS`, `PANGU`.
        :param pulumi.Input[_builtins.int] provisioned_throughput_in_mi_bps: Provisioned throughput. This parameter is required when ThroughputMode is set to Provisioned. Unit: MB/s Value range: 1~5120.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.242.0) The region ID of the File System.
        :param pulumi.Input[_builtins.int] space_capacity: File system capacity.  When the actual amount of data stored reaches the capacity of the file system, data cannot be written.  Unit: GiB.
        :param pulumi.Input[_builtins.str] storage_set_name: Save set identity, used to select a user-specified save set.
        :param pulumi.Input[_builtins.str] storage_type: The storage media type. Value: STANDARD (default): STANDARD PERFORMANCE: PERFORMANCE type.
        :param pulumi.Input[_builtins.str] throughput_mode: The throughput mode. Value: Standard (default): Standard throughput Provisioned: preset throughput.
        :param pulumi.Input[_builtins.str] zone_id: Zone Id, which is used to create file system resources to the specified zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileSystemState.__new__(_FileSystemState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_redundancy_type"] = data_redundancy_type
        __props__.__dict__["dedicated_cluster_id"] = dedicated_cluster_id
        __props__.__dict__["description"] = description
        __props__.__dict__["file_system_name"] = file_system_name
        __props__.__dict__["partition_number"] = partition_number
        __props__.__dict__["protocol_type"] = protocol_type
        __props__.__dict__["provisioned_throughput_in_mi_bps"] = provisioned_throughput_in_mi_bps
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["space_capacity"] = space_capacity
        __props__.__dict__["storage_set_name"] = storage_set_name
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["throughput_mode"] = throughput_mode
        __props__.__dict__["zone_id"] = zone_id
        return FileSystem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the file system instance.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataRedundancyType")
    def data_redundancy_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Redundancy mode of the file system. Value:
        - LRS (default): Local redundancy.
        - ZRS: Same-City redundancy. When ZRS is selected, zoneId is a string consisting of multiple zones that are expected to be redundant in the same city, for example,  'zoneId1,zoneId2 '.
        """
        return pulumi.get(self, "data_redundancy_type")

    @_builtins.property
    @pulumi.getter(name="dedicatedClusterId")
    def dedicated_cluster_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Dedicated cluster id, which is used to support scenarios such as group cloud migration.
        """
        return pulumi.get(self, "dedicated_cluster_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the file system resource. No more than 32 characters in length.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> pulumi.Output[_builtins.str]:
        """
        The file system name. The naming rules are as follows: The length is 6~64 characters. Globally unique and cannot be an empty string. English letters are supported and can contain numbers, underscores (_), and dashes (-).
        """
        return pulumi.get(self, "file_system_name")

    @_builtins.property
    @pulumi.getter(name="partitionNumber")
    def partition_number(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Save set sequence number, the user selects the content of the specified sequence number in the Save set.
        """
        return pulumi.get(self, "partition_number")

    @_builtins.property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Output[_builtins.str]:
        """
        The protocol type. Value: `HDFS`, `PANGU`.
        """
        return pulumi.get(self, "protocol_type")

    @_builtins.property
    @pulumi.getter(name="provisionedThroughputInMiBps")
    def provisioned_throughput_in_mi_bps(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Provisioned throughput. This parameter is required when ThroughputMode is set to Provisioned. Unit: MB/s Value range: 1~5120.
        """
        return pulumi.get(self, "provisioned_throughput_in_mi_bps")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.242.0) The region ID of the File System.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="spaceCapacity")
    def space_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        File system capacity.  When the actual amount of data stored reaches the capacity of the file system, data cannot be written.  Unit: GiB.
        """
        return pulumi.get(self, "space_capacity")

    @_builtins.property
    @pulumi.getter(name="storageSetName")
    def storage_set_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Save set identity, used to select a user-specified save set.
        """
        return pulumi.get(self, "storage_set_name")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[_builtins.str]:
        """
        The storage media type. Value: STANDARD (default): STANDARD PERFORMANCE: PERFORMANCE type.
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The throughput mode. Value: Standard (default): Standard throughput Provisioned: preset throughput.
        """
        return pulumi.get(self, "throughput_mode")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Zone Id, which is used to create file system resources to the specified zone.
        """
        return pulumi.get(self, "zone_id")

