# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ReceiversArgs', 'Receivers']

@pulumi.input_type
class ReceiversArgs:
    def __init__(__self__, *,
                 receivers_alias: pulumi.Input[_builtins.str],
                 receivers_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Receivers resource.
        :param pulumi.Input[_builtins.str] receivers_alias: The alias of receivers. Must email address and less than 30 characters in length.
        :param pulumi.Input[_builtins.str] receivers_name: The name of the resource. The length that cannot be repeated is 1-30 characters.
        :param pulumi.Input[_builtins.str] description: The description of receivers and 1-50 characters in length.
        """
        pulumi.set(__self__, "receivers_alias", receivers_alias)
        pulumi.set(__self__, "receivers_name", receivers_name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="receiversAlias")
    def receivers_alias(self) -> pulumi.Input[_builtins.str]:
        """
        The alias of receivers. Must email address and less than 30 characters in length.
        """
        return pulumi.get(self, "receivers_alias")

    @receivers_alias.setter
    def receivers_alias(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "receivers_alias", value)

    @_builtins.property
    @pulumi.getter(name="receiversName")
    def receivers_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource. The length that cannot be repeated is 1-30 characters.
        """
        return pulumi.get(self, "receivers_name")

    @receivers_name.setter
    def receivers_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "receivers_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of receivers and 1-50 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _ReceiversState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 receivers_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 receivers_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Receivers resources.
        :param pulumi.Input[_builtins.str] description: The description of receivers and 1-50 characters in length.
        :param pulumi.Input[_builtins.str] receivers_alias: The alias of receivers. Must email address and less than 30 characters in length.
        :param pulumi.Input[_builtins.str] receivers_name: The name of the resource. The length that cannot be repeated is 1-30 characters.
        :param pulumi.Input[_builtins.int] status: The status of the resource. `0` means uploading, `1` means upload completed.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if receivers_alias is not None:
            pulumi.set(__self__, "receivers_alias", receivers_alias)
        if receivers_name is not None:
            pulumi.set(__self__, "receivers_name", receivers_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of receivers and 1-50 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="receiversAlias")
    def receivers_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alias of receivers. Must email address and less than 30 characters in length.
        """
        return pulumi.get(self, "receivers_alias")

    @receivers_alias.setter
    def receivers_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "receivers_alias", value)

    @_builtins.property
    @pulumi.getter(name="receiversName")
    def receivers_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource. The length that cannot be repeated is 1-30 characters.
        """
        return pulumi.get(self, "receivers_name")

    @receivers_name.setter
    def receivers_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "receivers_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The status of the resource. `0` means uploading, `1` means upload completed.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:directmail/receivers:Receivers")
class Receivers(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 receivers_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 receivers_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Direct Mail Receivers resource.

        For information about Direct Mail Receivers and how to use it, see [What is Direct Mail Receivers](https://www.alibabacloud.com/help/en/doc-detail/29414.htm).

        > **NOTE:** Available since v1.125.0.

        ## Import

        Direct Mail Receivers can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:directmail/receivers:Receivers example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of receivers and 1-50 characters in length.
        :param pulumi.Input[_builtins.str] receivers_alias: The alias of receivers. Must email address and less than 30 characters in length.
        :param pulumi.Input[_builtins.str] receivers_name: The name of the resource. The length that cannot be repeated is 1-30 characters.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReceiversArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Direct Mail Receivers resource.

        For information about Direct Mail Receivers and how to use it, see [What is Direct Mail Receivers](https://www.alibabacloud.com/help/en/doc-detail/29414.htm).

        > **NOTE:** Available since v1.125.0.

        ## Import

        Direct Mail Receivers can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:directmail/receivers:Receivers example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ReceiversArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReceiversArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 receivers_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 receivers_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReceiversArgs.__new__(ReceiversArgs)

            __props__.__dict__["description"] = description
            if receivers_alias is None and not opts.urn:
                raise TypeError("Missing required property 'receivers_alias'")
            __props__.__dict__["receivers_alias"] = receivers_alias
            if receivers_name is None and not opts.urn:
                raise TypeError("Missing required property 'receivers_name'")
            __props__.__dict__["receivers_name"] = receivers_name
            __props__.__dict__["status"] = None
        super(Receivers, __self__).__init__(
            'alicloud:directmail/receivers:Receivers',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            receivers_alias: Optional[pulumi.Input[_builtins.str]] = None,
            receivers_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None) -> 'Receivers':
        """
        Get an existing Receivers resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of receivers and 1-50 characters in length.
        :param pulumi.Input[_builtins.str] receivers_alias: The alias of receivers. Must email address and less than 30 characters in length.
        :param pulumi.Input[_builtins.str] receivers_name: The name of the resource. The length that cannot be repeated is 1-30 characters.
        :param pulumi.Input[_builtins.int] status: The status of the resource. `0` means uploading, `1` means upload completed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReceiversState.__new__(_ReceiversState)

        __props__.__dict__["description"] = description
        __props__.__dict__["receivers_alias"] = receivers_alias
        __props__.__dict__["receivers_name"] = receivers_name
        __props__.__dict__["status"] = status
        return Receivers(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of receivers and 1-50 characters in length.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="receiversAlias")
    def receivers_alias(self) -> pulumi.Output[_builtins.str]:
        """
        The alias of receivers. Must email address and less than 30 characters in length.
        """
        return pulumi.get(self, "receivers_alias")

    @_builtins.property
    @pulumi.getter(name="receiversName")
    def receivers_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource. The length that cannot be repeated is 1-30 characters.
        """
        return pulumi.get(self, "receivers_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        The status of the resource. `0` means uploading, `1` means upload completed.
        """
        return pulumi.get(self, "status")

