# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GtmInstanceArgs', 'GtmInstance']

@pulumi.input_type
class GtmInstanceArgs:
    def __init__(__self__, *,
                 health_check_task_count: pulumi.Input[_builtins.int],
                 instance_name: pulumi.Input[_builtins.str],
                 package_edition: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 period: pulumi.Input[_builtins.int],
                 sms_notification_count: pulumi.Input[_builtins.int],
                 alert_configs: Optional[pulumi.Input[Sequence[pulumi.Input['GtmInstanceAlertConfigArgs']]]] = None,
                 alert_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cname_type: Optional[pulumi.Input[_builtins.str]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 public_cname_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 public_rr: Optional[pulumi.Input[_builtins.str]] = None,
                 public_user_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_zone_name: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 strategy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a GtmInstance resource.
        :param pulumi.Input[_builtins.int] health_check_task_count: The quota of detection tasks.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance.
        :param pulumi.Input[_builtins.str] package_edition: Paid package version. Valid values: `ultimate`, `standard`.
        :param pulumi.Input[_builtins.str] payment_type: The Payment Type of the resource. Valid value: `Subscription`.
        :param pulumi.Input[_builtins.int] period: Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
        :param pulumi.Input[_builtins.int] sms_notification_count: The quota of SMS notifications.
        :param pulumi.Input[Sequence[pulumi.Input['GtmInstanceAlertConfigArgs']]] alert_configs: The alert notification methods. See `alert_config` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alert_groups: The alert group.
        :param pulumi.Input[_builtins.str] cname_type: The access type of the CNAME domain name. Valid value: `PUBLIC`.
        :param pulumi.Input[_builtins.bool] force_update: The force update.
        :param pulumi.Input[_builtins.str] lang: The lang.
        :param pulumi.Input[_builtins.str] public_cname_mode: The Public Network domain name access method. Valid values: `CUSTOM`, `SYSTEM_ASSIGN`.
        :param pulumi.Input[_builtins.str] public_rr: The CNAME access domain name.
        :param pulumi.Input[_builtins.str] public_user_domain_name: The website domain name that the user uses on the Internet.
        :param pulumi.Input[_builtins.str] public_zone_name: The domain name that is used to access GTM over the Internet.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period, the unit is month. When setting `renewal_status` to AutoRenewal, it must be set.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] strategy_mode: The type of the access policy. Valid values: `GEO`, `LATENCY`.
        :param pulumi.Input[_builtins.int] ttl: The global time to live. Valid values: `60`, `120`, `300`, `600`. Unit: second.
        """
        pulumi.set(__self__, "health_check_task_count", health_check_task_count)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "package_edition", package_edition)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "sms_notification_count", sms_notification_count)
        if alert_configs is not None:
            pulumi.set(__self__, "alert_configs", alert_configs)
        if alert_groups is not None:
            pulumi.set(__self__, "alert_groups", alert_groups)
        if cname_type is not None:
            pulumi.set(__self__, "cname_type", cname_type)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if public_cname_mode is not None:
            pulumi.set(__self__, "public_cname_mode", public_cname_mode)
        if public_rr is not None:
            pulumi.set(__self__, "public_rr", public_rr)
        if public_user_domain_name is not None:
            pulumi.set(__self__, "public_user_domain_name", public_user_domain_name)
        if public_zone_name is not None:
            pulumi.set(__self__, "public_zone_name", public_zone_name)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if strategy_mode is not None:
            pulumi.set(__self__, "strategy_mode", strategy_mode)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="healthCheckTaskCount")
    def health_check_task_count(self) -> pulumi.Input[_builtins.int]:
        """
        The quota of detection tasks.
        """
        return pulumi.get(self, "health_check_task_count")

    @health_check_task_count.setter
    def health_check_task_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "health_check_task_count", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="packageEdition")
    def package_edition(self) -> pulumi.Input[_builtins.str]:
        """
        Paid package version. Valid values: `ultimate`, `standard`.
        """
        return pulumi.get(self, "package_edition")

    @package_edition.setter
    def package_edition(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "package_edition", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The Payment Type of the resource. Valid value: `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Input[_builtins.int]:
        """
        Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="smsNotificationCount")
    def sms_notification_count(self) -> pulumi.Input[_builtins.int]:
        """
        The quota of SMS notifications.
        """
        return pulumi.get(self, "sms_notification_count")

    @sms_notification_count.setter
    def sms_notification_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "sms_notification_count", value)

    @_builtins.property
    @pulumi.getter(name="alertConfigs")
    def alert_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GtmInstanceAlertConfigArgs']]]]:
        """
        The alert notification methods. See `alert_config` below for details.
        """
        return pulumi.get(self, "alert_configs")

    @alert_configs.setter
    def alert_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GtmInstanceAlertConfigArgs']]]]):
        pulumi.set(self, "alert_configs", value)

    @_builtins.property
    @pulumi.getter(name="alertGroups")
    def alert_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The alert group.
        """
        return pulumi.get(self, "alert_groups")

    @alert_groups.setter
    def alert_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alert_groups", value)

    @_builtins.property
    @pulumi.getter(name="cnameType")
    def cname_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access type of the CNAME domain name. Valid value: `PUBLIC`.
        """
        return pulumi.get(self, "cname_type")

    @cname_type.setter
    def cname_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cname_type", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The force update.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_update", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lang.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="publicCnameMode")
    def public_cname_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Public Network domain name access method. Valid values: `CUSTOM`, `SYSTEM_ASSIGN`.
        """
        return pulumi.get(self, "public_cname_mode")

    @public_cname_mode.setter
    def public_cname_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_cname_mode", value)

    @_builtins.property
    @pulumi.getter(name="publicRr")
    def public_rr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CNAME access domain name.
        """
        return pulumi.get(self, "public_rr")

    @public_rr.setter
    def public_rr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_rr", value)

    @_builtins.property
    @pulumi.getter(name="publicUserDomainName")
    def public_user_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The website domain name that the user uses on the Internet.
        """
        return pulumi.get(self, "public_user_domain_name")

    @public_user_domain_name.setter
    def public_user_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_user_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="publicZoneName")
    def public_zone_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name that is used to access GTM over the Internet.
        """
        return pulumi.get(self, "public_zone_name")

    @public_zone_name.setter
    def public_zone_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_zone_name", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal period, the unit is month. When setting `renewal_status` to AutoRenewal, it must be set.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="strategyMode")
    def strategy_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the access policy. Valid values: `GEO`, `LATENCY`.
        """
        return pulumi.get(self, "strategy_mode")

    @strategy_mode.setter
    def strategy_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "strategy_mode", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The global time to live. Valid values: `60`, `120`, `300`, `600`. Unit: second.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _GtmInstanceState:
    def __init__(__self__, *,
                 alert_configs: Optional[pulumi.Input[Sequence[pulumi.Input['GtmInstanceAlertConfigArgs']]]] = None,
                 alert_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cname_type: Optional[pulumi.Input[_builtins.str]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_task_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 package_edition: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 public_cname_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 public_rr: Optional[pulumi.Input[_builtins.str]] = None,
                 public_user_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_zone_name: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sms_notification_count: Optional[pulumi.Input[_builtins.int]] = None,
                 strategy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering GtmInstance resources.
        :param pulumi.Input[Sequence[pulumi.Input['GtmInstanceAlertConfigArgs']]] alert_configs: The alert notification methods. See `alert_config` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alert_groups: The alert group.
        :param pulumi.Input[_builtins.str] cname_type: The access type of the CNAME domain name. Valid value: `PUBLIC`.
        :param pulumi.Input[_builtins.bool] force_update: The force update.
        :param pulumi.Input[_builtins.int] health_check_task_count: The quota of detection tasks.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance.
        :param pulumi.Input[_builtins.str] lang: The lang.
        :param pulumi.Input[_builtins.str] package_edition: Paid package version. Valid values: `ultimate`, `standard`.
        :param pulumi.Input[_builtins.str] payment_type: The Payment Type of the resource. Valid value: `Subscription`.
        :param pulumi.Input[_builtins.int] period: Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
        :param pulumi.Input[_builtins.str] public_cname_mode: The Public Network domain name access method. Valid values: `CUSTOM`, `SYSTEM_ASSIGN`.
        :param pulumi.Input[_builtins.str] public_rr: The CNAME access domain name.
        :param pulumi.Input[_builtins.str] public_user_domain_name: The website domain name that the user uses on the Internet.
        :param pulumi.Input[_builtins.str] public_zone_name: The domain name that is used to access GTM over the Internet.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period, the unit is month. When setting `renewal_status` to AutoRenewal, it must be set.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.int] sms_notification_count: The quota of SMS notifications.
        :param pulumi.Input[_builtins.str] strategy_mode: The type of the access policy. Valid values: `GEO`, `LATENCY`.
        :param pulumi.Input[_builtins.int] ttl: The global time to live. Valid values: `60`, `120`, `300`, `600`. Unit: second.
        """
        if alert_configs is not None:
            pulumi.set(__self__, "alert_configs", alert_configs)
        if alert_groups is not None:
            pulumi.set(__self__, "alert_groups", alert_groups)
        if cname_type is not None:
            pulumi.set(__self__, "cname_type", cname_type)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if health_check_task_count is not None:
            pulumi.set(__self__, "health_check_task_count", health_check_task_count)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)
        if package_edition is not None:
            pulumi.set(__self__, "package_edition", package_edition)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_cname_mode is not None:
            pulumi.set(__self__, "public_cname_mode", public_cname_mode)
        if public_rr is not None:
            pulumi.set(__self__, "public_rr", public_rr)
        if public_user_domain_name is not None:
            pulumi.set(__self__, "public_user_domain_name", public_user_domain_name)
        if public_zone_name is not None:
            pulumi.set(__self__, "public_zone_name", public_zone_name)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if sms_notification_count is not None:
            pulumi.set(__self__, "sms_notification_count", sms_notification_count)
        if strategy_mode is not None:
            pulumi.set(__self__, "strategy_mode", strategy_mode)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="alertConfigs")
    def alert_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GtmInstanceAlertConfigArgs']]]]:
        """
        The alert notification methods. See `alert_config` below for details.
        """
        return pulumi.get(self, "alert_configs")

    @alert_configs.setter
    def alert_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GtmInstanceAlertConfigArgs']]]]):
        pulumi.set(self, "alert_configs", value)

    @_builtins.property
    @pulumi.getter(name="alertGroups")
    def alert_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The alert group.
        """
        return pulumi.get(self, "alert_groups")

    @alert_groups.setter
    def alert_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alert_groups", value)

    @_builtins.property
    @pulumi.getter(name="cnameType")
    def cname_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access type of the CNAME domain name. Valid value: `PUBLIC`.
        """
        return pulumi.get(self, "cname_type")

    @cname_type.setter
    def cname_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cname_type", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The force update.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_update", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTaskCount")
    def health_check_task_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The quota of detection tasks.
        """
        return pulumi.get(self, "health_check_task_count")

    @health_check_task_count.setter
    def health_check_task_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_task_count", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lang.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lang", value)

    @_builtins.property
    @pulumi.getter(name="packageEdition")
    def package_edition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Paid package version. Valid values: `ultimate`, `standard`.
        """
        return pulumi.get(self, "package_edition")

    @package_edition.setter
    def package_edition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_edition", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Payment Type of the resource. Valid value: `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="publicCnameMode")
    def public_cname_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Public Network domain name access method. Valid values: `CUSTOM`, `SYSTEM_ASSIGN`.
        """
        return pulumi.get(self, "public_cname_mode")

    @public_cname_mode.setter
    def public_cname_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_cname_mode", value)

    @_builtins.property
    @pulumi.getter(name="publicRr")
    def public_rr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CNAME access domain name.
        """
        return pulumi.get(self, "public_rr")

    @public_rr.setter
    def public_rr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_rr", value)

    @_builtins.property
    @pulumi.getter(name="publicUserDomainName")
    def public_user_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The website domain name that the user uses on the Internet.
        """
        return pulumi.get(self, "public_user_domain_name")

    @public_user_domain_name.setter
    def public_user_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_user_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="publicZoneName")
    def public_zone_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name that is used to access GTM over the Internet.
        """
        return pulumi.get(self, "public_zone_name")

    @public_zone_name.setter
    def public_zone_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_zone_name", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal period, the unit is month. When setting `renewal_status` to AutoRenewal, it must be set.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="smsNotificationCount")
    def sms_notification_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The quota of SMS notifications.
        """
        return pulumi.get(self, "sms_notification_count")

    @sms_notification_count.setter
    def sms_notification_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sms_notification_count", value)

    @_builtins.property
    @pulumi.getter(name="strategyMode")
    def strategy_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the access policy. Valid values: `GEO`, `LATENCY`.
        """
        return pulumi.get(self, "strategy_mode")

    @strategy_mode.setter
    def strategy_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "strategy_mode", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The global time to live. Valid values: `60`, `120`, `300`, `600`. Unit: second.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)


@pulumi.type_token("alicloud:dns/gtmInstance:GtmInstance")
class GtmInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GtmInstanceAlertConfigArgs', 'GtmInstanceAlertConfigArgsDict']]]]] = None,
                 alert_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cname_type: Optional[pulumi.Input[_builtins.str]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_task_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 package_edition: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 public_cname_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 public_rr: Optional[pulumi.Input[_builtins.str]] = None,
                 public_user_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_zone_name: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sms_notification_count: Optional[pulumi.Input[_builtins.int]] = None,
                 strategy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Alidns Gtm Instance resource.

        For information about Alidns Gtm Instance and how to use it, see [What is Gtm Instance](https://www.alibabacloud.com/help/en/doc-detail/204852.html).

        > **NOTE:** Available since v1.151.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        domain_name = config.get("domainName")
        if domain_name is None:
            domain_name = "alicloud-provider.com"
        default = alicloud.resourcemanager.get_resource_groups()
        default_alarm_contact_group = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name="tf_example")
        default_gtm_instance = alicloud.dns.GtmInstance("default",
            instance_name="tf_example",
            payment_type="Subscription",
            period=1,
            renewal_status="ManualRenewal",
            package_edition="standard",
            health_check_task_count=100,
            sms_notification_count=1000,
            public_cname_mode="SYSTEM_ASSIGN",
            ttl=60,
            cname_type="PUBLIC",
            resource_group_id=default.groups[0].id,
            alert_groups=[default_alarm_contact_group.alarm_contact_group_name],
            public_user_domain_name=domain_name,
            alert_configs=[{
                "sms_notice": True,
                "notice_type": "ADDR_ALERT",
                "email_notice": True,
                "dingtalk_notice": True,
            }])
        ```

        ## Import

        Alidns Gtm Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dns/gtmInstance:GtmInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GtmInstanceAlertConfigArgs', 'GtmInstanceAlertConfigArgsDict']]]] alert_configs: The alert notification methods. See `alert_config` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alert_groups: The alert group.
        :param pulumi.Input[_builtins.str] cname_type: The access type of the CNAME domain name. Valid value: `PUBLIC`.
        :param pulumi.Input[_builtins.bool] force_update: The force update.
        :param pulumi.Input[_builtins.int] health_check_task_count: The quota of detection tasks.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance.
        :param pulumi.Input[_builtins.str] lang: The lang.
        :param pulumi.Input[_builtins.str] package_edition: Paid package version. Valid values: `ultimate`, `standard`.
        :param pulumi.Input[_builtins.str] payment_type: The Payment Type of the resource. Valid value: `Subscription`.
        :param pulumi.Input[_builtins.int] period: Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
        :param pulumi.Input[_builtins.str] public_cname_mode: The Public Network domain name access method. Valid values: `CUSTOM`, `SYSTEM_ASSIGN`.
        :param pulumi.Input[_builtins.str] public_rr: The CNAME access domain name.
        :param pulumi.Input[_builtins.str] public_user_domain_name: The website domain name that the user uses on the Internet.
        :param pulumi.Input[_builtins.str] public_zone_name: The domain name that is used to access GTM over the Internet.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period, the unit is month. When setting `renewal_status` to AutoRenewal, it must be set.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.int] sms_notification_count: The quota of SMS notifications.
        :param pulumi.Input[_builtins.str] strategy_mode: The type of the access policy. Valid values: `GEO`, `LATENCY`.
        :param pulumi.Input[_builtins.int] ttl: The global time to live. Valid values: `60`, `120`, `300`, `600`. Unit: second.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GtmInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Alidns Gtm Instance resource.

        For information about Alidns Gtm Instance and how to use it, see [What is Gtm Instance](https://www.alibabacloud.com/help/en/doc-detail/204852.html).

        > **NOTE:** Available since v1.151.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        domain_name = config.get("domainName")
        if domain_name is None:
            domain_name = "alicloud-provider.com"
        default = alicloud.resourcemanager.get_resource_groups()
        default_alarm_contact_group = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name="tf_example")
        default_gtm_instance = alicloud.dns.GtmInstance("default",
            instance_name="tf_example",
            payment_type="Subscription",
            period=1,
            renewal_status="ManualRenewal",
            package_edition="standard",
            health_check_task_count=100,
            sms_notification_count=1000,
            public_cname_mode="SYSTEM_ASSIGN",
            ttl=60,
            cname_type="PUBLIC",
            resource_group_id=default.groups[0].id,
            alert_groups=[default_alarm_contact_group.alarm_contact_group_name],
            public_user_domain_name=domain_name,
            alert_configs=[{
                "sms_notice": True,
                "notice_type": "ADDR_ALERT",
                "email_notice": True,
                "dingtalk_notice": True,
            }])
        ```

        ## Import

        Alidns Gtm Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dns/gtmInstance:GtmInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param GtmInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GtmInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GtmInstanceAlertConfigArgs', 'GtmInstanceAlertConfigArgsDict']]]]] = None,
                 alert_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cname_type: Optional[pulumi.Input[_builtins.str]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 health_check_task_count: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lang: Optional[pulumi.Input[_builtins.str]] = None,
                 package_edition: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 public_cname_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 public_rr: Optional[pulumi.Input[_builtins.str]] = None,
                 public_user_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_zone_name: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sms_notification_count: Optional[pulumi.Input[_builtins.int]] = None,
                 strategy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GtmInstanceArgs.__new__(GtmInstanceArgs)

            __props__.__dict__["alert_configs"] = alert_configs
            __props__.__dict__["alert_groups"] = alert_groups
            __props__.__dict__["cname_type"] = cname_type
            __props__.__dict__["force_update"] = force_update
            if health_check_task_count is None and not opts.urn:
                raise TypeError("Missing required property 'health_check_task_count'")
            __props__.__dict__["health_check_task_count"] = health_check_task_count
            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["lang"] = lang
            if package_edition is None and not opts.urn:
                raise TypeError("Missing required property 'package_edition'")
            __props__.__dict__["package_edition"] = package_edition
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            if period is None and not opts.urn:
                raise TypeError("Missing required property 'period'")
            __props__.__dict__["period"] = period
            __props__.__dict__["public_cname_mode"] = public_cname_mode
            __props__.__dict__["public_rr"] = public_rr
            __props__.__dict__["public_user_domain_name"] = public_user_domain_name
            __props__.__dict__["public_zone_name"] = public_zone_name
            __props__.__dict__["renew_period"] = renew_period
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["resource_group_id"] = resource_group_id
            if sms_notification_count is None and not opts.urn:
                raise TypeError("Missing required property 'sms_notification_count'")
            __props__.__dict__["sms_notification_count"] = sms_notification_count
            __props__.__dict__["strategy_mode"] = strategy_mode
            __props__.__dict__["ttl"] = ttl
        super(GtmInstance, __self__).__init__(
            'alicloud:dns/gtmInstance:GtmInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GtmInstanceAlertConfigArgs', 'GtmInstanceAlertConfigArgsDict']]]]] = None,
            alert_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cname_type: Optional[pulumi.Input[_builtins.str]] = None,
            force_update: Optional[pulumi.Input[_builtins.bool]] = None,
            health_check_task_count: Optional[pulumi.Input[_builtins.int]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            lang: Optional[pulumi.Input[_builtins.str]] = None,
            package_edition: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            public_cname_mode: Optional[pulumi.Input[_builtins.str]] = None,
            public_rr: Optional[pulumi.Input[_builtins.str]] = None,
            public_user_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            public_zone_name: Optional[pulumi.Input[_builtins.str]] = None,
            renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            renewal_status: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            sms_notification_count: Optional[pulumi.Input[_builtins.int]] = None,
            strategy_mode: Optional[pulumi.Input[_builtins.str]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None) -> 'GtmInstance':
        """
        Get an existing GtmInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GtmInstanceAlertConfigArgs', 'GtmInstanceAlertConfigArgsDict']]]] alert_configs: The alert notification methods. See `alert_config` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alert_groups: The alert group.
        :param pulumi.Input[_builtins.str] cname_type: The access type of the CNAME domain name. Valid value: `PUBLIC`.
        :param pulumi.Input[_builtins.bool] force_update: The force update.
        :param pulumi.Input[_builtins.int] health_check_task_count: The quota of detection tasks.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance.
        :param pulumi.Input[_builtins.str] lang: The lang.
        :param pulumi.Input[_builtins.str] package_edition: Paid package version. Valid values: `ultimate`, `standard`.
        :param pulumi.Input[_builtins.str] payment_type: The Payment Type of the resource. Valid value: `Subscription`.
        :param pulumi.Input[_builtins.int] period: Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
        :param pulumi.Input[_builtins.str] public_cname_mode: The Public Network domain name access method. Valid values: `CUSTOM`, `SYSTEM_ASSIGN`.
        :param pulumi.Input[_builtins.str] public_rr: The CNAME access domain name.
        :param pulumi.Input[_builtins.str] public_user_domain_name: The website domain name that the user uses on the Internet.
        :param pulumi.Input[_builtins.str] public_zone_name: The domain name that is used to access GTM over the Internet.
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period, the unit is month. When setting `renewal_status` to AutoRenewal, it must be set.
        :param pulumi.Input[_builtins.str] renewal_status: Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.int] sms_notification_count: The quota of SMS notifications.
        :param pulumi.Input[_builtins.str] strategy_mode: The type of the access policy. Valid values: `GEO`, `LATENCY`.
        :param pulumi.Input[_builtins.int] ttl: The global time to live. Valid values: `60`, `120`, `300`, `600`. Unit: second.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GtmInstanceState.__new__(_GtmInstanceState)

        __props__.__dict__["alert_configs"] = alert_configs
        __props__.__dict__["alert_groups"] = alert_groups
        __props__.__dict__["cname_type"] = cname_type
        __props__.__dict__["force_update"] = force_update
        __props__.__dict__["health_check_task_count"] = health_check_task_count
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["lang"] = lang
        __props__.__dict__["package_edition"] = package_edition
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["public_cname_mode"] = public_cname_mode
        __props__.__dict__["public_rr"] = public_rr
        __props__.__dict__["public_user_domain_name"] = public_user_domain_name
        __props__.__dict__["public_zone_name"] = public_zone_name
        __props__.__dict__["renew_period"] = renew_period
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["sms_notification_count"] = sms_notification_count
        __props__.__dict__["strategy_mode"] = strategy_mode
        __props__.__dict__["ttl"] = ttl
        return GtmInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alertConfigs")
    def alert_configs(self) -> pulumi.Output[Optional[Sequence['outputs.GtmInstanceAlertConfig']]]:
        """
        The alert notification methods. See `alert_config` below for details.
        """
        return pulumi.get(self, "alert_configs")

    @_builtins.property
    @pulumi.getter(name="alertGroups")
    def alert_groups(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The alert group.
        """
        return pulumi.get(self, "alert_groups")

    @_builtins.property
    @pulumi.getter(name="cnameType")
    def cname_type(self) -> pulumi.Output[_builtins.str]:
        """
        The access type of the CNAME domain name. Valid value: `PUBLIC`.
        """
        return pulumi.get(self, "cname_type")

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The force update.
        """
        return pulumi.get(self, "force_update")

    @_builtins.property
    @pulumi.getter(name="healthCheckTaskCount")
    def health_check_task_count(self) -> pulumi.Output[_builtins.int]:
        """
        The quota of detection tasks.
        """
        return pulumi.get(self, "health_check_task_count")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter
    def lang(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The lang.
        """
        return pulumi.get(self, "lang")

    @_builtins.property
    @pulumi.getter(name="packageEdition")
    def package_edition(self) -> pulumi.Output[_builtins.str]:
        """
        Paid package version. Valid values: `ultimate`, `standard`.
        """
        return pulumi.get(self, "package_edition")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The Payment Type of the resource. Valid value: `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[_builtins.int]:
        """
        Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="publicCnameMode")
    def public_cname_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The Public Network domain name access method. Valid values: `CUSTOM`, `SYSTEM_ASSIGN`.
        """
        return pulumi.get(self, "public_cname_mode")

    @_builtins.property
    @pulumi.getter(name="publicRr")
    def public_rr(self) -> pulumi.Output[_builtins.str]:
        """
        The CNAME access domain name.
        """
        return pulumi.get(self, "public_rr")

    @_builtins.property
    @pulumi.getter(name="publicUserDomainName")
    def public_user_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The website domain name that the user uses on the Internet.
        """
        return pulumi.get(self, "public_user_domain_name")

    @_builtins.property
    @pulumi.getter(name="publicZoneName")
    def public_zone_name(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name that is used to access GTM over the Internet.
        """
        return pulumi.get(self, "public_zone_name")

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Automatic renewal period, the unit is month. When setting `renewal_status` to AutoRenewal, it must be set.
        """
        return pulumi.get(self, "renew_period")

    @_builtins.property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[_builtins.str]:
        """
        Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`.
        """
        return pulumi.get(self, "renewal_status")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="smsNotificationCount")
    def sms_notification_count(self) -> pulumi.Output[_builtins.int]:
        """
        The quota of SMS notifications.
        """
        return pulumi.get(self, "sms_notification_count")

    @_builtins.property
    @pulumi.getter(name="strategyMode")
    def strategy_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the access policy. Valid values: `GEO`, `LATENCY`.
        """
        return pulumi.get(self, "strategy_mode")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The global time to live. Valid values: `60`, `120`, `300`, `600`. Unit: second.
        """
        return pulumi.get(self, "ttl")

