# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DedicatedBlockStorageClusterArgs', 'DedicatedBlockStorageCluster']

@pulumi.input_type
class DedicatedBlockStorageClusterArgs:
    def __init__(__self__, *,
                 dedicated_block_storage_cluster_name: pulumi.Input[_builtins.str],
                 total_capacity: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DedicatedBlockStorageCluster resource.
        :param pulumi.Input[_builtins.str] dedicated_block_storage_cluster_name: The name of the resource
        :param pulumi.Input[_builtins.str] total_capacity: The total capacity of the dedicated block storage cluster. Unit: GiB.
        :param pulumi.Input[_builtins.str] type: The dedicated block storage cluster performance type. Possible values:-Standard: Basic type. This type of dedicated block storage cluster can create an ESSD PL0 cloud disk.-Premium: performance type. This type of dedicated block storage cluster can create an ESSD PL1 cloud disk.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource
        :param pulumi.Input[_builtins.str] description: The description of the dedicated block storage cluster.
        """
        pulumi.set(__self__, "dedicated_block_storage_cluster_name", dedicated_block_storage_cluster_name)
        pulumi.set(__self__, "total_capacity", total_capacity)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone_id", zone_id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="dedicatedBlockStorageClusterName")
    def dedicated_block_storage_cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "dedicated_block_storage_cluster_name")

    @dedicated_block_storage_cluster_name.setter
    def dedicated_block_storage_cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dedicated_block_storage_cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="totalCapacity")
    def total_capacity(self) -> pulumi.Input[_builtins.str]:
        """
        The total capacity of the dedicated block storage cluster. Unit: GiB.
        """
        return pulumi.get(self, "total_capacity")

    @total_capacity.setter
    def total_capacity(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "total_capacity", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The dedicated block storage cluster performance type. Possible values:-Standard: Basic type. This type of dedicated block storage cluster can create an ESSD PL0 cloud disk.-Premium: performance type. This type of dedicated block storage cluster can create an ESSD PL1 cloud disk.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The zone ID  of the resource
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the dedicated block storage cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _DedicatedBlockStorageClusterState:
    def __init__(__self__, *,
                 available_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_block_storage_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_block_storage_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expired_time: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 supported_category: Optional[pulumi.Input[_builtins.str]] = None,
                 total_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 used_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DedicatedBlockStorageCluster resources.
        :param pulumi.Input[_builtins.str] available_capacity: The available capacity of the dedicated block storage cluster. Unit: GiB.
        :param pulumi.Input[_builtins.str] category: The type of cloud disk that can be created by a dedicated block storage cluster.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] dedicated_block_storage_cluster_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] dedicated_block_storage_cluster_name: The name of the resource
        :param pulumi.Input[_builtins.str] delivery_capacity: Capacity to be delivered in GB.
        :param pulumi.Input[_builtins.str] description: The description of the dedicated block storage cluster.
        :param pulumi.Input[_builtins.str] expired_time: The expiration time of the dedicated block storage cluster, in the Unix timestamp format, in seconds.
        :param pulumi.Input[_builtins.str] performance_level: Cloud disk performance level, possible values:-PL0.-PL1.-PL2.-PL3.> Only valid in SupportedCategory = cloud_essd.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] supported_category: This parameter is not supported.
        :param pulumi.Input[_builtins.str] total_capacity: The total capacity of the dedicated block storage cluster. Unit: GiB.
        :param pulumi.Input[_builtins.str] type: The dedicated block storage cluster performance type. Possible values:-Standard: Basic type. This type of dedicated block storage cluster can create an ESSD PL0 cloud disk.-Premium: performance type. This type of dedicated block storage cluster can create an ESSD PL1 cloud disk.
        :param pulumi.Input[_builtins.str] used_capacity: The used (created disk) capacity of the current cluster, in GB
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource
        """
        if available_capacity is not None:
            pulumi.set(__self__, "available_capacity", available_capacity)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dedicated_block_storage_cluster_id is not None:
            pulumi.set(__self__, "dedicated_block_storage_cluster_id", dedicated_block_storage_cluster_id)
        if dedicated_block_storage_cluster_name is not None:
            pulumi.set(__self__, "dedicated_block_storage_cluster_name", dedicated_block_storage_cluster_name)
        if delivery_capacity is not None:
            pulumi.set(__self__, "delivery_capacity", delivery_capacity)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if supported_category is not None:
            pulumi.set(__self__, "supported_category", supported_category)
        if total_capacity is not None:
            pulumi.set(__self__, "total_capacity", total_capacity)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if used_capacity is not None:
            pulumi.set(__self__, "used_capacity", used_capacity)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="availableCapacity")
    def available_capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The available capacity of the dedicated block storage cluster. Unit: GiB.
        """
        return pulumi.get(self, "available_capacity")

    @available_capacity.setter
    def available_capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "available_capacity", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of cloud disk that can be created by a dedicated block storage cluster.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedBlockStorageClusterId")
    def dedicated_block_storage_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "dedicated_block_storage_cluster_id")

    @dedicated_block_storage_cluster_id.setter
    def dedicated_block_storage_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_block_storage_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedBlockStorageClusterName")
    def dedicated_block_storage_cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "dedicated_block_storage_cluster_name")

    @dedicated_block_storage_cluster_name.setter
    def dedicated_block_storage_cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_block_storage_cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="deliveryCapacity")
    def delivery_capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Capacity to be delivered in GB.
        """
        return pulumi.get(self, "delivery_capacity")

    @delivery_capacity.setter
    def delivery_capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_capacity", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the dedicated block storage cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time of the dedicated block storage cluster, in the Unix timestamp format, in seconds.
        """
        return pulumi.get(self, "expired_time")

    @expired_time.setter
    def expired_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expired_time", value)

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloud disk performance level, possible values:-PL0.-PL1.-PL2.-PL3.> Only valid in SupportedCategory = cloud_essd.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "performance_level", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="supportedCategory")
    def supported_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter is not supported.
        """
        return pulumi.get(self, "supported_category")

    @supported_category.setter
    def supported_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "supported_category", value)

    @_builtins.property
    @pulumi.getter(name="totalCapacity")
    def total_capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The total capacity of the dedicated block storage cluster. Unit: GiB.
        """
        return pulumi.get(self, "total_capacity")

    @total_capacity.setter
    def total_capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "total_capacity", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dedicated block storage cluster performance type. Possible values:-Standard: Basic type. This type of dedicated block storage cluster can create an ESSD PL0 cloud disk.-Premium: performance type. This type of dedicated block storage cluster can create an ESSD PL1 cloud disk.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="usedCapacity")
    def used_capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The used (created disk) capacity of the current cluster, in GB
        """
        return pulumi.get(self, "used_capacity")

    @used_capacity.setter
    def used_capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "used_capacity", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone ID  of the resource
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:ebs/dedicatedBlockStorageCluster:DedicatedBlockStorageCluster")
class DedicatedBlockStorageCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dedicated_block_storage_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 total_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Ebs Dedicated Block Storage Cluster resource.

        For information about Ebs Dedicated Block Storage Cluster and how to use it, see [What is Dedicated Block Storage Cluster](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-ebs-2021-07-30-creatededicatedblockstoragecluster).

        > **NOTE:** Available since v1.195.0.

        ## Import

        Ebs Dedicated Block Storage Cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ebs/dedicatedBlockStorageCluster:DedicatedBlockStorageCluster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dedicated_block_storage_cluster_name: The name of the resource
        :param pulumi.Input[_builtins.str] description: The description of the dedicated block storage cluster.
        :param pulumi.Input[_builtins.str] total_capacity: The total capacity of the dedicated block storage cluster. Unit: GiB.
        :param pulumi.Input[_builtins.str] type: The dedicated block storage cluster performance type. Possible values:-Standard: Basic type. This type of dedicated block storage cluster can create an ESSD PL0 cloud disk.-Premium: performance type. This type of dedicated block storage cluster can create an ESSD PL1 cloud disk.
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DedicatedBlockStorageClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Ebs Dedicated Block Storage Cluster resource.

        For information about Ebs Dedicated Block Storage Cluster and how to use it, see [What is Dedicated Block Storage Cluster](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-ebs-2021-07-30-creatededicatedblockstoragecluster).

        > **NOTE:** Available since v1.195.0.

        ## Import

        Ebs Dedicated Block Storage Cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ebs/dedicatedBlockStorageCluster:DedicatedBlockStorageCluster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DedicatedBlockStorageClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DedicatedBlockStorageClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dedicated_block_storage_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 total_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DedicatedBlockStorageClusterArgs.__new__(DedicatedBlockStorageClusterArgs)

            if dedicated_block_storage_cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'dedicated_block_storage_cluster_name'")
            __props__.__dict__["dedicated_block_storage_cluster_name"] = dedicated_block_storage_cluster_name
            __props__.__dict__["description"] = description
            if total_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'total_capacity'")
            __props__.__dict__["total_capacity"] = total_capacity
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["available_capacity"] = None
            __props__.__dict__["category"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["dedicated_block_storage_cluster_id"] = None
            __props__.__dict__["delivery_capacity"] = None
            __props__.__dict__["expired_time"] = None
            __props__.__dict__["performance_level"] = None
            __props__.__dict__["resource_group_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["supported_category"] = None
            __props__.__dict__["used_capacity"] = None
        super(DedicatedBlockStorageCluster, __self__).__init__(
            'alicloud:ebs/dedicatedBlockStorageCluster:DedicatedBlockStorageCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            available_capacity: Optional[pulumi.Input[_builtins.str]] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            dedicated_block_storage_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            dedicated_block_storage_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_capacity: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            expired_time: Optional[pulumi.Input[_builtins.str]] = None,
            performance_level: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            supported_category: Optional[pulumi.Input[_builtins.str]] = None,
            total_capacity: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            used_capacity: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DedicatedBlockStorageCluster':
        """
        Get an existing DedicatedBlockStorageCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] available_capacity: The available capacity of the dedicated block storage cluster. Unit: GiB.
        :param pulumi.Input[_builtins.str] category: The type of cloud disk that can be created by a dedicated block storage cluster.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] dedicated_block_storage_cluster_id: The first ID of the resource
        :param pulumi.Input[_builtins.str] dedicated_block_storage_cluster_name: The name of the resource
        :param pulumi.Input[_builtins.str] delivery_capacity: Capacity to be delivered in GB.
        :param pulumi.Input[_builtins.str] description: The description of the dedicated block storage cluster.
        :param pulumi.Input[_builtins.str] expired_time: The expiration time of the dedicated block storage cluster, in the Unix timestamp format, in seconds.
        :param pulumi.Input[_builtins.str] performance_level: Cloud disk performance level, possible values:-PL0.-PL1.-PL2.-PL3.> Only valid in SupportedCategory = cloud_essd.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] supported_category: This parameter is not supported.
        :param pulumi.Input[_builtins.str] total_capacity: The total capacity of the dedicated block storage cluster. Unit: GiB.
        :param pulumi.Input[_builtins.str] type: The dedicated block storage cluster performance type. Possible values:-Standard: Basic type. This type of dedicated block storage cluster can create an ESSD PL0 cloud disk.-Premium: performance type. This type of dedicated block storage cluster can create an ESSD PL1 cloud disk.
        :param pulumi.Input[_builtins.str] used_capacity: The used (created disk) capacity of the current cluster, in GB
        :param pulumi.Input[_builtins.str] zone_id: The zone ID  of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DedicatedBlockStorageClusterState.__new__(_DedicatedBlockStorageClusterState)

        __props__.__dict__["available_capacity"] = available_capacity
        __props__.__dict__["category"] = category
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dedicated_block_storage_cluster_id"] = dedicated_block_storage_cluster_id
        __props__.__dict__["dedicated_block_storage_cluster_name"] = dedicated_block_storage_cluster_name
        __props__.__dict__["delivery_capacity"] = delivery_capacity
        __props__.__dict__["description"] = description
        __props__.__dict__["expired_time"] = expired_time
        __props__.__dict__["performance_level"] = performance_level
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["supported_category"] = supported_category
        __props__.__dict__["total_capacity"] = total_capacity
        __props__.__dict__["type"] = type
        __props__.__dict__["used_capacity"] = used_capacity
        __props__.__dict__["zone_id"] = zone_id
        return DedicatedBlockStorageCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availableCapacity")
    def available_capacity(self) -> pulumi.Output[_builtins.str]:
        """
        The available capacity of the dedicated block storage cluster. Unit: GiB.
        """
        return pulumi.get(self, "available_capacity")

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        The type of cloud disk that can be created by a dedicated block storage cluster.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dedicatedBlockStorageClusterId")
    def dedicated_block_storage_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "dedicated_block_storage_cluster_id")

    @_builtins.property
    @pulumi.getter(name="dedicatedBlockStorageClusterName")
    def dedicated_block_storage_cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "dedicated_block_storage_cluster_name")

    @_builtins.property
    @pulumi.getter(name="deliveryCapacity")
    def delivery_capacity(self) -> pulumi.Output[_builtins.str]:
        """
        Capacity to be delivered in GB.
        """
        return pulumi.get(self, "delivery_capacity")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the dedicated block storage cluster.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> pulumi.Output[_builtins.str]:
        """
        The expiration time of the dedicated block storage cluster, in the Unix timestamp format, in seconds.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> pulumi.Output[_builtins.str]:
        """
        Cloud disk performance level, possible values:-PL0.-PL1.-PL2.-PL3.> Only valid in SupportedCategory = cloud_essd.
        """
        return pulumi.get(self, "performance_level")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="supportedCategory")
    def supported_category(self) -> pulumi.Output[_builtins.str]:
        """
        This parameter is not supported.
        """
        return pulumi.get(self, "supported_category")

    @_builtins.property
    @pulumi.getter(name="totalCapacity")
    def total_capacity(self) -> pulumi.Output[_builtins.str]:
        """
        The total capacity of the dedicated block storage cluster. Unit: GiB.
        """
        return pulumi.get(self, "total_capacity")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The dedicated block storage cluster performance type. Possible values:-Standard: Basic type. This type of dedicated block storage cluster can create an ESSD PL0 cloud disk.-Premium: performance type. This type of dedicated block storage cluster can create an ESSD PL1 cloud disk.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="usedCapacity")
    def used_capacity(self) -> pulumi.Output[_builtins.str]:
        """
        The used (created disk) capacity of the current cluster, in GB
        """
        return pulumi.get(self, "used_capacity")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone ID  of the resource
        """
        return pulumi.get(self, "zone_id")

