# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EcsSnapshotGroupArgs', 'EcsSnapshotGroup']

@pulumi.input_type
class EcsSnapshotGroupArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 exclude_disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instant_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 instant_access_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a EcsSnapshotGroup resource.
        :param pulumi.Input[_builtins.str] description: The description of the snapshot-consistent group. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_ids: The ID of disk for which to create snapshots. You can specify multiple disk IDs across instances with the same zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_disk_ids: The ID of disk N for which you do not need to create snapshots. After this parameter is specified, the created snapshot-consistent group does not contain snapshots of the disk.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.bool] instant_access: Specifies whether to enable the instant access feature.
        :param pulumi.Input[_builtins.int] instant_access_retention_days: Specify the number of days for which the instant access feature is available. Unit: days. Valid values: `1` to `65535`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the snapshot consistency group belongs.
        :param pulumi.Input[_builtins.str] snapshot_group_name: The name of the snapshot-consistent group. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), underscores (_), hyphens (-), and colons (:). It must start with a letter or a digit and cannot start with `http://` or `https://`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the snapshot group.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_ids is not None:
            pulumi.set(__self__, "disk_ids", disk_ids)
        if exclude_disk_ids is not None:
            pulumi.set(__self__, "exclude_disk_ids", exclude_disk_ids)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instant_access is not None:
            pulumi.set(__self__, "instant_access", instant_access)
        if instant_access_retention_days is not None:
            pulumi.set(__self__, "instant_access_retention_days", instant_access_retention_days)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if snapshot_group_name is not None:
            pulumi.set(__self__, "snapshot_group_name", snapshot_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the snapshot-consistent group. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskIds")
    def disk_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ID of disk for which to create snapshots. You can specify multiple disk IDs across instances with the same zone.
        """
        return pulumi.get(self, "disk_ids")

    @disk_ids.setter
    def disk_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disk_ids", value)

    @_builtins.property
    @pulumi.getter(name="excludeDiskIds")
    def exclude_disk_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ID of disk N for which you do not need to create snapshots. After this parameter is specified, the created snapshot-consistent group does not contain snapshots of the disk.
        """
        return pulumi.get(self, "exclude_disk_ids")

    @exclude_disk_ids.setter
    def exclude_disk_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_disk_ids", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instantAccess")
    def instant_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the instant access feature.
        """
        return pulumi.get(self, "instant_access")

    @instant_access.setter
    def instant_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "instant_access", value)

    @_builtins.property
    @pulumi.getter(name="instantAccessRetentionDays")
    def instant_access_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify the number of days for which the instant access feature is available. Unit: days. Valid values: `1` to `65535`.
        """
        return pulumi.get(self, "instant_access_retention_days")

    @instant_access_retention_days.setter
    def instant_access_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instant_access_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the snapshot consistency group belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotGroupName")
    def snapshot_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the snapshot-consistent group. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), underscores (_), hyphens (-), and colons (:). It must start with a letter or a digit and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "snapshot_group_name")

    @snapshot_group_name.setter
    def snapshot_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the snapshot group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _EcsSnapshotGroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 exclude_disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instant_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 instant_access_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering EcsSnapshotGroup resources.
        :param pulumi.Input[_builtins.str] description: The description of the snapshot-consistent group. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_ids: The ID of disk for which to create snapshots. You can specify multiple disk IDs across instances with the same zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_disk_ids: The ID of disk N for which you do not need to create snapshots. After this parameter is specified, the created snapshot-consistent group does not contain snapshots of the disk.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.bool] instant_access: Specifies whether to enable the instant access feature.
        :param pulumi.Input[_builtins.int] instant_access_retention_days: Specify the number of days for which the instant access feature is available. Unit: days. Valid values: `1` to `65535`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the snapshot consistency group belongs.
        :param pulumi.Input[_builtins.str] snapshot_group_name: The name of the snapshot-consistent group. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), underscores (_), hyphens (-), and colons (:). It must start with a letter or a digit and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the snapshot group.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_ids is not None:
            pulumi.set(__self__, "disk_ids", disk_ids)
        if exclude_disk_ids is not None:
            pulumi.set(__self__, "exclude_disk_ids", exclude_disk_ids)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instant_access is not None:
            pulumi.set(__self__, "instant_access", instant_access)
        if instant_access_retention_days is not None:
            pulumi.set(__self__, "instant_access_retention_days", instant_access_retention_days)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if snapshot_group_name is not None:
            pulumi.set(__self__, "snapshot_group_name", snapshot_group_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the snapshot-consistent group. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskIds")
    def disk_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ID of disk for which to create snapshots. You can specify multiple disk IDs across instances with the same zone.
        """
        return pulumi.get(self, "disk_ids")

    @disk_ids.setter
    def disk_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disk_ids", value)

    @_builtins.property
    @pulumi.getter(name="excludeDiskIds")
    def exclude_disk_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ID of disk N for which you do not need to create snapshots. After this parameter is specified, the created snapshot-consistent group does not contain snapshots of the disk.
        """
        return pulumi.get(self, "exclude_disk_ids")

    @exclude_disk_ids.setter
    def exclude_disk_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_disk_ids", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instantAccess")
    def instant_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the instant access feature.
        """
        return pulumi.get(self, "instant_access")

    @instant_access.setter
    def instant_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "instant_access", value)

    @_builtins.property
    @pulumi.getter(name="instantAccessRetentionDays")
    def instant_access_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify the number of days for which the instant access feature is available. Unit: days. Valid values: `1` to `65535`.
        """
        return pulumi.get(self, "instant_access_retention_days")

    @instant_access_retention_days.setter
    def instant_access_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instant_access_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the snapshot consistency group belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotGroupName")
    def snapshot_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the snapshot-consistent group. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), underscores (_), hyphens (-), and colons (:). It must start with a letter or a digit and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "snapshot_group_name")

    @snapshot_group_name.setter
    def snapshot_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_group_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the snapshot group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:ecs/ecsSnapshotGroup:EcsSnapshotGroup")
class EcsSnapshotGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 exclude_disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instant_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 instant_access_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a ECS Snapshot Group resource.

        For information about ECS Snapshot Group and how to use it, see [What is Snapshot Group](https://www.alibabacloud.com/help/en/doc-detail/210939.html).

        > **NOTE:** Available since v1.160.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_zones(available_resource_creation="Instance",
            available_disk_category="cloud_essd")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            system_disk_category="cloud_essd")
        default_get_images = alicloud.ecs.get_images(owners="system",
            name_regex="^ubuntu_18.*64",
            most_recent=True)
        default_network = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name="terraform-example",
            vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            availability_zone=default.zones[0].id,
            instance_name="terraform-example",
            security_groups=[default_security_group.id],
            vswitch_id=default_switch.id,
            instance_type=default_get_instance_types.instance_types[0].id,
            image_id=default_get_images.images[0].id,
            internet_max_bandwidth_out=10)
        default_ecs_disk = alicloud.ecs.EcsDisk("default",
            zone_id=default.zones[0].id,
            disk_name="terraform-example",
            description="terraform-example",
            category="cloud_essd",
            size=30)
        default_disk_attachment = alicloud.ecs.DiskAttachment("default",
            disk_id=default_ecs_disk.id,
            instance_id=default_instance.id)
        default_ecs_snapshot_group = alicloud.ecs.EcsSnapshotGroup("default",
            description="terraform-example",
            disk_ids=[default_disk_attachment.disk_id],
            snapshot_group_name="terraform-example",
            instance_id=default_instance.id,
            instant_access=True,
            instant_access_retention_days=1,
            tags={
                "Created": "TF",
                "For": "Acceptance",
            })
        ```

        ## Import

        ECS Snapshot Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/ecsSnapshotGroup:EcsSnapshotGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the snapshot-consistent group. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_ids: The ID of disk for which to create snapshots. You can specify multiple disk IDs across instances with the same zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_disk_ids: The ID of disk N for which you do not need to create snapshots. After this parameter is specified, the created snapshot-consistent group does not contain snapshots of the disk.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.bool] instant_access: Specifies whether to enable the instant access feature.
        :param pulumi.Input[_builtins.int] instant_access_retention_days: Specify the number of days for which the instant access feature is available. Unit: days. Valid values: `1` to `65535`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the snapshot consistency group belongs.
        :param pulumi.Input[_builtins.str] snapshot_group_name: The name of the snapshot-consistent group. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), underscores (_), hyphens (-), and colons (:). It must start with a letter or a digit and cannot start with `http://` or `https://`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the snapshot group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EcsSnapshotGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS Snapshot Group resource.

        For information about ECS Snapshot Group and how to use it, see [What is Snapshot Group](https://www.alibabacloud.com/help/en/doc-detail/210939.html).

        > **NOTE:** Available since v1.160.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_zones(available_resource_creation="Instance",
            available_disk_category="cloud_essd")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            system_disk_category="cloud_essd")
        default_get_images = alicloud.ecs.get_images(owners="system",
            name_regex="^ubuntu_18.*64",
            most_recent=True)
        default_network = alicloud.vpc.Network("default",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name="terraform-example",
            vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            availability_zone=default.zones[0].id,
            instance_name="terraform-example",
            security_groups=[default_security_group.id],
            vswitch_id=default_switch.id,
            instance_type=default_get_instance_types.instance_types[0].id,
            image_id=default_get_images.images[0].id,
            internet_max_bandwidth_out=10)
        default_ecs_disk = alicloud.ecs.EcsDisk("default",
            zone_id=default.zones[0].id,
            disk_name="terraform-example",
            description="terraform-example",
            category="cloud_essd",
            size=30)
        default_disk_attachment = alicloud.ecs.DiskAttachment("default",
            disk_id=default_ecs_disk.id,
            instance_id=default_instance.id)
        default_ecs_snapshot_group = alicloud.ecs.EcsSnapshotGroup("default",
            description="terraform-example",
            disk_ids=[default_disk_attachment.disk_id],
            snapshot_group_name="terraform-example",
            instance_id=default_instance.id,
            instant_access=True,
            instant_access_retention_days=1,
            tags={
                "Created": "TF",
                "For": "Acceptance",
            })
        ```

        ## Import

        ECS Snapshot Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/ecsSnapshotGroup:EcsSnapshotGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EcsSnapshotGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EcsSnapshotGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 exclude_disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instant_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 instant_access_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EcsSnapshotGroupArgs.__new__(EcsSnapshotGroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["disk_ids"] = disk_ids
            __props__.__dict__["exclude_disk_ids"] = exclude_disk_ids
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["instant_access"] = instant_access
            __props__.__dict__["instant_access_retention_days"] = instant_access_retention_days
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["snapshot_group_name"] = snapshot_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["status"] = None
        super(EcsSnapshotGroup, __self__).__init__(
            'alicloud:ecs/ecsSnapshotGroup:EcsSnapshotGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            exclude_disk_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            instant_access: Optional[pulumi.Input[_builtins.bool]] = None,
            instant_access_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'EcsSnapshotGroup':
        """
        Get an existing EcsSnapshotGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the snapshot-consistent group. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_ids: The ID of disk for which to create snapshots. You can specify multiple disk IDs across instances with the same zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_disk_ids: The ID of disk N for which you do not need to create snapshots. After this parameter is specified, the created snapshot-consistent group does not contain snapshots of the disk.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance.
        :param pulumi.Input[_builtins.bool] instant_access: Specifies whether to enable the instant access feature.
        :param pulumi.Input[_builtins.int] instant_access_retention_days: Specify the number of days for which the instant access feature is available. Unit: days. Valid values: `1` to `65535`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the snapshot consistency group belongs.
        :param pulumi.Input[_builtins.str] snapshot_group_name: The name of the snapshot-consistent group. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), underscores (_), hyphens (-), and colons (:). It must start with a letter or a digit and cannot start with `http://` or `https://`.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the snapshot group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EcsSnapshotGroupState.__new__(_EcsSnapshotGroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["disk_ids"] = disk_ids
        __props__.__dict__["exclude_disk_ids"] = exclude_disk_ids
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instant_access"] = instant_access
        __props__.__dict__["instant_access_retention_days"] = instant_access_retention_days
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["snapshot_group_name"] = snapshot_group_name
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return EcsSnapshotGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the snapshot-consistent group. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskIds")
    def disk_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The ID of disk for which to create snapshots. You can specify multiple disk IDs across instances with the same zone.
        """
        return pulumi.get(self, "disk_ids")

    @_builtins.property
    @pulumi.getter(name="excludeDiskIds")
    def exclude_disk_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The ID of disk N for which you do not need to create snapshots. After this parameter is specified, the created snapshot-consistent group does not contain snapshots of the disk.
        """
        return pulumi.get(self, "exclude_disk_ids")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instantAccess")
    def instant_access(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the instant access feature.
        """
        return pulumi.get(self, "instant_access")

    @_builtins.property
    @pulumi.getter(name="instantAccessRetentionDays")
    def instant_access_retention_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specify the number of days for which the instant access feature is available. Unit: days. Valid values: `1` to `65535`.
        """
        return pulumi.get(self, "instant_access_retention_days")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which the snapshot consistency group belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="snapshotGroupName")
    def snapshot_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the snapshot-consistent group. The name must be `2` to `128` characters in length, and can contain letters, digits, periods (.), underscores (_), hyphens (-), and colons (:). It must start with a letter or a digit and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "snapshot_group_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the snapshot group.
        """
        return pulumi.get(self, "tags")

