# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EipArgs', 'Eip']

@pulumi.input_type
class EipArgs:
    def __init__(__self__, *,
                 activity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 high_definition_monitor_log_status: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netmode: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Eip resource.
        :param pulumi.Input[_builtins.str] address_name: The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        :param pulumi.Input[_builtins.str] bandwidth: Maximum bandwidth to the elastic public network, measured in Mbps (Mega bit per second). If this value is not specified, then automatically sets it to 5 Mbps.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not. Default value: `false`.
               - true: Enable deletion protection.
               - false: Disable deletion protection.
        :param pulumi.Input[_builtins.str] description: Description of the EIP instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        :param pulumi.Input[_builtins.str] instance_charge_type: (It has been deprecated from version 1.126.0 and using new attribute `payment_type` instead) Elastic IP instance charge type. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        :param pulumi.Input[_builtins.str] internet_charge_type: Internet charge type of the EIP, Valid values are `PayByBandwidth`, `PayByTraffic`. Default to `PayByBandwidth`. **NOTE:** From version `1.7.1` to `1.125.0`, it defaults to `PayByTraffic`. It is only "PayByBandwidth" when `instance_charge_type` is PrePaid.
        :param pulumi.Input[_builtins.str] ip_address: The elastic ip address
        :param pulumi.Input[_builtins.str] isp: The line type of the Elastic IP instance. Default to `BGP`. Other type of the isp need to open a whitelist.
        :param pulumi.Input[_builtins.str] name: It has been deprecated from version 1.126.0 and using new attribute `address_name` instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the EIP. Valid values: `Subscription` and `PayAsYouGo`. Default value is `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
               **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the eip belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if activity_id is not None:
            pulumi.set(__self__, "activity_id", activity_id)
        if address_name is not None:
            pulumi.set(__self__, "address_name", address_name)
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if high_definition_monitor_log_status is not None:
            pulumi.set(__self__, "high_definition_monitor_log_status", high_definition_monitor_log_status)
        if instance_charge_type is not None:
            warnings.warn("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_charge_type is deprecated: Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if log_project is not None:
            pulumi.set(__self__, "log_project", log_project)
        if log_store is not None:
            pulumi.set(__self__, "log_store", log_store)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if netmode is not None:
            pulumi.set(__self__, "netmode", netmode)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if public_ip_address_pool_id is not None:
            pulumi.set(__self__, "public_ip_address_pool_id", public_ip_address_pool_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_protection_types is not None:
            pulumi.set(__self__, "security_protection_types", security_protection_types)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="activityId")
    def activity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "activity_id")

    @activity_id.setter
    def activity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activity_id", value)

    @_builtins.property
    @pulumi.getter(name="addressName")
    def address_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        """
        return pulumi.get(self, "address_name")

    @address_name.setter
    def address_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_name", value)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "allocation_id")

    @allocation_id.setter
    def allocation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allocation_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum bandwidth to the elastic public network, measured in Mbps (Mega bit per second). If this value is not specified, then automatically sets it to 5 Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable the deletion protection or not. Default value: `false`.
        - true: Enable deletion protection.
        - false: Disable deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the EIP instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="highDefinitionMonitorLogStatus")
    def high_definition_monitor_log_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "high_definition_monitor_log_status")

    @high_definition_monitor_log_status.setter
    def high_definition_monitor_log_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "high_definition_monitor_log_status", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (It has been deprecated from version 1.126.0 and using new attribute `payment_type` instead) Elastic IP instance charge type. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internet charge type of the EIP, Valid values are `PayByBandwidth`, `PayByTraffic`. Default to `PayByBandwidth`. **NOTE:** From version `1.7.1` to `1.125.0`, it defaults to `PayByTraffic`. It is only "PayByBandwidth" when `instance_charge_type` is PrePaid.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The elastic ip address
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The line type of the Elastic IP instance. Default to `BGP`. Other type of the isp need to open a whitelist.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isp", value)

    @_builtins.property
    @pulumi.getter(name="logProject")
    def log_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "log_project")

    @log_project.setter
    def log_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_project", value)

    @_builtins.property
    @pulumi.getter(name="logStore")
    def log_store(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "log_store")

    @log_store.setter
    def log_store(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_store", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from version 1.126.0 and using new attribute `address_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def netmode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "netmode")

    @netmode.setter
    def netmode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "netmode", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the EIP. Valid values: `Subscription` and `PayAsYouGo`. Default value is `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
        **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_ip_address_pool_id")

    @public_ip_address_pool_id.setter
    def public_ip_address_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the eip belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "security_protection_types")

    @security_protection_types.setter
    def security_protection_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_protection_types", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _EipState:
    def __init__(__self__, *,
                 activity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 high_definition_monitor_log_status: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netmode: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Eip resources.
        :param pulumi.Input[_builtins.str] address_name: The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        :param pulumi.Input[_builtins.str] bandwidth: Maximum bandwidth to the elastic public network, measured in Mbps (Mega bit per second). If this value is not specified, then automatically sets it to 5 Mbps.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not. Default value: `false`.
               - true: Enable deletion protection.
               - false: Disable deletion protection.
        :param pulumi.Input[_builtins.str] description: Description of the EIP instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        :param pulumi.Input[_builtins.str] instance_charge_type: (It has been deprecated from version 1.126.0 and using new attribute `payment_type` instead) Elastic IP instance charge type. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        :param pulumi.Input[_builtins.str] internet_charge_type: Internet charge type of the EIP, Valid values are `PayByBandwidth`, `PayByTraffic`. Default to `PayByBandwidth`. **NOTE:** From version `1.7.1` to `1.125.0`, it defaults to `PayByTraffic`. It is only "PayByBandwidth" when `instance_charge_type` is PrePaid.
        :param pulumi.Input[_builtins.str] ip_address: The elastic ip address
        :param pulumi.Input[_builtins.str] isp: The line type of the Elastic IP instance. Default to `BGP`. Other type of the isp need to open a whitelist.
        :param pulumi.Input[_builtins.str] name: It has been deprecated from version 1.126.0 and using new attribute `address_name` instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the EIP. Valid values: `Subscription` and `PayAsYouGo`. Default value is `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
               **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the eip belongs.
        :param pulumi.Input[_builtins.str] status: The EIP current status.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if activity_id is not None:
            pulumi.set(__self__, "activity_id", activity_id)
        if address_name is not None:
            pulumi.set(__self__, "address_name", address_name)
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if high_definition_monitor_log_status is not None:
            pulumi.set(__self__, "high_definition_monitor_log_status", high_definition_monitor_log_status)
        if instance_charge_type is not None:
            warnings.warn("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_charge_type is deprecated: Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if log_project is not None:
            pulumi.set(__self__, "log_project", log_project)
        if log_store is not None:
            pulumi.set(__self__, "log_store", log_store)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if netmode is not None:
            pulumi.set(__self__, "netmode", netmode)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if public_ip_address_pool_id is not None:
            pulumi.set(__self__, "public_ip_address_pool_id", public_ip_address_pool_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_protection_types is not None:
            pulumi.set(__self__, "security_protection_types", security_protection_types)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="activityId")
    def activity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "activity_id")

    @activity_id.setter
    def activity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activity_id", value)

    @_builtins.property
    @pulumi.getter(name="addressName")
    def address_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        """
        return pulumi.get(self, "address_name")

    @address_name.setter
    def address_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_name", value)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "allocation_id")

    @allocation_id.setter
    def allocation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "allocation_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum bandwidth to the elastic public network, measured in Mbps (Mega bit per second). If this value is not specified, then automatically sets it to 5 Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable the deletion protection or not. Default value: `false`.
        - true: Enable deletion protection.
        - false: Disable deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the EIP instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="highDefinitionMonitorLogStatus")
    def high_definition_monitor_log_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "high_definition_monitor_log_status")

    @high_definition_monitor_log_status.setter
    def high_definition_monitor_log_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "high_definition_monitor_log_status", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (It has been deprecated from version 1.126.0 and using new attribute `payment_type` instead) Elastic IP instance charge type. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internet charge type of the EIP, Valid values are `PayByBandwidth`, `PayByTraffic`. Default to `PayByBandwidth`. **NOTE:** From version `1.7.1` to `1.125.0`, it defaults to `PayByTraffic`. It is only "PayByBandwidth" when `instance_charge_type` is PrePaid.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The elastic ip address
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The line type of the Elastic IP instance. Default to `BGP`. Other type of the isp need to open a whitelist.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isp", value)

    @_builtins.property
    @pulumi.getter(name="logProject")
    def log_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "log_project")

    @log_project.setter
    def log_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_project", value)

    @_builtins.property
    @pulumi.getter(name="logStore")
    def log_store(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "log_store")

    @log_store.setter
    def log_store(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_store", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated from version 1.126.0 and using new attribute `address_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def netmode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "netmode")

    @netmode.setter
    def netmode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "netmode", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the EIP. Valid values: `Subscription` and `PayAsYouGo`. Default value is `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
        **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pricing_cycle", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_ip_address_pool_id")

    @public_ip_address_pool_id.setter
    def public_ip_address_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the eip belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "security_protection_types")

    @security_protection_types.setter
    def security_protection_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_protection_types", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EIP current status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


warnings.warn("""This resource has been deprecated in favour of the EipAddress resource""", DeprecationWarning)


@pulumi.type_token("alicloud:ecs/eip:Eip")
class Eip(pulumi.CustomResource):
    warnings.warn("""This resource has been deprecated in favour of the EipAddress resource""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 high_definition_monitor_log_status: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netmode: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an elastic IP resource.

        > **DEPRECATED:**  This resource  has been deprecated from version `1.126.0`. Please use new resource alicloud_eip_address.

        > **NOTE:** The resource only supports to create `PostPaid PayByTraffic`  or `PrePaid PayByBandwidth` elastic IP for international account. Otherwise, you will happened error `COMMODITY.INVALID_COMPONENT`.
        Your account is international if you can use it to login in [International Web Console](https://account.alibabacloud.com/login/login.htm).

        > **NOTE:** From version 1.10.1, this resource supports creating "PrePaid" EIP. In addition, it supports setting EIP name and description.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        # Create a new EIP.
        example = alicloud.ecs.Eip("example",
            bandwidth="10",
            internet_charge_type="PayByBandwidth")
        ```

        ## Module Support

        You can use the existing eip module
        to create several EIP instances and associate them with other resources one-click, like ECS instances, SLB, Nat Gateway and so on.

        ## Import

        Elastic IP address can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/eip:Eip example eip-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_name: The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        :param pulumi.Input[_builtins.str] bandwidth: Maximum bandwidth to the elastic public network, measured in Mbps (Mega bit per second). If this value is not specified, then automatically sets it to 5 Mbps.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not. Default value: `false`.
               - true: Enable deletion protection.
               - false: Disable deletion protection.
        :param pulumi.Input[_builtins.str] description: Description of the EIP instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        :param pulumi.Input[_builtins.str] instance_charge_type: (It has been deprecated from version 1.126.0 and using new attribute `payment_type` instead) Elastic IP instance charge type. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        :param pulumi.Input[_builtins.str] internet_charge_type: Internet charge type of the EIP, Valid values are `PayByBandwidth`, `PayByTraffic`. Default to `PayByBandwidth`. **NOTE:** From version `1.7.1` to `1.125.0`, it defaults to `PayByTraffic`. It is only "PayByBandwidth" when `instance_charge_type` is PrePaid.
        :param pulumi.Input[_builtins.str] ip_address: The elastic ip address
        :param pulumi.Input[_builtins.str] isp: The line type of the Elastic IP instance. Default to `BGP`. Other type of the isp need to open a whitelist.
        :param pulumi.Input[_builtins.str] name: It has been deprecated from version 1.126.0 and using new attribute `address_name` instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the EIP. Valid values: `Subscription` and `PayAsYouGo`. Default value is `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
               **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the eip belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EipArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an elastic IP resource.

        > **DEPRECATED:**  This resource  has been deprecated from version `1.126.0`. Please use new resource alicloud_eip_address.

        > **NOTE:** The resource only supports to create `PostPaid PayByTraffic`  or `PrePaid PayByBandwidth` elastic IP for international account. Otherwise, you will happened error `COMMODITY.INVALID_COMPONENT`.
        Your account is international if you can use it to login in [International Web Console](https://account.alibabacloud.com/login/login.htm).

        > **NOTE:** From version 1.10.1, this resource supports creating "PrePaid" EIP. In addition, it supports setting EIP name and description.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        # Create a new EIP.
        example = alicloud.ecs.Eip("example",
            bandwidth="10",
            internet_charge_type="PayByBandwidth")
        ```

        ## Module Support

        You can use the existing eip module
        to create several EIP instances and associate them with other resources one-click, like ECS instances, SLB, Nat Gateway and so on.

        ## Import

        Elastic IP address can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/eip:Eip example eip-abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param EipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 high_definition_monitor_log_status: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 log_store: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netmode: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""Eip is deprecated: This resource has been deprecated in favour of the EipAddress resource""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipArgs.__new__(EipArgs)

            __props__.__dict__["activity_id"] = activity_id
            __props__.__dict__["address_name"] = address_name
            __props__.__dict__["allocation_id"] = allocation_id
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["high_definition_monitor_log_status"] = high_definition_monitor_log_status
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["isp"] = isp
            __props__.__dict__["log_project"] = log_project
            __props__.__dict__["log_store"] = log_store
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["netmode"] = netmode
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            __props__.__dict__["public_ip_address_pool_id"] = public_ip_address_pool_id
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_protection_types"] = security_protection_types
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone"] = zone
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Eip, __self__).__init__(
            'alicloud:ecs/eip:Eip',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activity_id: Optional[pulumi.Input[_builtins.str]] = None,
            address_name: Optional[pulumi.Input[_builtins.str]] = None,
            allocation_id: Optional[pulumi.Input[_builtins.str]] = None,
            auto_pay: Optional[pulumi.Input[_builtins.bool]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            high_definition_monitor_log_status: Optional[pulumi.Input[_builtins.str]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            isp: Optional[pulumi.Input[_builtins.str]] = None,
            log_project: Optional[pulumi.Input[_builtins.str]] = None,
            log_store: Optional[pulumi.Input[_builtins.str]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            netmode: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            pricing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'Eip':
        """
        Get an existing Eip resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_name: The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        :param pulumi.Input[_builtins.str] bandwidth: Maximum bandwidth to the elastic public network, measured in Mbps (Mega bit per second). If this value is not specified, then automatically sets it to 5 Mbps.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not. Default value: `false`.
               - true: Enable deletion protection.
               - false: Disable deletion protection.
        :param pulumi.Input[_builtins.str] description: Description of the EIP instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        :param pulumi.Input[_builtins.str] instance_charge_type: (It has been deprecated from version 1.126.0 and using new attribute `payment_type` instead) Elastic IP instance charge type. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        :param pulumi.Input[_builtins.str] internet_charge_type: Internet charge type of the EIP, Valid values are `PayByBandwidth`, `PayByTraffic`. Default to `PayByBandwidth`. **NOTE:** From version `1.7.1` to `1.125.0`, it defaults to `PayByTraffic`. It is only "PayByBandwidth" when `instance_charge_type` is PrePaid.
        :param pulumi.Input[_builtins.str] ip_address: The elastic ip address
        :param pulumi.Input[_builtins.str] isp: The line type of the Elastic IP instance. Default to `BGP`. Other type of the isp need to open a whitelist.
        :param pulumi.Input[_builtins.str] name: It has been deprecated from version 1.126.0 and using new attribute `address_name` instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the EIP. Valid values: `Subscription` and `PayAsYouGo`. Default value is `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
               **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the eip belongs.
        :param pulumi.Input[_builtins.str] status: The EIP current status.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipState.__new__(_EipState)

        __props__.__dict__["activity_id"] = activity_id
        __props__.__dict__["address_name"] = address_name
        __props__.__dict__["allocation_id"] = allocation_id
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["high_definition_monitor_log_status"] = high_definition_monitor_log_status
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["isp"] = isp
        __props__.__dict__["log_project"] = log_project
        __props__.__dict__["log_store"] = log_store
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["netmode"] = netmode
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["public_ip_address_pool_id"] = public_ip_address_pool_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_protection_types"] = security_protection_types
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone"] = zone
        return Eip(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activityId")
    def activity_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "activity_id")

    @_builtins.property
    @pulumi.getter(name="addressName")
    def address_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        """
        return pulumi.get(self, "address_name")

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "allocation_id")

    @_builtins.property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.str]:
        """
        Maximum bandwidth to the elastic public network, measured in Mbps (Mega bit per second). If this value is not specified, then automatically sets it to 5 Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether enable the deletion protection or not. Default value: `false`.
        - true: Enable deletion protection.
        - false: Disable deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the EIP instance, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Default value is null.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="highDefinitionMonitorLogStatus")
    def high_definition_monitor_log_status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "high_definition_monitor_log_status")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")
    def instance_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        (It has been deprecated from version 1.126.0 and using new attribute `payment_type` instead) Elastic IP instance charge type. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        Internet charge type of the EIP, Valid values are `PayByBandwidth`, `PayByTraffic`. Default to `PayByBandwidth`. **NOTE:** From version `1.7.1` to `1.125.0`, it defaults to `PayByTraffic`. It is only "PayByBandwidth" when `instance_charge_type` is PrePaid.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The elastic ip address
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def isp(self) -> pulumi.Output[_builtins.str]:
        """
        The line type of the Elastic IP instance. Default to `BGP`. Other type of the isp need to open a whitelist.
        """
        return pulumi.get(self, "isp")

    @_builtins.property
    @pulumi.getter(name="logProject")
    def log_project(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "log_project")

    @_builtins.property
    @pulumi.getter(name="logStore")
    def log_store(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "log_store")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        It has been deprecated from version 1.126.0 and using new attribute `address_name` instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def netmode(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "netmode")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method of the EIP. Valid values: `Subscription` and `PayAsYouGo`. Default value is `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console.
        **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "pricing_cycle")

    @_builtins.property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "public_ip_address_pool_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of resource group which the eip belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "security_protection_types")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The EIP current status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "zone")

