# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EipSegmentAddressArgs', 'EipSegmentAddress']

@pulumi.input_type
class EipSegmentAddressArgs:
    def __init__(__self__, *,
                 eip_mask: pulumi.Input[_builtins.str],
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 netmode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EipSegmentAddress resource.
        :param pulumi.Input[_builtins.str] eip_mask: The subnet mask of the contiguous EIP group. Valid values:
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the contiguous EIP group. Unit: Mbit/s.
               - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByBandwidth`: `1` to `500`.****
               - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByTraffic`: `1` to `200`.****
               - Valid values when `InstanceChargeType` is set to `PrePaid`: `1` to `1000`.****
               
               Default value: `5`. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] internet_charge_type: The metering method of the contiguous EIP group. Valid values:
               - `PayByBandwidth` (default)
               - `PayByTraffic`
        :param pulumi.Input[_builtins.str] isp: The line type. Valid values:
               - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
               - `BGP_PRO`: BGP (Multi-ISP) Pro line BGP (Multi-ISP) Pro line is supported only in the China (Hong Kong), Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
               
               For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see [EIP line types](https://www.alibabacloud.com/help/en/doc-detail/32321.html).
               
               If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
               - `ChinaTelecom`
               - `ChinaUnicom`
               - `ChinaMobile`
               - `ChinaTelecom_L2`
               - `ChinaUnicom_L2`
               - `ChinaMobile_L2`
               
               If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        :param pulumi.Input[_builtins.str] netmode: The network type. Set the value to `public`, which specifies the public network type.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID.
        :param pulumi.Input[_builtins.str] zone: The zone of the contiguous EIP group.
        """
        pulumi.set(__self__, "eip_mask", eip_mask)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if netmode is not None:
            pulumi.set(__self__, "netmode", netmode)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="eipMask")
    def eip_mask(self) -> pulumi.Input[_builtins.str]:
        """
        The subnet mask of the contiguous EIP group. Valid values:
        """
        return pulumi.get(self, "eip_mask")

    @eip_mask.setter
    def eip_mask(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "eip_mask", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum bandwidth of the contiguous EIP group. Unit: Mbit/s.
        - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByBandwidth`: `1` to `500`.****
        - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByTraffic`: `1` to `200`.****
        - Valid values when `InstanceChargeType` is set to `PrePaid`: `1` to `1000`.****

        Default value: `5`. Unit: Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The metering method of the contiguous EIP group. Valid values:
        - `PayByBandwidth` (default)
        - `PayByTraffic`
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The line type. Valid values:
        - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
        - `BGP_PRO`: BGP (Multi-ISP) Pro line BGP (Multi-ISP) Pro line is supported only in the China (Hong Kong), Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.

        For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see [EIP line types](https://www.alibabacloud.com/help/en/doc-detail/32321.html).

        If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
        - `ChinaTelecom`
        - `ChinaUnicom`
        - `ChinaMobile`
        - `ChinaTelecom_L2`
        - `ChinaUnicom_L2`
        - `ChinaMobile_L2`

        If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isp", value)

    @_builtins.property
    @pulumi.getter
    def netmode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type. Set the value to `public`, which specifies the public network type.
        """
        return pulumi.get(self, "netmode")

    @netmode.setter
    def netmode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "netmode", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone of the contiguous EIP group.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _EipSegmentAddressState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 netmode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 segment_address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EipSegmentAddress resources.
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the contiguous EIP group. Unit: Mbit/s.
               - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByBandwidth`: `1` to `500`.****
               - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByTraffic`: `1` to `200`.****
               - Valid values when `InstanceChargeType` is set to `PrePaid`: `1` to `1000`.****
               
               Default value: `5`. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] create_time: The time when the contiguous Elastic IP address group was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] eip_mask: The subnet mask of the contiguous EIP group. Valid values:
        :param pulumi.Input[_builtins.str] internet_charge_type: The metering method of the contiguous EIP group. Valid values:
               - `PayByBandwidth` (default)
               - `PayByTraffic`
        :param pulumi.Input[_builtins.str] isp: The line type. Valid values:
               - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
               - `BGP_PRO`: BGP (Multi-ISP) Pro line BGP (Multi-ISP) Pro line is supported only in the China (Hong Kong), Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
               
               For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see [EIP line types](https://www.alibabacloud.com/help/en/doc-detail/32321.html).
               
               If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
               - `ChinaTelecom`
               - `ChinaUnicom`
               - `ChinaMobile`
               - `ChinaTelecom_L2`
               - `ChinaUnicom_L2`
               - `ChinaMobile_L2`
               
               If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        :param pulumi.Input[_builtins.str] netmode: The network type. Set the value to `public`, which specifies the public network type.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID.
        :param pulumi.Input[_builtins.str] segment_address_name: The name of the contiguous Elastic IP address group.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] zone: The zone of the contiguous EIP group.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if eip_mask is not None:
            pulumi.set(__self__, "eip_mask", eip_mask)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if netmode is not None:
            pulumi.set(__self__, "netmode", netmode)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if segment_address_name is not None:
            pulumi.set(__self__, "segment_address_name", segment_address_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum bandwidth of the contiguous EIP group. Unit: Mbit/s.
        - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByBandwidth`: `1` to `500`.****
        - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByTraffic`: `1` to `200`.****
        - Valid values when `InstanceChargeType` is set to `PrePaid`: `1` to `1000`.****

        Default value: `5`. Unit: Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the contiguous Elastic IP address group was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="eipMask")
    def eip_mask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subnet mask of the contiguous EIP group. Valid values:
        """
        return pulumi.get(self, "eip_mask")

    @eip_mask.setter
    def eip_mask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_mask", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The metering method of the contiguous EIP group. Valid values:
        - `PayByBandwidth` (default)
        - `PayByTraffic`
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The line type. Valid values:
        - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
        - `BGP_PRO`: BGP (Multi-ISP) Pro line BGP (Multi-ISP) Pro line is supported only in the China (Hong Kong), Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.

        For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see [EIP line types](https://www.alibabacloud.com/help/en/doc-detail/32321.html).

        If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
        - `ChinaTelecom`
        - `ChinaUnicom`
        - `ChinaMobile`
        - `ChinaTelecom_L2`
        - `ChinaUnicom_L2`
        - `ChinaMobile_L2`

        If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isp", value)

    @_builtins.property
    @pulumi.getter
    def netmode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type. Set the value to `public`, which specifies the public network type.
        """
        return pulumi.get(self, "netmode")

    @netmode.setter
    def netmode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "netmode", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="segmentAddressName")
    def segment_address_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the contiguous Elastic IP address group.
        """
        return pulumi.get(self, "segment_address_name")

    @segment_address_name.setter
    def segment_address_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "segment_address_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone of the contiguous EIP group.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("alicloud:ecs/eipSegmentAddress:EipSegmentAddress")
class EipSegmentAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 netmode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a EIP Segment Address resource.

        For information about EIP Segment Address and how to use it, see [What is Segment Address](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/allocateeipsegmentaddress).

        > **NOTE:** Available since v1.207.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ecs.EipSegmentAddress("default",
            eip_mask="28",
            bandwidth="5",
            isp="BGP",
            internet_charge_type="PayByBandwidth",
            netmode="public")
        ```

        ## Import

        EIP Segment Address can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/eipSegmentAddress:EipSegmentAddress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the contiguous EIP group. Unit: Mbit/s.
               - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByBandwidth`: `1` to `500`.****
               - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByTraffic`: `1` to `200`.****
               - Valid values when `InstanceChargeType` is set to `PrePaid`: `1` to `1000`.****
               
               Default value: `5`. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] eip_mask: The subnet mask of the contiguous EIP group. Valid values:
        :param pulumi.Input[_builtins.str] internet_charge_type: The metering method of the contiguous EIP group. Valid values:
               - `PayByBandwidth` (default)
               - `PayByTraffic`
        :param pulumi.Input[_builtins.str] isp: The line type. Valid values:
               - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
               - `BGP_PRO`: BGP (Multi-ISP) Pro line BGP (Multi-ISP) Pro line is supported only in the China (Hong Kong), Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
               
               For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see [EIP line types](https://www.alibabacloud.com/help/en/doc-detail/32321.html).
               
               If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
               - `ChinaTelecom`
               - `ChinaUnicom`
               - `ChinaMobile`
               - `ChinaTelecom_L2`
               - `ChinaUnicom_L2`
               - `ChinaMobile_L2`
               
               If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        :param pulumi.Input[_builtins.str] netmode: The network type. Set the value to `public`, which specifies the public network type.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID.
        :param pulumi.Input[_builtins.str] zone: The zone of the contiguous EIP group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EipSegmentAddressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a EIP Segment Address resource.

        For information about EIP Segment Address and how to use it, see [What is Segment Address](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/allocateeipsegmentaddress).

        > **NOTE:** Available since v1.207.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ecs.EipSegmentAddress("default",
            eip_mask="28",
            bandwidth="5",
            isp="BGP",
            internet_charge_type="PayByBandwidth",
            netmode="public")
        ```

        ## Import

        EIP Segment Address can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/eipSegmentAddress:EipSegmentAddress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EipSegmentAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipSegmentAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 isp: Optional[pulumi.Input[_builtins.str]] = None,
                 netmode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipSegmentAddressArgs.__new__(EipSegmentAddressArgs)

            __props__.__dict__["bandwidth"] = bandwidth
            if eip_mask is None and not opts.urn:
                raise TypeError("Missing required property 'eip_mask'")
            __props__.__dict__["eip_mask"] = eip_mask
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["isp"] = isp
            __props__.__dict__["netmode"] = netmode
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["zone"] = zone
            __props__.__dict__["create_time"] = None
            __props__.__dict__["segment_address_name"] = None
            __props__.__dict__["status"] = None
        super(EipSegmentAddress, __self__).__init__(
            'alicloud:ecs/eipSegmentAddress:EipSegmentAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            eip_mask: Optional[pulumi.Input[_builtins.str]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            isp: Optional[pulumi.Input[_builtins.str]] = None,
            netmode: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            segment_address_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'EipSegmentAddress':
        """
        Get an existing EipSegmentAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bandwidth: The maximum bandwidth of the contiguous EIP group. Unit: Mbit/s.
               - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByBandwidth`: `1` to `500`.****
               - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByTraffic`: `1` to `200`.****
               - Valid values when `InstanceChargeType` is set to `PrePaid`: `1` to `1000`.****
               
               Default value: `5`. Unit: Mbit/s.
        :param pulumi.Input[_builtins.str] create_time: The time when the contiguous Elastic IP address group was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[_builtins.str] eip_mask: The subnet mask of the contiguous EIP group. Valid values:
        :param pulumi.Input[_builtins.str] internet_charge_type: The metering method of the contiguous EIP group. Valid values:
               - `PayByBandwidth` (default)
               - `PayByTraffic`
        :param pulumi.Input[_builtins.str] isp: The line type. Valid values:
               - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
               - `BGP_PRO`: BGP (Multi-ISP) Pro line BGP (Multi-ISP) Pro line is supported only in the China (Hong Kong), Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.
               
               For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see [EIP line types](https://www.alibabacloud.com/help/en/doc-detail/32321.html).
               
               If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
               - `ChinaTelecom`
               - `ChinaUnicom`
               - `ChinaMobile`
               - `ChinaTelecom_L2`
               - `ChinaUnicom_L2`
               - `ChinaMobile_L2`
               
               If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        :param pulumi.Input[_builtins.str] netmode: The network type. Set the value to `public`, which specifies the public network type.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group ID.
        :param pulumi.Input[_builtins.str] segment_address_name: The name of the contiguous Elastic IP address group.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[_builtins.str] zone: The zone of the contiguous EIP group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipSegmentAddressState.__new__(_EipSegmentAddressState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["eip_mask"] = eip_mask
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["isp"] = isp
        __props__.__dict__["netmode"] = netmode
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["segment_address_name"] = segment_address_name
        __props__.__dict__["status"] = status
        __props__.__dict__["zone"] = zone
        return EipSegmentAddress(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The maximum bandwidth of the contiguous EIP group. Unit: Mbit/s.
        - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByBandwidth`: `1` to `500`.****
        - Valid values when `InstanceChargeType` is set to `PostPaid` and `InternetChargeType` is set to `PayByTraffic`: `1` to `200`.****
        - Valid values when `InstanceChargeType` is set to `PrePaid`: `1` to `1000`.****

        Default value: `5`. Unit: Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the contiguous Elastic IP address group was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="eipMask")
    def eip_mask(self) -> pulumi.Output[_builtins.str]:
        """
        The subnet mask of the contiguous EIP group. Valid values:
        """
        return pulumi.get(self, "eip_mask")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The metering method of the contiguous EIP group. Valid values:
        - `PayByBandwidth` (default)
        - `PayByTraffic`
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter
    def isp(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The line type. Valid values:
        - `BGP` (default): BGP (Multi-ISP) line The BGP (Multi-ISP) line is supported in all regions.
        - `BGP_PRO`: BGP (Multi-ISP) Pro line BGP (Multi-ISP) Pro line is supported only in the China (Hong Kong), Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions.

        For more information about the BGP (Multi-ISP) line and BGP (Multi-ISP) Pro line, see [EIP line types](https://www.alibabacloud.com/help/en/doc-detail/32321.html).

        If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
        - `ChinaTelecom`
        - `ChinaUnicom`
        - `ChinaMobile`
        - `ChinaTelecom_L2`
        - `ChinaUnicom_L2`
        - `ChinaMobile_L2`

        If your services are deployed in China East 1 Finance, this parameter is required and you must set the parameter to `BGP_FinanceCloud`.
        """
        return pulumi.get(self, "isp")

    @_builtins.property
    @pulumi.getter
    def netmode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The network type. Set the value to `public`, which specifies the public network type.
        """
        return pulumi.get(self, "netmode")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource group ID.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="segmentAddressName")
    def segment_address_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the contiguous Elastic IP address group.
        """
        return pulumi.get(self, "segment_address_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        The zone of the contiguous EIP group.
        """
        return pulumi.get(self, "zone")

