# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEcsImagePipelineResult',
    'AwaitableGetEcsImagePipelineResult',
    'get_ecs_image_pipeline',
    'get_ecs_image_pipeline_output',
]

@pulumi.output_type
class GetEcsImagePipelineResult:
    """
    A collection of values returned by getEcsImagePipeline.
    """
    def __init__(__self__, id=None, ids=None, name=None, name_regex=None, names=None, output_file=None, pipelines=None, resource_group_id=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if pipelines and not isinstance(pipelines, list):
            raise TypeError("Expected argument 'pipelines' to be a list")
        pulumi.set(__self__, "pipelines", pipelines)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def pipelines(self) -> Sequence['outputs.GetEcsImagePipelinePipelineResult']:
        return pulumi.get(self, "pipelines")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags")


class AwaitableGetEcsImagePipelineResult(GetEcsImagePipelineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEcsImagePipelineResult(
            id=self.id,
            ids=self.ids,
            name=self.name,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            pipelines=self.pipelines,
            resource_group_id=self.resource_group_id,
            tags=self.tags)


def get_ecs_image_pipeline(ids: Optional[Sequence[_builtins.str]] = None,
                           name: Optional[_builtins.str] = None,
                           name_regex: Optional[_builtins.str] = None,
                           output_file: Optional[_builtins.str] = None,
                           resource_group_id: Optional[_builtins.str] = None,
                           tags: Optional[Mapping[str, _builtins.str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEcsImagePipelineResult:
    """
    This data source provides the Ecs Image Pipelines of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.163.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ecs.get_ecs_image_pipeline(ids=["example_value"])
    pulumi.export("ecsImagePipelineId1", ids.pipelines[0].id)
    name_regex = alicloud.ecs.get_ecs_image_pipeline(name_regex="^my-ImagePipeline")
    pulumi.export("ecsImagePipelineId2", name_regex.pipelines[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Image Pipeline ids.
    :param _builtins.str name: The name of the image template.
    :param _builtins.str name_regex: A regex string to filter results by Image Pipeline name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group to which the image template belongs.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ecs/getEcsImagePipeline:getEcsImagePipeline', __args__, opts=opts, typ=GetEcsImagePipelineResult).value

    return AwaitableGetEcsImagePipelineResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name=pulumi.get(__ret__, 'name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        pipelines=pulumi.get(__ret__, 'pipelines'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_ecs_image_pipeline_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                  name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEcsImagePipelineResult]:
    """
    This data source provides the Ecs Image Pipelines of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.163.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ecs.get_ecs_image_pipeline(ids=["example_value"])
    pulumi.export("ecsImagePipelineId1", ids.pipelines[0].id)
    name_regex = alicloud.ecs.get_ecs_image_pipeline(name_regex="^my-ImagePipeline")
    pulumi.export("ecsImagePipelineId2", name_regex.pipelines[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Image Pipeline ids.
    :param _builtins.str name: The name of the image template.
    :param _builtins.str name_regex: A regex string to filter results by Image Pipeline name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group to which the image template belongs.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ecs/getEcsImagePipeline:getEcsImagePipeline', __args__, opts=opts, typ=GetEcsImagePipelineResult)
    return __ret__.apply(lambda __response__: GetEcsImagePipelineResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name=pulumi.get(__response__, 'name'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        pipelines=pulumi.get(__response__, 'pipelines'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        tags=pulumi.get(__response__, 'tags')))
