# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEcsSnapshotsResult',
    'AwaitableGetEcsSnapshotsResult',
    'get_ecs_snapshots',
    'get_ecs_snapshots_output',
]

@pulumi.output_type
class GetEcsSnapshotsResult:
    """
    A collection of values returned by getEcsSnapshots.
    """
    def __init__(__self__, category=None, dry_run=None, encrypted=None, id=None, ids=None, kms_key_id=None, name_regex=None, names=None, output_file=None, resource_group_id=None, snapshot_link_id=None, snapshot_name=None, snapshot_type=None, snapshots=None, source_disk_type=None, status=None, tags=None, type=None, usage=None):
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if dry_run and not isinstance(dry_run, bool):
            raise TypeError("Expected argument 'dry_run' to be a bool")
        pulumi.set(__self__, "dry_run", dry_run)
        if encrypted and not isinstance(encrypted, bool):
            raise TypeError("Expected argument 'encrypted' to be a bool")
        pulumi.set(__self__, "encrypted", encrypted)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if snapshot_link_id and not isinstance(snapshot_link_id, str):
            raise TypeError("Expected argument 'snapshot_link_id' to be a str")
        pulumi.set(__self__, "snapshot_link_id", snapshot_link_id)
        if snapshot_name and not isinstance(snapshot_name, str):
            raise TypeError("Expected argument 'snapshot_name' to be a str")
        pulumi.set(__self__, "snapshot_name", snapshot_name)
        if snapshot_type and not isinstance(snapshot_type, str):
            raise TypeError("Expected argument 'snapshot_type' to be a str")
        pulumi.set(__self__, "snapshot_type", snapshot_type)
        if snapshots and not isinstance(snapshots, list):
            raise TypeError("Expected argument 'snapshots' to be a list")
        pulumi.set(__self__, "snapshots", snapshots)
        if source_disk_type and not isinstance(source_disk_type, str):
            raise TypeError("Expected argument 'source_disk_type' to be a str")
        pulumi.set(__self__, "source_disk_type", source_disk_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if usage and not isinstance(usage, str):
            raise TypeError("Expected argument 'usage' to be a str")
        pulumi.set(__self__, "usage", usage)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[_builtins.str]:
        """
        The category of the snapshot.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the snapshot was encrypted.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Snapshot names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource group to which the snapshot belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="snapshotLinkId")
    def snapshot_link_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "snapshot_link_id")

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[_builtins.str]:
        """
        The name of the snapshot.
        """
        return pulumi.get(self, "snapshot_name")

    @_builtins.property
    @pulumi.getter(name="snapshotType")
    def snapshot_type(self) -> Optional[_builtins.str]:
        """
        The type of the snapshot.
        """
        return pulumi.get(self, "snapshot_type")

    @_builtins.property
    @pulumi.getter
    def snapshots(self) -> Sequence['outputs.GetEcsSnapshotsSnapshotResult']:
        """
        A list of Ecs Snapshots. Each element contains the following attributes:
        """
        return pulumi.get(self, "snapshots")

    @_builtins.property
    @pulumi.getter(name="sourceDiskType")
    def source_disk_type(self) -> Optional[_builtins.str]:
        """
        The type of the source disk.
        """
        return pulumi.get(self, "source_disk_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the snapshot.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The tags of the snapshot.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the snapshot.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional[_builtins.str]:
        """
        Indicates whether the snapshot was used to create images or cloud disks.
        """
        return pulumi.get(self, "usage")


class AwaitableGetEcsSnapshotsResult(GetEcsSnapshotsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEcsSnapshotsResult(
            category=self.category,
            dry_run=self.dry_run,
            encrypted=self.encrypted,
            id=self.id,
            ids=self.ids,
            kms_key_id=self.kms_key_id,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id,
            snapshot_link_id=self.snapshot_link_id,
            snapshot_name=self.snapshot_name,
            snapshot_type=self.snapshot_type,
            snapshots=self.snapshots,
            source_disk_type=self.source_disk_type,
            status=self.status,
            tags=self.tags,
            type=self.type,
            usage=self.usage)


def get_ecs_snapshots(category: Optional[_builtins.str] = None,
                      dry_run: Optional[_builtins.bool] = None,
                      encrypted: Optional[_builtins.bool] = None,
                      ids: Optional[Sequence[_builtins.str]] = None,
                      kms_key_id: Optional[_builtins.str] = None,
                      name_regex: Optional[_builtins.str] = None,
                      output_file: Optional[_builtins.str] = None,
                      resource_group_id: Optional[_builtins.str] = None,
                      snapshot_link_id: Optional[_builtins.str] = None,
                      snapshot_name: Optional[_builtins.str] = None,
                      snapshot_type: Optional[_builtins.str] = None,
                      source_disk_type: Optional[_builtins.str] = None,
                      status: Optional[_builtins.str] = None,
                      tags: Optional[Mapping[str, _builtins.str]] = None,
                      type: Optional[_builtins.str] = None,
                      usage: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEcsSnapshotsResult:
    """
    This data source provides the Ecs Snapshots of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.120.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.resourcemanager.get_resource_groups(status="OK")
    default_get_zones = alicloud.get_zones(available_disk_category="cloud_essd",
        available_resource_creation="VSwitch")
    default_get_images = alicloud.ecs.get_images(most_recent=True,
        owners="system")
    default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_get_zones.zones[0].id,
        image_id=default_get_images.images[0].id,
        system_disk_category="cloud_essd")
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="192.168.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vswitch_name=name,
        vpc_id=default_network.id,
        cidr_block="192.168.192.0/24",
        zone_id=default_get_zones.zones[0].id)
    default_security_group = alicloud.ecs.SecurityGroup("default",
        name=name,
        vpc_id=default_network.id)
    default_instance = alicloud.ecs.Instance("default",
        image_id=default_get_images.images[0].id,
        instance_type=default_get_instance_types.instance_types[0].id,
        security_groups=[__item.id for __item in [default_security_group]],
        internet_charge_type="PayByTraffic",
        internet_max_bandwidth_out=10,
        availability_zone=default_get_instance_types.instance_types[0].availability_zones[0],
        instance_charge_type="PostPaid",
        system_disk_category="cloud_essd",
        vswitch_id=default_switch.id,
        instance_name=name,
        data_disks=[{
            "category": "cloud_essd",
            "size": 20,
        }])
    default_ecs_disk = alicloud.ecs.EcsDisk("default",
        disk_name=name,
        zone_id=default_get_instance_types.instance_types[0].availability_zones[0],
        category="cloud_essd",
        size=500)
    default_ecs_disk_attachment = alicloud.ecs.EcsDiskAttachment("default",
        disk_id=default_ecs_disk.id,
        instance_id=default_instance.id)
    default_ecs_snapshot = alicloud.ecs.EcsSnapshot("default",
        disk_id=default_ecs_disk_attachment.disk_id,
        category="standard",
        retention_days=20,
        snapshot_name=name,
        description=name,
        tags={
            "Created": "TF",
            "For": "Snapshot",
        })
    ids = alicloud.ecs.get_ecs_snapshots_output(ids=[default_ecs_snapshot.id])
    pulumi.export("ecsSnapshotsId0", ids.snapshots[0].id)
    ```


    :param _builtins.str category: The category of the snapshot. Valid Values: `flash` and `standard`.
    :param _builtins.bool dry_run: Specifies whether to check the validity of the request without actually making the request.
    :param _builtins.bool encrypted: Specifies whether the snapshot is encrypted.
    :param Sequence[_builtins.str] ids: A list of Snapshot IDs.
    :param _builtins.str kms_key_id: The kms key id.
    :param _builtins.str name_regex: A regex string to filter results by Snapshot name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The resource group id.
    :param _builtins.str snapshot_link_id: The snapshot link id.
    :param _builtins.str snapshot_name: The name of the snapshot.
    :param _builtins.str snapshot_type: The type of the snapshot. Valid Values: `auto`, `user` and `all`. Default to: `all`.
    :param _builtins.str source_disk_type: The type of the disk for which the snapshot was created. Valid Values: `System`, `Data`.
    :param _builtins.str status: The status of the snapshot. Valid Values: `accomplished`, `failed`, `progressing` and `all`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the snapshot.
    :param _builtins.str type: The type of the snapshot. Valid Values: `auto`, `user` and `all`. Default to: `all`.
    :param _builtins.str usage: A resource type that has a reference relationship. Valid Values: `image`, `disk`, `image_disk` and `none`.
    """
    __args__ = dict()
    __args__['category'] = category
    __args__['dryRun'] = dry_run
    __args__['encrypted'] = encrypted
    __args__['ids'] = ids
    __args__['kmsKeyId'] = kms_key_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['snapshotLinkId'] = snapshot_link_id
    __args__['snapshotName'] = snapshot_name
    __args__['snapshotType'] = snapshot_type
    __args__['sourceDiskType'] = source_disk_type
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['type'] = type
    __args__['usage'] = usage
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ecs/getEcsSnapshots:getEcsSnapshots', __args__, opts=opts, typ=GetEcsSnapshotsResult).value

    return AwaitableGetEcsSnapshotsResult(
        category=pulumi.get(__ret__, 'category'),
        dry_run=pulumi.get(__ret__, 'dry_run'),
        encrypted=pulumi.get(__ret__, 'encrypted'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        snapshot_link_id=pulumi.get(__ret__, 'snapshot_link_id'),
        snapshot_name=pulumi.get(__ret__, 'snapshot_name'),
        snapshot_type=pulumi.get(__ret__, 'snapshot_type'),
        snapshots=pulumi.get(__ret__, 'snapshots'),
        source_disk_type=pulumi.get(__ret__, 'source_disk_type'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        usage=pulumi.get(__ret__, 'usage'))
def get_ecs_snapshots_output(category: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             dry_run: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                             encrypted: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                             ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                             kms_key_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             snapshot_link_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             snapshot_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             snapshot_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             source_disk_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                             type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             usage: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEcsSnapshotsResult]:
    """
    This data source provides the Ecs Snapshots of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.120.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.resourcemanager.get_resource_groups(status="OK")
    default_get_zones = alicloud.get_zones(available_disk_category="cloud_essd",
        available_resource_creation="VSwitch")
    default_get_images = alicloud.ecs.get_images(most_recent=True,
        owners="system")
    default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_get_zones.zones[0].id,
        image_id=default_get_images.images[0].id,
        system_disk_category="cloud_essd")
    default_network = alicloud.vpc.Network("default",
        vpc_name=name,
        cidr_block="192.168.0.0/16")
    default_switch = alicloud.vpc.Switch("default",
        vswitch_name=name,
        vpc_id=default_network.id,
        cidr_block="192.168.192.0/24",
        zone_id=default_get_zones.zones[0].id)
    default_security_group = alicloud.ecs.SecurityGroup("default",
        name=name,
        vpc_id=default_network.id)
    default_instance = alicloud.ecs.Instance("default",
        image_id=default_get_images.images[0].id,
        instance_type=default_get_instance_types.instance_types[0].id,
        security_groups=[__item.id for __item in [default_security_group]],
        internet_charge_type="PayByTraffic",
        internet_max_bandwidth_out=10,
        availability_zone=default_get_instance_types.instance_types[0].availability_zones[0],
        instance_charge_type="PostPaid",
        system_disk_category="cloud_essd",
        vswitch_id=default_switch.id,
        instance_name=name,
        data_disks=[{
            "category": "cloud_essd",
            "size": 20,
        }])
    default_ecs_disk = alicloud.ecs.EcsDisk("default",
        disk_name=name,
        zone_id=default_get_instance_types.instance_types[0].availability_zones[0],
        category="cloud_essd",
        size=500)
    default_ecs_disk_attachment = alicloud.ecs.EcsDiskAttachment("default",
        disk_id=default_ecs_disk.id,
        instance_id=default_instance.id)
    default_ecs_snapshot = alicloud.ecs.EcsSnapshot("default",
        disk_id=default_ecs_disk_attachment.disk_id,
        category="standard",
        retention_days=20,
        snapshot_name=name,
        description=name,
        tags={
            "Created": "TF",
            "For": "Snapshot",
        })
    ids = alicloud.ecs.get_ecs_snapshots_output(ids=[default_ecs_snapshot.id])
    pulumi.export("ecsSnapshotsId0", ids.snapshots[0].id)
    ```


    :param _builtins.str category: The category of the snapshot. Valid Values: `flash` and `standard`.
    :param _builtins.bool dry_run: Specifies whether to check the validity of the request without actually making the request.
    :param _builtins.bool encrypted: Specifies whether the snapshot is encrypted.
    :param Sequence[_builtins.str] ids: A list of Snapshot IDs.
    :param _builtins.str kms_key_id: The kms key id.
    :param _builtins.str name_regex: A regex string to filter results by Snapshot name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The resource group id.
    :param _builtins.str snapshot_link_id: The snapshot link id.
    :param _builtins.str snapshot_name: The name of the snapshot.
    :param _builtins.str snapshot_type: The type of the snapshot. Valid Values: `auto`, `user` and `all`. Default to: `all`.
    :param _builtins.str source_disk_type: The type of the disk for which the snapshot was created. Valid Values: `System`, `Data`.
    :param _builtins.str status: The status of the snapshot. Valid Values: `accomplished`, `failed`, `progressing` and `all`.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the snapshot.
    :param _builtins.str type: The type of the snapshot. Valid Values: `auto`, `user` and `all`. Default to: `all`.
    :param _builtins.str usage: A resource type that has a reference relationship. Valid Values: `image`, `disk`, `image_disk` and `none`.
    """
    __args__ = dict()
    __args__['category'] = category
    __args__['dryRun'] = dry_run
    __args__['encrypted'] = encrypted
    __args__['ids'] = ids
    __args__['kmsKeyId'] = kms_key_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['snapshotLinkId'] = snapshot_link_id
    __args__['snapshotName'] = snapshot_name
    __args__['snapshotType'] = snapshot_type
    __args__['sourceDiskType'] = source_disk_type
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['type'] = type
    __args__['usage'] = usage
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ecs/getEcsSnapshots:getEcsSnapshots', __args__, opts=opts, typ=GetEcsSnapshotsResult)
    return __ret__.apply(lambda __response__: GetEcsSnapshotsResult(
        category=pulumi.get(__response__, 'category'),
        dry_run=pulumi.get(__response__, 'dry_run'),
        encrypted=pulumi.get(__response__, 'encrypted'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        snapshot_link_id=pulumi.get(__response__, 'snapshot_link_id'),
        snapshot_name=pulumi.get(__response__, 'snapshot_name'),
        snapshot_type=pulumi.get(__response__, 'snapshot_type'),
        snapshots=pulumi.get(__response__, 'snapshots'),
        source_disk_type=pulumi.get(__response__, 'source_disk_type'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        usage=pulumi.get(__response__, 'usage')))
