# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, availability_zone=None, enable_details=None, id=None, ids=None, image_id=None, instance_name=None, instances=None, name_regex=None, names=None, output_file=None, page_number=None, page_size=None, ram_role_name=None, resource_group_id=None, status=None, tags=None, total_count=None, vpc_id=None, vswitch_id=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if instance_name and not isinstance(instance_name, str):
            raise TypeError("Expected argument 'instance_name' to be a str")
        pulumi.set(__self__, "instance_name", instance_name)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if ram_role_name and not isinstance(ram_role_name, str):
            raise TypeError("Expected argument 'ram_role_name' to be a str")
        pulumi.set(__self__, "ram_role_name", ram_role_name)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id and not isinstance(vswitch_id, str):
            raise TypeError("Expected argument 'vswitch_id' to be a str")
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[_builtins.str]:
        """
        Availability zone the instance belongs to.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enable_details")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[_builtins.str]:
        """
        Image ID the instance is using.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetInstancesInstanceResult']:
        """
        A list of instances. Each element contains the following attributes:
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of instances names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[_builtins.str]:
        """
        The Ram role name.
        """
        return pulumi.get(self, "ram_role_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The Id of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Instance current status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the ECS instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> _builtins.int:
        return pulumi.get(self, "total_count")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        ID of the VPC the instance belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[_builtins.str]:
        """
        ID of the vSwitch the instance belongs to.
        """
        return pulumi.get(self, "vswitch_id")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            availability_zone=self.availability_zone,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            image_id=self.image_id,
            instance_name=self.instance_name,
            instances=self.instances,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            ram_role_name=self.ram_role_name,
            resource_group_id=self.resource_group_id,
            status=self.status,
            tags=self.tags,
            total_count=self.total_count,
            vpc_id=self.vpc_id,
            vswitch_id=self.vswitch_id)


def get_instances(availability_zone: Optional[_builtins.str] = None,
                  enable_details: Optional[_builtins.bool] = None,
                  ids: Optional[Sequence[_builtins.str]] = None,
                  image_id: Optional[_builtins.str] = None,
                  instance_name: Optional[_builtins.str] = None,
                  name_regex: Optional[_builtins.str] = None,
                  output_file: Optional[_builtins.str] = None,
                  page_number: Optional[_builtins.int] = None,
                  page_size: Optional[_builtins.int] = None,
                  ram_role_name: Optional[_builtins.str] = None,
                  resource_group_id: Optional[_builtins.str] = None,
                  status: Optional[_builtins.str] = None,
                  tags: Optional[Mapping[str, _builtins.str]] = None,
                  vpc_id: Optional[_builtins.str] = None,
                  vswitch_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    The Instances data source list ECS instance resources according to their ID, name regex, image id, status and other fields.

    > **NOTE:** Available since v1.7.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    instances_ds = alicloud.ecs.get_instances(name_regex="web_server",
        status="Running")
    pulumi.export("firstInstanceId", instances_ds.instances[0].id)
    pulumi.export("instanceIds", instances_ds.ids)
    ```


    :param _builtins.str availability_zone: Availability zone where instances are located.
    :param _builtins.bool enable_details: Default to `true`. If false, the attributes `ram_role_name` and `disk_device_mappings` will not be fetched and output.
    :param Sequence[_builtins.str] ids: A list of ECS instance IDs.
    :param _builtins.str image_id: The image ID of some ECS instance used.
    :param _builtins.str instance_name: The name of the instance. Fuzzy search with the asterisk (*) wildcard characters is supported.
    :param _builtins.str name_regex: A regex string to filter results by instance name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str ram_role_name: The RAM role name which the instance attaches.
    :param _builtins.str resource_group_id: The ID of resource group which the instance belongs.
    :param _builtins.str status: Instance status. Valid values: "Creating", "Starting", "Running", "Stopping" and "Stopped". If undefined, all statuses are considered.
    :param Mapping[str, _builtins.str] tags: A map of tags assigned to the ECS instances. It must be in the format:
           ```python
           import pulumi
           import pulumi_alicloud as alicloud
           
           tagged_instances = alicloud.ecs.get_instances(tags={
               "tagKey1": "tagValue1",
               "tagKey2": "tagValue2",
           })
           ```
    :param _builtins.str vpc_id: ID of the VPC linked to the instances.
    :param _builtins.str vswitch_id: ID of the vSwitch linked to the instances.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['imageId'] = image_id
    __args__['instanceName'] = instance_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['ramRoleName'] = ram_role_name
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    __args__['vswitchId'] = vswitch_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ecs/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        image_id=pulumi.get(__ret__, 'image_id'),
        instance_name=pulumi.get(__ret__, 'instance_name'),
        instances=pulumi.get(__ret__, 'instances'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        ram_role_name=pulumi.get(__ret__, 'ram_role_name'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        vswitch_id=pulumi.get(__ret__, 'vswitch_id'))
def get_instances_output(availability_zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         enable_details: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                         ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                         image_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         instance_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                         page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                         ram_role_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                         vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         vswitch_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancesResult]:
    """
    The Instances data source list ECS instance resources according to their ID, name regex, image id, status and other fields.

    > **NOTE:** Available since v1.7.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    instances_ds = alicloud.ecs.get_instances(name_regex="web_server",
        status="Running")
    pulumi.export("firstInstanceId", instances_ds.instances[0].id)
    pulumi.export("instanceIds", instances_ds.ids)
    ```


    :param _builtins.str availability_zone: Availability zone where instances are located.
    :param _builtins.bool enable_details: Default to `true`. If false, the attributes `ram_role_name` and `disk_device_mappings` will not be fetched and output.
    :param Sequence[_builtins.str] ids: A list of ECS instance IDs.
    :param _builtins.str image_id: The image ID of some ECS instance used.
    :param _builtins.str instance_name: The name of the instance. Fuzzy search with the asterisk (*) wildcard characters is supported.
    :param _builtins.str name_regex: A regex string to filter results by instance name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str ram_role_name: The RAM role name which the instance attaches.
    :param _builtins.str resource_group_id: The ID of resource group which the instance belongs.
    :param _builtins.str status: Instance status. Valid values: "Creating", "Starting", "Running", "Stopping" and "Stopped". If undefined, all statuses are considered.
    :param Mapping[str, _builtins.str] tags: A map of tags assigned to the ECS instances. It must be in the format:
           ```python
           import pulumi
           import pulumi_alicloud as alicloud
           
           tagged_instances = alicloud.ecs.get_instances(tags={
               "tagKey1": "tagValue1",
               "tagKey2": "tagValue2",
           })
           ```
    :param _builtins.str vpc_id: ID of the VPC linked to the instances.
    :param _builtins.str vswitch_id: ID of the vSwitch linked to the instances.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['imageId'] = image_id
    __args__['instanceName'] = instance_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['ramRoleName'] = ram_role_name
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    __args__['vswitchId'] = vswitch_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ecs/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult)
    return __ret__.apply(lambda __response__: GetInstancesResult(
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        enable_details=pulumi.get(__response__, 'enable_details'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        image_id=pulumi.get(__response__, 'image_id'),
        instance_name=pulumi.get(__response__, 'instance_name'),
        instances=pulumi.get(__response__, 'instances'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        ram_role_name=pulumi.get(__response__, 'ram_role_name'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        total_count=pulumi.get(__response__, 'total_count'),
        vpc_id=pulumi.get(__response__, 'vpc_id'),
        vswitch_id=pulumi.get(__response__, 'vswitch_id')))
