# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImageImportArgs', 'ImageImport']

@pulumi.input_type
class ImageImportArgs:
    def __init__(__self__, *,
                 disk_device_mappings: pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]],
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ImageImport resource.
        :param pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]] disk_device_mappings: The information about the custom image. See `disk_device_mapping` below.
        :param pulumi.Input[_builtins.str] architecture: The architecture of the image. Default value: `x86_64`. Valid values: `x86_64`, `i386`.
        :param pulumi.Input[_builtins.str] boot_mode: The boot mode of the image. Valid values: `BIOS`, `UEFI`.
        :param pulumi.Input[_builtins.str] description: The description of the image. The `description` must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] image_name: The name of the image. The `image_name` must be `2` to `128` characters in length. The `image_name` must start with a letter and cannot start with acs: or aliyun. The `image_name` cannot contain http:// or https://. The `image_name` can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] license_type: The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`, `Aliyun`, `BYOL`.
        :param pulumi.Input[_builtins.str] os_type: The type of the operating system. Default value: `linux`. Valid values: `windows`, `linux`.
        :param pulumi.Input[_builtins.str] platform: The operating system platform. More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
               > **NOTE:** Before provider version 1.197.0, the default value of `platform` is `Ubuntu`.
        """
        pulumi.set(__self__, "disk_device_mappings", disk_device_mappings)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if boot_mode is not None:
            pulumi.set(__self__, "boot_mode", boot_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @_builtins.property
    @pulumi.getter(name="diskDeviceMappings")
    def disk_device_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]]:
        """
        The information about the custom image. See `disk_device_mapping` below.
        """
        return pulumi.get(self, "disk_device_mappings")

    @disk_device_mappings.setter
    def disk_device_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]]):
        pulumi.set(self, "disk_device_mappings", value)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The architecture of the image. Default value: `x86_64`. Valid values: `x86_64`, `i386`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "architecture", value)

    @_builtins.property
    @pulumi.getter(name="bootMode")
    def boot_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The boot mode of the image. Valid values: `BIOS`, `UEFI`.
        """
        return pulumi.get(self, "boot_mode")

    @boot_mode.setter
    def boot_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_mode", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the image. The `description` must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image. The `image_name` must be `2` to `128` characters in length. The `image_name` must start with a letter and cannot start with acs: or aliyun. The `image_name` cannot contain http:// or https://. The `image_name` can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`, `Aliyun`, `BYOL`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the operating system. Default value: `linux`. Valid values: `windows`, `linux`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system platform. More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
        > **NOTE:** Before provider version 1.197.0, the default value of `platform` is `Ubuntu`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)


@pulumi.input_type
class _ImageImportState:
    def __init__(__self__, *,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ImageImport resources.
        :param pulumi.Input[_builtins.str] architecture: The architecture of the image. Default value: `x86_64`. Valid values: `x86_64`, `i386`.
        :param pulumi.Input[_builtins.str] boot_mode: The boot mode of the image. Valid values: `BIOS`, `UEFI`.
        :param pulumi.Input[_builtins.str] description: The description of the image. The `description` must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]] disk_device_mappings: The information about the custom image. See `disk_device_mapping` below.
        :param pulumi.Input[_builtins.str] image_name: The name of the image. The `image_name` must be `2` to `128` characters in length. The `image_name` must start with a letter and cannot start with acs: or aliyun. The `image_name` cannot contain http:// or https://. The `image_name` can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] license_type: The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`, `Aliyun`, `BYOL`.
        :param pulumi.Input[_builtins.str] os_type: The type of the operating system. Default value: `linux`. Valid values: `windows`, `linux`.
        :param pulumi.Input[_builtins.str] platform: The operating system platform. More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
               > **NOTE:** Before provider version 1.197.0, the default value of `platform` is `Ubuntu`.
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if boot_mode is not None:
            pulumi.set(__self__, "boot_mode", boot_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_device_mappings is not None:
            pulumi.set(__self__, "disk_device_mappings", disk_device_mappings)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The architecture of the image. Default value: `x86_64`. Valid values: `x86_64`, `i386`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "architecture", value)

    @_builtins.property
    @pulumi.getter(name="bootMode")
    def boot_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The boot mode of the image. Valid values: `BIOS`, `UEFI`.
        """
        return pulumi.get(self, "boot_mode")

    @boot_mode.setter
    def boot_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_mode", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the image. The `description` must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskDeviceMappings")
    def disk_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]]]:
        """
        The information about the custom image. See `disk_device_mapping` below.
        """
        return pulumi.get(self, "disk_device_mappings")

    @disk_device_mappings.setter
    def disk_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]]]):
        pulumi.set(self, "disk_device_mappings", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image. The `image_name` must be `2` to `128` characters in length. The `image_name` must start with a letter and cannot start with acs: or aliyun. The `image_name` cannot contain http:// or https://. The `image_name` can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`, `Aliyun`, `BYOL`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the operating system. Default value: `linux`. Valid values: `windows`, `linux`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system platform. More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
        > **NOTE:** Before provider version 1.197.0, the default value of `platform` is `Ubuntu`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)


@pulumi.type_token("alicloud:ecs/imageImport:ImageImport")
class ImageImport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageImportDiskDeviceMappingArgs', 'ImageImportDiskDeviceMappingArgsDict']]]]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ECS Image Import resource.

        For information about ECS Image Import and how to use it, see [What is Image Import](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-ecs-2014-05-26-importimage).

        > **NOTE:** Available since v1.69.0.

        > **NOTE:** You must upload the image file to the object storage OSS in advance.

        > **NOTE:** The region where the image is imported must be the same region as the OSS bucket where the image file is uploaded.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-image-import-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_bucket = alicloud.oss.Bucket("default", bucket=f"{name}-{default['result']}")
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.id,
            key="fc/hello.zip",
            content=\"\"\"    # -*- coding: utf-8 -*-
            def handler(event, context):
            print "hello world"
            return 'hello world'
        \"\"\")
        default_image_import = alicloud.ecs.ImageImport("default",
            architecture="x86_64",
            os_type="linux",
            platform="Ubuntu",
            license_type="Auto",
            image_name=name,
            description=name,
            disk_device_mappings=[{
                "oss_bucket": default_bucket.id,
                "oss_object": default_bucket_object.id,
                "disk_image_size": 5,
            }])
        ```

        ## Import

        ECS Image Import can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/imageImport:ImageImport example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] architecture: The architecture of the image. Default value: `x86_64`. Valid values: `x86_64`, `i386`.
        :param pulumi.Input[_builtins.str] boot_mode: The boot mode of the image. Valid values: `BIOS`, `UEFI`.
        :param pulumi.Input[_builtins.str] description: The description of the image. The `description` must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageImportDiskDeviceMappingArgs', 'ImageImportDiskDeviceMappingArgsDict']]]] disk_device_mappings: The information about the custom image. See `disk_device_mapping` below.
        :param pulumi.Input[_builtins.str] image_name: The name of the image. The `image_name` must be `2` to `128` characters in length. The `image_name` must start with a letter and cannot start with acs: or aliyun. The `image_name` cannot contain http:// or https://. The `image_name` can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] license_type: The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`, `Aliyun`, `BYOL`.
        :param pulumi.Input[_builtins.str] os_type: The type of the operating system. Default value: `linux`. Valid values: `windows`, `linux`.
        :param pulumi.Input[_builtins.str] platform: The operating system platform. More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
               > **NOTE:** Before provider version 1.197.0, the default value of `platform` is `Ubuntu`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageImportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS Image Import resource.

        For information about ECS Image Import and how to use it, see [What is Image Import](https://www.alibabacloud.com/help/en/ecs/developer-reference/api-ecs-2014-05-26-importimage).

        > **NOTE:** Available since v1.69.0.

        > **NOTE:** You must upload the image file to the object storage OSS in advance.

        > **NOTE:** The region where the image is imported must be the same region as the OSS bucket where the image file is uploaded.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-image-import-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_bucket = alicloud.oss.Bucket("default", bucket=f"{name}-{default['result']}")
        default_bucket_object = alicloud.oss.BucketObject("default",
            bucket=default_bucket.id,
            key="fc/hello.zip",
            content=\"\"\"    # -*- coding: utf-8 -*-
            def handler(event, context):
            print "hello world"
            return 'hello world'
        \"\"\")
        default_image_import = alicloud.ecs.ImageImport("default",
            architecture="x86_64",
            os_type="linux",
            platform="Ubuntu",
            license_type="Auto",
            image_name=name,
            description=name,
            disk_device_mappings=[{
                "oss_bucket": default_bucket.id,
                "oss_object": default_bucket_object.id,
                "disk_image_size": 5,
            }])
        ```

        ## Import

        ECS Image Import can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ecs/imageImport:ImageImport example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ImageImportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageImportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageImportDiskDeviceMappingArgs', 'ImageImportDiskDeviceMappingArgsDict']]]]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageImportArgs.__new__(ImageImportArgs)

            __props__.__dict__["architecture"] = architecture
            __props__.__dict__["boot_mode"] = boot_mode
            __props__.__dict__["description"] = description
            if disk_device_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'disk_device_mappings'")
            __props__.__dict__["disk_device_mappings"] = disk_device_mappings
            __props__.__dict__["image_name"] = image_name
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["platform"] = platform
        super(ImageImport, __self__).__init__(
            'alicloud:ecs/imageImport:ImageImport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            architecture: Optional[pulumi.Input[_builtins.str]] = None,
            boot_mode: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageImportDiskDeviceMappingArgs', 'ImageImportDiskDeviceMappingArgsDict']]]]] = None,
            image_name: Optional[pulumi.Input[_builtins.str]] = None,
            license_type: Optional[pulumi.Input[_builtins.str]] = None,
            os_type: Optional[pulumi.Input[_builtins.str]] = None,
            platform: Optional[pulumi.Input[_builtins.str]] = None) -> 'ImageImport':
        """
        Get an existing ImageImport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] architecture: The architecture of the image. Default value: `x86_64`. Valid values: `x86_64`, `i386`.
        :param pulumi.Input[_builtins.str] boot_mode: The boot mode of the image. Valid values: `BIOS`, `UEFI`.
        :param pulumi.Input[_builtins.str] description: The description of the image. The `description` must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageImportDiskDeviceMappingArgs', 'ImageImportDiskDeviceMappingArgsDict']]]] disk_device_mappings: The information about the custom image. See `disk_device_mapping` below.
        :param pulumi.Input[_builtins.str] image_name: The name of the image. The `image_name` must be `2` to `128` characters in length. The `image_name` must start with a letter and cannot start with acs: or aliyun. The `image_name` cannot contain http:// or https://. The `image_name` can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] license_type: The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`, `Aliyun`, `BYOL`.
        :param pulumi.Input[_builtins.str] os_type: The type of the operating system. Default value: `linux`. Valid values: `windows`, `linux`.
        :param pulumi.Input[_builtins.str] platform: The operating system platform. More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
               > **NOTE:** Before provider version 1.197.0, the default value of `platform` is `Ubuntu`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageImportState.__new__(_ImageImportState)

        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["boot_mode"] = boot_mode
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_device_mappings"] = disk_device_mappings
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["platform"] = platform
        return ImageImport(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The architecture of the image. Default value: `x86_64`. Valid values: `x86_64`, `i386`.
        """
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter(name="bootMode")
    def boot_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The boot mode of the image. Valid values: `BIOS`, `UEFI`.
        """
        return pulumi.get(self, "boot_mode")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the image. The `description` must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskDeviceMappings")
    def disk_device_mappings(self) -> pulumi.Output[Sequence['outputs.ImageImportDiskDeviceMapping']]:
        """
        The information about the custom image. See `disk_device_mapping` below.
        """
        return pulumi.get(self, "disk_device_mappings")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the image. The `image_name` must be `2` to `128` characters in length. The `image_name` must start with a letter and cannot start with acs: or aliyun. The `image_name` cannot contain http:// or https://. The `image_name` can contain letters, digits, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`, `Aliyun`, `BYOL`.
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the operating system. Default value: `linux`. Valid values: `windows`, `linux`.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> pulumi.Output[_builtins.str]:
        """
        The operating system platform. More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
        > **NOTE:** Before provider version 1.197.0, the default value of `platform` is `Ubuntu`.
        """
        return pulumi.get(self, "platform")

