# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourceArgs', 'Resource']

@pulumi.input_type
class ResourceArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 cluster_name: pulumi.Input[_builtins.str],
                 machine_types: pulumi.Input['ResourceMachineTypesArgs'],
                 user_access_param: pulumi.Input['ResourceUserAccessParamArgs'],
                 cluster_desc: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Resource resource.
        :param pulumi.Input[_builtins.str] cluster_id: Used to uniquely identify a computing cluster.
        :param pulumi.Input[_builtins.str] cluster_name: Represents the name of the compute cluster, usually including the model number.
        :param pulumi.Input['ResourceMachineTypesArgs'] machine_types: Generally refers to the type or instance type of a computing resource. See `machine_types` below.
        :param pulumi.Input['ResourceUserAccessParamArgs'] user_access_param: Used to define the access parameters for the user. See `user_access_param` below.
        :param pulumi.Input[_builtins.str] cluster_desc: Used to provide a description or comment on the compute cluster.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "machine_types", machine_types)
        pulumi.set(__self__, "user_access_param", user_access_param)
        if cluster_desc is not None:
            pulumi.set(__self__, "cluster_desc", cluster_desc)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        Used to uniquely identify a computing cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        Represents the name of the compute cluster, usually including the model number.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="machineTypes")
    def machine_types(self) -> pulumi.Input['ResourceMachineTypesArgs']:
        """
        Generally refers to the type or instance type of a computing resource. See `machine_types` below.
        """
        return pulumi.get(self, "machine_types")

    @machine_types.setter
    def machine_types(self, value: pulumi.Input['ResourceMachineTypesArgs']):
        pulumi.set(self, "machine_types", value)

    @_builtins.property
    @pulumi.getter(name="userAccessParam")
    def user_access_param(self) -> pulumi.Input['ResourceUserAccessParamArgs']:
        """
        Used to define the access parameters for the user. See `user_access_param` below.
        """
        return pulumi.get(self, "user_access_param")

    @user_access_param.setter
    def user_access_param(self, value: pulumi.Input['ResourceUserAccessParamArgs']):
        pulumi.set(self, "user_access_param", value)

    @_builtins.property
    @pulumi.getter(name="clusterDesc")
    def cluster_desc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to provide a description or comment on the compute cluster.
        """
        return pulumi.get(self, "cluster_desc")

    @cluster_desc.setter
    def cluster_desc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_desc", value)


@pulumi.input_type
class _ResourceState:
    def __init__(__self__, *,
                 cluster_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_types: Optional[pulumi.Input['ResourceMachineTypesArgs']] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_access_param: Optional[pulumi.Input['ResourceUserAccessParamArgs']] = None):
        """
        Input properties used for looking up and filtering Resource resources.
        :param pulumi.Input[_builtins.str] cluster_desc: Used to provide a description or comment on the compute cluster.
        :param pulumi.Input[_builtins.str] cluster_id: Used to uniquely identify a computing cluster.
        :param pulumi.Input[_builtins.str] cluster_name: Represents the name of the compute cluster, usually including the model number.
        :param pulumi.Input['ResourceMachineTypesArgs'] machine_types: Generally refers to the type or instance type of a computing resource. See `machine_types` below.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the Resource.
        :param pulumi.Input['ResourceUserAccessParamArgs'] user_access_param: Used to define the access parameters for the user. See `user_access_param` below.
        """
        if cluster_desc is not None:
            pulumi.set(__self__, "cluster_desc", cluster_desc)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if machine_types is not None:
            pulumi.set(__self__, "machine_types", machine_types)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if user_access_param is not None:
            pulumi.set(__self__, "user_access_param", user_access_param)

    @_builtins.property
    @pulumi.getter(name="clusterDesc")
    def cluster_desc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to provide a description or comment on the compute cluster.
        """
        return pulumi.get(self, "cluster_desc")

    @cluster_desc.setter
    def cluster_desc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_desc", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to uniquely identify a computing cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Represents the name of the compute cluster, usually including the model number.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="machineTypes")
    def machine_types(self) -> Optional[pulumi.Input['ResourceMachineTypesArgs']]:
        """
        Generally refers to the type or instance type of a computing resource. See `machine_types` below.
        """
        return pulumi.get(self, "machine_types")

    @machine_types.setter
    def machine_types(self, value: Optional[pulumi.Input['ResourceMachineTypesArgs']]):
        pulumi.set(self, "machine_types", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="userAccessParam")
    def user_access_param(self) -> Optional[pulumi.Input['ResourceUserAccessParamArgs']]:
        """
        Used to define the access parameters for the user. See `user_access_param` below.
        """
        return pulumi.get(self, "user_access_param")

    @user_access_param.setter
    def user_access_param(self, value: Optional[pulumi.Input['ResourceUserAccessParamArgs']]):
        pulumi.set(self, "user_access_param", value)


@pulumi.type_token("alicloud:eflo/resource:Resource")
class Resource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_types: Optional[pulumi.Input[Union['ResourceMachineTypesArgs', 'ResourceMachineTypesArgsDict']]] = None,
                 user_access_param: Optional[pulumi.Input[Union['ResourceUserAccessParamArgs', 'ResourceUserAccessParamArgsDict']]] = None,
                 __props__=None):
        """
        ## Import

        Eflo Resource can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/resource:Resource example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_desc: Used to provide a description or comment on the compute cluster.
        :param pulumi.Input[_builtins.str] cluster_id: Used to uniquely identify a computing cluster.
        :param pulumi.Input[_builtins.str] cluster_name: Represents the name of the compute cluster, usually including the model number.
        :param pulumi.Input[Union['ResourceMachineTypesArgs', 'ResourceMachineTypesArgsDict']] machine_types: Generally refers to the type or instance type of a computing resource. See `machine_types` below.
        :param pulumi.Input[Union['ResourceUserAccessParamArgs', 'ResourceUserAccessParamArgsDict']] user_access_param: Used to define the access parameters for the user. See `user_access_param` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Eflo Resource can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/resource:Resource example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_desc: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_types: Optional[pulumi.Input[Union['ResourceMachineTypesArgs', 'ResourceMachineTypesArgsDict']]] = None,
                 user_access_param: Optional[pulumi.Input[Union['ResourceUserAccessParamArgs', 'ResourceUserAccessParamArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceArgs.__new__(ResourceArgs)

            __props__.__dict__["cluster_desc"] = cluster_desc
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            if machine_types is None and not opts.urn:
                raise TypeError("Missing required property 'machine_types'")
            __props__.__dict__["machine_types"] = machine_types
            if user_access_param is None and not opts.urn:
                raise TypeError("Missing required property 'user_access_param'")
            __props__.__dict__["user_access_param"] = user_access_param
            __props__.__dict__["resource_id"] = None
        super(Resource, __self__).__init__(
            'alicloud:eflo/resource:Resource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_desc: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            machine_types: Optional[pulumi.Input[Union['ResourceMachineTypesArgs', 'ResourceMachineTypesArgsDict']]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_access_param: Optional[pulumi.Input[Union['ResourceUserAccessParamArgs', 'ResourceUserAccessParamArgsDict']]] = None) -> 'Resource':
        """
        Get an existing Resource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_desc: Used to provide a description or comment on the compute cluster.
        :param pulumi.Input[_builtins.str] cluster_id: Used to uniquely identify a computing cluster.
        :param pulumi.Input[_builtins.str] cluster_name: Represents the name of the compute cluster, usually including the model number.
        :param pulumi.Input[Union['ResourceMachineTypesArgs', 'ResourceMachineTypesArgsDict']] machine_types: Generally refers to the type or instance type of a computing resource. See `machine_types` below.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the Resource.
        :param pulumi.Input[Union['ResourceUserAccessParamArgs', 'ResourceUserAccessParamArgsDict']] user_access_param: Used to define the access parameters for the user. See `user_access_param` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceState.__new__(_ResourceState)

        __props__.__dict__["cluster_desc"] = cluster_desc
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["machine_types"] = machine_types
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["user_access_param"] = user_access_param
        return Resource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterDesc")
    def cluster_desc(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Used to provide a description or comment on the compute cluster.
        """
        return pulumi.get(self, "cluster_desc")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Used to uniquely identify a computing cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        Represents the name of the compute cluster, usually including the model number.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="machineTypes")
    def machine_types(self) -> pulumi.Output['outputs.ResourceMachineTypes']:
        """
        Generally refers to the type or instance type of a computing resource. See `machine_types` below.
        """
        return pulumi.get(self, "machine_types")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="userAccessParam")
    def user_access_param(self) -> pulumi.Output['outputs.ResourceUserAccessParam']:
        """
        Used to define the access parameters for the user. See `user_access_param` below.
        """
        return pulumi.get(self, "user_access_param")

