# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterBootstrapAction',
    'ClusterConfig',
    'ClusterHostGroup',
    'ClusterMetaStoreConf',
    'ClusterModifyClusterServiceConfig',
    'GetClustersClusterResult',
    'GetClustersClusterAccessInfoResult',
    'GetClustersClusterAccessInfoZkLinkResult',
    'GetClustersClusterBootstrapActionListResult',
    'GetClustersClusterHostGroupListResult',
    'GetClustersClusterHostGroupListNodeResult',
    'GetClustersClusterHostGroupListNodeDiskInfoResult',
    'GetClustersClusterHostPoolInfoResult',
    'GetClustersClusterRelateClusterInfoResult',
    'GetClustersClusterSoftwareInfoResult',
    'GetClustersClusterSoftwareInfoSoftwareResult',
    'GetDiskTypesTypeResult',
    'GetInstanceTypesTypeResult',
    'GetMainVersionsMainVersionResult',
]

@pulumi.output_type
class ClusterBootstrapAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionFailStrategy":
            suggest = "execution_fail_strategy"
        elif key == "executionMoment":
            suggest = "execution_moment"
        elif key == "executionTarget":
            suggest = "execution_target"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBootstrapAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBootstrapAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBootstrapAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arg: Optional[_builtins.str] = None,
                 execution_fail_strategy: Optional[_builtins.str] = None,
                 execution_moment: Optional[_builtins.str] = None,
                 execution_target: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None):
        """
        :param _builtins.str arg: bootstrap action args, e.g. "--a=b".
        :param _builtins.str execution_fail_strategy: bootstrap action execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ . Default value: "FAILED_BLOCKED
        :param _builtins.str execution_moment: bootstrap action execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ . Default value: "BEFORE_INSTALL".
        :param _builtins.str execution_target: bootstrap action execution target, you can specify the host group name, e.g. "core_group". If this is not specified, the bootstrap action execution target is whole cluster.
        :param _builtins.str name: The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        :param _builtins.str path: bootstrap action path, e.g. "oss://bucket/path".
        """
        if arg is not None:
            pulumi.set(__self__, "arg", arg)
        if execution_fail_strategy is not None:
            pulumi.set(__self__, "execution_fail_strategy", execution_fail_strategy)
        if execution_moment is not None:
            pulumi.set(__self__, "execution_moment", execution_moment)
        if execution_target is not None:
            pulumi.set(__self__, "execution_target", execution_target)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def arg(self) -> Optional[_builtins.str]:
        """
        bootstrap action args, e.g. "--a=b".
        """
        return pulumi.get(self, "arg")

    @_builtins.property
    @pulumi.getter(name="executionFailStrategy")
    def execution_fail_strategy(self) -> Optional[_builtins.str]:
        """
        bootstrap action execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ . Default value: "FAILED_BLOCKED
        """
        return pulumi.get(self, "execution_fail_strategy")

    @_builtins.property
    @pulumi.getter(name="executionMoment")
    def execution_moment(self) -> Optional[_builtins.str]:
        """
        bootstrap action execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ . Default value: "BEFORE_INSTALL".
        """
        return pulumi.get(self, "execution_moment")

    @_builtins.property
    @pulumi.getter(name="executionTarget")
    def execution_target(self) -> Optional[_builtins.str]:
        """
        bootstrap action execution target, you can specify the host group name, e.g. "core_group". If this is not specified, the bootstrap action execution target is whole cluster.
        """
        return pulumi.get(self, "execution_target")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        bootstrap action path, e.g. "oss://bucket/path".
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configKey":
            suggest = "config_key"
        elif key == "configValue":
            suggest = "config_value"
        elif key == "fileName":
            suggest = "file_name"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_key: _builtins.str,
                 config_value: _builtins.str,
                 file_name: _builtins.str,
                 service_name: _builtins.str):
        """
        :param _builtins.str config_key: Custom configuration service config key, e.g. ’dfs.replication’.
        :param _builtins.str config_value: Custom configuration service config value, e.g. ’3’.
        :param _builtins.str file_name: Custom configuration service file name, e.g. ’hdfs-site’.
        """
        pulumi.set(__self__, "config_key", config_key)
        pulumi.set(__self__, "config_value", config_value)
        pulumi.set(__self__, "file_name", file_name)
        pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter(name="configKey")
    def config_key(self) -> _builtins.str:
        """
        Custom configuration service config key, e.g. ’dfs.replication’.
        """
        return pulumi.get(self, "config_key")

    @_builtins.property
    @pulumi.getter(name="configValue")
    def config_value(self) -> _builtins.str:
        """
        Custom configuration service config value, e.g. ’3’.
        """
        return pulumi.get(self, "config_value")

    @_builtins.property
    @pulumi.getter(name="fileName")
    def file_name(self) -> _builtins.str:
        """
        Custom configuration service file name, e.g. ’hdfs-site’.
        """
        return pulumi.get(self, "file_name")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        return pulumi.get(self, "service_name")


@pulumi.output_type
class ClusterHostGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoRenew":
            suggest = "auto_renew"
        elif key == "chargeType":
            suggest = "charge_type"
        elif key == "decommissionTimeout":
            suggest = "decommission_timeout"
        elif key == "diskCapacity":
            suggest = "disk_capacity"
        elif key == "diskCount":
            suggest = "disk_count"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "enableGracefulDecommission":
            suggest = "enable_graceful_decommission"
        elif key == "gpuDriver":
            suggest = "gpu_driver"
        elif key == "hostGroupName":
            suggest = "host_group_name"
        elif key == "hostGroupType":
            suggest = "host_group_type"
        elif key == "instanceList":
            suggest = "instance_list"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "nodeCount":
            suggest = "node_count"
        elif key == "sysDiskCapacity":
            suggest = "sys_disk_capacity"
        elif key == "sysDiskType":
            suggest = "sys_disk_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterHostGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterHostGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterHostGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_renew: Optional[_builtins.bool] = None,
                 charge_type: Optional[_builtins.str] = None,
                 decommission_timeout: Optional[_builtins.int] = None,
                 disk_capacity: Optional[_builtins.str] = None,
                 disk_count: Optional[_builtins.str] = None,
                 disk_type: Optional[_builtins.str] = None,
                 enable_graceful_decommission: Optional[_builtins.bool] = None,
                 gpu_driver: Optional[_builtins.str] = None,
                 host_group_name: Optional[_builtins.str] = None,
                 host_group_type: Optional[_builtins.str] = None,
                 instance_list: Optional[_builtins.str] = None,
                 instance_type: Optional[_builtins.str] = None,
                 node_count: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 sys_disk_capacity: Optional[_builtins.str] = None,
                 sys_disk_type: Optional[_builtins.str] = None):
        """
        :param _builtins.bool auto_renew: Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        :param _builtins.str charge_type: Charge Type for this cluster. Supported value: PostPaid or PrePaid. Default value: PostPaid.
        :param _builtins.int decommission_timeout: Graceful decommission timeout, unit: seconds.
        :param _builtins.str disk_capacity: Data disk capacity.
        :param _builtins.str disk_count: Data disk count.
        :param _builtins.str disk_type: Data disk type. Supported value: cloud,cloud_efficiency,cloud_ssd,local_disk,cloud_essd.
        :param _builtins.bool enable_graceful_decommission: Enable hadoop cluster of task node graceful decommission, ’true’ or ‘false’ . Default value: false.
        :param _builtins.str host_group_name: host group name.
        :param _builtins.str host_group_type: host group type, supported value: MASTER, CORE or TASK, supported 'GATEWAY' available in 1.61.0+.
        :param _builtins.str instance_list: Instance list for cluster scale down. This value follows the json format, e.g. ["instance_id1","instance_id2"]. escape character for " is \\".
        :param _builtins.str instance_type: Host Ecs instance type.
        :param _builtins.str node_count: Host number in this group.
        :param _builtins.int period: If charge type is PrePaid, this should be specified, unit is month. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36.
        :param _builtins.str sys_disk_capacity: System disk capacity.
        :param _builtins.str sys_disk_type: System disk type. Supported value: cloud,cloud_efficiency,cloud_ssd,cloud_essd.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if decommission_timeout is not None:
            pulumi.set(__self__, "decommission_timeout", decommission_timeout)
        if disk_capacity is not None:
            pulumi.set(__self__, "disk_capacity", disk_capacity)
        if disk_count is not None:
            pulumi.set(__self__, "disk_count", disk_count)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if enable_graceful_decommission is not None:
            pulumi.set(__self__, "enable_graceful_decommission", enable_graceful_decommission)
        if gpu_driver is not None:
            pulumi.set(__self__, "gpu_driver", gpu_driver)
        if host_group_name is not None:
            pulumi.set(__self__, "host_group_name", host_group_name)
        if host_group_type is not None:
            pulumi.set(__self__, "host_group_type", host_group_type)
        if instance_list is not None:
            pulumi.set(__self__, "instance_list", instance_list)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if sys_disk_capacity is not None:
            pulumi.set(__self__, "sys_disk_capacity", sys_disk_capacity)
        if sys_disk_type is not None:
            pulumi.set(__self__, "sys_disk_type", sys_disk_type)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[_builtins.bool]:
        """
        Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[_builtins.str]:
        """
        Charge Type for this cluster. Supported value: PostPaid or PrePaid. Default value: PostPaid.
        """
        return pulumi.get(self, "charge_type")

    @_builtins.property
    @pulumi.getter(name="decommissionTimeout")
    def decommission_timeout(self) -> Optional[_builtins.int]:
        """
        Graceful decommission timeout, unit: seconds.
        """
        return pulumi.get(self, "decommission_timeout")

    @_builtins.property
    @pulumi.getter(name="diskCapacity")
    def disk_capacity(self) -> Optional[_builtins.str]:
        """
        Data disk capacity.
        """
        return pulumi.get(self, "disk_capacity")

    @_builtins.property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> Optional[_builtins.str]:
        """
        Data disk count.
        """
        return pulumi.get(self, "disk_count")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[_builtins.str]:
        """
        Data disk type. Supported value: cloud,cloud_efficiency,cloud_ssd,local_disk,cloud_essd.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter(name="enableGracefulDecommission")
    def enable_graceful_decommission(self) -> Optional[_builtins.bool]:
        """
        Enable hadoop cluster of task node graceful decommission, ’true’ or ‘false’ . Default value: false.
        """
        return pulumi.get(self, "enable_graceful_decommission")

    @_builtins.property
    @pulumi.getter(name="gpuDriver")
    def gpu_driver(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "gpu_driver")

    @_builtins.property
    @pulumi.getter(name="hostGroupName")
    def host_group_name(self) -> Optional[_builtins.str]:
        """
        host group name.
        """
        return pulumi.get(self, "host_group_name")

    @_builtins.property
    @pulumi.getter(name="hostGroupType")
    def host_group_type(self) -> Optional[_builtins.str]:
        """
        host group type, supported value: MASTER, CORE or TASK, supported 'GATEWAY' available in 1.61.0+.
        """
        return pulumi.get(self, "host_group_type")

    @_builtins.property
    @pulumi.getter(name="instanceList")
    def instance_list(self) -> Optional[_builtins.str]:
        """
        Instance list for cluster scale down. This value follows the json format, e.g. ["instance_id1","instance_id2"]. escape character for " is \\".
        """
        return pulumi.get(self, "instance_list")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[_builtins.str]:
        """
        Host Ecs instance type.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[_builtins.str]:
        """
        Host number in this group.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        If charge type is PrePaid, this should be specified, unit is month. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="sysDiskCapacity")
    def sys_disk_capacity(self) -> Optional[_builtins.str]:
        """
        System disk capacity.
        """
        return pulumi.get(self, "sys_disk_capacity")

    @_builtins.property
    @pulumi.getter(name="sysDiskType")
    def sys_disk_type(self) -> Optional[_builtins.str]:
        """
        System disk type. Supported value: cloud,cloud_efficiency,cloud_ssd,cloud_essd.
        """
        return pulumi.get(self, "sys_disk_type")


@pulumi.output_type
class ClusterMetaStoreConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbPassword":
            suggest = "db_password"
        elif key == "dbUrl":
            suggest = "db_url"
        elif key == "dbUserName":
            suggest = "db_user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMetaStoreConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMetaStoreConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMetaStoreConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 db_password: _builtins.str,
                 db_url: _builtins.str,
                 db_user_name: _builtins.str):
        """
        :param _builtins.str db_password: Custom rds database password.
        :param _builtins.str db_url: Custom rds database connection url.
        :param _builtins.str db_user_name: Custom rds database user name.
        """
        pulumi.set(__self__, "db_password", db_password)
        pulumi.set(__self__, "db_url", db_url)
        pulumi.set(__self__, "db_user_name", db_user_name)

    @_builtins.property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> _builtins.str:
        """
        Custom rds database password.
        """
        return pulumi.get(self, "db_password")

    @_builtins.property
    @pulumi.getter(name="dbUrl")
    def db_url(self) -> _builtins.str:
        """
        Custom rds database connection url.
        """
        return pulumi.get(self, "db_url")

    @_builtins.property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> _builtins.str:
        """
        Custom rds database user name.
        """
        return pulumi.get(self, "db_user_name")


@pulumi.output_type
class ClusterModifyClusterServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configParams":
            suggest = "config_params"
        elif key == "serviceName":
            suggest = "service_name"
        elif key == "configType":
            suggest = "config_type"
        elif key == "customConfigParams":
            suggest = "custom_config_params"
        elif key == "gatewayClusterIdLists":
            suggest = "gateway_cluster_id_lists"
        elif key == "groupId":
            suggest = "group_id"
        elif key == "hostInstanceId":
            suggest = "host_instance_id"
        elif key == "refreshHostConfig":
            suggest = "refresh_host_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterModifyClusterServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterModifyClusterServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterModifyClusterServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_params: _builtins.str,
                 service_name: _builtins.str,
                 comment: Optional[_builtins.str] = None,
                 config_type: Optional[_builtins.str] = None,
                 custom_config_params: Optional[_builtins.str] = None,
                 gateway_cluster_id_lists: Optional[Sequence[_builtins.str]] = None,
                 group_id: Optional[_builtins.str] = None,
                 host_instance_id: Optional[_builtins.str] = None,
                 refresh_host_config: Optional[_builtins.bool] = None):
        """
        :param _builtins.str config_params: Cluster service configuration modification params, e.g. ’{"hdfs-site":{"dfs.replication":"3"}}’.
        :param _builtins.str comment: Cluster service configuration modification comment, e.g. "Modify tez configuration".
        :param _builtins.str config_type: Cluster service configuration modification type.
        :param _builtins.str custom_config_params: Cluster service configuration modification custom params, e.g. ’{"tez-site":{"key":{"Value":"value"}}}’.
        :param Sequence[_builtins.str] gateway_cluster_id_lists: Cluster service configuration modification related gateway cluster id list.
        :param _builtins.str group_id: Cluster service configuration modification node group id, e.g. ’G-XXX’.
        :param _builtins.str host_instance_id: Cluster service configuration modification host instance id, e.g. ’i-bp146tnrkq4tcxxxxx’.
        :param _builtins.bool refresh_host_config: Cluster service configuration modification refresh host config, ’true’ or ’false’.
        """
        pulumi.set(__self__, "config_params", config_params)
        pulumi.set(__self__, "service_name", service_name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if config_type is not None:
            pulumi.set(__self__, "config_type", config_type)
        if custom_config_params is not None:
            pulumi.set(__self__, "custom_config_params", custom_config_params)
        if gateway_cluster_id_lists is not None:
            pulumi.set(__self__, "gateway_cluster_id_lists", gateway_cluster_id_lists)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if host_instance_id is not None:
            pulumi.set(__self__, "host_instance_id", host_instance_id)
        if refresh_host_config is not None:
            pulumi.set(__self__, "refresh_host_config", refresh_host_config)

    @_builtins.property
    @pulumi.getter(name="configParams")
    def config_params(self) -> _builtins.str:
        """
        Cluster service configuration modification params, e.g. ’{"hdfs-site":{"dfs.replication":"3"}}’.
        """
        return pulumi.get(self, "config_params")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[_builtins.str]:
        """
        Cluster service configuration modification comment, e.g. "Modify tez configuration".
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="configType")
    def config_type(self) -> Optional[_builtins.str]:
        """
        Cluster service configuration modification type.
        """
        return pulumi.get(self, "config_type")

    @_builtins.property
    @pulumi.getter(name="customConfigParams")
    def custom_config_params(self) -> Optional[_builtins.str]:
        """
        Cluster service configuration modification custom params, e.g. ’{"tez-site":{"key":{"Value":"value"}}}’.
        """
        return pulumi.get(self, "custom_config_params")

    @_builtins.property
    @pulumi.getter(name="gatewayClusterIdLists")
    def gateway_cluster_id_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        Cluster service configuration modification related gateway cluster id list.
        """
        return pulumi.get(self, "gateway_cluster_id_lists")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[_builtins.str]:
        """
        Cluster service configuration modification node group id, e.g. ’G-XXX’.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="hostInstanceId")
    def host_instance_id(self) -> Optional[_builtins.str]:
        """
        Cluster service configuration modification host instance id, e.g. ’i-bp146tnrkq4tcxxxxx’.
        """
        return pulumi.get(self, "host_instance_id")

    @_builtins.property
    @pulumi.getter(name="refreshHostConfig")
    def refresh_host_config(self) -> Optional[_builtins.bool]:
        """
        Cluster service configuration modification refresh host config, ’true’ or ’false’.
        """
        return pulumi.get(self, "refresh_host_config")


@pulumi.output_type
class GetClustersClusterResult(dict):
    def __init__(__self__, *,
                 access_infos: Sequence['outputs.GetClustersClusterAccessInfoResult'],
                 auto_scaling_allowed: _builtins.bool,
                 auto_scaling_by_load_allowed: _builtins.bool,
                 auto_scaling_enable: _builtins.bool,
                 auto_scaling_spot_with_limit_allowed: _builtins.bool,
                 bootstrap_action_lists: Sequence['outputs.GetClustersClusterBootstrapActionListResult'],
                 bootstrap_failed: _builtins.bool,
                 cluster_id: _builtins.str,
                 cluster_name: _builtins.str,
                 create_resource: _builtins.str,
                 create_time: _builtins.str,
                 create_type: _builtins.str,
                 deposit_type: _builtins.str,
                 eas_enable: _builtins.bool,
                 expired_time: _builtins.str,
                 extra_info: _builtins.str,
                 has_uncompleted_order: _builtins.bool,
                 high_availability_enable: _builtins.bool,
                 host_group_lists: Sequence['outputs.GetClustersClusterHostGroupListResult'],
                 host_pool_infos: Sequence['outputs.GetClustersClusterHostPoolInfoResult'],
                 id: _builtins.str,
                 image_id: _builtins.str,
                 local_meta_db: _builtins.bool,
                 machine_type: _builtins.str,
                 meta_store_type: _builtins.str,
                 net_type: _builtins.str,
                 payment_type: _builtins.str,
                 period: _builtins.int,
                 relate_cluster_infos: Sequence['outputs.GetClustersClusterRelateClusterInfoResult'],
                 resize_disk_enable: _builtins.bool,
                 running_time: _builtins.int,
                 security_group_id: _builtins.str,
                 security_group_name: _builtins.str,
                 software_infos: Sequence['outputs.GetClustersClusterSoftwareInfoResult'],
                 start_time: _builtins.str,
                 status: _builtins.str,
                 stop_time: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 type: _builtins.str,
                 user_defined_emr_ecs_role: _builtins.str,
                 user_id: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitch_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param Sequence['GetClustersClusterAccessInfoArgs'] access_infos: Cluster connection information.
        :param _builtins.bool auto_scaling_allowed: Whether flexible expansion is allowed.
        :param _builtins.bool auto_scaling_by_load_allowed: Whether to allow expansion by load.
        :param _builtins.bool auto_scaling_enable: Whether to enable elastic expansion.
        :param _builtins.bool auto_scaling_spot_with_limit_allowed: Whether to allow the use of elastic scaling bidding instances.
        :param Sequence['GetClustersClusterBootstrapActionListArgs'] bootstrap_action_lists: List of boot actions.
        :param _builtins.bool bootstrap_failed: The result of the boot operation.
        :param _builtins.str cluster_id: The first ID of the resource.
        :param _builtins.str cluster_name: The ClusterName.
        :param _builtins.str create_resource: Cluster tag, no need to pay attention.
        :param _builtins.str create_time: The creation time of the resource.
        :param _builtins.str create_type: How to create a cluster.
        :param _builtins.str deposit_type: The hosting type of the cluster.
        :param _builtins.bool eas_enable: High security cluster.
        :param _builtins.str expired_time: The expiration time of the cluster.
        :param _builtins.str extra_info: Additional information for Stack.
        :param _builtins.bool high_availability_enable: High availability cluster.
        :param Sequence['GetClustersClusterHostGroupListArgs'] host_group_lists: List of cluster machine groups.
        :param Sequence['GetClustersClusterHostPoolInfoArgs'] host_pool_infos: Machine pool information.
        :param _builtins.str image_id: The ID of the image used to create the cluster.
        :param _builtins.bool local_meta_db: Whether to use Hive local Metabase.
        :param _builtins.str machine_type: The host type of the cluster. The default is ECS.
        :param _builtins.str meta_store_type: Metadata type:
        :param _builtins.str net_type: Cluster network type.
        :param _builtins.str payment_type: The payment type of the resource.
        :param _builtins.int period: The package year and month time of the machine group. The Valid Values : `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`.
        :param Sequence['GetClustersClusterRelateClusterInfoArgs'] relate_cluster_infos: The information of the primary cluster associated with the Gateway.
        :param _builtins.bool resize_disk_enable: Whether to allow disk expansion:
        :param _builtins.int running_time: The time (in seconds) that has been running.
        :param _builtins.str security_group_id: The ID of the security group.
        :param _builtins.str security_group_name: The name of the security group.
        :param Sequence['GetClustersClusterSoftwareInfoArgs'] software_infos: Service list.
        :param _builtins.str start_time: Cluster startup time.
        :param _builtins.str status: The cluster status.
        :param _builtins.str stop_time: Cluster stop time.
        :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
        :param _builtins.str type: Disk type.
        :param _builtins.str user_defined_emr_ecs_role: The EMR permission name used.
        :param _builtins.str user_id: The user ID.
        :param _builtins.str vpc_id: The VPC ID.
        :param _builtins.str vswitch_id: The vswitch id.
        :param _builtins.str zone_id: The zone ID.
        """
        pulumi.set(__self__, "access_infos", access_infos)
        pulumi.set(__self__, "auto_scaling_allowed", auto_scaling_allowed)
        pulumi.set(__self__, "auto_scaling_by_load_allowed", auto_scaling_by_load_allowed)
        pulumi.set(__self__, "auto_scaling_enable", auto_scaling_enable)
        pulumi.set(__self__, "auto_scaling_spot_with_limit_allowed", auto_scaling_spot_with_limit_allowed)
        pulumi.set(__self__, "bootstrap_action_lists", bootstrap_action_lists)
        pulumi.set(__self__, "bootstrap_failed", bootstrap_failed)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "create_resource", create_resource)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "create_type", create_type)
        pulumi.set(__self__, "deposit_type", deposit_type)
        pulumi.set(__self__, "eas_enable", eas_enable)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "extra_info", extra_info)
        pulumi.set(__self__, "has_uncompleted_order", has_uncompleted_order)
        pulumi.set(__self__, "high_availability_enable", high_availability_enable)
        pulumi.set(__self__, "host_group_lists", host_group_lists)
        pulumi.set(__self__, "host_pool_infos", host_pool_infos)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "local_meta_db", local_meta_db)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "meta_store_type", meta_store_type)
        pulumi.set(__self__, "net_type", net_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "relate_cluster_infos", relate_cluster_infos)
        pulumi.set(__self__, "resize_disk_enable", resize_disk_enable)
        pulumi.set(__self__, "running_time", running_time)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "security_group_name", security_group_name)
        pulumi.set(__self__, "software_infos", software_infos)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "stop_time", stop_time)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user_defined_emr_ecs_role", user_defined_emr_ecs_role)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accessInfos")
    def access_infos(self) -> Sequence['outputs.GetClustersClusterAccessInfoResult']:
        """
        Cluster connection information.
        """
        return pulumi.get(self, "access_infos")

    @_builtins.property
    @pulumi.getter(name="autoScalingAllowed")
    def auto_scaling_allowed(self) -> _builtins.bool:
        """
        Whether flexible expansion is allowed.
        """
        return pulumi.get(self, "auto_scaling_allowed")

    @_builtins.property
    @pulumi.getter(name="autoScalingByLoadAllowed")
    def auto_scaling_by_load_allowed(self) -> _builtins.bool:
        """
        Whether to allow expansion by load.
        """
        return pulumi.get(self, "auto_scaling_by_load_allowed")

    @_builtins.property
    @pulumi.getter(name="autoScalingEnable")
    def auto_scaling_enable(self) -> _builtins.bool:
        """
        Whether to enable elastic expansion.
        """
        return pulumi.get(self, "auto_scaling_enable")

    @_builtins.property
    @pulumi.getter(name="autoScalingSpotWithLimitAllowed")
    def auto_scaling_spot_with_limit_allowed(self) -> _builtins.bool:
        """
        Whether to allow the use of elastic scaling bidding instances.
        """
        return pulumi.get(self, "auto_scaling_spot_with_limit_allowed")

    @_builtins.property
    @pulumi.getter(name="bootstrapActionLists")
    def bootstrap_action_lists(self) -> Sequence['outputs.GetClustersClusterBootstrapActionListResult']:
        """
        List of boot actions.
        """
        return pulumi.get(self, "bootstrap_action_lists")

    @_builtins.property
    @pulumi.getter(name="bootstrapFailed")
    def bootstrap_failed(self) -> _builtins.bool:
        """
        The result of the boot operation.
        """
        return pulumi.get(self, "bootstrap_failed")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        The ClusterName.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="createResource")
    def create_resource(self) -> _builtins.str:
        """
        Cluster tag, no need to pay attention.
        """
        return pulumi.get(self, "create_resource")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createType")
    def create_type(self) -> _builtins.str:
        """
        How to create a cluster.
        """
        return pulumi.get(self, "create_type")

    @_builtins.property
    @pulumi.getter(name="depositType")
    def deposit_type(self) -> _builtins.str:
        """
        The hosting type of the cluster.
        """
        return pulumi.get(self, "deposit_type")

    @_builtins.property
    @pulumi.getter(name="easEnable")
    def eas_enable(self) -> _builtins.bool:
        """
        High security cluster.
        """
        return pulumi.get(self, "eas_enable")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        """
        The expiration time of the cluster.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="extraInfo")
    def extra_info(self) -> _builtins.str:
        """
        Additional information for Stack.
        """
        return pulumi.get(self, "extra_info")

    @_builtins.property
    @pulumi.getter(name="hasUncompletedOrder")
    def has_uncompleted_order(self) -> _builtins.bool:
        return pulumi.get(self, "has_uncompleted_order")

    @_builtins.property
    @pulumi.getter(name="highAvailabilityEnable")
    def high_availability_enable(self) -> _builtins.bool:
        """
        High availability cluster.
        """
        return pulumi.get(self, "high_availability_enable")

    @_builtins.property
    @pulumi.getter(name="hostGroupLists")
    def host_group_lists(self) -> Sequence['outputs.GetClustersClusterHostGroupListResult']:
        """
        List of cluster machine groups.
        """
        return pulumi.get(self, "host_group_lists")

    @_builtins.property
    @pulumi.getter(name="hostPoolInfos")
    def host_pool_infos(self) -> Sequence['outputs.GetClustersClusterHostPoolInfoResult']:
        """
        Machine pool information.
        """
        return pulumi.get(self, "host_pool_infos")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The ID of the image used to create the cluster.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="localMetaDb")
    def local_meta_db(self) -> _builtins.bool:
        """
        Whether to use Hive local Metabase.
        """
        return pulumi.get(self, "local_meta_db")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> _builtins.str:
        """
        The host type of the cluster. The default is ECS.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="metaStoreType")
    def meta_store_type(self) -> _builtins.str:
        """
        Metadata type:
        """
        return pulumi.get(self, "meta_store_type")

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> _builtins.str:
        """
        Cluster network type.
        """
        return pulumi.get(self, "net_type")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> _builtins.str:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> _builtins.int:
        """
        The package year and month time of the machine group. The Valid Values : `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="relateClusterInfos")
    def relate_cluster_infos(self) -> Sequence['outputs.GetClustersClusterRelateClusterInfoResult']:
        """
        The information of the primary cluster associated with the Gateway.
        """
        return pulumi.get(self, "relate_cluster_infos")

    @_builtins.property
    @pulumi.getter(name="resizeDiskEnable")
    def resize_disk_enable(self) -> _builtins.bool:
        """
        Whether to allow disk expansion:
        """
        return pulumi.get(self, "resize_disk_enable")

    @_builtins.property
    @pulumi.getter(name="runningTime")
    def running_time(self) -> _builtins.int:
        """
        The time (in seconds) that has been running.
        """
        return pulumi.get(self, "running_time")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupName")
    def security_group_name(self) -> _builtins.str:
        """
        The name of the security group.
        """
        return pulumi.get(self, "security_group_name")

    @_builtins.property
    @pulumi.getter(name="softwareInfos")
    def software_infos(self) -> Sequence['outputs.GetClustersClusterSoftwareInfoResult']:
        """
        Service list.
        """
        return pulumi.get(self, "software_infos")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        Cluster startup time.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The cluster status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> _builtins.str:
        """
        Cluster stop time.
        """
        return pulumi.get(self, "stop_time")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Disk type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userDefinedEmrEcsRole")
    def user_defined_emr_ecs_role(self) -> _builtins.str:
        """
        The EMR permission name used.
        """
        return pulumi.get(self, "user_defined_emr_ecs_role")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        The user ID.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> _builtins.str:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetClustersClusterAccessInfoResult(dict):
    def __init__(__self__, *,
                 zk_links: Sequence['outputs.GetClustersClusterAccessInfoZkLinkResult']):
        """
        :param Sequence['GetClustersClusterAccessInfoZkLinkArgs'] zk_links: Link address information list of ZooKeeper.
        """
        pulumi.set(__self__, "zk_links", zk_links)

    @_builtins.property
    @pulumi.getter(name="zkLinks")
    def zk_links(self) -> Sequence['outputs.GetClustersClusterAccessInfoZkLinkResult']:
        """
        Link address information list of ZooKeeper.
        """
        return pulumi.get(self, "zk_links")


@pulumi.output_type
class GetClustersClusterAccessInfoZkLinkResult(dict):
    def __init__(__self__, *,
                 link: _builtins.str,
                 port: _builtins.str):
        """
        :param _builtins.str link: The access link address of ZooKeeper.
        :param _builtins.str port: The port of ZooKeeper.
        """
        pulumi.set(__self__, "link", link)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def link(self) -> _builtins.str:
        """
        The access link address of ZooKeeper.
        """
        return pulumi.get(self, "link")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        The port of ZooKeeper.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetClustersClusterBootstrapActionListResult(dict):
    def __init__(__self__, *,
                 arg: _builtins.str,
                 name: _builtins.str,
                 path: _builtins.str):
        """
        :param _builtins.str arg: Parameters of the boot operation.
        :param _builtins.str name: The name of the boot operation.
        :param _builtins.str path: Boot operation script path.
        """
        pulumi.set(__self__, "arg", arg)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def arg(self) -> _builtins.str:
        """
        Parameters of the boot operation.
        """
        return pulumi.get(self, "arg")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the boot operation.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Boot operation script path.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetClustersClusterHostGroupListResult(dict):
    def __init__(__self__, *,
                 band_width: _builtins.str,
                 charge_type: _builtins.str,
                 cpu_core: _builtins.int,
                 disk_capacity: _builtins.int,
                 disk_count: _builtins.int,
                 disk_type: _builtins.str,
                 host_group_change_type: _builtins.str,
                 host_group_id: _builtins.str,
                 host_group_name: _builtins.str,
                 host_group_type: _builtins.str,
                 instance_type: _builtins.str,
                 memory_capacity: _builtins.int,
                 node_count: _builtins.int,
                 nodes: Sequence['outputs.GetClustersClusterHostGroupListNodeResult'],
                 period: _builtins.str):
        """
        :param _builtins.str band_width: Bandwidth.
        :param _builtins.str charge_type: Payment Type.
        :param _builtins.int cpu_core: The number of CPU cores.
        :param _builtins.int disk_capacity: Data disk capacity.
        :param _builtins.int disk_count: The number of data disks.
        :param _builtins.str disk_type: System disk type:
        :param _builtins.str host_group_change_type: The current operation type of the machine Group:
        :param _builtins.str host_group_id: The ID of the machine group.
        :param _builtins.str host_group_name: The name of the machine group.
        :param _builtins.str host_group_type: Role of host in cluster:
        :param _builtins.str instance_type: Machine Group instance.
        :param _builtins.int memory_capacity: Memory size.
        :param _builtins.int node_count: The number of machine group nodes.
        :param Sequence['GetClustersClusterHostGroupListNodeArgs'] nodes: Machine node.
        :param _builtins.str period: Package year and month time (days).
        """
        pulumi.set(__self__, "band_width", band_width)
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "cpu_core", cpu_core)
        pulumi.set(__self__, "disk_capacity", disk_capacity)
        pulumi.set(__self__, "disk_count", disk_count)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "host_group_change_type", host_group_change_type)
        pulumi.set(__self__, "host_group_id", host_group_id)
        pulumi.set(__self__, "host_group_name", host_group_name)
        pulumi.set(__self__, "host_group_type", host_group_type)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "memory_capacity", memory_capacity)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "period", period)

    @_builtins.property
    @pulumi.getter(name="bandWidth")
    def band_width(self) -> _builtins.str:
        """
        Bandwidth.
        """
        return pulumi.get(self, "band_width")

    @_builtins.property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> _builtins.str:
        """
        Payment Type.
        """
        return pulumi.get(self, "charge_type")

    @_builtins.property
    @pulumi.getter(name="cpuCore")
    def cpu_core(self) -> _builtins.int:
        """
        The number of CPU cores.
        """
        return pulumi.get(self, "cpu_core")

    @_builtins.property
    @pulumi.getter(name="diskCapacity")
    def disk_capacity(self) -> _builtins.int:
        """
        Data disk capacity.
        """
        return pulumi.get(self, "disk_capacity")

    @_builtins.property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> _builtins.int:
        """
        The number of data disks.
        """
        return pulumi.get(self, "disk_count")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> _builtins.str:
        """
        System disk type:
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter(name="hostGroupChangeType")
    def host_group_change_type(self) -> _builtins.str:
        """
        The current operation type of the machine Group:
        """
        return pulumi.get(self, "host_group_change_type")

    @_builtins.property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> _builtins.str:
        """
        The ID of the machine group.
        """
        return pulumi.get(self, "host_group_id")

    @_builtins.property
    @pulumi.getter(name="hostGroupName")
    def host_group_name(self) -> _builtins.str:
        """
        The name of the machine group.
        """
        return pulumi.get(self, "host_group_name")

    @_builtins.property
    @pulumi.getter(name="hostGroupType")
    def host_group_type(self) -> _builtins.str:
        """
        Role of host in cluster:
        """
        return pulumi.get(self, "host_group_type")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        Machine Group instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="memoryCapacity")
    def memory_capacity(self) -> _builtins.int:
        """
        Memory size.
        """
        return pulumi.get(self, "memory_capacity")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> _builtins.int:
        """
        The number of machine group nodes.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetClustersClusterHostGroupListNodeResult']:
        """
        Machine node.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def period(self) -> _builtins.str:
        """
        Package year and month time (days).
        """
        return pulumi.get(self, "period")


@pulumi.output_type
class GetClustersClusterHostGroupListNodeResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 disk_infos: Sequence['outputs.GetClustersClusterHostGroupListNodeDiskInfoResult'],
                 emr_expired_time: _builtins.str,
                 expired_time: _builtins.str,
                 inner_ip: _builtins.str,
                 instance_id: _builtins.str,
                 pub_ip: _builtins.str,
                 status: _builtins.str,
                 support_ipv6: _builtins.bool,
                 zone_id: _builtins.str):
        """
        :param _builtins.str create_time: Creation time.
        :param Sequence['GetClustersClusterHostGroupListNodeDiskInfoArgs'] disk_infos: Disk information.
        :param _builtins.str emr_expired_time: The timeout of the EMR.
        :param _builtins.str expired_time: Timeout time.
        :param _builtins.str inner_ip: The Intranet IP of the EMR.
        :param _builtins.str instance_id: The ID of the ECS instance.
        :param _builtins.str pub_ip: Public IP address.
        :param _builtins.str status: Status.
        :param _builtins.bool support_ipv6: Whether IPV6 is supported.
        :param _builtins.str zone_id: The zone ID.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "disk_infos", disk_infos)
        pulumi.set(__self__, "emr_expired_time", emr_expired_time)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "inner_ip", inner_ip)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "pub_ip", pub_ip)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "support_ipv6", support_ipv6)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="diskInfos")
    def disk_infos(self) -> Sequence['outputs.GetClustersClusterHostGroupListNodeDiskInfoResult']:
        """
        Disk information.
        """
        return pulumi.get(self, "disk_infos")

    @_builtins.property
    @pulumi.getter(name="emrExpiredTime")
    def emr_expired_time(self) -> _builtins.str:
        """
        The timeout of the EMR.
        """
        return pulumi.get(self, "emr_expired_time")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        """
        Timeout time.
        """
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="innerIp")
    def inner_ip(self) -> _builtins.str:
        """
        The Intranet IP of the EMR.
        """
        return pulumi.get(self, "inner_ip")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="pubIp")
    def pub_ip(self) -> _builtins.str:
        """
        Public IP address.
        """
        return pulumi.get(self, "pub_ip")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="supportIpv6")
    def support_ipv6(self) -> _builtins.bool:
        """
        Whether IPV6 is supported.
        """
        return pulumi.get(self, "support_ipv6")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetClustersClusterHostGroupListNodeDiskInfoResult(dict):
    def __init__(__self__, *,
                 device: _builtins.str,
                 disk_id: _builtins.str,
                 disk_name: _builtins.str,
                 size: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.str device: The disk name.
        :param _builtins.str disk_id: The ID of the disk.
        :param _builtins.str disk_name: The disk name.
        :param _builtins.int size: Disk capacity.
        :param _builtins.str type: Disk type.
        """
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def device(self) -> _builtins.str:
        """
        The disk name.
        """
        return pulumi.get(self, "device")

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> _builtins.str:
        """
        The ID of the disk.
        """
        return pulumi.get(self, "disk_id")

    @_builtins.property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> _builtins.str:
        """
        The disk name.
        """
        return pulumi.get(self, "disk_name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Disk capacity.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Disk type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetClustersClusterHostPoolInfoResult(dict):
    def __init__(__self__, *,
                 hp_biz_id: _builtins.str,
                 hp_name: _builtins.str):
        """
        :param _builtins.str hp_biz_id: Machine pool ID.
        :param _builtins.str hp_name: The name of the machine pool.
        """
        pulumi.set(__self__, "hp_biz_id", hp_biz_id)
        pulumi.set(__self__, "hp_name", hp_name)

    @_builtins.property
    @pulumi.getter(name="hpBizId")
    def hp_biz_id(self) -> _builtins.str:
        """
        Machine pool ID.
        """
        return pulumi.get(self, "hp_biz_id")

    @_builtins.property
    @pulumi.getter(name="hpName")
    def hp_name(self) -> _builtins.str:
        """
        The name of the machine pool.
        """
        return pulumi.get(self, "hp_name")


@pulumi.output_type
class GetClustersClusterRelateClusterInfoResult(dict):
    def __init__(__self__, *,
                 cluster_id: _builtins.str,
                 cluster_name: _builtins.str,
                 cluster_type: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str cluster_id: The ID of the associated cluster.
        :param _builtins.str cluster_name: The name of the associated cluster.
        :param _builtins.str cluster_type: The cluster type of the associated cluster.
        :param _builtins.str status: The status  of the associated cluster.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        """
        The ID of the associated cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        """
        The name of the associated cluster.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> _builtins.str:
        """
        The cluster type of the associated cluster.
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status  of the associated cluster.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetClustersClusterSoftwareInfoResult(dict):
    def __init__(__self__, *,
                 cluster_type: _builtins.str,
                 emr_ver: _builtins.str,
                 softwares: Sequence['outputs.GetClustersClusterSoftwareInfoSoftwareResult']):
        """
        :param _builtins.str cluster_type: Cluster type:
        :param _builtins.str emr_ver: E-MapReduce version number.
        :param Sequence['GetClustersClusterSoftwareInfoSoftwareArgs'] softwares: Service list.
        """
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "emr_ver", emr_ver)
        pulumi.set(__self__, "softwares", softwares)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> _builtins.str:
        """
        Cluster type:
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter(name="emrVer")
    def emr_ver(self) -> _builtins.str:
        """
        E-MapReduce version number.
        """
        return pulumi.get(self, "emr_ver")

    @_builtins.property
    @pulumi.getter
    def softwares(self) -> Sequence['outputs.GetClustersClusterSoftwareInfoSoftwareResult']:
        """
        Service list.
        """
        return pulumi.get(self, "softwares")


@pulumi.output_type
class GetClustersClusterSoftwareInfoSoftwareResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 name: _builtins.str,
                 only_display: _builtins.bool,
                 start_tpe: _builtins.int,
                 version: _builtins.str):
        """
        :param _builtins.str display_name: The name of the service.
        :param _builtins.str name: The internal name of the service.
        :param _builtins.bool only_display: Whether it shows.
        :param _builtins.int start_tpe: Startup type.
        :param _builtins.str version: Service version.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "only_display", only_display)
        pulumi.set(__self__, "start_tpe", start_tpe)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The name of the service.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The internal name of the service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="onlyDisplay")
    def only_display(self) -> _builtins.bool:
        """
        Whether it shows.
        """
        return pulumi.get(self, "only_display")

    @_builtins.property
    @pulumi.getter(name="startTpe")
    def start_tpe(self) -> _builtins.int:
        """
        Startup type.
        """
        return pulumi.get(self, "start_tpe")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Service version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDiskTypesTypeResult(dict):
    def __init__(__self__, *,
                 max: _builtins.int,
                 min: _builtins.int,
                 value: _builtins.str):
        """
        :param _builtins.int max: The maximum value of the data disk to supported the specific instance type
        :param _builtins.int min: The mininum value of the data disk to supported the specific instance type
        :param _builtins.str value: The value of the data disk or system disk
        """
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def max(self) -> _builtins.int:
        """
        The maximum value of the data disk to supported the specific instance type
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> _builtins.int:
        """
        The mininum value of the data disk to supported the specific instance type
        """
        return pulumi.get(self, "min")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the data disk or system disk
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetInstanceTypesTypeResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 local_storage_capacity: _builtins.int,
                 zone_id: _builtins.str):
        """
        :param _builtins.str id: The ID of the instance type.
        :param _builtins.int local_storage_capacity: Local capacity of the applied ecs instance for emr cluster. Unit: GB.
        :param _builtins.str zone_id: The supported resources of specific zoneId.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "local_storage_capacity", local_storage_capacity)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the instance type.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localStorageCapacity")
    def local_storage_capacity(self) -> _builtins.int:
        """
        Local capacity of the applied ecs instance for emr cluster. Unit: GB.
        """
        return pulumi.get(self, "local_storage_capacity")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The supported resources of specific zoneId.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetMainVersionsMainVersionResult(dict):
    def __init__(__self__, *,
                 cluster_types: Sequence[_builtins.str],
                 emr_version: _builtins.str,
                 image_id: _builtins.str):
        """
        :param Sequence[_builtins.str] cluster_types: A list of cluster types the emr cluster supported. Possible values: `HADOOP`, `ZOOKEEPER`, `KAFKA`, `DRUID`.
        :param _builtins.str emr_version: The version of the emr cluster instance. Possible values: `EMR-4.0.0`, `EMR-3.23.0`, `EMR-3.22.0`.
        :param _builtins.str image_id: The image id of the emr cluster instance.
        """
        pulumi.set(__self__, "cluster_types", cluster_types)
        pulumi.set(__self__, "emr_version", emr_version)
        pulumi.set(__self__, "image_id", image_id)

    @_builtins.property
    @pulumi.getter(name="clusterTypes")
    def cluster_types(self) -> Sequence[_builtins.str]:
        """
        A list of cluster types the emr cluster supported. Possible values: `HADOOP`, `ZOOKEEPER`, `KAFKA`, `DRUID`.
        """
        return pulumi.get(self, "cluster_types")

    @_builtins.property
    @pulumi.getter(name="emrVersion")
    def emr_version(self) -> _builtins.str:
        """
        The version of the emr cluster instance. Possible values: `EMR-4.0.0`, `EMR-3.23.0`, `EMR-3.22.0`.
        """
        return pulumi.get(self, "emr_version")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The image id of the emr cluster instance.
        """
        return pulumi.get(self, "image_id")


