# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterInstancesResult',
    'AwaitableGetClusterInstancesResult',
    'get_cluster_instances',
    'get_cluster_instances_output',
]

@pulumi.output_type
class GetClusterInstancesResult:
    """
    A collection of values returned by getClusterInstances.
    """
    def __init__(__self__, cluster_id=None, id=None, ids=None, instance_states=None, instances=None, max_results=None, names=None, next_token=None, node_group_ids=None, node_group_names=None, output_file=None, tags=None, total_count=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_states and not isinstance(instance_states, list):
            raise TypeError("Expected argument 'instance_states' to be a list")
        pulumi.set(__self__, "instance_states", instance_states)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if max_results and not isinstance(max_results, int):
            raise TypeError("Expected argument 'max_results' to be a int")
        pulumi.set(__self__, "max_results", max_results)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if next_token and not isinstance(next_token, str):
            raise TypeError("Expected argument 'next_token' to be a str")
        pulumi.set(__self__, "next_token", next_token)
        if node_group_ids and not isinstance(node_group_ids, list):
            raise TypeError("Expected argument 'node_group_ids' to be a list")
        pulumi.set(__self__, "node_group_ids", node_group_ids)
        if node_group_names and not isinstance(node_group_names, list):
            raise TypeError("Expected argument 'node_group_names' to be a list")
        pulumi.set(__self__, "node_group_names", node_group_names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Cluster ecs instance IDS.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="instanceStates")
    def instance_states(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "instance_states")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetClusterInstancesInstanceResult']:
        """
        A list of Emr Cluster ecs instances. Each element contains the following attributes:
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="maxResults")
    def max_results(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "max_results")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Cluster ecs instance names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="nextToken")
    def next_token(self) -> _builtins.str:
        return pulumi.get(self, "next_token")

    @_builtins.property
    @pulumi.getter(name="nodeGroupIds")
    def node_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "node_group_ids")

    @_builtins.property
    @pulumi.getter(name="nodeGroupNames")
    def node_group_names(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "node_group_names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> _builtins.int:
        """
        The total count of list emr cluster ecs instances.
        """
        return pulumi.get(self, "total_count")


class AwaitableGetClusterInstancesResult(GetClusterInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterInstancesResult(
            cluster_id=self.cluster_id,
            id=self.id,
            ids=self.ids,
            instance_states=self.instance_states,
            instances=self.instances,
            max_results=self.max_results,
            names=self.names,
            next_token=self.next_token,
            node_group_ids=self.node_group_ids,
            node_group_names=self.node_group_names,
            output_file=self.output_file,
            tags=self.tags,
            total_count=self.total_count)


def get_cluster_instances(cluster_id: Optional[_builtins.str] = None,
                          ids: Optional[Sequence[_builtins.str]] = None,
                          instance_states: Optional[Sequence[_builtins.str]] = None,
                          max_results: Optional[_builtins.int] = None,
                          next_token: Optional[_builtins.str] = None,
                          node_group_ids: Optional[Sequence[_builtins.str]] = None,
                          node_group_names: Optional[Sequence[_builtins.str]] = None,
                          output_file: Optional[_builtins.str] = None,
                          tags: Optional[Mapping[str, _builtins.str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterInstancesResult:
    """
    This data source provides the Emr Cluster ecs instances of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.243.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.resourcemanager.get_resource_groups(status="OK")
    default_get_zones = alicloud.get_zones(available_instance_type="ecs.g7.xlarge")
    default_network = alicloud.vpc.Network("default",
        vpc_name="TF-VPC",
        cidr_block="172.16.0.0/12")
    default_switch = alicloud.vpc.Switch("default",
        vpc_id=default_network.id,
        cidr_block="172.16.0.0/21",
        zone_id=default_get_zones.zones[0].id,
        vswitch_name="TF_VSwitch")
    default_ecs_key_pair = alicloud.ecs.EcsKeyPair("default", key_pair_name="terraform-kp")
    default_security_group = alicloud.ecs.SecurityGroup("default",
        name="TF_SECURITY_GROUP",
        vpc_id=default_network.id)
    default_role = alicloud.ram.Role("default",
        name="emrtf",
        document=\"\"\"    {
            "Statement": [
            {
                "Action": "sts:AssumeRole",
                "Effect": "Allow",
                "Principal": {
                "Service": [
                    "emr.aliyuncs.com",
                    "ecs.aliyuncs.com"
                ]
                }
            }
            ],
            "Version": "1"
        }
    \"\"\",
        description="this is a role test.",
        force=True)
    default_cluster = alicloud.emrv2.Cluster("default",
        payment_type="PayAsYouGo",
        cluster_type="DATALAKE",
        release_version="EMR-5.10.0",
        cluster_name="terraform-emr-cluster-v2",
        deploy_mode="NORMAL",
        security_mode="NORMAL",
        applications=[
            "HADOOP-COMMON",
            "HDFS",
            "YARN",
            "HIVE",
            "SPARK3",
            "TEZ",
        ],
        application_configs=[
            {
                "application_name": "HIVE",
                "config_file_name": "hivemetastore-site.xml",
                "config_item_key": "hive.metastore.type",
                "config_item_value": "DLF",
                "config_scope": "CLUSTER",
            },
            {
                "application_name": "SPARK3",
                "config_file_name": "hive-site.xml",
                "config_item_key": "hive.metastore.type",
                "config_item_value": "DLF",
                "config_scope": "CLUSTER",
            },
        ],
        node_attributes=[{
            "ram_role": default_role.name,
            "security_group_id": default_security_group.id,
            "vpc_id": default_network.id,
            "zone_id": default_get_zones.zones[0].id,
            "key_pair_name": default_ecs_key_pair.id,
        }],
        tags={
            "created": "tf",
        },
        node_groups=[
            {
                "node_group_type": "MASTER",
                "node_group_name": "emr-master",
                "payment_type": "PayAsYouGo",
                "vswitch_ids": [default_switch.id],
                "with_public_ip": False,
                "instance_types": ["ecs.g7.xlarge"],
                "node_count": 1,
                "system_disk": {
                    "category": "cloud_essd",
                    "size": 80,
                    "count": 1,
                },
                "data_disks": [{
                    "category": "cloud_essd",
                    "size": 80,
                    "count": 3,
                }],
            },
            {
                "node_group_type": "CORE",
                "node_group_name": "emr-core",
                "payment_type": "PayAsYouGo",
                "vswitch_ids": [default_switch.id],
                "with_public_ip": False,
                "instance_types": ["ecs.g7.xlarge"],
                "node_count": 3,
                "system_disk": {
                    "category": "cloud_essd",
                    "size": 80,
                    "count": 1,
                },
                "data_disks": [{
                    "category": "cloud_essd",
                    "size": 80,
                    "count": 3,
                }],
            },
        ],
        resource_group_id=default.ids[0])
    ids = alicloud.emrv2.get_cluster_instances()
    pulumi.export("emrv2ClusterInstancesId1", ids.instances[0].instance_id)
    node_group_names = alicloud.emrv2.get_cluster_instances(node_group_names=["emr-core"])
    pulumi.export("emrv2ClusterInstancesId2", node_group_names.instances[0].instance_id)
    ```


    :param _builtins.str cluster_id: The emr cluster ID.
    :param Sequence[_builtins.str] ids: A list of Cluster IDs.
    :param Sequence[_builtins.str] instance_states: The cluster ecs instance states.
    :param _builtins.int max_results: The max results is used to list emr cluster ecs instances for next page.
    :param _builtins.str next_token: The next token is used to list emr cluster ecs instances for next page.
    :param Sequence[_builtins.str] node_group_ids: The cluster node group ids.
    :param Sequence[_builtins.str] node_group_names: The cluster node group names.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['ids'] = ids
    __args__['instanceStates'] = instance_states
    __args__['maxResults'] = max_results
    __args__['nextToken'] = next_token
    __args__['nodeGroupIds'] = node_group_ids
    __args__['nodeGroupNames'] = node_group_names
    __args__['outputFile'] = output_file
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:emrv2/getClusterInstances:getClusterInstances', __args__, opts=opts, typ=GetClusterInstancesResult).value

    return AwaitableGetClusterInstancesResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_states=pulumi.get(__ret__, 'instance_states'),
        instances=pulumi.get(__ret__, 'instances'),
        max_results=pulumi.get(__ret__, 'max_results'),
        names=pulumi.get(__ret__, 'names'),
        next_token=pulumi.get(__ret__, 'next_token'),
        node_group_ids=pulumi.get(__ret__, 'node_group_ids'),
        node_group_names=pulumi.get(__ret__, 'node_group_names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'))
def get_cluster_instances_output(cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 instance_states: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 max_results: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                 next_token: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 node_group_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 node_group_names: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                 output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterInstancesResult]:
    """
    This data source provides the Emr Cluster ecs instances of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.243.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.resourcemanager.get_resource_groups(status="OK")
    default_get_zones = alicloud.get_zones(available_instance_type="ecs.g7.xlarge")
    default_network = alicloud.vpc.Network("default",
        vpc_name="TF-VPC",
        cidr_block="172.16.0.0/12")
    default_switch = alicloud.vpc.Switch("default",
        vpc_id=default_network.id,
        cidr_block="172.16.0.0/21",
        zone_id=default_get_zones.zones[0].id,
        vswitch_name="TF_VSwitch")
    default_ecs_key_pair = alicloud.ecs.EcsKeyPair("default", key_pair_name="terraform-kp")
    default_security_group = alicloud.ecs.SecurityGroup("default",
        name="TF_SECURITY_GROUP",
        vpc_id=default_network.id)
    default_role = alicloud.ram.Role("default",
        name="emrtf",
        document=\"\"\"    {
            "Statement": [
            {
                "Action": "sts:AssumeRole",
                "Effect": "Allow",
                "Principal": {
                "Service": [
                    "emr.aliyuncs.com",
                    "ecs.aliyuncs.com"
                ]
                }
            }
            ],
            "Version": "1"
        }
    \"\"\",
        description="this is a role test.",
        force=True)
    default_cluster = alicloud.emrv2.Cluster("default",
        payment_type="PayAsYouGo",
        cluster_type="DATALAKE",
        release_version="EMR-5.10.0",
        cluster_name="terraform-emr-cluster-v2",
        deploy_mode="NORMAL",
        security_mode="NORMAL",
        applications=[
            "HADOOP-COMMON",
            "HDFS",
            "YARN",
            "HIVE",
            "SPARK3",
            "TEZ",
        ],
        application_configs=[
            {
                "application_name": "HIVE",
                "config_file_name": "hivemetastore-site.xml",
                "config_item_key": "hive.metastore.type",
                "config_item_value": "DLF",
                "config_scope": "CLUSTER",
            },
            {
                "application_name": "SPARK3",
                "config_file_name": "hive-site.xml",
                "config_item_key": "hive.metastore.type",
                "config_item_value": "DLF",
                "config_scope": "CLUSTER",
            },
        ],
        node_attributes=[{
            "ram_role": default_role.name,
            "security_group_id": default_security_group.id,
            "vpc_id": default_network.id,
            "zone_id": default_get_zones.zones[0].id,
            "key_pair_name": default_ecs_key_pair.id,
        }],
        tags={
            "created": "tf",
        },
        node_groups=[
            {
                "node_group_type": "MASTER",
                "node_group_name": "emr-master",
                "payment_type": "PayAsYouGo",
                "vswitch_ids": [default_switch.id],
                "with_public_ip": False,
                "instance_types": ["ecs.g7.xlarge"],
                "node_count": 1,
                "system_disk": {
                    "category": "cloud_essd",
                    "size": 80,
                    "count": 1,
                },
                "data_disks": [{
                    "category": "cloud_essd",
                    "size": 80,
                    "count": 3,
                }],
            },
            {
                "node_group_type": "CORE",
                "node_group_name": "emr-core",
                "payment_type": "PayAsYouGo",
                "vswitch_ids": [default_switch.id],
                "with_public_ip": False,
                "instance_types": ["ecs.g7.xlarge"],
                "node_count": 3,
                "system_disk": {
                    "category": "cloud_essd",
                    "size": 80,
                    "count": 1,
                },
                "data_disks": [{
                    "category": "cloud_essd",
                    "size": 80,
                    "count": 3,
                }],
            },
        ],
        resource_group_id=default.ids[0])
    ids = alicloud.emrv2.get_cluster_instances()
    pulumi.export("emrv2ClusterInstancesId1", ids.instances[0].instance_id)
    node_group_names = alicloud.emrv2.get_cluster_instances(node_group_names=["emr-core"])
    pulumi.export("emrv2ClusterInstancesId2", node_group_names.instances[0].instance_id)
    ```


    :param _builtins.str cluster_id: The emr cluster ID.
    :param Sequence[_builtins.str] ids: A list of Cluster IDs.
    :param Sequence[_builtins.str] instance_states: The cluster ecs instance states.
    :param _builtins.int max_results: The max results is used to list emr cluster ecs instances for next page.
    :param _builtins.str next_token: The next token is used to list emr cluster ecs instances for next page.
    :param Sequence[_builtins.str] node_group_ids: The cluster node group ids.
    :param Sequence[_builtins.str] node_group_names: The cluster node group names.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['ids'] = ids
    __args__['instanceStates'] = instance_states
    __args__['maxResults'] = max_results
    __args__['nextToken'] = next_token
    __args__['nodeGroupIds'] = node_group_ids
    __args__['nodeGroupNames'] = node_group_names
    __args__['outputFile'] = output_file
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:emrv2/getClusterInstances:getClusterInstances', __args__, opts=opts, typ=GetClusterInstancesResult)
    return __ret__.apply(lambda __response__: GetClusterInstancesResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instance_states=pulumi.get(__response__, 'instance_states'),
        instances=pulumi.get(__response__, 'instances'),
        max_results=pulumi.get(__response__, 'max_results'),
        names=pulumi.get(__response__, 'names'),
        next_token=pulumi.get(__response__, 'next_token'),
        node_group_ids=pulumi.get(__response__, 'node_group_ids'),
        node_group_names=pulumi.get(__response__, 'node_group_names'),
        output_file=pulumi.get(__response__, 'output_file'),
        tags=pulumi.get(__response__, 'tags'),
        total_count=pulumi.get(__response__, 'total_count')))
