# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OriginPoolArgs', 'OriginPool']

@pulumi.input_type
class OriginPoolArgs:
    def __init__(__self__, *,
                 origin_pool_name: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input['OriginPoolOriginArgs']]]] = None):
        """
        The set of arguments for constructing a OriginPool resource.
        :param pulumi.Input[_builtins.str] origin_pool_name: The source address pool name.
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        :param pulumi.Input[_builtins.bool] enabled: Whether the source address pool is enabled:
        :param pulumi.Input[Sequence[pulumi.Input['OriginPoolOriginArgs']]] origins: The Source station information added to the source address pool. Multiple Source stations use arrays to transfer values. See `origins` below.
        """
        pulumi.set(__self__, "origin_pool_name", origin_pool_name)
        pulumi.set(__self__, "site_id", site_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)

    @_builtins.property
    @pulumi.getter(name="originPoolName")
    def origin_pool_name(self) -> pulumi.Input[_builtins.str]:
        """
        The source address pool name.
        """
        return pulumi.get(self, "origin_pool_name")

    @origin_pool_name.setter
    def origin_pool_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "origin_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the source address pool is enabled:
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OriginPoolOriginArgs']]]]:
        """
        The Source station information added to the source address pool. Multiple Source stations use arrays to transfer values. See `origins` below.
        """
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OriginPoolOriginArgs']]]]):
        pulumi.set(self, "origins", value)


@pulumi.input_type
class _OriginPoolState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 origin_pool_id: Optional[pulumi.Input[_builtins.int]] = None,
                 origin_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input['OriginPoolOriginArgs']]]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering OriginPool resources.
        :param pulumi.Input[_builtins.bool] enabled: Whether the source address pool is enabled:
        :param pulumi.Input[_builtins.int] origin_pool_id: OriginPool Id
        :param pulumi.Input[_builtins.str] origin_pool_name: The source address pool name.
        :param pulumi.Input[Sequence[pulumi.Input['OriginPoolOriginArgs']]] origins: The Source station information added to the source address pool. Multiple Source stations use arrays to transfer values. See `origins` below.
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if origin_pool_id is not None:
            pulumi.set(__self__, "origin_pool_id", origin_pool_id)
        if origin_pool_name is not None:
            pulumi.set(__self__, "origin_pool_name", origin_pool_name)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the source address pool is enabled:
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="originPoolId")
    def origin_pool_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        OriginPool Id
        """
        return pulumi.get(self, "origin_pool_id")

    @origin_pool_id.setter
    def origin_pool_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "origin_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="originPoolName")
    def origin_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source address pool name.
        """
        return pulumi.get(self, "origin_pool_name")

    @origin_pool_name.setter
    def origin_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_pool_name", value)

    @_builtins.property
    @pulumi.getter
    def origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OriginPoolOriginArgs']]]]:
        """
        The Source station information added to the source address pool. Multiple Source stations use arrays to transfer values. See `origins` below.
        """
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OriginPoolOriginArgs']]]]):
        pulumi.set(self, "origins", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)


@pulumi.type_token("alicloud:esa/originPool:OriginPool")
class OriginPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 origin_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OriginPoolOriginArgs', 'OriginPoolOriginArgsDict']]]]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Origin Pool resource.

        For information about ESA Origin Pool and how to use it, see [What is Origin Pool](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateOriginPool).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_site = alicloud.esa.Site("default",
            site_name=f"gositecdn-{default_integer['result']}.cn",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_origin_pool = alicloud.esa.OriginPool("default",
            origins=[
                {
                    "type": "OSS",
                    "address": "example.oss-cn-beijing.aliyuncs.com",
                    "header": "{\\"Host\\":[\\"example.oss-cn-beijing.aliyuncs.com\\"]}",
                    "enabled": True,
                    "auth_conf": {
                        "secret_key": "<SecretKeyId>",
                        "auth_type": "private_cross_account",
                        "access_key": "<AccessKeyId>",
                    },
                    "weight": 50,
                    "name": "origin1",
                },
                {
                    "address": "example.s3.com",
                    "header": "{\\"Host\\": [\\"example1.com\\"]}",
                    "enabled": True,
                    "auth_conf": {
                        "version": "v2",
                        "region": "us-east-1",
                        "auth_type": "private",
                        "access_key": "<AccessKeyId>",
                        "secret_key": "<SecretKeyId>",
                    },
                    "weight": 50,
                    "name": "origin2",
                    "type": "S3",
                },
                {
                    "type": "S3",
                    "address": "example1111.s3.com",
                    "header": "{\\"Host\\":[\\"example1111.com\\"]}",
                    "enabled": True,
                    "auth_conf": {
                        "secret_key": "<SecretKeyId>",
                        "version": "v2",
                        "region": "us-east-1",
                        "auth_type": "private",
                        "access_key": "<AccessKeyId>",
                    },
                    "weight": 30,
                    "name": "origin3",
                },
            ],
            site_id=default_site.id,
            origin_pool_name="exampleoriginpool",
            enabled=True)
        ```

        ## Import

        ESA Origin Pool can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/originPool:OriginPool example <site_id>:<origin_pool_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the source address pool is enabled:
        :param pulumi.Input[_builtins.str] origin_pool_name: The source address pool name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OriginPoolOriginArgs', 'OriginPoolOriginArgsDict']]]] origins: The Source station information added to the source address pool. Multiple Source stations use arrays to transfer values. See `origins` below.
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OriginPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Origin Pool resource.

        For information about ESA Origin Pool and how to use it, see [What is Origin Pool](https://next.api.alibabacloud.com/document/ESA/2024-09-10/CreateOriginPool).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        default_site = alicloud.esa.Site("default",
            site_name=f"gositecdn-{default_integer['result']}.cn",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_origin_pool = alicloud.esa.OriginPool("default",
            origins=[
                {
                    "type": "OSS",
                    "address": "example.oss-cn-beijing.aliyuncs.com",
                    "header": "{\\"Host\\":[\\"example.oss-cn-beijing.aliyuncs.com\\"]}",
                    "enabled": True,
                    "auth_conf": {
                        "secret_key": "<SecretKeyId>",
                        "auth_type": "private_cross_account",
                        "access_key": "<AccessKeyId>",
                    },
                    "weight": 50,
                    "name": "origin1",
                },
                {
                    "address": "example.s3.com",
                    "header": "{\\"Host\\": [\\"example1.com\\"]}",
                    "enabled": True,
                    "auth_conf": {
                        "version": "v2",
                        "region": "us-east-1",
                        "auth_type": "private",
                        "access_key": "<AccessKeyId>",
                        "secret_key": "<SecretKeyId>",
                    },
                    "weight": 50,
                    "name": "origin2",
                    "type": "S3",
                },
                {
                    "type": "S3",
                    "address": "example1111.s3.com",
                    "header": "{\\"Host\\":[\\"example1111.com\\"]}",
                    "enabled": True,
                    "auth_conf": {
                        "secret_key": "<SecretKeyId>",
                        "version": "v2",
                        "region": "us-east-1",
                        "auth_type": "private",
                        "access_key": "<AccessKeyId>",
                    },
                    "weight": 30,
                    "name": "origin3",
                },
            ],
            site_id=default_site.id,
            origin_pool_name="exampleoriginpool",
            enabled=True)
        ```

        ## Import

        ESA Origin Pool can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/originPool:OriginPool example <site_id>:<origin_pool_id>
        ```

        :param str resource_name: The name of the resource.
        :param OriginPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OriginPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 origin_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OriginPoolOriginArgs', 'OriginPoolOriginArgsDict']]]]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OriginPoolArgs.__new__(OriginPoolArgs)

            __props__.__dict__["enabled"] = enabled
            if origin_pool_name is None and not opts.urn:
                raise TypeError("Missing required property 'origin_pool_name'")
            __props__.__dict__["origin_pool_name"] = origin_pool_name
            __props__.__dict__["origins"] = origins
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["origin_pool_id"] = None
        super(OriginPool, __self__).__init__(
            'alicloud:esa/originPool:OriginPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            origin_pool_id: Optional[pulumi.Input[_builtins.int]] = None,
            origin_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
            origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OriginPoolOriginArgs', 'OriginPoolOriginArgsDict']]]]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'OriginPool':
        """
        Get an existing OriginPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the source address pool is enabled:
        :param pulumi.Input[_builtins.int] origin_pool_id: OriginPool Id
        :param pulumi.Input[_builtins.str] origin_pool_name: The source address pool name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OriginPoolOriginArgs', 'OriginPoolOriginArgsDict']]]] origins: The Source station information added to the source address pool. Multiple Source stations use arrays to transfer values. See `origins` below.
        :param pulumi.Input[_builtins.int] site_id: The site ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OriginPoolState.__new__(_OriginPoolState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["origin_pool_id"] = origin_pool_id
        __props__.__dict__["origin_pool_name"] = origin_pool_name
        __props__.__dict__["origins"] = origins
        __props__.__dict__["site_id"] = site_id
        return OriginPool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the source address pool is enabled:
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="originPoolId")
    def origin_pool_id(self) -> pulumi.Output[_builtins.int]:
        """
        OriginPool Id
        """
        return pulumi.get(self, "origin_pool_id")

    @_builtins.property
    @pulumi.getter(name="originPoolName")
    def origin_pool_name(self) -> pulumi.Output[_builtins.str]:
        """
        The source address pool name.
        """
        return pulumi.get(self, "origin_pool_name")

    @_builtins.property
    @pulumi.getter
    def origins(self) -> pulumi.Output[Optional[Sequence['outputs.OriginPoolOrigin']]]:
        """
        The Source station information added to the source address pool. Multiple Source stations use arrays to transfer values. See `origins` below.
        """
        return pulumi.get(self, "origins")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        The site ID.
        """
        return pulumi.get(self, "site_id")

