# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PageArgs', 'Page']

@pulumi.input_type
class PageArgs:
    def __init__(__self__, *,
                 content_type: pulumi.Input[_builtins.str],
                 page_name: pulumi.Input[_builtins.str],
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Page resource.
        :param pulumi.Input[_builtins.str] content_type: The Content-Type field in the HTTP header.
        :param pulumi.Input[_builtins.str] page_name: The name of the custom response page.
        :param pulumi.Input[_builtins.str] content: The Base64-encoded content of the error page. The content type is specified by the Content-Type field.
        :param pulumi.Input[_builtins.str] description: The description of the custom error page.
        """
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "page_name", page_name)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[_builtins.str]:
        """
        The Content-Type field in the HTTP header.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter(name="pageName")
    def page_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the custom response page.
        """
        return pulumi.get(self, "page_name")

    @page_name.setter
    def page_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "page_name", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-encoded content of the error page. The content type is specified by the Content-Type field.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the custom error page.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _PageState:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 page_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Page resources.
        :param pulumi.Input[_builtins.str] content: The Base64-encoded content of the error page. The content type is specified by the Content-Type field.
        :param pulumi.Input[_builtins.str] content_type: The Content-Type field in the HTTP header.
        :param pulumi.Input[_builtins.str] description: The description of the custom error page.
        :param pulumi.Input[_builtins.str] page_name: The name of the custom response page.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if page_name is not None:
            pulumi.set(__self__, "page_name", page_name)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-encoded content of the error page. The content type is specified by the Content-Type field.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Content-Type field in the HTTP header.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the custom error page.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="pageName")
    def page_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the custom response page.
        """
        return pulumi.get(self, "page_name")

    @page_name.setter
    def page_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "page_name", value)


@pulumi.type_token("alicloud:esa/page:Page")
class Page(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 page_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESA Page resource.

        For information about ESA Page and how to use it, see [What is Page](https://www.alibabacloud.com/help/en/edge-security-acceleration/esa/user-guide/customize-page).

        > **NOTE:** Available since v1.242.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.Page("default",
            description="example resource html page",
            content_type="text/html",
            content="PCFET0NUWVBFIGh0bWw+CjxodG1sIGxhbmc9InpoLUNOIj4KICA8aGVhZD4KICAgIDx0aXRsZT40MDMgRm9yYmlkZGVuPC90aXRsZT4KICA8L2hlYWQ+CiAgPGJvZHk+CiAgICA8aDE+NDAzIEZvcmJpZGRlbjwvaDE+CiAgPC9ib2R5Pgo8L2h0bWw+",
            page_name="resource_example_html_page")
        ```

        ## Import

        ESA Page can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/page:Page example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content: The Base64-encoded content of the error page. The content type is specified by the Content-Type field.
        :param pulumi.Input[_builtins.str] content_type: The Content-Type field in the HTTP header.
        :param pulumi.Input[_builtins.str] description: The description of the custom error page.
        :param pulumi.Input[_builtins.str] page_name: The name of the custom response page.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Page resource.

        For information about ESA Page and how to use it, see [What is Page](https://www.alibabacloud.com/help/en/edge-security-acceleration/esa/user-guide/customize-page).

        > **NOTE:** Available since v1.242.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.esa.Page("default",
            description="example resource html page",
            content_type="text/html",
            content="PCFET0NUWVBFIGh0bWw+CjxodG1sIGxhbmc9InpoLUNOIj4KICA8aGVhZD4KICAgIDx0aXRsZT40MDMgRm9yYmlkZGVuPC90aXRsZT4KICA8L2hlYWQ+CiAgPGJvZHk+CiAgICA8aDE+NDAzIEZvcmJpZGRlbjwvaDE+CiAgPC9ib2R5Pgo8L2h0bWw+",
            page_name="resource_example_html_page")
        ```

        ## Import

        ESA Page can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/page:Page example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 page_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PageArgs.__new__(PageArgs)

            __props__.__dict__["content"] = content
            if content_type is None and not opts.urn:
                raise TypeError("Missing required property 'content_type'")
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["description"] = description
            if page_name is None and not opts.urn:
                raise TypeError("Missing required property 'page_name'")
            __props__.__dict__["page_name"] = page_name
        super(Page, __self__).__init__(
            'alicloud:esa/page:Page',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            content_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            page_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Page':
        """
        Get an existing Page resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content: The Base64-encoded content of the error page. The content type is specified by the Content-Type field.
        :param pulumi.Input[_builtins.str] content_type: The Content-Type field in the HTTP header.
        :param pulumi.Input[_builtins.str] description: The description of the custom error page.
        :param pulumi.Input[_builtins.str] page_name: The name of the custom response page.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PageState.__new__(_PageState)

        __props__.__dict__["content"] = content
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["description"] = description
        __props__.__dict__["page_name"] = page_name
        return Page(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Base64-encoded content of the error page. The content type is specified by the Content-Type field.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[_builtins.str]:
        """
        The Content-Type field in the HTTP header.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the custom error page.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="pageName")
    def page_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the custom response page.
        """
        return pulumi.get(self, "page_name")

