# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScalingConfigurationArgs', 'ScalingConfiguration']

@pulumi.input_type
class ScalingConfigurationArgs:
    def __init__(__self__, *,
                 scaling_group_id: pulumi.Input[_builtins.str],
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 credit_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_priorities: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationCustomPriorityArgs']]]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_options_login_as_non_root: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pattern_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstanceTypeOverrideArgs']]]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 is_outdated: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationNetworkInterfaceArgs']]]] = None,
                 override: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 substitute: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ScalingConfiguration resource.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group of a scaling configuration.
        :param pulumi.Input[_builtins.bool] active: Whether active current scaling configuration in the specified scaling group. Default to `false`.
        :param pulumi.Input[_builtins.str] credit_specification: Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationCustomPriorityArgs']]] custom_priorities: You can use CustomPriorities to specify the priority of a custom ECS instance type + vSwitch combination. See `custom_priorities` below for details.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]] data_disks: DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        :param pulumi.Input[_builtins.bool] deletion_protection: Specifies whether to enable the Release Protection feature for ECS instances. This parameter is applicable to only pay-as-you-go instances. You can use this parameter to specify whether an ECS instance can be directly released by using the ECS console or calling the DeleteInstance operation. Valid values: true, false. Default value: false.
        :param pulumi.Input[_builtins.bool] enable: Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        :param pulumi.Input[_builtins.bool] force_delete: The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        :param pulumi.Input[_builtins.str] host_name: Hostname of an ECS instance.
        :param pulumi.Input[_builtins.str] image_id: ID of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[_builtins.str] image_name: Name of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[_builtins.bool] image_options_login_as_non_root: Specifies whether to use ecs-user to log on to an ECS instance. For more information, see Manage the username used to log on to an ECS instance. Valid values: true, false. Default value: false.
        :param pulumi.Input[_builtins.str] instance_description: The description of ECS instances. The description must be 2 to 256 characters in length. It can contain letters but cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_ids: It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        :param pulumi.Input[_builtins.str] instance_name: Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]] instance_pattern_infos: intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        :param pulumi.Input[_builtins.str] instance_type: Resource type of an ECS instance.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstanceTypeOverrideArgs']]] instance_type_overrides: specify the weight of instance type.  See `instance_type_override` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: Resource types of an ECS instance.
        :param pulumi.Input[_builtins.str] internet_charge_type: Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_in: Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second).
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        :param pulumi.Input[_builtins.str] io_optimized: It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        :param pulumi.Input[_builtins.bool] is_outdated: Whether to use outdated instance type. Default to false.
        :param pulumi.Input[_builtins.str] key_name: The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationNetworkInterfaceArgs']]] network_interfaces: Specify NetworkInterfaces.N to configure primary and secondary ENIs. In this case, specify at least one primary ENI. If you set NetworkInterfaces.N.InstanceType to Primary, a primary ENI is configured. If you set NetworkInterfaces.N.InstanceType to Secondary or leave the parameter empty, a secondary ENI is configured. See `network_interfaces` below for details.
        :param pulumi.Input[_builtins.bool] override: Indicates whether to overwrite the existing data. Default to false.
        :param pulumi.Input[_builtins.str] password: The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        :param pulumi.Input[_builtins.bool] password_inherit: Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        :param pulumi.Input[_builtins.str] resource_group_id: ID of resource group.
        :param pulumi.Input[_builtins.str] role_name: Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        :param pulumi.Input[_builtins.str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: Specifies whether to enable Security Hardening. Valid values: Active, Deactive.
        :param pulumi.Input[_builtins.str] security_group_id: ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        :param pulumi.Input[_builtins.int] spot_duration: The protection period of preemptible instances. Unit: hours. Valid values: 1, 0.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]] spot_price_limits: Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
               
               > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
               
               > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
               
               > **NOTE:** Restrictions on attaching ECS instances:
               
               - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
               - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
               - The attached ECS instances must in the running state.
               - The attached ECS instances has not been attached to other scaling groups.
               - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
               
               > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        :param pulumi.Input[_builtins.str] substitute: The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        :param pulumi.Input[_builtins.str] system_disk_auto_snapshot_policy_id: The id of auto snapshot policy for system disk.
        :param pulumi.Input[_builtins.str] system_disk_category: Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        :param pulumi.Input[_builtins.str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_encrypt_algorithm: The algorithm that you want to use to encrypt the system disk. Valid values: AES-256, SM4-128.
        :param pulumi.Input[_builtins.bool] system_disk_encrypted: Whether to encrypt the system disk.
        :param pulumi.Input[_builtins.str] system_disk_kms_key_id: The ID of the KMS key that you want to use to encrypt the system disk.
        :param pulumi.Input[_builtins.str] system_disk_name: The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        :param pulumi.Input[_builtins.str] system_disk_performance_level: The performance level of the ESSD used as the system disk.
        :param pulumi.Input[_builtins.int] system_disk_provisioned_iops: IOPS measures the number of read and write operations that an EBS device can process per second.
        :param pulumi.Input[_builtins.int] system_disk_size: Size of system disk, in GiB. Valid values: Basic disk: 20 to 500, ESSD: The valid values depend on the performance level (PL) of the system disk (PL0 ESSD: 1 to 2048, PL1 ESSD: 20 to 2048, PL2 ESSD: 461 to 2048, PL3 ESSD: 1261 to 2048) , ESSD AutoPL disk: 1 to 2048, Other disk categories: 20 to 2048. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        :param pulumi.Input[_builtins.str] user_data: User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if custom_priorities is not None:
            pulumi.set(__self__, "custom_priorities", custom_priorities)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if image_options_login_as_non_root is not None:
            pulumi.set(__self__, "image_options_login_as_non_root", image_options_login_as_non_root)
        if instance_description is not None:
            pulumi.set(__self__, "instance_description", instance_description)
        if instance_ids is not None:
            warnings.warn("""Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""instance_ids is deprecated: Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""")
        if instance_ids is not None:
            pulumi.set(__self__, "instance_ids", instance_ids)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_pattern_infos is not None:
            pulumi.set(__self__, "instance_pattern_infos", instance_pattern_infos)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if instance_type_overrides is not None:
            pulumi.set(__self__, "instance_type_overrides", instance_type_overrides)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_in is not None:
            pulumi.set(__self__, "internet_max_bandwidth_in", internet_max_bandwidth_in)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if io_optimized is not None:
            warnings.warn("""Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""", DeprecationWarning)
            pulumi.log.warn("""io_optimized is deprecated: Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""")
        if io_optimized is not None:
            pulumi.set(__self__, "io_optimized", io_optimized)
        if is_outdated is not None:
            pulumi.set(__self__, "is_outdated", is_outdated)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if override is not None:
            pulumi.set(__self__, "override", override)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if scaling_configuration_name is not None:
            pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_duration is not None:
            pulumi.set(__self__, "spot_duration", spot_duration)
        if spot_price_limits is not None:
            pulumi.set(__self__, "spot_price_limits", spot_price_limits)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if substitute is not None:
            pulumi.set(__self__, "substitute", substitute)
        if system_disk_auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "system_disk_auto_snapshot_policy_id", system_disk_auto_snapshot_policy_id)
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_description is not None:
            pulumi.set(__self__, "system_disk_description", system_disk_description)
        if system_disk_encrypt_algorithm is not None:
            pulumi.set(__self__, "system_disk_encrypt_algorithm", system_disk_encrypt_algorithm)
        if system_disk_encrypted is not None:
            pulumi.set(__self__, "system_disk_encrypted", system_disk_encrypted)
        if system_disk_kms_key_id is not None:
            pulumi.set(__self__, "system_disk_kms_key_id", system_disk_kms_key_id)
        if system_disk_name is not None:
            pulumi.set(__self__, "system_disk_name", system_disk_name)
        if system_disk_performance_level is not None:
            pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        if system_disk_provisioned_iops is not None:
            pulumi.set(__self__, "system_disk_provisioned_iops", system_disk_provisioned_iops)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the scaling group of a scaling configuration.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether active current scaling configuration in the specified scaling group. Default to `false`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credit_specification", value)

    @_builtins.property
    @pulumi.getter(name="customPriorities")
    def custom_priorities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationCustomPriorityArgs']]]]:
        """
        You can use CustomPriorities to specify the priority of a custom ECS instance type + vSwitch combination. See `custom_priorities` below for details.
        """
        return pulumi.get(self, "custom_priorities")

    @custom_priorities.setter
    def custom_priorities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationCustomPriorityArgs']]]]):
        pulumi.set(self, "custom_priorities", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]]]:
        """
        DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the Release Protection feature for ECS instances. This parameter is applicable to only pay-as-you-go instances. You can use this parameter to specify whether an ECS instance can be directly released by using the ECS console or calling the DeleteInstance operation. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Hostname of an ECS instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of an image file, indicating the image resource selected when an instance is enabled.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of an image file, indicating the image resource selected when an instance is enabled.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="imageOptionsLoginAsNonRoot")
    def image_options_login_as_non_root(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use ecs-user to log on to an ECS instance. For more information, see Manage the username used to log on to an ECS instance. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "image_options_login_as_non_root")

    @image_options_login_as_non_root.setter
    def image_options_login_as_non_root(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "image_options_login_as_non_root", value)

    @_builtins.property
    @pulumi.getter(name="instanceDescription")
    def instance_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of ECS instances. The description must be 2 to 256 characters in length. It can contain letters but cannot start with http:// or https://.
        """
        return pulumi.get(self, "instance_description")

    @instance_description.setter
    def instance_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_description", value)

    @_builtins.property
    @pulumi.getter(name="instanceIds")
    @_utilities.deprecated("""Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""")
    def instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        """
        return pulumi.get(self, "instance_ids")

    @instance_ids.setter
    def instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_ids", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instancePatternInfos")
    def instance_pattern_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]]]:
        """
        intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        """
        return pulumi.get(self, "instance_pattern_infos")

    @instance_pattern_infos.setter
    def instance_pattern_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]]]):
        pulumi.set(self, "instance_pattern_infos", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource type of an ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypeOverrides")
    def instance_type_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstanceTypeOverrideArgs']]]]:
        """
        specify the weight of instance type.  See `instance_type_override` below for details.
        """
        return pulumi.get(self, "instance_type_overrides")

    @instance_type_overrides.setter
    def instance_type_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstanceTypeOverrideArgs']]]]):
        pulumi.set(self, "instance_type_overrides", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Resource types of an ECS instance.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second).
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @internet_max_bandwidth_in.setter
    def internet_max_bandwidth_in(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_in", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @_builtins.property
    @pulumi.getter(name="ioOptimized")
    @_utilities.deprecated("""Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""")
    def io_optimized(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        """
        return pulumi.get(self, "io_optimized")

    @io_optimized.setter
    def io_optimized(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "io_optimized", value)

    @_builtins.property
    @pulumi.getter(name="isOutdated")
    def is_outdated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use outdated instance type. Default to false.
        """
        return pulumi.get(self, "is_outdated")

    @is_outdated.setter
    def is_outdated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_outdated", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationNetworkInterfaceArgs']]]]:
        """
        Specify NetworkInterfaces.N to configure primary and secondary ENIs. In this case, specify at least one primary ENI. If you set NetworkInterfaces.N.InstanceType to Primary, a primary ENI is configured. If you set NetworkInterfaces.N.InstanceType to Secondary or leave the parameter empty, a secondary ENI is configured. See `network_interfaces` below for details.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter
    def override(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to overwrite the existing data. Default to false.
        """
        return pulumi.get(self, "override")

    @override.setter
    def override(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "override", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_inherit", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_configuration_name", value)

    @_builtins.property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable Security Hardening. Valid values: Active, Deactive.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The protection period of preemptible instances. Unit: hours. Valid values: 1, 0.
        """
        return pulumi.get(self, "spot_duration")

    @spot_duration.setter
    def spot_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_duration", value)

    @_builtins.property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]]]:
        """
        Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.

        > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.

        > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.

        > **NOTE:** Restrictions on attaching ECS instances:

        - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
        - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
        - The attached ECS instances must in the running state.
        - The attached ECS instances has not been attached to other scaling groups.
        - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.

        > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        """
        return pulumi.get(self, "spot_price_limits")

    @spot_price_limits.setter
    def spot_price_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]]]):
        pulumi.set(self, "spot_price_limits", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter
    def substitute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        """
        return pulumi.get(self, "substitute")

    @substitute.setter
    def substitute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "substitute", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskAutoSnapshotPolicyId")
    def system_disk_auto_snapshot_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of auto snapshot policy for system disk.
        """
        return pulumi.get(self, "system_disk_auto_snapshot_policy_id")

    @system_disk_auto_snapshot_policy_id.setter
    def system_disk_auto_snapshot_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_auto_snapshot_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_category", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "system_disk_description")

    @system_disk_description.setter
    def system_disk_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_description", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskEncryptAlgorithm")
    def system_disk_encrypt_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The algorithm that you want to use to encrypt the system disk. Valid values: AES-256, SM4-128.
        """
        return pulumi.get(self, "system_disk_encrypt_algorithm")

    @system_disk_encrypt_algorithm.setter
    def system_disk_encrypt_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_encrypt_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to encrypt the system disk.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @system_disk_encrypted.setter
    def system_disk_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_disk_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKeyId")
    def system_disk_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS key that you want to use to encrypt the system disk.
        """
        return pulumi.get(self, "system_disk_kms_key_id")

    @system_disk_kms_key_id.setter
    def system_disk_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        """
        return pulumi.get(self, "system_disk_name")

    @system_disk_name.setter
    def system_disk_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_name", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The performance level of the ESSD used as the system disk.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @system_disk_performance_level.setter
    def system_disk_performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_performance_level", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskProvisionedIops")
    def system_disk_provisioned_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        IOPS measures the number of read and write operations that an EBS device can process per second.
        """
        return pulumi.get(self, "system_disk_provisioned_iops")

    @system_disk_provisioned_iops.setter
    def system_disk_provisioned_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_provisioned_iops", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of system disk, in GiB. Valid values: Basic disk: 20 to 500, ESSD: The valid values depend on the performance level (PL) of the system disk (PL0 ESSD: 1 to 2048, PL1 ESSD: 20 to 2048, PL2 ESSD: 461 to 2048, PL3 ESSD: 1261 to 2048) , ESSD AutoPL disk: 1 to 2048, Other disk categories: 20 to 2048. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_size", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _ScalingConfigurationState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 credit_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_priorities: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationCustomPriorityArgs']]]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_options_login_as_non_root: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pattern_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstanceTypeOverrideArgs']]]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 is_outdated: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationNetworkInterfaceArgs']]]] = None,
                 override: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 substitute: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ScalingConfiguration resources.
        :param pulumi.Input[_builtins.bool] active: Whether active current scaling configuration in the specified scaling group. Default to `false`.
        :param pulumi.Input[_builtins.str] credit_specification: Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationCustomPriorityArgs']]] custom_priorities: You can use CustomPriorities to specify the priority of a custom ECS instance type + vSwitch combination. See `custom_priorities` below for details.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]] data_disks: DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        :param pulumi.Input[_builtins.bool] deletion_protection: Specifies whether to enable the Release Protection feature for ECS instances. This parameter is applicable to only pay-as-you-go instances. You can use this parameter to specify whether an ECS instance can be directly released by using the ECS console or calling the DeleteInstance operation. Valid values: true, false. Default value: false.
        :param pulumi.Input[_builtins.bool] enable: Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        :param pulumi.Input[_builtins.bool] force_delete: The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        :param pulumi.Input[_builtins.str] host_name: Hostname of an ECS instance.
        :param pulumi.Input[_builtins.str] image_id: ID of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[_builtins.str] image_name: Name of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[_builtins.bool] image_options_login_as_non_root: Specifies whether to use ecs-user to log on to an ECS instance. For more information, see Manage the username used to log on to an ECS instance. Valid values: true, false. Default value: false.
        :param pulumi.Input[_builtins.str] instance_description: The description of ECS instances. The description must be 2 to 256 characters in length. It can contain letters but cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_ids: It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        :param pulumi.Input[_builtins.str] instance_name: Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]] instance_pattern_infos: intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        :param pulumi.Input[_builtins.str] instance_type: Resource type of an ECS instance.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstanceTypeOverrideArgs']]] instance_type_overrides: specify the weight of instance type.  See `instance_type_override` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: Resource types of an ECS instance.
        :param pulumi.Input[_builtins.str] internet_charge_type: Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_in: Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second).
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        :param pulumi.Input[_builtins.str] io_optimized: It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        :param pulumi.Input[_builtins.bool] is_outdated: Whether to use outdated instance type. Default to false.
        :param pulumi.Input[_builtins.str] key_name: The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationNetworkInterfaceArgs']]] network_interfaces: Specify NetworkInterfaces.N to configure primary and secondary ENIs. In this case, specify at least one primary ENI. If you set NetworkInterfaces.N.InstanceType to Primary, a primary ENI is configured. If you set NetworkInterfaces.N.InstanceType to Secondary or leave the parameter empty, a secondary ENI is configured. See `network_interfaces` below for details.
        :param pulumi.Input[_builtins.bool] override: Indicates whether to overwrite the existing data. Default to false.
        :param pulumi.Input[_builtins.str] password: The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        :param pulumi.Input[_builtins.bool] password_inherit: Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        :param pulumi.Input[_builtins.str] resource_group_id: ID of resource group.
        :param pulumi.Input[_builtins.str] role_name: Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        :param pulumi.Input[_builtins.str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group of a scaling configuration.
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: Specifies whether to enable Security Hardening. Valid values: Active, Deactive.
        :param pulumi.Input[_builtins.str] security_group_id: ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        :param pulumi.Input[_builtins.int] spot_duration: The protection period of preemptible instances. Unit: hours. Valid values: 1, 0.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]] spot_price_limits: Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
               
               > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
               
               > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
               
               > **NOTE:** Restrictions on attaching ECS instances:
               
               - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
               - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
               - The attached ECS instances must in the running state.
               - The attached ECS instances has not been attached to other scaling groups.
               - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
               
               > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        :param pulumi.Input[_builtins.str] substitute: The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        :param pulumi.Input[_builtins.str] system_disk_auto_snapshot_policy_id: The id of auto snapshot policy for system disk.
        :param pulumi.Input[_builtins.str] system_disk_category: Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        :param pulumi.Input[_builtins.str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_encrypt_algorithm: The algorithm that you want to use to encrypt the system disk. Valid values: AES-256, SM4-128.
        :param pulumi.Input[_builtins.bool] system_disk_encrypted: Whether to encrypt the system disk.
        :param pulumi.Input[_builtins.str] system_disk_kms_key_id: The ID of the KMS key that you want to use to encrypt the system disk.
        :param pulumi.Input[_builtins.str] system_disk_name: The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        :param pulumi.Input[_builtins.str] system_disk_performance_level: The performance level of the ESSD used as the system disk.
        :param pulumi.Input[_builtins.int] system_disk_provisioned_iops: IOPS measures the number of read and write operations that an EBS device can process per second.
        :param pulumi.Input[_builtins.int] system_disk_size: Size of system disk, in GiB. Valid values: Basic disk: 20 to 500, ESSD: The valid values depend on the performance level (PL) of the system disk (PL0 ESSD: 1 to 2048, PL1 ESSD: 20 to 2048, PL2 ESSD: 461 to 2048, PL3 ESSD: 1261 to 2048) , ESSD AutoPL disk: 1 to 2048, Other disk categories: 20 to 2048. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        :param pulumi.Input[_builtins.str] user_data: User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if custom_priorities is not None:
            pulumi.set(__self__, "custom_priorities", custom_priorities)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if image_options_login_as_non_root is not None:
            pulumi.set(__self__, "image_options_login_as_non_root", image_options_login_as_non_root)
        if instance_description is not None:
            pulumi.set(__self__, "instance_description", instance_description)
        if instance_ids is not None:
            warnings.warn("""Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""instance_ids is deprecated: Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""")
        if instance_ids is not None:
            pulumi.set(__self__, "instance_ids", instance_ids)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_pattern_infos is not None:
            pulumi.set(__self__, "instance_pattern_infos", instance_pattern_infos)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if instance_type_overrides is not None:
            pulumi.set(__self__, "instance_type_overrides", instance_type_overrides)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_in is not None:
            pulumi.set(__self__, "internet_max_bandwidth_in", internet_max_bandwidth_in)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if io_optimized is not None:
            warnings.warn("""Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""", DeprecationWarning)
            pulumi.log.warn("""io_optimized is deprecated: Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""")
        if io_optimized is not None:
            pulumi.set(__self__, "io_optimized", io_optimized)
        if is_outdated is not None:
            pulumi.set(__self__, "is_outdated", is_outdated)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if override is not None:
            pulumi.set(__self__, "override", override)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if scaling_configuration_name is not None:
            pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_duration is not None:
            pulumi.set(__self__, "spot_duration", spot_duration)
        if spot_price_limits is not None:
            pulumi.set(__self__, "spot_price_limits", spot_price_limits)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if substitute is not None:
            pulumi.set(__self__, "substitute", substitute)
        if system_disk_auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "system_disk_auto_snapshot_policy_id", system_disk_auto_snapshot_policy_id)
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_description is not None:
            pulumi.set(__self__, "system_disk_description", system_disk_description)
        if system_disk_encrypt_algorithm is not None:
            pulumi.set(__self__, "system_disk_encrypt_algorithm", system_disk_encrypt_algorithm)
        if system_disk_encrypted is not None:
            pulumi.set(__self__, "system_disk_encrypted", system_disk_encrypted)
        if system_disk_kms_key_id is not None:
            pulumi.set(__self__, "system_disk_kms_key_id", system_disk_kms_key_id)
        if system_disk_name is not None:
            pulumi.set(__self__, "system_disk_name", system_disk_name)
        if system_disk_performance_level is not None:
            pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        if system_disk_provisioned_iops is not None:
            pulumi.set(__self__, "system_disk_provisioned_iops", system_disk_provisioned_iops)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether active current scaling configuration in the specified scaling group. Default to `false`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credit_specification", value)

    @_builtins.property
    @pulumi.getter(name="customPriorities")
    def custom_priorities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationCustomPriorityArgs']]]]:
        """
        You can use CustomPriorities to specify the priority of a custom ECS instance type + vSwitch combination. See `custom_priorities` below for details.
        """
        return pulumi.get(self, "custom_priorities")

    @custom_priorities.setter
    def custom_priorities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationCustomPriorityArgs']]]]):
        pulumi.set(self, "custom_priorities", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]]]:
        """
        DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the Release Protection feature for ECS instances. This parameter is applicable to only pay-as-you-go instances. You can use this parameter to specify whether an ECS instance can be directly released by using the ECS console or calling the DeleteInstance operation. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Hostname of an ECS instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of an image file, indicating the image resource selected when an instance is enabled.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of an image file, indicating the image resource selected when an instance is enabled.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="imageOptionsLoginAsNonRoot")
    def image_options_login_as_non_root(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use ecs-user to log on to an ECS instance. For more information, see Manage the username used to log on to an ECS instance. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "image_options_login_as_non_root")

    @image_options_login_as_non_root.setter
    def image_options_login_as_non_root(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "image_options_login_as_non_root", value)

    @_builtins.property
    @pulumi.getter(name="instanceDescription")
    def instance_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of ECS instances. The description must be 2 to 256 characters in length. It can contain letters but cannot start with http:// or https://.
        """
        return pulumi.get(self, "instance_description")

    @instance_description.setter
    def instance_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_description", value)

    @_builtins.property
    @pulumi.getter(name="instanceIds")
    @_utilities.deprecated("""Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""")
    def instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        """
        return pulumi.get(self, "instance_ids")

    @instance_ids.setter
    def instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_ids", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instancePatternInfos")
    def instance_pattern_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]]]:
        """
        intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        """
        return pulumi.get(self, "instance_pattern_infos")

    @instance_pattern_infos.setter
    def instance_pattern_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]]]):
        pulumi.set(self, "instance_pattern_infos", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource type of an ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypeOverrides")
    def instance_type_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstanceTypeOverrideArgs']]]]:
        """
        specify the weight of instance type.  See `instance_type_override` below for details.
        """
        return pulumi.get(self, "instance_type_overrides")

    @instance_type_overrides.setter
    def instance_type_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstanceTypeOverrideArgs']]]]):
        pulumi.set(self, "instance_type_overrides", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Resource types of an ECS instance.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second).
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @internet_max_bandwidth_in.setter
    def internet_max_bandwidth_in(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_in", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @_builtins.property
    @pulumi.getter(name="ioOptimized")
    @_utilities.deprecated("""Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""")
    def io_optimized(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        """
        return pulumi.get(self, "io_optimized")

    @io_optimized.setter
    def io_optimized(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "io_optimized", value)

    @_builtins.property
    @pulumi.getter(name="isOutdated")
    def is_outdated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use outdated instance type. Default to false.
        """
        return pulumi.get(self, "is_outdated")

    @is_outdated.setter
    def is_outdated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_outdated", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationNetworkInterfaceArgs']]]]:
        """
        Specify NetworkInterfaces.N to configure primary and secondary ENIs. In this case, specify at least one primary ENI. If you set NetworkInterfaces.N.InstanceType to Primary, a primary ENI is configured. If you set NetworkInterfaces.N.InstanceType to Secondary or leave the parameter empty, a secondary ENI is configured. See `network_interfaces` below for details.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter
    def override(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to overwrite the existing data. Default to false.
        """
        return pulumi.get(self, "override")

    @override.setter
    def override(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "override", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_inherit", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_configuration_name", value)

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the scaling group of a scaling configuration.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scaling_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable Security Hardening. Valid values: Active, Deactive.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The protection period of preemptible instances. Unit: hours. Valid values: 1, 0.
        """
        return pulumi.get(self, "spot_duration")

    @spot_duration.setter
    def spot_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_duration", value)

    @_builtins.property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]]]:
        """
        Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.

        > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.

        > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.

        > **NOTE:** Restrictions on attaching ECS instances:

        - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
        - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
        - The attached ECS instances must in the running state.
        - The attached ECS instances has not been attached to other scaling groups.
        - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.

        > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        """
        return pulumi.get(self, "spot_price_limits")

    @spot_price_limits.setter
    def spot_price_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]]]):
        pulumi.set(self, "spot_price_limits", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter
    def substitute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        """
        return pulumi.get(self, "substitute")

    @substitute.setter
    def substitute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "substitute", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskAutoSnapshotPolicyId")
    def system_disk_auto_snapshot_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of auto snapshot policy for system disk.
        """
        return pulumi.get(self, "system_disk_auto_snapshot_policy_id")

    @system_disk_auto_snapshot_policy_id.setter
    def system_disk_auto_snapshot_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_auto_snapshot_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_category", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "system_disk_description")

    @system_disk_description.setter
    def system_disk_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_description", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskEncryptAlgorithm")
    def system_disk_encrypt_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The algorithm that you want to use to encrypt the system disk. Valid values: AES-256, SM4-128.
        """
        return pulumi.get(self, "system_disk_encrypt_algorithm")

    @system_disk_encrypt_algorithm.setter
    def system_disk_encrypt_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_encrypt_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to encrypt the system disk.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @system_disk_encrypted.setter
    def system_disk_encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system_disk_encrypted", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKeyId")
    def system_disk_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the KMS key that you want to use to encrypt the system disk.
        """
        return pulumi.get(self, "system_disk_kms_key_id")

    @system_disk_kms_key_id.setter
    def system_disk_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        """
        return pulumi.get(self, "system_disk_name")

    @system_disk_name.setter
    def system_disk_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_name", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The performance level of the ESSD used as the system disk.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @system_disk_performance_level.setter
    def system_disk_performance_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_performance_level", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskProvisionedIops")
    def system_disk_provisioned_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        IOPS measures the number of read and write operations that an EBS device can process per second.
        """
        return pulumi.get(self, "system_disk_provisioned_iops")

    @system_disk_provisioned_iops.setter
    def system_disk_provisioned_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_provisioned_iops", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of system disk, in GiB. Valid values: Basic disk: 20 to 500, ESSD: The valid values depend on the performance level (PL) of the system disk (PL0 ESSD: 1 to 2048, PL1 ESSD: 20 to 2048, PL2 ESSD: 461 to 2048, PL3 ESSD: 1261 to 2048) , ESSD AutoPL disk: 1 to 2048, Other disk categories: 20 to 2048. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_size", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.type_token("alicloud:ess/scalingConfiguration:ScalingConfiguration")
class ScalingConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 credit_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_priorities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationCustomPriorityArgs', 'ScalingConfigurationCustomPriorityArgsDict']]]]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationDataDiskArgs', 'ScalingConfigurationDataDiskArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_options_login_as_non_root: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pattern_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationInstancePatternInfoArgs', 'ScalingConfigurationInstancePatternInfoArgsDict']]]]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationInstanceTypeOverrideArgs', 'ScalingConfigurationInstanceTypeOverrideArgsDict']]]]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 is_outdated: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationNetworkInterfaceArgs', 'ScalingConfigurationNetworkInterfaceArgsDict']]]]] = None,
                 override: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationSpotPriceLimitArgs', 'ScalingConfigurationSpotPriceLimitArgsDict']]]]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 substitute: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ESS scaling configuration resource.

        > **NOTE:** Several instance types have outdated in some regions and availability zones, such as `ecs.t1.*`, `ecs.s2.*`, `ecs.n1.*` and so on. If you want to keep them, you should set `is_outdated` to true. For more about the upgraded instance type, refer to `ecs_get_instance_types` datasource.

        > **NOTE:** Available since v1.39.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        my_name = f"{name}-{default_integer['result']}"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=2,
            memory_size=4)
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=my_name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=my_name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=my_name,
            vpc_id=default_network.id)
        default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
            type="ingress",
            ip_protocol="tcp",
            nic_type="intranet",
            policy="accept",
            port_range="22/22",
            priority=1,
            security_group_id=default_security_group.id,
            cidr_ip="172.16.0.0/24")
        default_scaling_group = alicloud.ess.ScalingGroup("default",
            min_size=1,
            max_size=1,
            scaling_group_name=my_name,
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ],
            vswitch_ids=[default_switch.id])
        default_scaling_configuration = alicloud.ess.ScalingConfiguration("default",
            scaling_group_id=default_scaling_group.id,
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_group_id=default_security_group.id,
            force_delete=True,
            active=True)
        ```

        ## Module Support

        You can use to the existing autoscaling module
        to create a configuration, scaling group and lifecycle hook one-click.

        ## Import

        ESS scaling configuration can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/scalingConfiguration:ScalingConfiguration example asg-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active: Whether active current scaling configuration in the specified scaling group. Default to `false`.
        :param pulumi.Input[_builtins.str] credit_specification: Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationCustomPriorityArgs', 'ScalingConfigurationCustomPriorityArgsDict']]]] custom_priorities: You can use CustomPriorities to specify the priority of a custom ECS instance type + vSwitch combination. See `custom_priorities` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationDataDiskArgs', 'ScalingConfigurationDataDiskArgsDict']]]] data_disks: DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        :param pulumi.Input[_builtins.bool] deletion_protection: Specifies whether to enable the Release Protection feature for ECS instances. This parameter is applicable to only pay-as-you-go instances. You can use this parameter to specify whether an ECS instance can be directly released by using the ECS console or calling the DeleteInstance operation. Valid values: true, false. Default value: false.
        :param pulumi.Input[_builtins.bool] enable: Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        :param pulumi.Input[_builtins.bool] force_delete: The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        :param pulumi.Input[_builtins.str] host_name: Hostname of an ECS instance.
        :param pulumi.Input[_builtins.str] image_id: ID of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[_builtins.str] image_name: Name of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[_builtins.bool] image_options_login_as_non_root: Specifies whether to use ecs-user to log on to an ECS instance. For more information, see Manage the username used to log on to an ECS instance. Valid values: true, false. Default value: false.
        :param pulumi.Input[_builtins.str] instance_description: The description of ECS instances. The description must be 2 to 256 characters in length. It can contain letters but cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_ids: It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        :param pulumi.Input[_builtins.str] instance_name: Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationInstancePatternInfoArgs', 'ScalingConfigurationInstancePatternInfoArgsDict']]]] instance_pattern_infos: intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        :param pulumi.Input[_builtins.str] instance_type: Resource type of an ECS instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationInstanceTypeOverrideArgs', 'ScalingConfigurationInstanceTypeOverrideArgsDict']]]] instance_type_overrides: specify the weight of instance type.  See `instance_type_override` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: Resource types of an ECS instance.
        :param pulumi.Input[_builtins.str] internet_charge_type: Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_in: Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second).
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        :param pulumi.Input[_builtins.str] io_optimized: It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        :param pulumi.Input[_builtins.bool] is_outdated: Whether to use outdated instance type. Default to false.
        :param pulumi.Input[_builtins.str] key_name: The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationNetworkInterfaceArgs', 'ScalingConfigurationNetworkInterfaceArgsDict']]]] network_interfaces: Specify NetworkInterfaces.N to configure primary and secondary ENIs. In this case, specify at least one primary ENI. If you set NetworkInterfaces.N.InstanceType to Primary, a primary ENI is configured. If you set NetworkInterfaces.N.InstanceType to Secondary or leave the parameter empty, a secondary ENI is configured. See `network_interfaces` below for details.
        :param pulumi.Input[_builtins.bool] override: Indicates whether to overwrite the existing data. Default to false.
        :param pulumi.Input[_builtins.str] password: The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        :param pulumi.Input[_builtins.bool] password_inherit: Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        :param pulumi.Input[_builtins.str] resource_group_id: ID of resource group.
        :param pulumi.Input[_builtins.str] role_name: Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        :param pulumi.Input[_builtins.str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group of a scaling configuration.
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: Specifies whether to enable Security Hardening. Valid values: Active, Deactive.
        :param pulumi.Input[_builtins.str] security_group_id: ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        :param pulumi.Input[_builtins.int] spot_duration: The protection period of preemptible instances. Unit: hours. Valid values: 1, 0.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationSpotPriceLimitArgs', 'ScalingConfigurationSpotPriceLimitArgsDict']]]] spot_price_limits: Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
               
               > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
               
               > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
               
               > **NOTE:** Restrictions on attaching ECS instances:
               
               - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
               - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
               - The attached ECS instances must in the running state.
               - The attached ECS instances has not been attached to other scaling groups.
               - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
               
               > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        :param pulumi.Input[_builtins.str] substitute: The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        :param pulumi.Input[_builtins.str] system_disk_auto_snapshot_policy_id: The id of auto snapshot policy for system disk.
        :param pulumi.Input[_builtins.str] system_disk_category: Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        :param pulumi.Input[_builtins.str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_encrypt_algorithm: The algorithm that you want to use to encrypt the system disk. Valid values: AES-256, SM4-128.
        :param pulumi.Input[_builtins.bool] system_disk_encrypted: Whether to encrypt the system disk.
        :param pulumi.Input[_builtins.str] system_disk_kms_key_id: The ID of the KMS key that you want to use to encrypt the system disk.
        :param pulumi.Input[_builtins.str] system_disk_name: The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        :param pulumi.Input[_builtins.str] system_disk_performance_level: The performance level of the ESSD used as the system disk.
        :param pulumi.Input[_builtins.int] system_disk_provisioned_iops: IOPS measures the number of read and write operations that an EBS device can process per second.
        :param pulumi.Input[_builtins.int] system_disk_size: Size of system disk, in GiB. Valid values: Basic disk: 20 to 500, ESSD: The valid values depend on the performance level (PL) of the system disk (PL0 ESSD: 1 to 2048, PL1 ESSD: 20 to 2048, PL2 ESSD: 461 to 2048, PL3 ESSD: 1261 to 2048) , ESSD AutoPL disk: 1 to 2048, Other disk categories: 20 to 2048. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        :param pulumi.Input[_builtins.str] user_data: User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScalingConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESS scaling configuration resource.

        > **NOTE:** Several instance types have outdated in some regions and availability zones, such as `ecs.t1.*`, `ecs.s2.*`, `ecs.n1.*` and so on. If you want to keep them, you should set `is_outdated` to true. For more about the upgraded instance type, refer to `ecs_get_instance_types` datasource.

        > **NOTE:** Available since v1.39.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_integer = random.index.Integer("default",
            min=10000,
            max=99999)
        my_name = f"{name}-{default_integer['result']}"
        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=2,
            memory_size=4)
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=my_name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=my_name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            name=my_name,
            vpc_id=default_network.id)
        default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
            type="ingress",
            ip_protocol="tcp",
            nic_type="intranet",
            policy="accept",
            port_range="22/22",
            priority=1,
            security_group_id=default_security_group.id,
            cidr_ip="172.16.0.0/24")
        default_scaling_group = alicloud.ess.ScalingGroup("default",
            min_size=1,
            max_size=1,
            scaling_group_name=my_name,
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ],
            vswitch_ids=[default_switch.id])
        default_scaling_configuration = alicloud.ess.ScalingConfiguration("default",
            scaling_group_id=default_scaling_group.id,
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_group_id=default_security_group.id,
            force_delete=True,
            active=True)
        ```

        ## Module Support

        You can use to the existing autoscaling module
        to create a configuration, scaling group and lifecycle hook one-click.

        ## Import

        ESS scaling configuration can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ess/scalingConfiguration:ScalingConfiguration example asg-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param ScalingConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScalingConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 credit_specification: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_priorities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationCustomPriorityArgs', 'ScalingConfigurationCustomPriorityArgsDict']]]]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationDataDiskArgs', 'ScalingConfigurationDataDiskArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_options_login_as_non_root: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_pattern_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationInstancePatternInfoArgs', 'ScalingConfigurationInstancePatternInfoArgsDict']]]]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationInstanceTypeOverrideArgs', 'ScalingConfigurationInstanceTypeOverrideArgsDict']]]]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
                 is_outdated: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationNetworkInterfaceArgs', 'ScalingConfigurationNetworkInterfaceArgsDict']]]]] = None,
                 override: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationSpotPriceLimitArgs', 'ScalingConfigurationSpotPriceLimitArgsDict']]]]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 substitute: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScalingConfigurationArgs.__new__(ScalingConfigurationArgs)

            __props__.__dict__["active"] = active
            __props__.__dict__["credit_specification"] = credit_specification
            __props__.__dict__["custom_priorities"] = custom_priorities
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["enable"] = enable
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["image_name"] = image_name
            __props__.__dict__["image_options_login_as_non_root"] = image_options_login_as_non_root
            __props__.__dict__["instance_description"] = instance_description
            __props__.__dict__["instance_ids"] = instance_ids
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["instance_pattern_infos"] = instance_pattern_infos
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["instance_type_overrides"] = instance_type_overrides
            __props__.__dict__["instance_types"] = instance_types
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["internet_max_bandwidth_in"] = internet_max_bandwidth_in
            __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
            __props__.__dict__["io_optimized"] = io_optimized
            __props__.__dict__["is_outdated"] = is_outdated
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
            __props__.__dict__["kms_encryption_context"] = kms_encryption_context
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["override"] = override
            __props__.__dict__["password"] = password
            __props__.__dict__["password_inherit"] = password_inherit
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
            __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["spot_duration"] = spot_duration
            __props__.__dict__["spot_price_limits"] = spot_price_limits
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["substitute"] = substitute
            __props__.__dict__["system_disk_auto_snapshot_policy_id"] = system_disk_auto_snapshot_policy_id
            __props__.__dict__["system_disk_category"] = system_disk_category
            __props__.__dict__["system_disk_description"] = system_disk_description
            __props__.__dict__["system_disk_encrypt_algorithm"] = system_disk_encrypt_algorithm
            __props__.__dict__["system_disk_encrypted"] = system_disk_encrypted
            __props__.__dict__["system_disk_kms_key_id"] = system_disk_kms_key_id
            __props__.__dict__["system_disk_name"] = system_disk_name
            __props__.__dict__["system_disk_performance_level"] = system_disk_performance_level
            __props__.__dict__["system_disk_provisioned_iops"] = system_disk_provisioned_iops
            __props__.__dict__["system_disk_size"] = system_disk_size
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
        super(ScalingConfiguration, __self__).__init__(
            'alicloud:ess/scalingConfiguration:ScalingConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[_builtins.bool]] = None,
            credit_specification: Optional[pulumi.Input[_builtins.str]] = None,
            custom_priorities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationCustomPriorityArgs', 'ScalingConfigurationCustomPriorityArgsDict']]]]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationDataDiskArgs', 'ScalingConfigurationDataDiskArgsDict']]]]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            enable: Optional[pulumi.Input[_builtins.bool]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            host_name: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            image_name: Optional[pulumi.Input[_builtins.str]] = None,
            image_options_login_as_non_root: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_pattern_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationInstancePatternInfoArgs', 'ScalingConfigurationInstancePatternInfoArgsDict']]]]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationInstanceTypeOverrideArgs', 'ScalingConfigurationInstanceTypeOverrideArgsDict']]]]] = None,
            instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_max_bandwidth_in: Optional[pulumi.Input[_builtins.int]] = None,
            internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
            io_optimized: Optional[pulumi.Input[_builtins.str]] = None,
            is_outdated: Optional[pulumi.Input[_builtins.bool]] = None,
            key_name: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
            kms_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationNetworkInterfaceArgs', 'ScalingConfigurationNetworkInterfaceArgsDict']]]]] = None,
            override: Optional[pulumi.Input[_builtins.bool]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
            scaling_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_enhancement_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
            spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationSpotPriceLimitArgs', 'ScalingConfigurationSpotPriceLimitArgsDict']]]]] = None,
            spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            substitute: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_category: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_description: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_encrypt_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_name: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_performance_level: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_provisioned_iops: Optional[pulumi.Input[_builtins.int]] = None,
            system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None) -> 'ScalingConfiguration':
        """
        Get an existing ScalingConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active: Whether active current scaling configuration in the specified scaling group. Default to `false`.
        :param pulumi.Input[_builtins.str] credit_specification: Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationCustomPriorityArgs', 'ScalingConfigurationCustomPriorityArgsDict']]]] custom_priorities: You can use CustomPriorities to specify the priority of a custom ECS instance type + vSwitch combination. See `custom_priorities` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationDataDiskArgs', 'ScalingConfigurationDataDiskArgsDict']]]] data_disks: DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        :param pulumi.Input[_builtins.bool] deletion_protection: Specifies whether to enable the Release Protection feature for ECS instances. This parameter is applicable to only pay-as-you-go instances. You can use this parameter to specify whether an ECS instance can be directly released by using the ECS console or calling the DeleteInstance operation. Valid values: true, false. Default value: false.
        :param pulumi.Input[_builtins.bool] enable: Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        :param pulumi.Input[_builtins.bool] force_delete: The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        :param pulumi.Input[_builtins.str] host_name: Hostname of an ECS instance.
        :param pulumi.Input[_builtins.str] image_id: ID of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[_builtins.str] image_name: Name of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[_builtins.bool] image_options_login_as_non_root: Specifies whether to use ecs-user to log on to an ECS instance. For more information, see Manage the username used to log on to an ECS instance. Valid values: true, false. Default value: false.
        :param pulumi.Input[_builtins.str] instance_description: The description of ECS instances. The description must be 2 to 256 characters in length. It can contain letters but cannot start with http:// or https://.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_ids: It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        :param pulumi.Input[_builtins.str] instance_name: Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationInstancePatternInfoArgs', 'ScalingConfigurationInstancePatternInfoArgsDict']]]] instance_pattern_infos: intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        :param pulumi.Input[_builtins.str] instance_type: Resource type of an ECS instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationInstanceTypeOverrideArgs', 'ScalingConfigurationInstanceTypeOverrideArgsDict']]]] instance_type_overrides: specify the weight of instance type.  See `instance_type_override` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: Resource types of an ECS instance.
        :param pulumi.Input[_builtins.str] internet_charge_type: Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_in: Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second).
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        :param pulumi.Input[_builtins.str] io_optimized: It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        :param pulumi.Input[_builtins.bool] is_outdated: Whether to use outdated instance type. Default to false.
        :param pulumi.Input[_builtins.str] key_name: The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        :param pulumi.Input[_builtins.str] kms_encrypted_password: An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationNetworkInterfaceArgs', 'ScalingConfigurationNetworkInterfaceArgsDict']]]] network_interfaces: Specify NetworkInterfaces.N to configure primary and secondary ENIs. In this case, specify at least one primary ENI. If you set NetworkInterfaces.N.InstanceType to Primary, a primary ENI is configured. If you set NetworkInterfaces.N.InstanceType to Secondary or leave the parameter empty, a secondary ENI is configured. See `network_interfaces` below for details.
        :param pulumi.Input[_builtins.bool] override: Indicates whether to overwrite the existing data. Default to false.
        :param pulumi.Input[_builtins.str] password: The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        :param pulumi.Input[_builtins.bool] password_inherit: Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        :param pulumi.Input[_builtins.str] resource_group_id: ID of resource group.
        :param pulumi.Input[_builtins.str] role_name: Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        :param pulumi.Input[_builtins.str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        :param pulumi.Input[_builtins.str] scaling_group_id: ID of the scaling group of a scaling configuration.
        :param pulumi.Input[_builtins.str] security_enhancement_strategy: Specifies whether to enable Security Hardening. Valid values: Active, Deactive.
        :param pulumi.Input[_builtins.str] security_group_id: ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        :param pulumi.Input[_builtins.int] spot_duration: The protection period of preemptible instances. Unit: hours. Valid values: 1, 0.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScalingConfigurationSpotPriceLimitArgs', 'ScalingConfigurationSpotPriceLimitArgsDict']]]] spot_price_limits: Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
               
               > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
               
               > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
               
               > **NOTE:** Restrictions on attaching ECS instances:
               
               - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
               - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
               - The attached ECS instances must in the running state.
               - The attached ECS instances has not been attached to other scaling groups.
               - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
               
               > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        :param pulumi.Input[_builtins.str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        :param pulumi.Input[_builtins.str] substitute: The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        :param pulumi.Input[_builtins.str] system_disk_auto_snapshot_policy_id: The id of auto snapshot policy for system disk.
        :param pulumi.Input[_builtins.str] system_disk_category: Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        :param pulumi.Input[_builtins.str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] system_disk_encrypt_algorithm: The algorithm that you want to use to encrypt the system disk. Valid values: AES-256, SM4-128.
        :param pulumi.Input[_builtins.bool] system_disk_encrypted: Whether to encrypt the system disk.
        :param pulumi.Input[_builtins.str] system_disk_kms_key_id: The ID of the KMS key that you want to use to encrypt the system disk.
        :param pulumi.Input[_builtins.str] system_disk_name: The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        :param pulumi.Input[_builtins.str] system_disk_performance_level: The performance level of the ESSD used as the system disk.
        :param pulumi.Input[_builtins.int] system_disk_provisioned_iops: IOPS measures the number of read and write operations that an EBS device can process per second.
        :param pulumi.Input[_builtins.int] system_disk_size: Size of system disk, in GiB. Valid values: Basic disk: 20 to 500, ESSD: The valid values depend on the performance level (PL) of the system disk (PL0 ESSD: 1 to 2048, PL1 ESSD: 20 to 2048, PL2 ESSD: 461 to 2048, PL3 ESSD: 1261 to 2048) , ESSD AutoPL disk: 1 to 2048, Other disk categories: 20 to 2048. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        :param pulumi.Input[_builtins.str] user_data: User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScalingConfigurationState.__new__(_ScalingConfigurationState)

        __props__.__dict__["active"] = active
        __props__.__dict__["credit_specification"] = credit_specification
        __props__.__dict__["custom_priorities"] = custom_priorities
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["enable"] = enable
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["image_options_login_as_non_root"] = image_options_login_as_non_root
        __props__.__dict__["instance_description"] = instance_description
        __props__.__dict__["instance_ids"] = instance_ids
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_pattern_infos"] = instance_pattern_infos
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["instance_type_overrides"] = instance_type_overrides
        __props__.__dict__["instance_types"] = instance_types
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["internet_max_bandwidth_in"] = internet_max_bandwidth_in
        __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
        __props__.__dict__["io_optimized"] = io_optimized
        __props__.__dict__["is_outdated"] = is_outdated
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
        __props__.__dict__["kms_encryption_context"] = kms_encryption_context
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["override"] = override
        __props__.__dict__["password"] = password
        __props__.__dict__["password_inherit"] = password_inherit
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["spot_duration"] = spot_duration
        __props__.__dict__["spot_price_limits"] = spot_price_limits
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["substitute"] = substitute
        __props__.__dict__["system_disk_auto_snapshot_policy_id"] = system_disk_auto_snapshot_policy_id
        __props__.__dict__["system_disk_category"] = system_disk_category
        __props__.__dict__["system_disk_description"] = system_disk_description
        __props__.__dict__["system_disk_encrypt_algorithm"] = system_disk_encrypt_algorithm
        __props__.__dict__["system_disk_encrypted"] = system_disk_encrypted
        __props__.__dict__["system_disk_kms_key_id"] = system_disk_kms_key_id
        __props__.__dict__["system_disk_name"] = system_disk_name
        __props__.__dict__["system_disk_performance_level"] = system_disk_performance_level
        __props__.__dict__["system_disk_provisioned_iops"] = system_disk_provisioned_iops
        __props__.__dict__["system_disk_size"] = system_disk_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_data"] = user_data
        return ScalingConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def active(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether active current scaling configuration in the specified scaling group. Default to `false`.
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        """
        return pulumi.get(self, "credit_specification")

    @_builtins.property
    @pulumi.getter(name="customPriorities")
    def custom_priorities(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingConfigurationCustomPriority']]]:
        """
        You can use CustomPriorities to specify the priority of a custom ECS instance type + vSwitch combination. See `custom_priorities` below for details.
        """
        return pulumi.get(self, "custom_priorities")

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingConfigurationDataDisk']]]:
        """
        DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the Release Protection feature for ECS instances. This parameter is applicable to only pay-as-you-go instances. You can use this parameter to specify whether an ECS instance can be directly released by using the ECS console or calling the DeleteInstance operation. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Hostname of an ECS instance.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of an image file, indicating the image resource selected when an instance is enabled.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of an image file, indicating the image resource selected when an instance is enabled.
        """
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter(name="imageOptionsLoginAsNonRoot")
    def image_options_login_as_non_root(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to use ecs-user to log on to an ECS instance. For more information, see Manage the username used to log on to an ECS instance. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "image_options_login_as_non_root")

    @_builtins.property
    @pulumi.getter(name="instanceDescription")
    def instance_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of ECS instances. The description must be 2 to 256 characters in length. It can contain letters but cannot start with http:// or https://.
        """
        return pulumi.get(self, "instance_description")

    @_builtins.property
    @pulumi.getter(name="instanceIds")
    @_utilities.deprecated("""Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""")
    def instance_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        """
        return pulumi.get(self, "instance_ids")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instancePatternInfos")
    def instance_pattern_infos(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingConfigurationInstancePatternInfo']]]:
        """
        intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        """
        return pulumi.get(self, "instance_pattern_infos")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource type of an ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="instanceTypeOverrides")
    def instance_type_overrides(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingConfigurationInstanceTypeOverride']]]:
        """
        specify the weight of instance type.  See `instance_type_override` below for details.
        """
        return pulumi.get(self, "instance_type_overrides")

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Resource types of an ECS instance.
        """
        return pulumi.get(self, "instance_types")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second).
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @_builtins.property
    @pulumi.getter(name="ioOptimized")
    @_utilities.deprecated("""Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""")
    def io_optimized(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        """
        return pulumi.get(self, "io_optimized")

    @_builtins.property
    @pulumi.getter(name="isOutdated")
    def is_outdated(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to use outdated instance type. Default to false.
        """
        return pulumi.get(self, "is_outdated")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingConfigurationNetworkInterface']]]:
        """
        Specify NetworkInterfaces.N to configure primary and secondary ENIs. In this case, specify at least one primary ENI. If you set NetworkInterfaces.N.InstanceType to Primary, a primary ENI is configured. If you set NetworkInterfaces.N.InstanceType to Secondary or leave the parameter empty, a secondary ENI is configured. See `network_interfaces` below for details.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter
    def override(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether to overwrite the existing data. Default to false.
        """
        return pulumi.get(self, "override")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        """
        return pulumi.get(self, "password_inherit")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @_builtins.property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the scaling group of a scaling configuration.
        """
        return pulumi.get(self, "scaling_group_id")

    @_builtins.property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to enable Security Hardening. Valid values: Active, Deactive.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The protection period of preemptible instances. Unit: hours. Valid values: 1, 0.
        """
        return pulumi.get(self, "spot_duration")

    @_builtins.property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingConfigurationSpotPriceLimit']]]:
        """
        Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.

        > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.

        > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.

        > **NOTE:** Restrictions on attaching ECS instances:

        - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
        - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
        - The attached ECS instances must in the running state.
        - The attached ECS instances has not been attached to other scaling groups.
        - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.

        > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        """
        return pulumi.get(self, "spot_price_limits")

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        """
        return pulumi.get(self, "spot_strategy")

    @_builtins.property
    @pulumi.getter
    def substitute(self) -> pulumi.Output[_builtins.str]:
        """
        The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        """
        return pulumi.get(self, "substitute")

    @_builtins.property
    @pulumi.getter(name="systemDiskAutoSnapshotPolicyId")
    def system_disk_auto_snapshot_policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The id of auto snapshot policy for system disk.
        """
        return pulumi.get(self, "system_disk_auto_snapshot_policy_id")

    @_builtins.property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "system_disk_category")

    @_builtins.property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "system_disk_description")

    @_builtins.property
    @pulumi.getter(name="systemDiskEncryptAlgorithm")
    def system_disk_encrypt_algorithm(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The algorithm that you want to use to encrypt the system disk. Valid values: AES-256, SM4-128.
        """
        return pulumi.get(self, "system_disk_encrypt_algorithm")

    @_builtins.property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to encrypt the system disk.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKeyId")
    def system_disk_kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the KMS key that you want to use to encrypt the system disk.
        """
        return pulumi.get(self, "system_disk_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        """
        return pulumi.get(self, "system_disk_name")

    @_builtins.property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The performance level of the ESSD used as the system disk.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @_builtins.property
    @pulumi.getter(name="systemDiskProvisionedIops")
    def system_disk_provisioned_iops(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        IOPS measures the number of read and write operations that an EBS device can process per second.
        """
        return pulumi.get(self, "system_disk_provisioned_iops")

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Size of system disk, in GiB. Valid values: Basic disk: 20 to 500, ESSD: The valid values depend on the performance level (PL) of the system disk (PL0 ESSD: 1 to 2048, PL1 ESSD: 20 to 2048, PL2 ESSD: 461 to 2048, PL3 ESSD: 1261 to 2048) , ESSD AutoPL disk: 1 to 2048, Other disk categories: 20 to 2048. The value of this parameter must be at least 1 and greater than or equal to the image size. Default value: 40 or the size of the image, whichever is larger.
        """
        return pulumi.get(self, "system_disk_size")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        return pulumi.get(self, "user_data")

