# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouterGrantAssociationArgs', 'RouterGrantAssociation']

@pulumi.input_type
class RouterGrantAssociationArgs:
    def __init__(__self__, *,
                 ecr_id: pulumi.Input[_builtins.str],
                 ecr_owner_ali_uid: pulumi.Input[_builtins.int],
                 instance_id: pulumi.Input[_builtins.str],
                 instance_region_id: pulumi.Input[_builtins.str],
                 instance_type: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a RouterGrantAssociation resource.
        :param pulumi.Input[_builtins.str] ecr_id: The ID of the associated Leased Line Gateway instance.
        :param pulumi.Input[_builtins.int] ecr_owner_ali_uid: The ID of the Alibaba Cloud account (primary account) to which the leased line gateway instance is authorized.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the network instance.
        :param pulumi.Input[_builtins.str] instance_region_id: The ID of the region where the authorized network instance is located.
        :param pulumi.Input[_builtins.str] instance_type: The type of the network instance. Value:
               - `VBR`: the VBR instance.
               - `VPC`: VPC instance.
        """
        pulumi.set(__self__, "ecr_id", ecr_id)
        pulumi.set(__self__, "ecr_owner_ali_uid", ecr_owner_ali_uid)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_region_id", instance_region_id)
        pulumi.set(__self__, "instance_type", instance_type)

    @_builtins.property
    @pulumi.getter(name="ecrId")
    def ecr_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the associated Leased Line Gateway instance.
        """
        return pulumi.get(self, "ecr_id")

    @ecr_id.setter
    def ecr_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ecr_id", value)

    @_builtins.property
    @pulumi.getter(name="ecrOwnerAliUid")
    def ecr_owner_ali_uid(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the Alibaba Cloud account (primary account) to which the leased line gateway instance is authorized.
        """
        return pulumi.get(self, "ecr_owner_ali_uid")

    @ecr_owner_ali_uid.setter
    def ecr_owner_ali_uid(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "ecr_owner_ali_uid", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the network instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceRegionId")
    def instance_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region where the authorized network instance is located.
        """
        return pulumi.get(self, "instance_region_id")

    @instance_region_id.setter
    def instance_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_region_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the network instance. Value:
        - `VBR`: the VBR instance.
        - `VPC`: VPC instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)


@pulumi.input_type
class _RouterGrantAssociationState:
    def __init__(__self__, *,
                 ecr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_owner_ali_uid: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouterGrantAssociation resources.
        :param pulumi.Input[_builtins.str] ecr_id: The ID of the associated Leased Line Gateway instance.
        :param pulumi.Input[_builtins.int] ecr_owner_ali_uid: The ID of the Alibaba Cloud account (primary account) to which the leased line gateway instance is authorized.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the network instance.
        :param pulumi.Input[_builtins.str] instance_region_id: The ID of the region where the authorized network instance is located.
        :param pulumi.Input[_builtins.str] instance_type: The type of the network instance. Value:
               - `VBR`: the VBR instance.
               - `VPC`: VPC instance.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        if ecr_id is not None:
            pulumi.set(__self__, "ecr_id", ecr_id)
        if ecr_owner_ali_uid is not None:
            pulumi.set(__self__, "ecr_owner_ali_uid", ecr_owner_ali_uid)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_region_id is not None:
            pulumi.set(__self__, "instance_region_id", instance_region_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="ecrId")
    def ecr_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the associated Leased Line Gateway instance.
        """
        return pulumi.get(self, "ecr_id")

    @ecr_id.setter
    def ecr_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ecr_id", value)

    @_builtins.property
    @pulumi.getter(name="ecrOwnerAliUid")
    def ecr_owner_ali_uid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Alibaba Cloud account (primary account) to which the leased line gateway instance is authorized.
        """
        return pulumi.get(self, "ecr_owner_ali_uid")

    @ecr_owner_ali_uid.setter
    def ecr_owner_ali_uid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ecr_owner_ali_uid", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the network instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceRegionId")
    def instance_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where the authorized network instance is located.
        """
        return pulumi.get(self, "instance_region_id")

    @instance_region_id.setter
    def instance_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_region_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the network instance. Value:
        - `VBR`: the VBR instance.
        - `VPC`: VPC instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:expressconnect/routerGrantAssociation:RouterGrantAssociation")
class RouterGrantAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ecr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_owner_ali_uid: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Express Connect Router Grant Association resource.

        Network instances authorized to the leased line Gateway.

        For information about Express Connect Router Grant Association and how to use it, see [What is Grant Association](https://www.alibabacloud.com/help/en/express-connect/developer-reference/api-expressconnectrouter-2023-09-01-grantinstancetoexpressconnectrouter).

        > **NOTE:** Available since v1.239.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        vpc_id = config.get("vpcId")
        if vpc_id is None:
            vpc_id = "vpc-xxx"
        ecr_owner_uid = config.get("ecrOwnerUid")
        if ecr_owner_uid is None:
            ecr_owner_uid = "18xxx"
        ecr_id = config.get("ecrId")
        if ecr_id is None:
            ecr_id = "ecr-xxx"
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        default = alicloud.expressconnect.RouterGrantAssociation("default",
            ecr_id=ecr_id,
            instance_region_id=region,
            instance_id=vpc_id,
            ecr_owner_ali_uid=ecr_owner_uid,
            instance_type="VPC")
        ```

        ## Import

        Express Connect Router Grant Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/routerGrantAssociation:RouterGrantAssociation example <ecr_id>:<instance_id>:<instance_region_id>:<ecr_owner_ali_uid>:<instance_type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ecr_id: The ID of the associated Leased Line Gateway instance.
        :param pulumi.Input[_builtins.int] ecr_owner_ali_uid: The ID of the Alibaba Cloud account (primary account) to which the leased line gateway instance is authorized.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the network instance.
        :param pulumi.Input[_builtins.str] instance_region_id: The ID of the region where the authorized network instance is located.
        :param pulumi.Input[_builtins.str] instance_type: The type of the network instance. Value:
               - `VBR`: the VBR instance.
               - `VPC`: VPC instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterGrantAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Router Grant Association resource.

        Network instances authorized to the leased line Gateway.

        For information about Express Connect Router Grant Association and how to use it, see [What is Grant Association](https://www.alibabacloud.com/help/en/express-connect/developer-reference/api-expressconnectrouter-2023-09-01-grantinstancetoexpressconnectrouter).

        > **NOTE:** Available since v1.239.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        vpc_id = config.get("vpcId")
        if vpc_id is None:
            vpc_id = "vpc-xxx"
        ecr_owner_uid = config.get("ecrOwnerUid")
        if ecr_owner_uid is None:
            ecr_owner_uid = "18xxx"
        ecr_id = config.get("ecrId")
        if ecr_id is None:
            ecr_id = "ecr-xxx"
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        default = alicloud.expressconnect.RouterGrantAssociation("default",
            ecr_id=ecr_id,
            instance_region_id=region,
            instance_id=vpc_id,
            ecr_owner_ali_uid=ecr_owner_uid,
            instance_type="VPC")
        ```

        ## Import

        Express Connect Router Grant Association can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:expressconnect/routerGrantAssociation:RouterGrantAssociation example <ecr_id>:<instance_id>:<instance_region_id>:<ecr_owner_ali_uid>:<instance_type>
        ```

        :param str resource_name: The name of the resource.
        :param RouterGrantAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterGrantAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ecr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ecr_owner_ali_uid: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterGrantAssociationArgs.__new__(RouterGrantAssociationArgs)

            if ecr_id is None and not opts.urn:
                raise TypeError("Missing required property 'ecr_id'")
            __props__.__dict__["ecr_id"] = ecr_id
            if ecr_owner_ali_uid is None and not opts.urn:
                raise TypeError("Missing required property 'ecr_owner_ali_uid'")
            __props__.__dict__["ecr_owner_ali_uid"] = ecr_owner_ali_uid
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if instance_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_region_id'")
            __props__.__dict__["instance_region_id"] = instance_region_id
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["status"] = None
        super(RouterGrantAssociation, __self__).__init__(
            'alicloud:expressconnect/routerGrantAssociation:RouterGrantAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ecr_id: Optional[pulumi.Input[_builtins.str]] = None,
            ecr_owner_ali_uid: Optional[pulumi.Input[_builtins.int]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'RouterGrantAssociation':
        """
        Get an existing RouterGrantAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ecr_id: The ID of the associated Leased Line Gateway instance.
        :param pulumi.Input[_builtins.int] ecr_owner_ali_uid: The ID of the Alibaba Cloud account (primary account) to which the leased line gateway instance is authorized.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the network instance.
        :param pulumi.Input[_builtins.str] instance_region_id: The ID of the region where the authorized network instance is located.
        :param pulumi.Input[_builtins.str] instance_type: The type of the network instance. Value:
               - `VBR`: the VBR instance.
               - `VPC`: VPC instance.
        :param pulumi.Input[_builtins.str] status: The status of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterGrantAssociationState.__new__(_RouterGrantAssociationState)

        __props__.__dict__["ecr_id"] = ecr_id
        __props__.__dict__["ecr_owner_ali_uid"] = ecr_owner_ali_uid
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_region_id"] = instance_region_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["status"] = status
        return RouterGrantAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ecrId")
    def ecr_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the associated Leased Line Gateway instance.
        """
        return pulumi.get(self, "ecr_id")

    @_builtins.property
    @pulumi.getter(name="ecrOwnerAliUid")
    def ecr_owner_ali_uid(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the Alibaba Cloud account (primary account) to which the leased line gateway instance is authorized.
        """
        return pulumi.get(self, "ecr_owner_ali_uid")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the network instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceRegionId")
    def instance_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region where the authorized network instance is located.
        """
        return pulumi.get(self, "instance_region_id")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the network instance. Value:
        - `VBR`: the VBR instance.
        - `VPC`: VPC instance.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

