# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['V3VpcBindingArgs', 'V3VpcBinding']

@pulumi.input_type
class V3VpcBindingArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[_builtins.str],
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a V3VpcBinding resource.
        :param pulumi.Input[_builtins.str] function_name: Function Name
        :param pulumi.Input[_builtins.str] vpc_id: VPC instance ID
        """
        pulumi.set(__self__, "function_name", function_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[_builtins.str]:
        """
        Function Name
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC instance ID
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _V3VpcBindingState:
    def __init__(__self__, *,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering V3VpcBinding resources.
        :param pulumi.Input[_builtins.str] function_name: Function Name
        :param pulumi.Input[_builtins.str] vpc_id: VPC instance ID
        """
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Function Name
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC instance ID
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("alicloud:fc/v3VpcBinding:V3VpcBinding")
class V3VpcBinding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a FCV3 Vpc Binding resource.

        For information about FCV3 Vpc Binding and how to use it, see [What is Vpc Binding](https://www.alibabacloud.com/help/en/functioncompute/fc-3-0/developer-reference/api-fc-2023-03-30-createvpcbinding).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        vpc = alicloud.vpc.Network("vpc",
            cidr_block="10.0.0.0/8",
            vpc_name=name)
        function = alicloud.fc.V3Function("function",
            memory_size=512,
            cpu=0.5,
            handler="index.Handler",
            code={
                "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
            },
            function_name=name,
            runtime="python3.9",
            disk_size=512,
            log_config={
                "log_begin_rule": "None",
            })
        default = alicloud.fc.V3VpcBinding("default",
            function_name=function.function_name,
            vpc_id=vpc.id)
        ```

        ## Import

        FCV3 Vpc Binding can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3VpcBinding:V3VpcBinding example <function_name>:<vpc_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] function_name: Function Name
        :param pulumi.Input[_builtins.str] vpc_id: VPC instance ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: V3VpcBindingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a FCV3 Vpc Binding resource.

        For information about FCV3 Vpc Binding and how to use it, see [What is Vpc Binding](https://www.alibabacloud.com/help/en/functioncompute/fc-3-0/developer-reference/api-fc-2023-03-30-createvpcbinding).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        vpc = alicloud.vpc.Network("vpc",
            cidr_block="10.0.0.0/8",
            vpc_name=name)
        function = alicloud.fc.V3Function("function",
            memory_size=512,
            cpu=0.5,
            handler="index.Handler",
            code={
                "zip_file": "UEsDBBQACAAIAAAAAAAAAAAAAAAAAAAAAAAIAAAAaW5kZXgucHmEkEFKxEAQRfd9ig9ZTCJOooIwDMwNXLqXnnQlaalUhU5lRj2KZ/FOXkESGR114bJ/P/7jV4b1xRq1hijtFpM1682cuNgPmgysbRulPT0fRxXnMtwrSPyeCdYRokSLnuMLJTTkbUqEvDMbxm1VdcRD6Tk+T1LW2ldB66knsYdA5iNX17ebm6tN2VnPhcswMPmREPuBacb+CiapLarAj9gT6/H97dVlCNScY3mtYvRkxdZlwDKDEnanPWVLdrdkeXEGlFEazVdfPVHaVeHc3N15CUwppwOJXeK7HshAB8NuOU7J6sP4SRXuH/EvbUfMiqMmDqv5M5FNSfAj/wgAAP//UEsHCPl//NYAAQAArwEAAFBLAQIUABQACAAIAAAAAAD5f/zWAAEAAK8BAAAIAAAAAAAAAAAAAAAAAAAAAABpbmRleC5weVBLBQYAAAAAAQABADYAAAA2AQAAAAA=",
            },
            function_name=name,
            runtime="python3.9",
            disk_size=512,
            log_config={
                "log_begin_rule": "None",
            })
        default = alicloud.fc.V3VpcBinding("default",
            function_name=function.function_name,
            vpc_id=vpc.id)
        ```

        ## Import

        FCV3 Vpc Binding can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:fc/v3VpcBinding:V3VpcBinding example <function_name>:<vpc_id>
        ```

        :param str resource_name: The name of the resource.
        :param V3VpcBindingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(V3VpcBindingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = V3VpcBindingArgs.__new__(V3VpcBindingArgs)

            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["vpc_id"] = vpc_id
        super(V3VpcBinding, __self__).__init__(
            'alicloud:fc/v3VpcBinding:V3VpcBinding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            function_name: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'V3VpcBinding':
        """
        Get an existing V3VpcBinding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] function_name: Function Name
        :param pulumi.Input[_builtins.str] vpc_id: VPC instance ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _V3VpcBindingState.__new__(_V3VpcBindingState)

        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["vpc_id"] = vpc_id
        return V3VpcBinding(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[_builtins.str]:
        """
        Function Name
        """
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        VPC instance ID
        """
        return pulumi.get(self, "vpc_id")

