# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AclAclEntryArgs',
    'AclAclEntryArgsDict',
    'CustomRoutingEndpointTrafficPolicyPortRangeArgs',
    'CustomRoutingEndpointTrafficPolicyPortRangeArgsDict',
    'EndpointGroupEndpointConfigurationArgs',
    'EndpointGroupEndpointConfigurationArgsDict',
    'EndpointGroupPortOverridesArgs',
    'EndpointGroupPortOverridesArgsDict',
    'ForwardingRuleRuleActionArgs',
    'ForwardingRuleRuleActionArgsDict',
    'ForwardingRuleRuleActionForwardGroupConfigArgs',
    'ForwardingRuleRuleActionForwardGroupConfigArgsDict',
    'ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs',
    'ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgsDict',
    'ForwardingRuleRuleConditionArgs',
    'ForwardingRuleRuleConditionArgsDict',
    'ForwardingRuleRuleConditionHostConfigArgs',
    'ForwardingRuleRuleConditionHostConfigArgsDict',
    'ForwardingRuleRuleConditionPathConfigArgs',
    'ForwardingRuleRuleConditionPathConfigArgsDict',
    'ListenerCertificateArgs',
    'ListenerCertificateArgsDict',
    'ListenerForwardedForConfigArgs',
    'ListenerForwardedForConfigArgsDict',
    'ListenerPortRangeArgs',
    'ListenerPortRangeArgsDict',
]

MYPY = False

if not MYPY:
    class AclAclEntryArgsDict(TypedDict):
        entry: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
        """
        entry_description: NotRequired[pulumi.Input[_builtins.str]]
        """
        The description of the IP entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_).
        """
elif False:
    AclAclEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AclAclEntryArgs:
    def __init__(__self__, *,
                 entry: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] entry: The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
        :param pulumi.Input[_builtins.str] entry_description: The description of the IP entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_).
        """
        if entry is not None:
            pulumi.set(__self__, "entry", entry)
        if entry_description is not None:
            pulumi.set(__self__, "entry_description", entry_description)

    @_builtins.property
    @pulumi.getter
    def entry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
        """
        return pulumi.get(self, "entry")

    @entry.setter
    def entry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry", value)

    @_builtins.property
    @pulumi.getter(name="entryDescription")
    def entry_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the IP entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_).
        """
        return pulumi.get(self, "entry_description")

    @entry_description.setter
    def entry_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry_description", value)


if not MYPY:
    class CustomRoutingEndpointTrafficPolicyPortRangeArgsDict(TypedDict):
        from_port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The start port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        """
        to_port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The end port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        """
elif False:
    CustomRoutingEndpointTrafficPolicyPortRangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CustomRoutingEndpointTrafficPolicyPortRangeArgs:
    def __init__(__self__, *,
                 from_port: Optional[pulumi.Input[_builtins.int]] = None,
                 to_port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] from_port: The start port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        :param pulumi.Input[_builtins.int] to_port: The end port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        """
        if from_port is not None:
            pulumi.set(__self__, "from_port", from_port)
        if to_port is not None:
            pulumi.set(__self__, "to_port", to_port)

    @_builtins.property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The start port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "from_port", value)

    @_builtins.property
    @pulumi.getter(name="toPort")
    def to_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The end port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "to_port", value)


if not MYPY:
    class EndpointGroupEndpointConfigurationArgsDict(TypedDict):
        endpoint: pulumi.Input[_builtins.str]
        """
        The IP address or domain name of Endpoint N in the endpoint group.
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of Endpoint N in the endpoint group. Valid values:
        - `Domain`: A custom domain name.
        - `Ip`: A custom IP address.
        - `PublicIp`: An Alibaba Cloud public IP address.
        - `ECS`: An Elastic Compute Service (ECS) instance.
        - `SLB`: A Classic Load Balancer (CLB) instance.
        - `ALB`: An Application Load Balancer (ALB) instance.
        - `NLB`: A Network Load Balancer (NLB) instance.
        - `ENI`: An Elastic Network Interface (ENI).
        - `OSS`: An Object Storage Service (OSS) bucket.
        > **NOTE:** From version 1.232.0, `type` can be set to `ALB`, `NLB`, `ENI`, `OSS`.
        """
        weight: pulumi.Input[_builtins.int]
        """
        The weight of Endpoint N in the endpoint group. Valid values: `0` to `255`.
        > **NOTE:** If the weight of a terminal node is set to `0`, global acceleration will terminate the distribution of traffic to the terminal node. Please be careful.
        """
        enable_clientip_preservation: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates whether client IP addresses are reserved. Default Value: `false`. Valid values:
        """
        enable_proxy_protocol: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether to preserve client IP addresses by using the ProxyProtocol module. Default Value: `false`. Valid values:
        """
        sub_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The private IP address of the ENI.
        > **NOTE:** `sub_address` is valid only when `type` is set to `ENI`.
        """
elif False:
    EndpointGroupEndpointConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointGroupEndpointConfigurationArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 weight: pulumi.Input[_builtins.int],
                 enable_clientip_preservation: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[_builtins.bool]] = None,
                 sub_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] endpoint: The IP address or domain name of Endpoint N in the endpoint group.
        :param pulumi.Input[_builtins.str] type: The type of Endpoint N in the endpoint group. Valid values:
               - `Domain`: A custom domain name.
               - `Ip`: A custom IP address.
               - `PublicIp`: An Alibaba Cloud public IP address.
               - `ECS`: An Elastic Compute Service (ECS) instance.
               - `SLB`: A Classic Load Balancer (CLB) instance.
               - `ALB`: An Application Load Balancer (ALB) instance.
               - `NLB`: A Network Load Balancer (NLB) instance.
               - `ENI`: An Elastic Network Interface (ENI).
               - `OSS`: An Object Storage Service (OSS) bucket.
               > **NOTE:** From version 1.232.0, `type` can be set to `ALB`, `NLB`, `ENI`, `OSS`.
        :param pulumi.Input[_builtins.int] weight: The weight of Endpoint N in the endpoint group. Valid values: `0` to `255`.
               > **NOTE:** If the weight of a terminal node is set to `0`, global acceleration will terminate the distribution of traffic to the terminal node. Please be careful.
        :param pulumi.Input[_builtins.bool] enable_clientip_preservation: Indicates whether client IP addresses are reserved. Default Value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] enable_proxy_protocol: Specifies whether to preserve client IP addresses by using the ProxyProtocol module. Default Value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] sub_address: The private IP address of the ENI.
               > **NOTE:** `sub_address` is valid only when `type` is set to `ENI`.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "weight", weight)
        if enable_clientip_preservation is not None:
            pulumi.set(__self__, "enable_clientip_preservation", enable_clientip_preservation)
        if enable_proxy_protocol is not None:
            pulumi.set(__self__, "enable_proxy_protocol", enable_proxy_protocol)
        if sub_address is not None:
            pulumi.set(__self__, "sub_address", sub_address)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address or domain name of Endpoint N in the endpoint group.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of Endpoint N in the endpoint group. Valid values:
        - `Domain`: A custom domain name.
        - `Ip`: A custom IP address.
        - `PublicIp`: An Alibaba Cloud public IP address.
        - `ECS`: An Elastic Compute Service (ECS) instance.
        - `SLB`: A Classic Load Balancer (CLB) instance.
        - `ALB`: An Application Load Balancer (ALB) instance.
        - `NLB`: A Network Load Balancer (NLB) instance.
        - `ENI`: An Elastic Network Interface (ENI).
        - `OSS`: An Object Storage Service (OSS) bucket.
        > **NOTE:** From version 1.232.0, `type` can be set to `ALB`, `NLB`, `ENI`, `OSS`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> pulumi.Input[_builtins.int]:
        """
        The weight of Endpoint N in the endpoint group. Valid values: `0` to `255`.
        > **NOTE:** If the weight of a terminal node is set to `0`, global acceleration will terminate the distribution of traffic to the terminal node. Please be careful.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "weight", value)

    @_builtins.property
    @pulumi.getter(name="enableClientipPreservation")
    def enable_clientip_preservation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether client IP addresses are reserved. Default Value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_clientip_preservation")

    @enable_clientip_preservation.setter
    def enable_clientip_preservation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_clientip_preservation", value)

    @_builtins.property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to preserve client IP addresses by using the ProxyProtocol module. Default Value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @enable_proxy_protocol.setter
    def enable_proxy_protocol(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_proxy_protocol", value)

    @_builtins.property
    @pulumi.getter(name="subAddress")
    def sub_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP address of the ENI.
        > **NOTE:** `sub_address` is valid only when `type` is set to `ENI`.
        """
        return pulumi.get(self, "sub_address")

    @sub_address.setter
    def sub_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_address", value)


if not MYPY:
    class EndpointGroupPortOverridesArgsDict(TypedDict):
        endpoint_port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Forwarding port.
        """
        listener_port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Listener port.
        """
elif False:
    EndpointGroupPortOverridesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointGroupPortOverridesArgs:
    def __init__(__self__, *,
                 endpoint_port: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_port: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] endpoint_port: Forwarding port.
        :param pulumi.Input[_builtins.int] listener_port: Listener port.
        """
        if endpoint_port is not None:
            pulumi.set(__self__, "endpoint_port", endpoint_port)
        if listener_port is not None:
            pulumi.set(__self__, "listener_port", listener_port)

    @_builtins.property
    @pulumi.getter(name="endpointPort")
    def endpoint_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Forwarding port.
        """
        return pulumi.get(self, "endpoint_port")

    @endpoint_port.setter
    def endpoint_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "endpoint_port", value)

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Listener port.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "listener_port", value)


if not MYPY:
    class ForwardingRuleRuleActionArgsDict(TypedDict):
        order: pulumi.Input[_builtins.int]
        """
        Forwarding priority.
        """
        rule_action_type: pulumi.Input[_builtins.str]
        """
        The type of the forwarding action. Valid values: `ForwardGroup`, `Redirect`, `FixResponse`, `Rewrite`, `AddHeader`, `RemoveHeader`, `Drop`.
        """
        forward_group_config: NotRequired[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigArgsDict']]
        """
        Forwarding configuration. See `forward_group_config` below.
        > **NOTE:** From version 1.207.0, We recommend that you do not use `forward_group_config`, and we recommend that you use the `rule_action_type` and `rule_action_value` to configure forwarding actions.
        """
        rule_action_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value of the forwarding action type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
        """
elif False:
    ForwardingRuleRuleActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ForwardingRuleRuleActionArgs:
    def __init__(__self__, *,
                 order: pulumi.Input[_builtins.int],
                 rule_action_type: pulumi.Input[_builtins.str],
                 forward_group_config: Optional[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigArgs']] = None,
                 rule_action_value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] order: Forwarding priority.
        :param pulumi.Input[_builtins.str] rule_action_type: The type of the forwarding action. Valid values: `ForwardGroup`, `Redirect`, `FixResponse`, `Rewrite`, `AddHeader`, `RemoveHeader`, `Drop`.
        :param pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigArgs'] forward_group_config: Forwarding configuration. See `forward_group_config` below.
               > **NOTE:** From version 1.207.0, We recommend that you do not use `forward_group_config`, and we recommend that you use the `rule_action_type` and `rule_action_value` to configure forwarding actions.
        :param pulumi.Input[_builtins.str] rule_action_value: The value of the forwarding action type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
        """
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "rule_action_type", rule_action_type)
        if forward_group_config is not None:
            pulumi.set(__self__, "forward_group_config", forward_group_config)
        if rule_action_value is not None:
            pulumi.set(__self__, "rule_action_value", rule_action_value)

    @_builtins.property
    @pulumi.getter
    def order(self) -> pulumi.Input[_builtins.int]:
        """
        Forwarding priority.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "order", value)

    @_builtins.property
    @pulumi.getter(name="ruleActionType")
    def rule_action_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the forwarding action. Valid values: `ForwardGroup`, `Redirect`, `FixResponse`, `Rewrite`, `AddHeader`, `RemoveHeader`, `Drop`.
        """
        return pulumi.get(self, "rule_action_type")

    @rule_action_type.setter
    def rule_action_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_action_type", value)

    @_builtins.property
    @pulumi.getter(name="forwardGroupConfig")
    def forward_group_config(self) -> Optional[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigArgs']]:
        """
        Forwarding configuration. See `forward_group_config` below.
        > **NOTE:** From version 1.207.0, We recommend that you do not use `forward_group_config`, and we recommend that you use the `rule_action_type` and `rule_action_value` to configure forwarding actions.
        """
        return pulumi.get(self, "forward_group_config")

    @forward_group_config.setter
    def forward_group_config(self, value: Optional[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigArgs']]):
        pulumi.set(self, "forward_group_config", value)

    @_builtins.property
    @pulumi.getter(name="ruleActionValue")
    def rule_action_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the forwarding action type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
        """
        return pulumi.get(self, "rule_action_value")

    @rule_action_value.setter
    def rule_action_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_action_value", value)


if not MYPY:
    class ForwardingRuleRuleActionForwardGroupConfigArgsDict(TypedDict):
        server_group_tuples: pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgsDict']]]
        """
        The information about the endpoint group. See `server_group_tuples` below.
        """
elif False:
    ForwardingRuleRuleActionForwardGroupConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ForwardingRuleRuleActionForwardGroupConfigArgs:
    def __init__(__self__, *,
                 server_group_tuples: pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs']]] server_group_tuples: The information about the endpoint group. See `server_group_tuples` below.
        """
        pulumi.set(__self__, "server_group_tuples", server_group_tuples)

    @_builtins.property
    @pulumi.getter(name="serverGroupTuples")
    def server_group_tuples(self) -> pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs']]]:
        """
        The information about the endpoint group. See `server_group_tuples` below.
        """
        return pulumi.get(self, "server_group_tuples")

    @server_group_tuples.setter
    def server_group_tuples(self, value: pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs']]]):
        pulumi.set(self, "server_group_tuples", value)


if not MYPY:
    class ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgsDict(TypedDict):
        endpoint_group_id: pulumi.Input[_builtins.str]
        """
        The ID of the endpoint group.
        """
elif False:
    ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs:
    def __init__(__self__, *,
                 endpoint_group_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] endpoint_group_id: The ID of the endpoint group.
        """
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)

    @_builtins.property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the endpoint group.
        """
        return pulumi.get(self, "endpoint_group_id")

    @endpoint_group_id.setter
    def endpoint_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint_group_id", value)


if not MYPY:
    class ForwardingRuleRuleConditionArgsDict(TypedDict):
        rule_condition_type: pulumi.Input[_builtins.str]
        """
        The type of the forwarding conditions. Valid values: `Host`, `Path`, `RequestHeader`, `Query`, `Method`, `Cookie`, `SourceIP`. **NOTE:** From version 1.231.0, `rule_condition_type` can be set to `RequestHeader`, `Query`, `Method`, `Cookie`, `SourceIP`.
        """
        host_configs: NotRequired[pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleConditionHostConfigArgsDict']]]]
        """
        The configuration of the domain name. See `host_config` below.
        > **NOTE:** From version 1.231.0, We recommend that you do not use `path_config` or `host_config`, and we recommend that you use the `rule_condition_type` and `rule_condition_value` to configure forwarding conditions.
        """
        path_config: NotRequired[pulumi.Input['ForwardingRuleRuleConditionPathConfigArgsDict']]
        """
        The configuration of the path. See `path_config` below.
        """
        rule_condition_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value of the forwarding condition type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
        """
elif False:
    ForwardingRuleRuleConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ForwardingRuleRuleConditionArgs:
    def __init__(__self__, *,
                 rule_condition_type: pulumi.Input[_builtins.str],
                 host_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleConditionHostConfigArgs']]]] = None,
                 path_config: Optional[pulumi.Input['ForwardingRuleRuleConditionPathConfigArgs']] = None,
                 rule_condition_value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] rule_condition_type: The type of the forwarding conditions. Valid values: `Host`, `Path`, `RequestHeader`, `Query`, `Method`, `Cookie`, `SourceIP`. **NOTE:** From version 1.231.0, `rule_condition_type` can be set to `RequestHeader`, `Query`, `Method`, `Cookie`, `SourceIP`.
        :param pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleConditionHostConfigArgs']]] host_configs: The configuration of the domain name. See `host_config` below.
               > **NOTE:** From version 1.231.0, We recommend that you do not use `path_config` or `host_config`, and we recommend that you use the `rule_condition_type` and `rule_condition_value` to configure forwarding conditions.
        :param pulumi.Input['ForwardingRuleRuleConditionPathConfigArgs'] path_config: The configuration of the path. See `path_config` below.
        :param pulumi.Input[_builtins.str] rule_condition_value: The value of the forwarding condition type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
        """
        pulumi.set(__self__, "rule_condition_type", rule_condition_type)
        if host_configs is not None:
            pulumi.set(__self__, "host_configs", host_configs)
        if path_config is not None:
            pulumi.set(__self__, "path_config", path_config)
        if rule_condition_value is not None:
            pulumi.set(__self__, "rule_condition_value", rule_condition_value)

    @_builtins.property
    @pulumi.getter(name="ruleConditionType")
    def rule_condition_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the forwarding conditions. Valid values: `Host`, `Path`, `RequestHeader`, `Query`, `Method`, `Cookie`, `SourceIP`. **NOTE:** From version 1.231.0, `rule_condition_type` can be set to `RequestHeader`, `Query`, `Method`, `Cookie`, `SourceIP`.
        """
        return pulumi.get(self, "rule_condition_type")

    @rule_condition_type.setter
    def rule_condition_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_condition_type", value)

    @_builtins.property
    @pulumi.getter(name="hostConfigs")
    def host_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleConditionHostConfigArgs']]]]:
        """
        The configuration of the domain name. See `host_config` below.
        > **NOTE:** From version 1.231.0, We recommend that you do not use `path_config` or `host_config`, and we recommend that you use the `rule_condition_type` and `rule_condition_value` to configure forwarding conditions.
        """
        return pulumi.get(self, "host_configs")

    @host_configs.setter
    def host_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleConditionHostConfigArgs']]]]):
        pulumi.set(self, "host_configs", value)

    @_builtins.property
    @pulumi.getter(name="pathConfig")
    def path_config(self) -> Optional[pulumi.Input['ForwardingRuleRuleConditionPathConfigArgs']]:
        """
        The configuration of the path. See `path_config` below.
        """
        return pulumi.get(self, "path_config")

    @path_config.setter
    def path_config(self, value: Optional[pulumi.Input['ForwardingRuleRuleConditionPathConfigArgs']]):
        pulumi.set(self, "path_config", value)

    @_builtins.property
    @pulumi.getter(name="ruleConditionValue")
    def rule_condition_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of the forwarding condition type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
        """
        return pulumi.get(self, "rule_condition_value")

    @rule_condition_value.setter
    def rule_condition_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_condition_value", value)


if not MYPY:
    class ForwardingRuleRuleConditionHostConfigArgsDict(TypedDict):
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
elif False:
    ForwardingRuleRuleConditionHostConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ForwardingRuleRuleConditionHostConfigArgs:
    def __init__(__self__, *,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ForwardingRuleRuleConditionPathConfigArgsDict(TypedDict):
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
elif False:
    ForwardingRuleRuleConditionPathConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ForwardingRuleRuleConditionPathConfigArgs:
    def __init__(__self__, *,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ListenerCertificateArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The id of the certificate.
        """
elif False:
    ListenerCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerCertificateArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: The id of the certificate.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the certificate.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class ListenerForwardedForConfigArgsDict(TypedDict):
        forwarded_for_ga_ap_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether to use the GA-AP header to retrieve the information about acceleration regions. Default value: `false`. Valid values:
        """
        forwarded_for_ga_id_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether to use the GA-ID header to retrieve the ID of the GA instance. Default value: `false`. Valid values:
        """
        forwarded_for_port_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether to use the GA-X-Forward-Port header to retrieve the listener ports of the GA instance. Default value: `false`. Valid values:
        """
        forwarded_for_proto_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether to use the GA-X-Forward-Proto header to retrieve the listener protocol of the GA instance. Default value: `false`. Valid values:
        """
        real_ip_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether to use the X-Real-IP header to retrieve client IP addresses. Default value: `false`. Valid values:
        """
elif False:
    ListenerForwardedForConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerForwardedForConfigArgs:
    def __init__(__self__, *,
                 forwarded_for_ga_ap_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 forwarded_for_ga_id_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 forwarded_for_port_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 forwarded_for_proto_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 real_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] forwarded_for_ga_ap_enabled: Specifies whether to use the GA-AP header to retrieve the information about acceleration regions. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] forwarded_for_ga_id_enabled: Specifies whether to use the GA-ID header to retrieve the ID of the GA instance. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] forwarded_for_port_enabled: Specifies whether to use the GA-X-Forward-Port header to retrieve the listener ports of the GA instance. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] forwarded_for_proto_enabled: Specifies whether to use the GA-X-Forward-Proto header to retrieve the listener protocol of the GA instance. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] real_ip_enabled: Specifies whether to use the X-Real-IP header to retrieve client IP addresses. Default value: `false`. Valid values:
        """
        if forwarded_for_ga_ap_enabled is not None:
            pulumi.set(__self__, "forwarded_for_ga_ap_enabled", forwarded_for_ga_ap_enabled)
        if forwarded_for_ga_id_enabled is not None:
            pulumi.set(__self__, "forwarded_for_ga_id_enabled", forwarded_for_ga_id_enabled)
        if forwarded_for_port_enabled is not None:
            pulumi.set(__self__, "forwarded_for_port_enabled", forwarded_for_port_enabled)
        if forwarded_for_proto_enabled is not None:
            pulumi.set(__self__, "forwarded_for_proto_enabled", forwarded_for_proto_enabled)
        if real_ip_enabled is not None:
            pulumi.set(__self__, "real_ip_enabled", real_ip_enabled)

    @_builtins.property
    @pulumi.getter(name="forwardedForGaApEnabled")
    def forwarded_for_ga_ap_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use the GA-AP header to retrieve the information about acceleration regions. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "forwarded_for_ga_ap_enabled")

    @forwarded_for_ga_ap_enabled.setter
    def forwarded_for_ga_ap_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forwarded_for_ga_ap_enabled", value)

    @_builtins.property
    @pulumi.getter(name="forwardedForGaIdEnabled")
    def forwarded_for_ga_id_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use the GA-ID header to retrieve the ID of the GA instance. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "forwarded_for_ga_id_enabled")

    @forwarded_for_ga_id_enabled.setter
    def forwarded_for_ga_id_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forwarded_for_ga_id_enabled", value)

    @_builtins.property
    @pulumi.getter(name="forwardedForPortEnabled")
    def forwarded_for_port_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use the GA-X-Forward-Port header to retrieve the listener ports of the GA instance. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "forwarded_for_port_enabled")

    @forwarded_for_port_enabled.setter
    def forwarded_for_port_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forwarded_for_port_enabled", value)

    @_builtins.property
    @pulumi.getter(name="forwardedForProtoEnabled")
    def forwarded_for_proto_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use the GA-X-Forward-Proto header to retrieve the listener protocol of the GA instance. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "forwarded_for_proto_enabled")

    @forwarded_for_proto_enabled.setter
    def forwarded_for_proto_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forwarded_for_proto_enabled", value)

    @_builtins.property
    @pulumi.getter(name="realIpEnabled")
    def real_ip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use the X-Real-IP header to retrieve client IP addresses. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "real_ip_enabled")

    @real_ip_enabled.setter
    def real_ip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "real_ip_enabled", value)


if not MYPY:
    class ListenerPortRangeArgsDict(TypedDict):
        from_port: pulumi.Input[_builtins.int]
        """
        The initial listening port used to receive requests and forward them to terminal nodes.
        """
        to_port: pulumi.Input[_builtins.int]
        """
        The end listening port used to receive requests and forward them to terminal nodes.
        """
elif False:
    ListenerPortRangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerPortRangeArgs:
    def __init__(__self__, *,
                 from_port: pulumi.Input[_builtins.int],
                 to_port: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] from_port: The initial listening port used to receive requests and forward them to terminal nodes.
        :param pulumi.Input[_builtins.int] to_port: The end listening port used to receive requests and forward them to terminal nodes.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "to_port", to_port)

    @_builtins.property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> pulumi.Input[_builtins.int]:
        """
        The initial listening port used to receive requests and forward them to terminal nodes.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "from_port", value)

    @_builtins.property
    @pulumi.getter(name="toPort")
    def to_port(self) -> pulumi.Input[_builtins.int]:
        """
        The end listening port used to receive requests and forward them to terminal nodes.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "to_port", value)


