# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBasicAcceleratorsResult',
    'AwaitableGetBasicAcceleratorsResult',
    'get_basic_accelerators',
    'get_basic_accelerators_output',
]

@pulumi.output_type
class GetBasicAcceleratorsResult:
    """
    A collection of values returned by getBasicAccelerators.
    """
    def __init__(__self__, accelerator_id=None, accelerators=None, bandwidth_billing_type=None, id=None, ids=None, name_regex=None, names=None, output_file=None, page_number=None, page_size=None, status=None):
        if accelerator_id and not isinstance(accelerator_id, str):
            raise TypeError("Expected argument 'accelerator_id' to be a str")
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        if accelerators and not isinstance(accelerators, list):
            raise TypeError("Expected argument 'accelerators' to be a list")
        pulumi.set(__self__, "accelerators", accelerators)
        if bandwidth_billing_type and not isinstance(bandwidth_billing_type, str):
            raise TypeError("Expected argument 'bandwidth_billing_type' to be a str")
        pulumi.set(__self__, "bandwidth_billing_type", bandwidth_billing_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "accelerator_id")

    @_builtins.property
    @pulumi.getter
    def accelerators(self) -> Sequence['outputs.GetBasicAcceleratorsAcceleratorResult']:
        """
        A list of Global Accelerator Basic Accelerators. Each element contains the following attributes:
        """
        return pulumi.get(self, "accelerators")

    @_builtins.property
    @pulumi.getter(name="bandwidthBillingType")
    def bandwidth_billing_type(self) -> Optional[_builtins.str]:
        """
        The bandwidth billing method.
        """
        return pulumi.get(self, "bandwidth_billing_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of Global Accelerator Basic Accelerator names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_number")

    @_builtins.property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page_size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the Global Accelerator Basic Accelerator instance.
        """
        return pulumi.get(self, "status")


class AwaitableGetBasicAcceleratorsResult(GetBasicAcceleratorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBasicAcceleratorsResult(
            accelerator_id=self.accelerator_id,
            accelerators=self.accelerators,
            bandwidth_billing_type=self.bandwidth_billing_type,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            status=self.status)


def get_basic_accelerators(accelerator_id: Optional[_builtins.str] = None,
                           bandwidth_billing_type: Optional[_builtins.str] = None,
                           ids: Optional[Sequence[_builtins.str]] = None,
                           name_regex: Optional[_builtins.str] = None,
                           output_file: Optional[_builtins.str] = None,
                           page_number: Optional[_builtins.int] = None,
                           page_size: Optional[_builtins.int] = None,
                           status: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBasicAcceleratorsResult:
    """
    This data source provides the Global Accelerator (GA) Basic Accelerators of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.194.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ga.get_basic_accelerators(status="active")
    pulumi.export("gaBasicAcceleratorId1", default.accelerators[0].id)
    ```


    :param _builtins.str accelerator_id: The ID of the Global Accelerator Basic Accelerator instance.
    :param _builtins.str bandwidth_billing_type: The bandwidth billing method. Valid values:
           - `BandwidthPackage`: billed based on bandwidth plans.
           - `CDT`: billed through Cloud Data Transfer (CDT) and based on data transfer.
           - `CDT95`: billed through CDT and based on the 95th percentile bandwidth. This bandwidth billing method is available only for users that are included in the whitelist.
    :param Sequence[_builtins.str] ids: A list of Global Accelerator Basic Accelerator IDs.
    :param _builtins.str name_regex: A regex string to filter results by Global Accelerator Basic Accelerator name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the Global Accelerator Basic Accelerator instance. Valid Value: `init`, `active`, `configuring`, `binding`, `unbinding`, `deleting`, `finacialLocked`.
    """
    __args__ = dict()
    __args__['acceleratorId'] = accelerator_id
    __args__['bandwidthBillingType'] = bandwidth_billing_type
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ga/getBasicAccelerators:getBasicAccelerators', __args__, opts=opts, typ=GetBasicAcceleratorsResult).value

    return AwaitableGetBasicAcceleratorsResult(
        accelerator_id=pulumi.get(__ret__, 'accelerator_id'),
        accelerators=pulumi.get(__ret__, 'accelerators'),
        bandwidth_billing_type=pulumi.get(__ret__, 'bandwidth_billing_type'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        status=pulumi.get(__ret__, 'status'))
def get_basic_accelerators_output(accelerator_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  bandwidth_billing_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                  name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  page_number: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                  page_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                  status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBasicAcceleratorsResult]:
    """
    This data source provides the Global Accelerator (GA) Basic Accelerators of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.194.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ga.get_basic_accelerators(status="active")
    pulumi.export("gaBasicAcceleratorId1", default.accelerators[0].id)
    ```


    :param _builtins.str accelerator_id: The ID of the Global Accelerator Basic Accelerator instance.
    :param _builtins.str bandwidth_billing_type: The bandwidth billing method. Valid values:
           - `BandwidthPackage`: billed based on bandwidth plans.
           - `CDT`: billed through Cloud Data Transfer (CDT) and based on data transfer.
           - `CDT95`: billed through CDT and based on the 95th percentile bandwidth. This bandwidth billing method is available only for users that are included in the whitelist.
    :param Sequence[_builtins.str] ids: A list of Global Accelerator Basic Accelerator IDs.
    :param _builtins.str name_regex: A regex string to filter results by Global Accelerator Basic Accelerator name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the Global Accelerator Basic Accelerator instance. Valid Value: `init`, `active`, `configuring`, `binding`, `unbinding`, `deleting`, `finacialLocked`.
    """
    __args__ = dict()
    __args__['acceleratorId'] = accelerator_id
    __args__['bandwidthBillingType'] = bandwidth_billing_type
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ga/getBasicAccelerators:getBasicAccelerators', __args__, opts=opts, typ=GetBasicAcceleratorsResult)
    return __ret__.apply(lambda __response__: GetBasicAcceleratorsResult(
        accelerator_id=pulumi.get(__response__, 'accelerator_id'),
        accelerators=pulumi.get(__response__, 'accelerators'),
        bandwidth_billing_type=pulumi.get(__response__, 'bandwidth_billing_type'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        page_number=pulumi.get(__response__, 'page_number'),
        page_size=pulumi.get(__response__, 'page_size'),
        status=pulumi.get(__response__, 'status')))
