# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[_builtins.str] instance_id: The Id of instance that can run database.
        :param pulumi.Input[_builtins.str] connection_prefix: Prefix of an Internet connection string. It must be checked for uniqueness. It may consist of lowercase letters, numbers, and underlines, and must start with a letter and have no more than 30 characters. Default to <instance_id> + '-tf'.
        :param pulumi.Input[_builtins.str] port: Internet connection port. Valid value: [3200-3999]. Default to 3306.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if connection_prefix is not None:
            pulumi.set(__self__, "connection_prefix", connection_prefix)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Id of instance that can run database.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prefix of an Internet connection string. It must be checked for uniqueness. It may consist of lowercase letters, numbers, and underlines, and must start with a letter and have no more than 30 characters. Default to <instance_id> + '-tf'.
        """
        return pulumi.get(self, "connection_prefix")

    @connection_prefix.setter
    def connection_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_prefix", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internet connection port. Valid value: [3200-3999]. Default to 3306.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input[_builtins.str] connection_prefix: Prefix of an Internet connection string. It must be checked for uniqueness. It may consist of lowercase letters, numbers, and underlines, and must start with a letter and have no more than 30 characters. Default to <instance_id> + '-tf'.
        :param pulumi.Input[_builtins.str] connection_string: Connection instance string.
        :param pulumi.Input[_builtins.str] instance_id: The Id of instance that can run database.
        :param pulumi.Input[_builtins.str] ip_address: The ip address of connection string.
        :param pulumi.Input[_builtins.str] port: Internet connection port. Valid value: [3200-3999]. Default to 3306.
        """
        if connection_prefix is not None:
            pulumi.set(__self__, "connection_prefix", connection_prefix)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prefix of an Internet connection string. It must be checked for uniqueness. It may consist of lowercase letters, numbers, and underlines, and must start with a letter and have no more than 30 characters. Default to <instance_id> + '-tf'.
        """
        return pulumi.get(self, "connection_prefix")

    @connection_prefix.setter
    def connection_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_prefix", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Connection instance string.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of instance that can run database.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ip address of connection string.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internet connection port. Valid value: [3200-3999]. Default to 3306.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)


@pulumi.type_token("alicloud:gpdb/connection:Connection")
class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a connection resource to allocate an Internet connection string for instance.

        > **NOTE:** Available since v1.48.0.

        > **NOTE:** Each instance will allocate a intranet connection string automatically and its prefix is instance ID.
         To avoid unnecessary conflict, please specified a internet connection prefix before applying the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_zones = alicloud.gpdb.get_zones()
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default_get_zones.ids[0])
        default_instance = alicloud.gpdb.Instance("default",
            db_instance_category="HighAvailability",
            db_instance_class="gpdb.group.segsdx1",
            db_instance_mode="StorageElastic",
            description=name,
            engine="gpdb",
            engine_version="6.0",
            zone_id=default_get_zones.ids[0],
            instance_network_type="VPC",
            instance_spec="2C16G",
            payment_type="PayAsYouGo",
            seg_storage_type="cloud_essd",
            seg_node_num=4,
            storage_size=50,
            vpc_id=default_get_networks.ids[0],
            vswitch_id=default_get_switches.ids[0],
            ip_whitelists=[{
                "security_ip_list": "127.0.0.1",
            }])
        default_connection = alicloud.gpdb.Connection("default",
            instance_id=default_instance.id,
            connection_prefix="exampelcon")
        ```

        ## Import

        AnalyticDB for PostgreSQL's connection can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/connection:Connection example abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_prefix: Prefix of an Internet connection string. It must be checked for uniqueness. It may consist of lowercase letters, numbers, and underlines, and must start with a letter and have no more than 30 characters. Default to <instance_id> + '-tf'.
        :param pulumi.Input[_builtins.str] instance_id: The Id of instance that can run database.
        :param pulumi.Input[_builtins.str] port: Internet connection port. Valid value: [3200-3999]. Default to 3306.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a connection resource to allocate an Internet connection string for instance.

        > **NOTE:** Available since v1.48.0.

        > **NOTE:** Each instance will allocate a intranet connection string automatically and its prefix is instance ID.
         To avoid unnecessary conflict, please specified a internet connection prefix before applying the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_zones = alicloud.gpdb.get_zones()
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default_get_zones.ids[0])
        default_instance = alicloud.gpdb.Instance("default",
            db_instance_category="HighAvailability",
            db_instance_class="gpdb.group.segsdx1",
            db_instance_mode="StorageElastic",
            description=name,
            engine="gpdb",
            engine_version="6.0",
            zone_id=default_get_zones.ids[0],
            instance_network_type="VPC",
            instance_spec="2C16G",
            payment_type="PayAsYouGo",
            seg_storage_type="cloud_essd",
            seg_node_num=4,
            storage_size=50,
            vpc_id=default_get_networks.ids[0],
            vswitch_id=default_get_switches.ids[0],
            ip_whitelists=[{
                "security_ip_list": "127.0.0.1",
            }])
        default_connection = alicloud.gpdb.Connection("default",
            instance_id=default_instance.id,
            connection_prefix="exampelcon")
        ```

        ## Import

        AnalyticDB for PostgreSQL's connection can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/connection:Connection example abc12345678
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["connection_prefix"] = connection_prefix
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["port"] = port
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["ip_address"] = None
        super(Connection, __self__).__init__(
            'alicloud:gpdb/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.str]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_prefix: Prefix of an Internet connection string. It must be checked for uniqueness. It may consist of lowercase letters, numbers, and underlines, and must start with a letter and have no more than 30 characters. Default to <instance_id> + '-tf'.
        :param pulumi.Input[_builtins.str] connection_string: Connection instance string.
        :param pulumi.Input[_builtins.str] instance_id: The Id of instance that can run database.
        :param pulumi.Input[_builtins.str] ip_address: The ip address of connection string.
        :param pulumi.Input[_builtins.str] port: Internet connection port. Valid value: [3200-3999]. Default to 3306.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["connection_prefix"] = connection_prefix
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["port"] = port
        return Connection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionPrefix")
    def connection_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Prefix of an Internet connection string. It must be checked for uniqueness. It may consist of lowercase letters, numbers, and underlines, and must start with a letter and have no more than 30 characters. Default to <instance_id> + '-tf'.
        """
        return pulumi.get(self, "connection_prefix")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        Connection instance string.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of instance that can run database.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The ip address of connection string.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Internet connection port. Valid value: [3200-3999]. Default to 3306.
        """
        return pulumi.get(self, "port")

