# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ElasticInstanceArgs', 'ElasticInstance']

@pulumi.input_type
class ElasticInstanceArgs:
    def __init__(__self__, *,
                 engine: pulumi.Input[_builtins.str],
                 engine_version: pulumi.Input[_builtins.str],
                 instance_spec: pulumi.Input[_builtins.str],
                 seg_node_num: pulumi.Input[_builtins.int],
                 seg_storage_type: pulumi.Input[_builtins.str],
                 storage_size: pulumi.Input[_builtins.int],
                 vswitch_id: pulumi.Input[_builtins.str],
                 db_instance_category: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ElasticInstance resource.
        :param pulumi.Input[_builtins.str] engine: Database engine: `gpdb`.
        :param pulumi.Input[_builtins.str] engine_version: Database version. Valid value is `6.0`.
        :param pulumi.Input[_builtins.str] instance_spec: The specification of segment nodes. 
               * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
               * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
        :param pulumi.Input[_builtins.int] seg_node_num: The number of segment nodes. Minimum is `4`, max is `256`, step is `4`.
        :param pulumi.Input[_builtins.str] seg_storage_type: The disk type of segment nodes. Valid values: `cloud_essd`, `cloud_efficiency`.
        :param pulumi.Input[_builtins.int] storage_size: The storage capacity of per segment node. Unit: GB. Minimum is `50`, max is `4000`, step is `50`.
        :param pulumi.Input[_builtins.str] vswitch_id: The virtual switch ID to launch ADB PG instances in one VPC.
        :param pulumi.Input[_builtins.str] db_instance_category: The edition of the instance. Valid values: `Basic`, `HighAvailability`. Default value: `HighAvailability`.
        :param pulumi.Input[_builtins.str] db_instance_description: The description of ADB PG instance. It is a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.str] encryption_key: The ID of the encryption key. **Note:** If the `encryption_type` parameter is set to `CloudDisk`, you must specify this parameter to the encryption key that is in the same region as the disk that is specified by the EncryptionType parameter. Otherwise, leave this parameter empty.
        :param pulumi.Input[_builtins.str] encryption_type: The type of the encryption. Valid values: `CloudDisk`. **Note:** Disk encryption cannot be disabled after it is enabled.
        :param pulumi.Input[_builtins.str] instance_network_type: The network type of ADB PG instance. Only `VPC` supported now.
        :param pulumi.Input[_builtins.int] payment_duration: The subscription period. Valid values: [1~12]. It is valid when payment_type is `Subscription`.  
               **NOTE:** Will not take effect after modifying `payment_duration` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        :param pulumi.Input[_builtins.str] payment_duration_unit: The unit of the subscription period. Valid values: `Month`, `Year`. It is valid when payment_type is `Subscription`.  
               **NOTE:** Will not take effect after modifying `payment_duration_unit` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        :param pulumi.Input[_builtins.str] payment_type: Valid values are `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ip_lists: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the ADB PG instance. If specified, must be consistent with the zone where the vswitch is located.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "instance_spec", instance_spec)
        pulumi.set(__self__, "seg_node_num", seg_node_num)
        pulumi.set(__self__, "seg_storage_type", seg_storage_type)
        pulumi.set(__self__, "storage_size", storage_size)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if db_instance_category is not None:
            pulumi.set(__self__, "db_instance_category", db_instance_category)
        if db_instance_description is not None:
            pulumi.set(__self__, "db_instance_description", db_instance_description)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if instance_network_type is not None:
            pulumi.set(__self__, "instance_network_type", instance_network_type)
        if payment_duration is not None:
            pulumi.set(__self__, "payment_duration", payment_duration)
        if payment_duration_unit is not None:
            pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if security_ip_lists is not None:
            pulumi.set(__self__, "security_ip_lists", security_ip_lists)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Input[_builtins.str]:
        """
        Database engine: `gpdb`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[_builtins.str]:
        """
        Database version. Valid value is `6.0`.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="instanceSpec")
    def instance_spec(self) -> pulumi.Input[_builtins.str]:
        """
        The specification of segment nodes. 
        * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
        * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
        """
        return pulumi.get(self, "instance_spec")

    @instance_spec.setter
    def instance_spec(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_spec", value)

    @_builtins.property
    @pulumi.getter(name="segNodeNum")
    def seg_node_num(self) -> pulumi.Input[_builtins.int]:
        """
        The number of segment nodes. Minimum is `4`, max is `256`, step is `4`.
        """
        return pulumi.get(self, "seg_node_num")

    @seg_node_num.setter
    def seg_node_num(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "seg_node_num", value)

    @_builtins.property
    @pulumi.getter(name="segStorageType")
    def seg_storage_type(self) -> pulumi.Input[_builtins.str]:
        """
        The disk type of segment nodes. Valid values: `cloud_essd`, `cloud_efficiency`.
        """
        return pulumi.get(self, "seg_storage_type")

    @seg_storage_type.setter
    def seg_storage_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "seg_storage_type", value)

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> pulumi.Input[_builtins.int]:
        """
        The storage capacity of per segment node. Unit: GB. Minimum is `50`, max is `4000`, step is `50`.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "storage_size", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The virtual switch ID to launch ADB PG instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceCategory")
    def db_instance_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition of the instance. Valid values: `Basic`, `HighAvailability`. Default value: `HighAvailability`.
        """
        return pulumi.get(self, "db_instance_category")

    @db_instance_category.setter
    def db_instance_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_category", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of ADB PG instance. It is a string of 2 to 256 characters.
        """
        return pulumi.get(self, "db_instance_description")

    @db_instance_description.setter
    def db_instance_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_description", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the encryption key. **Note:** If the `encryption_type` parameter is set to `CloudDisk`, you must specify this parameter to the encryption key that is in the same region as the disk that is specified by the EncryptionType parameter. Otherwise, leave this parameter empty.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the encryption. Valid values: `CloudDisk`. **Note:** Disk encryption cannot be disabled after it is enabled.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceNetworkType")
    def instance_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of ADB PG instance. Only `VPC` supported now.
        """
        return pulumi.get(self, "instance_network_type")

    @instance_network_type.setter
    def instance_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_network_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The subscription period. Valid values: [1~12]. It is valid when payment_type is `Subscription`.  
        **NOTE:** Will not take effect after modifying `payment_duration` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        """
        return pulumi.get(self, "payment_duration")

    @payment_duration.setter
    def payment_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "payment_duration", value)

    @_builtins.property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of the subscription period. Valid values: `Month`, `Year`. It is valid when payment_type is `Subscription`.  
        **NOTE:** Will not take effect after modifying `payment_duration_unit` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        """
        return pulumi.get(self, "payment_duration_unit")

    @payment_duration_unit.setter
    def payment_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_duration_unit", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="securityIpLists")
    def security_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ip_lists")

    @security_ip_lists.setter
    def security_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_ip_lists", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone to launch the ADB PG instance. If specified, must be consistent with the zone where the vswitch is located.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ElasticInstanceState:
    def __init__(__self__, *,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_category: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 seg_node_num: Optional[pulumi.Input[_builtins.int]] = None,
                 seg_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ElasticInstance resources.
        :param pulumi.Input[_builtins.str] connection_string: ADB PG instance connection string.
        :param pulumi.Input[_builtins.str] db_instance_category: The edition of the instance. Valid values: `Basic`, `HighAvailability`. Default value: `HighAvailability`.
        :param pulumi.Input[_builtins.str] db_instance_description: The description of ADB PG instance. It is a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.str] encryption_key: The ID of the encryption key. **Note:** If the `encryption_type` parameter is set to `CloudDisk`, you must specify this parameter to the encryption key that is in the same region as the disk that is specified by the EncryptionType parameter. Otherwise, leave this parameter empty.
        :param pulumi.Input[_builtins.str] encryption_type: The type of the encryption. Valid values: `CloudDisk`. **Note:** Disk encryption cannot be disabled after it is enabled.
        :param pulumi.Input[_builtins.str] engine: Database engine: `gpdb`.
        :param pulumi.Input[_builtins.str] engine_version: Database version. Valid value is `6.0`.
        :param pulumi.Input[_builtins.str] instance_network_type: The network type of ADB PG instance. Only `VPC` supported now.
        :param pulumi.Input[_builtins.str] instance_spec: The specification of segment nodes. 
               * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
               * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
        :param pulumi.Input[_builtins.int] payment_duration: The subscription period. Valid values: [1~12]. It is valid when payment_type is `Subscription`.  
               **NOTE:** Will not take effect after modifying `payment_duration` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        :param pulumi.Input[_builtins.str] payment_duration_unit: The unit of the subscription period. Valid values: `Month`, `Year`. It is valid when payment_type is `Subscription`.  
               **NOTE:** Will not take effect after modifying `payment_duration_unit` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        :param pulumi.Input[_builtins.str] payment_type: Valid values are `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] port: (Available since v1.196.0) The connection port of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ip_lists: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[_builtins.int] seg_node_num: The number of segment nodes. Minimum is `4`, max is `256`, step is `4`.
        :param pulumi.Input[_builtins.str] seg_storage_type: The disk type of segment nodes. Valid values: `cloud_essd`, `cloud_efficiency`.
        :param pulumi.Input[_builtins.str] status: Instance status.
        :param pulumi.Input[_builtins.int] storage_size: The storage capacity of per segment node. Unit: GB. Minimum is `50`, max is `4000`, step is `50`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The virtual switch ID to launch ADB PG instances in one VPC.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the ADB PG instance. If specified, must be consistent with the zone where the vswitch is located.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if db_instance_category is not None:
            pulumi.set(__self__, "db_instance_category", db_instance_category)
        if db_instance_description is not None:
            pulumi.set(__self__, "db_instance_description", db_instance_description)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if instance_network_type is not None:
            pulumi.set(__self__, "instance_network_type", instance_network_type)
        if instance_spec is not None:
            pulumi.set(__self__, "instance_spec", instance_spec)
        if payment_duration is not None:
            pulumi.set(__self__, "payment_duration", payment_duration)
        if payment_duration_unit is not None:
            pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if security_ip_lists is not None:
            pulumi.set(__self__, "security_ip_lists", security_ip_lists)
        if seg_node_num is not None:
            pulumi.set(__self__, "seg_node_num", seg_node_num)
        if seg_storage_type is not None:
            pulumi.set(__self__, "seg_storage_type", seg_storage_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ADB PG instance connection string.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceCategory")
    def db_instance_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition of the instance. Valid values: `Basic`, `HighAvailability`. Default value: `HighAvailability`.
        """
        return pulumi.get(self, "db_instance_category")

    @db_instance_category.setter
    def db_instance_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_category", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of ADB PG instance. It is a string of 2 to 256 characters.
        """
        return pulumi.get(self, "db_instance_description")

    @db_instance_description.setter
    def db_instance_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_description", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the encryption key. **Note:** If the `encryption_type` parameter is set to `CloudDisk`, you must specify this parameter to the encryption key that is in the same region as the disk that is specified by the EncryptionType parameter. Otherwise, leave this parameter empty.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the encryption. Valid values: `CloudDisk`. **Note:** Disk encryption cannot be disabled after it is enabled.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database engine: `gpdb`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database version. Valid value is `6.0`.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="instanceNetworkType")
    def instance_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of ADB PG instance. Only `VPC` supported now.
        """
        return pulumi.get(self, "instance_network_type")

    @instance_network_type.setter
    def instance_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_network_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceSpec")
    def instance_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of segment nodes. 
        * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
        * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
        """
        return pulumi.get(self, "instance_spec")

    @instance_spec.setter
    def instance_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_spec", value)

    @_builtins.property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The subscription period. Valid values: [1~12]. It is valid when payment_type is `Subscription`.  
        **NOTE:** Will not take effect after modifying `payment_duration` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        """
        return pulumi.get(self, "payment_duration")

    @payment_duration.setter
    def payment_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "payment_duration", value)

    @_builtins.property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of the subscription period. Valid values: `Month`, `Year`. It is valid when payment_type is `Subscription`.  
        **NOTE:** Will not take effect after modifying `payment_duration_unit` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        """
        return pulumi.get(self, "payment_duration_unit")

    @payment_duration_unit.setter
    def payment_duration_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_duration_unit", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.196.0) The connection port of the instance.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="securityIpLists")
    def security_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ip_lists")

    @security_ip_lists.setter
    def security_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="segNodeNum")
    def seg_node_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of segment nodes. Minimum is `4`, max is `256`, step is `4`.
        """
        return pulumi.get(self, "seg_node_num")

    @seg_node_num.setter
    def seg_node_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "seg_node_num", value)

    @_builtins.property
    @pulumi.getter(name="segStorageType")
    def seg_storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The disk type of segment nodes. Valid values: `cloud_essd`, `cloud_efficiency`.
        """
        return pulumi.get(self, "seg_storage_type")

    @seg_storage_type.setter
    def seg_storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "seg_storage_type", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The storage capacity of per segment node. Unit: GB. Minimum is `50`, max is `4000`, step is `50`.
        """
        return pulumi.get(self, "storage_size")

    @storage_size.setter
    def storage_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_size", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The virtual switch ID to launch ADB PG instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone to launch the ADB PG instance. If specified, must be consistent with the zone where the vswitch is located.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:gpdb/elasticInstance:ElasticInstance")
class ElasticInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_instance_category: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 seg_node_num: Optional[pulumi.Input[_builtins.int]] = None,
                 seg_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a AnalyticDB for PostgreSQL instance resource which storage type is flexible. Compared to the reserved storage ADB PG instance, you can scale up each disk and smoothly scale out nodes online.\\
        For more detail product introduction, see [here](https://www.alibabacloud.com/help/doc-detail/141368.htm).

        > **NOTE:** Deprecated since v1.147.0.

        > **DEPRECATED:**  This resource  has been deprecated from version `1.147.0`. Please use new resource alicloud_gpdb_instance.

        ## Example Usage

        ### Create a AnalyticDB for PostgreSQL instance

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_zones(available_resource_creation="Gpdb")
        default_network = alicloud.vpc.Network("default",
            name="vpc-123456",
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            zone_id=default.zones[0].id,
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            vswitch_name="vpc-123456")
        adb_pg_instance = alicloud.gpdb.ElasticInstance("adb_pg_instance",
            engine="gpdb",
            engine_version="6.0",
            seg_storage_type="cloud_essd",
            seg_node_num=4,
            storage_size=50,
            instance_spec="2C16G",
            db_instance_description="Created by terraform",
            instance_network_type="VPC",
            payment_type="PayAsYouGo",
            vswitch_id=default_switch.id)
        ```

        ## Import

        AnalyticDB for PostgreSQL can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/elasticInstance:ElasticInstance adb_pg_instance gp-bpxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_instance_category: The edition of the instance. Valid values: `Basic`, `HighAvailability`. Default value: `HighAvailability`.
        :param pulumi.Input[_builtins.str] db_instance_description: The description of ADB PG instance. It is a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.str] encryption_key: The ID of the encryption key. **Note:** If the `encryption_type` parameter is set to `CloudDisk`, you must specify this parameter to the encryption key that is in the same region as the disk that is specified by the EncryptionType parameter. Otherwise, leave this parameter empty.
        :param pulumi.Input[_builtins.str] encryption_type: The type of the encryption. Valid values: `CloudDisk`. **Note:** Disk encryption cannot be disabled after it is enabled.
        :param pulumi.Input[_builtins.str] engine: Database engine: `gpdb`.
        :param pulumi.Input[_builtins.str] engine_version: Database version. Valid value is `6.0`.
        :param pulumi.Input[_builtins.str] instance_network_type: The network type of ADB PG instance. Only `VPC` supported now.
        :param pulumi.Input[_builtins.str] instance_spec: The specification of segment nodes. 
               * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
               * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
        :param pulumi.Input[_builtins.int] payment_duration: The subscription period. Valid values: [1~12]. It is valid when payment_type is `Subscription`.  
               **NOTE:** Will not take effect after modifying `payment_duration` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        :param pulumi.Input[_builtins.str] payment_duration_unit: The unit of the subscription period. Valid values: `Month`, `Year`. It is valid when payment_type is `Subscription`.  
               **NOTE:** Will not take effect after modifying `payment_duration_unit` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        :param pulumi.Input[_builtins.str] payment_type: Valid values are `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ip_lists: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[_builtins.int] seg_node_num: The number of segment nodes. Minimum is `4`, max is `256`, step is `4`.
        :param pulumi.Input[_builtins.str] seg_storage_type: The disk type of segment nodes. Valid values: `cloud_essd`, `cloud_efficiency`.
        :param pulumi.Input[_builtins.int] storage_size: The storage capacity of per segment node. Unit: GB. Minimum is `50`, max is `4000`, step is `50`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The virtual switch ID to launch ADB PG instances in one VPC.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the ADB PG instance. If specified, must be consistent with the zone where the vswitch is located.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElasticInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a AnalyticDB for PostgreSQL instance resource which storage type is flexible. Compared to the reserved storage ADB PG instance, you can scale up each disk and smoothly scale out nodes online.\\
        For more detail product introduction, see [here](https://www.alibabacloud.com/help/doc-detail/141368.htm).

        > **NOTE:** Deprecated since v1.147.0.

        > **DEPRECATED:**  This resource  has been deprecated from version `1.147.0`. Please use new resource alicloud_gpdb_instance.

        ## Example Usage

        ### Create a AnalyticDB for PostgreSQL instance

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_zones(available_resource_creation="Gpdb")
        default_network = alicloud.vpc.Network("default",
            name="vpc-123456",
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            zone_id=default.zones[0].id,
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            vswitch_name="vpc-123456")
        adb_pg_instance = alicloud.gpdb.ElasticInstance("adb_pg_instance",
            engine="gpdb",
            engine_version="6.0",
            seg_storage_type="cloud_essd",
            seg_node_num=4,
            storage_size=50,
            instance_spec="2C16G",
            db_instance_description="Created by terraform",
            instance_network_type="VPC",
            payment_type="PayAsYouGo",
            vswitch_id=default_switch.id)
        ```

        ## Import

        AnalyticDB for PostgreSQL can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:gpdb/elasticInstance:ElasticInstance adb_pg_instance gp-bpxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param ElasticInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElasticInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_instance_category: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 seg_node_num: Optional[pulumi.Input[_builtins.int]] = None,
                 seg_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElasticInstanceArgs.__new__(ElasticInstanceArgs)

            __props__.__dict__["db_instance_category"] = db_instance_category
            __props__.__dict__["db_instance_description"] = db_instance_description
            __props__.__dict__["encryption_key"] = encryption_key
            __props__.__dict__["encryption_type"] = encryption_type
            if engine is None and not opts.urn:
                raise TypeError("Missing required property 'engine'")
            __props__.__dict__["engine"] = engine
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["instance_network_type"] = instance_network_type
            if instance_spec is None and not opts.urn:
                raise TypeError("Missing required property 'instance_spec'")
            __props__.__dict__["instance_spec"] = instance_spec
            __props__.__dict__["payment_duration"] = payment_duration
            __props__.__dict__["payment_duration_unit"] = payment_duration_unit
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["security_ip_lists"] = security_ip_lists
            if seg_node_num is None and not opts.urn:
                raise TypeError("Missing required property 'seg_node_num'")
            __props__.__dict__["seg_node_num"] = seg_node_num
            if seg_storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'seg_storage_type'")
            __props__.__dict__["seg_storage_type"] = seg_storage_type
            if storage_size is None and not opts.urn:
                raise TypeError("Missing required property 'storage_size'")
            __props__.__dict__["storage_size"] = storage_size
            __props__.__dict__["tags"] = tags
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["status"] = None
        super(ElasticInstance, __self__).__init__(
            'alicloud:gpdb/elasticInstance:ElasticInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_category: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            instance_network_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_spec: Optional[pulumi.Input[_builtins.str]] = None,
            payment_duration: Optional[pulumi.Input[_builtins.int]] = None,
            payment_duration_unit: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.str]] = None,
            security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            seg_node_num: Optional[pulumi.Input[_builtins.int]] = None,
            seg_storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_size: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ElasticInstance':
        """
        Get an existing ElasticInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_string: ADB PG instance connection string.
        :param pulumi.Input[_builtins.str] db_instance_category: The edition of the instance. Valid values: `Basic`, `HighAvailability`. Default value: `HighAvailability`.
        :param pulumi.Input[_builtins.str] db_instance_description: The description of ADB PG instance. It is a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.str] encryption_key: The ID of the encryption key. **Note:** If the `encryption_type` parameter is set to `CloudDisk`, you must specify this parameter to the encryption key that is in the same region as the disk that is specified by the EncryptionType parameter. Otherwise, leave this parameter empty.
        :param pulumi.Input[_builtins.str] encryption_type: The type of the encryption. Valid values: `CloudDisk`. **Note:** Disk encryption cannot be disabled after it is enabled.
        :param pulumi.Input[_builtins.str] engine: Database engine: `gpdb`.
        :param pulumi.Input[_builtins.str] engine_version: Database version. Valid value is `6.0`.
        :param pulumi.Input[_builtins.str] instance_network_type: The network type of ADB PG instance. Only `VPC` supported now.
        :param pulumi.Input[_builtins.str] instance_spec: The specification of segment nodes. 
               * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
               * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
        :param pulumi.Input[_builtins.int] payment_duration: The subscription period. Valid values: [1~12]. It is valid when payment_type is `Subscription`.  
               **NOTE:** Will not take effect after modifying `payment_duration` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        :param pulumi.Input[_builtins.str] payment_duration_unit: The unit of the subscription period. Valid values: `Month`, `Year`. It is valid when payment_type is `Subscription`.  
               **NOTE:** Will not take effect after modifying `payment_duration_unit` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        :param pulumi.Input[_builtins.str] payment_type: Valid values are `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        :param pulumi.Input[_builtins.str] port: (Available since v1.196.0) The connection port of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_ip_lists: List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        :param pulumi.Input[_builtins.int] seg_node_num: The number of segment nodes. Minimum is `4`, max is `256`, step is `4`.
        :param pulumi.Input[_builtins.str] seg_storage_type: The disk type of segment nodes. Valid values: `cloud_essd`, `cloud_efficiency`.
        :param pulumi.Input[_builtins.str] status: Instance status.
        :param pulumi.Input[_builtins.int] storage_size: The storage capacity of per segment node. Unit: GB. Minimum is `50`, max is `4000`, step is `50`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The virtual switch ID to launch ADB PG instances in one VPC.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the ADB PG instance. If specified, must be consistent with the zone where the vswitch is located.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElasticInstanceState.__new__(_ElasticInstanceState)

        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["db_instance_category"] = db_instance_category
        __props__.__dict__["db_instance_description"] = db_instance_description
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["encryption_type"] = encryption_type
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["instance_network_type"] = instance_network_type
        __props__.__dict__["instance_spec"] = instance_spec
        __props__.__dict__["payment_duration"] = payment_duration
        __props__.__dict__["payment_duration_unit"] = payment_duration_unit
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["port"] = port
        __props__.__dict__["security_ip_lists"] = security_ip_lists
        __props__.__dict__["seg_node_num"] = seg_node_num
        __props__.__dict__["seg_storage_type"] = seg_storage_type
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_size"] = storage_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return ElasticInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        ADB PG instance connection string.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="dbInstanceCategory")
    def db_instance_category(self) -> pulumi.Output[_builtins.str]:
        """
        The edition of the instance. Valid values: `Basic`, `HighAvailability`. Default value: `HighAvailability`.
        """
        return pulumi.get(self, "db_instance_category")

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of ADB PG instance. It is a string of 2 to 256 characters.
        """
        return pulumi.get(self, "db_instance_description")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the encryption key. **Note:** If the `encryption_type` parameter is set to `CloudDisk`, you must specify this parameter to the encryption key that is in the same region as the disk that is specified by the EncryptionType parameter. Otherwise, leave this parameter empty.
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the encryption. Valid values: `CloudDisk`. **Note:** Disk encryption cannot be disabled after it is enabled.
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        Database engine: `gpdb`.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        Database version. Valid value is `6.0`.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="instanceNetworkType")
    def instance_network_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The network type of ADB PG instance. Only `VPC` supported now.
        """
        return pulumi.get(self, "instance_network_type")

    @_builtins.property
    @pulumi.getter(name="instanceSpec")
    def instance_spec(self) -> pulumi.Output[_builtins.str]:
        """
        The specification of segment nodes. 
        * When `db_instance_category` is `HighAvailability`, Valid values: `2C16G`, `4C32G`, `16C128G`.
        * When `db_instance_category` is `Basic`, Valid values: `2C8G`, `4C16G`, `8C32G`, `16C64G`.
        """
        return pulumi.get(self, "instance_spec")

    @_builtins.property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The subscription period. Valid values: [1~12]. It is valid when payment_type is `Subscription`.  
        **NOTE:** Will not take effect after modifying `payment_duration` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        """
        return pulumi.get(self, "payment_duration")

    @_builtins.property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unit of the subscription period. Valid values: `Month`, `Year`. It is valid when payment_type is `Subscription`.  
        **NOTE:** Will not take effect after modifying `payment_duration_unit` for now, if you want to renew a PayAsYouGo instance, need to do in on aliyun console.
        """
        return pulumi.get(self, "payment_duration_unit")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Valid values are `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.196.0) The connection port of the instance.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="securityIpLists")
    def security_ip_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of IP addresses allowed to access all databases of an instance. The list contains up to 1,000 IP addresses, separated by commas. Supported formats include 0.0.0.0/0, 10.23.12.24 (IP), and 10.23.12.24/24 (Classless Inter-Domain Routing (CIDR) mode. /24 represents the length of the prefix in an IP address. The range of the prefix length is [1,32]).
        """
        return pulumi.get(self, "security_ip_lists")

    @_builtins.property
    @pulumi.getter(name="segNodeNum")
    def seg_node_num(self) -> pulumi.Output[_builtins.int]:
        """
        The number of segment nodes. Minimum is `4`, max is `256`, step is `4`.
        """
        return pulumi.get(self, "seg_node_num")

    @_builtins.property
    @pulumi.getter(name="segStorageType")
    def seg_storage_type(self) -> pulumi.Output[_builtins.str]:
        """
        The disk type of segment nodes. Valid values: `cloud_essd`, `cloud_efficiency`.
        """
        return pulumi.get(self, "seg_storage_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Instance status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> pulumi.Output[_builtins.int]:
        """
        The storage capacity of per segment node. Unit: GB. Minimum is `50`, max is `4000`, step is `50`.
        """
        return pulumi.get(self, "storage_size")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The virtual switch ID to launch ADB PG instances in one VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Zone to launch the ADB PG instance. If specified, must be consistent with the zone where the vswitch is located.
        """
        return pulumi.get(self, "zone_id")

