# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccountsResult',
    'AwaitableGetAccountsResult',
    'get_accounts',
    'get_accounts_output',
]

@pulumi.output_type
class GetAccountsResult:
    """
    A collection of values returned by getAccounts.
    """
    def __init__(__self__, accounts=None, db_instance_id=None, id=None, ids=None, name_regex=None, names=None, output_file=None, status=None):
        if accounts and not isinstance(accounts, list):
            raise TypeError("Expected argument 'accounts' to be a list")
        pulumi.set(__self__, "accounts", accounts)
        if db_instance_id and not isinstance(db_instance_id, str):
            raise TypeError("Expected argument 'db_instance_id' to be a str")
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def accounts(self) -> Sequence['outputs.GetAccountsAccountResult']:
        return pulumi.get(self, "accounts")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> _builtins.str:
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")


class AwaitableGetAccountsResult(GetAccountsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountsResult(
            accounts=self.accounts,
            db_instance_id=self.db_instance_id,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            status=self.status)


def get_accounts(db_instance_id: Optional[_builtins.str] = None,
                 ids: Optional[Sequence[_builtins.str]] = None,
                 name_regex: Optional[_builtins.str] = None,
                 output_file: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountsResult:
    """
    This data source provides the Gpdb Accounts of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.142.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.gpdb.get_accounts(db_instance_id="example_value",
        ids=[
            "my-Account-1",
            "my-Account-2",
        ])
    pulumi.export("gpdbAccountId1", ids.accounts[0].id)
    name_regex = alicloud.gpdb.get_accounts(db_instance_id="example_value",
        name_regex="^my-Account")
    pulumi.export("gpdbAccountId2", name_regex.accounts[0].id)
    ```


    :param _builtins.str db_instance_id: The ID of the instance.
    :param Sequence[_builtins.str] ids: A list of Account IDs. Its element value is same as Account Name.
    :param _builtins.str name_regex: A regex string to filter results by Account name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the account. Valid values: `Active`, `Creating` and `Deleting`.
    """
    __args__ = dict()
    __args__['dbInstanceId'] = db_instance_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:gpdb/getAccounts:getAccounts', __args__, opts=opts, typ=GetAccountsResult).value

    return AwaitableGetAccountsResult(
        accounts=pulumi.get(__ret__, 'accounts'),
        db_instance_id=pulumi.get(__ret__, 'db_instance_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))
def get_accounts_output(db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                        name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountsResult]:
    """
    This data source provides the Gpdb Accounts of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.142.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.gpdb.get_accounts(db_instance_id="example_value",
        ids=[
            "my-Account-1",
            "my-Account-2",
        ])
    pulumi.export("gpdbAccountId1", ids.accounts[0].id)
    name_regex = alicloud.gpdb.get_accounts(db_instance_id="example_value",
        name_regex="^my-Account")
    pulumi.export("gpdbAccountId2", name_regex.accounts[0].id)
    ```


    :param _builtins.str db_instance_id: The ID of the instance.
    :param Sequence[_builtins.str] ids: A list of Account IDs. Its element value is same as Account Name.
    :param _builtins.str name_regex: A regex string to filter results by Account name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the account. Valid values: `Active`, `Creating` and `Deleting`.
    """
    __args__ = dict()
    __args__['dbInstanceId'] = db_instance_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:gpdb/getAccounts:getAccounts', __args__, opts=opts, typ=GetAccountsResult)
    return __ret__.apply(lambda __response__: GetAccountsResult(
        accounts=pulumi.get(__response__, 'accounts'),
        db_instance_id=pulumi.get(__response__, 'db_instance_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        status=pulumi.get(__response__, 'status')))
