# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEcsBackupPlansResult',
    'AwaitableGetEcsBackupPlansResult',
    'get_ecs_backup_plans',
    'get_ecs_backup_plans_output',
]

@pulumi.output_type
class GetEcsBackupPlansResult:
    """
    A collection of values returned by getEcsBackupPlans.
    """
    def __init__(__self__, id=None, ids=None, instance_id=None, name_regex=None, names=None, output_file=None, plans=None, vault_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if plans and not isinstance(plans, list):
            raise TypeError("Expected argument 'plans' to be a list")
        pulumi.set(__self__, "plans", plans)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def plans(self) -> Sequence['outputs.GetEcsBackupPlansPlanResult']:
        return pulumi.get(self, "plans")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "vault_id")


class AwaitableGetEcsBackupPlansResult(GetEcsBackupPlansResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEcsBackupPlansResult(
            id=self.id,
            ids=self.ids,
            instance_id=self.instance_id,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            plans=self.plans,
            vault_id=self.vault_id)


def get_ecs_backup_plans(ids: Optional[Sequence[_builtins.str]] = None,
                         instance_id: Optional[_builtins.str] = None,
                         name_regex: Optional[_builtins.str] = None,
                         output_file: Optional[_builtins.str] = None,
                         vault_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEcsBackupPlansResult:
    """
    This data source provides the Hbr EcsBackupPlans of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.132.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.hbr.get_ecs_backup_plans(name_regex="plan-name")
    pulumi.export("hbrEcsBackupPlanId", ids.plans[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of EcsBackupPlan IDs.
    :param _builtins.str instance_id: The ECS instance ID of the EcsBackupPlan used.
    :param _builtins.str name_regex: A regex string to filter results by EcsBackupPlan name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str vault_id: The Vault ID of the EcsBackupPlan used.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['vaultId'] = vault_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:hbr/getEcsBackupPlans:getEcsBackupPlans', __args__, opts=opts, typ=GetEcsBackupPlansResult).value

    return AwaitableGetEcsBackupPlansResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        plans=pulumi.get(__ret__, 'plans'),
        vault_id=pulumi.get(__ret__, 'vault_id'))
def get_ecs_backup_plans_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                vault_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEcsBackupPlansResult]:
    """
    This data source provides the Hbr EcsBackupPlans of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.132.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.hbr.get_ecs_backup_plans(name_regex="plan-name")
    pulumi.export("hbrEcsBackupPlanId", ids.plans[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of EcsBackupPlan IDs.
    :param _builtins.str instance_id: The ECS instance ID of the EcsBackupPlan used.
    :param _builtins.str name_regex: A regex string to filter results by EcsBackupPlan name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str vault_id: The Vault ID of the EcsBackupPlan used.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['vaultId'] = vault_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:hbr/getEcsBackupPlans:getEcsBackupPlans', __args__, opts=opts, typ=GetEcsBackupPlansResult)
    return __ret__.apply(lambda __response__: GetEcsBackupPlansResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        plans=pulumi.get(__response__, 'plans'),
        vault_id=pulumi.get(__response__, 'vault_id')))
