# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NasBackupPlanArgs', 'NasBackupPlan']

@pulumi.input_type
class NasBackupPlanArgs:
    def __init__(__self__, *,
                 backup_type: pulumi.Input[_builtins.str],
                 file_system_id: pulumi.Input[_builtins.str],
                 nas_backup_plan_name: pulumi.Input[_builtins.str],
                 paths: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 retention: pulumi.Input[_builtins.str],
                 schedule: pulumi.Input[_builtins.str],
                 vault_id: pulumi.Input[_builtins.str],
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NasBackupPlan resource.
        :param pulumi.Input[_builtins.str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[_builtins.str] file_system_id: The File System ID of Nas.
        :param pulumi.Input[_builtins.str] nas_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] paths: List of backup path. Up to 65536 characters. e.g.`["/home", "/var"]`. **Note** You should at least specify a backup path, empty array not allowed here.
        :param pulumi.Input[_builtins.str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[_builtins.str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               * `startTime` Backup start time, UNIX time seconds.
        :param pulumi.Input[_builtins.str] vault_id: The ID of Backup vault.
        :param pulumi.Input[_builtins.str] create_time: This field has been deprecated from provider version 1.153.0+. The creation time of NAS file system. **Note** The time format of the API adopts the ISO 8601, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
               
               > **Note** `hbr.NasBackupPlan` depends on the `nas.FileSystem` and creates a mount point on the file system. If this dependency has not declared, the file system may not be deleted correctly.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] options: This parameter specifies whether to use Windows VSS to define a backup path.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "nas_backup_plan_name", nas_backup_plan_name)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "vault_id", vault_id)
        if create_time is not None:
            warnings.warn("""Field 'create_time' has been deprecated from provider version 1.153.0.""", DeprecationWarning)
            pulumi.log.warn("""create_time is deprecated: Field 'create_time' has been deprecated from provider version 1.153.0.""")
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cross_account_role_name is not None:
            pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        if cross_account_type is not None:
            pulumi.set(__self__, "cross_account_type", cross_account_type)
        if cross_account_user_id is not None:
            pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Input[_builtins.str]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[_builtins.str]:
        """
        The File System ID of Nas.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="nasBackupPlanName")
    def nas_backup_plan_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "nas_backup_plan_name")

    @nas_backup_plan_name.setter
    def nas_backup_plan_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nas_backup_plan_name", value)

    @_builtins.property
    @pulumi.getter
    def paths(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of backup path. Up to 65536 characters. e.g.`["/home", "/var"]`. **Note** You should at least specify a backup path, empty array not allowed here.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "paths", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> pulumi.Input[_builtins.str]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Input[_builtins.str]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        * `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of Backup vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    @_utilities.deprecated("""Field 'create_time' has been deprecated from provider version 1.153.0.""")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field has been deprecated from provider version 1.153.0+. The creation time of NAS file system. **Note** The time format of the API adopts the ISO 8601, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.

        > **Note** `hbr.NasBackupPlan` depends on the `nas.FileSystem` and creates a mount point on the file system. If this dependency has not declared, the file system may not be deleted correctly.
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_role_name", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @cross_account_type.setter
    def cross_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cross_account_user_id", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter specifies whether to use Windows VSS to define a backup path.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class _NasBackupPlanState:
    def __init__(__self__, *,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nas_backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 retention: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NasBackupPlan resources.
        :param pulumi.Input[_builtins.str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[_builtins.str] create_time: This field has been deprecated from provider version 1.153.0+. The creation time of NAS file system. **Note** The time format of the API adopts the ISO 8601, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
               
               > **Note** `hbr.NasBackupPlan` depends on the `nas.FileSystem` and creates a mount point on the file system. If this dependency has not declared, the file system may not be deleted correctly.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] file_system_id: The File System ID of Nas.
        :param pulumi.Input[_builtins.str] nas_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[_builtins.str] options: This parameter specifies whether to use Windows VSS to define a backup path.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] paths: List of backup path. Up to 65536 characters. e.g.`["/home", "/var"]`. **Note** You should at least specify a backup path, empty array not allowed here.
        :param pulumi.Input[_builtins.str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[_builtins.str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               * `startTime` Backup start time, UNIX time seconds.
        :param pulumi.Input[_builtins.str] vault_id: The ID of Backup vault.
        """
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if create_time is not None:
            warnings.warn("""Field 'create_time' has been deprecated from provider version 1.153.0.""", DeprecationWarning)
            pulumi.log.warn("""create_time is deprecated: Field 'create_time' has been deprecated from provider version 1.153.0.""")
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cross_account_role_name is not None:
            pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        if cross_account_type is not None:
            pulumi.set(__self__, "cross_account_type", cross_account_type)
        if cross_account_user_id is not None:
            pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if nas_backup_plan_name is not None:
            pulumi.set(__self__, "nas_backup_plan_name", nas_backup_plan_name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    @_utilities.deprecated("""Field 'create_time' has been deprecated from provider version 1.153.0.""")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This field has been deprecated from provider version 1.153.0+. The creation time of NAS file system. **Note** The time format of the API adopts the ISO 8601, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.

        > **Note** `hbr.NasBackupPlan` depends on the `nas.FileSystem` and creates a mount point on the file system. If this dependency has not declared, the file system may not be deleted correctly.
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_role_name", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @cross_account_type.setter
    def cross_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_account_type", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cross_account_user_id", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The File System ID of Nas.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_id", value)

    @_builtins.property
    @pulumi.getter(name="nasBackupPlanName")
    def nas_backup_plan_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "nas_backup_plan_name")

    @nas_backup_plan_name.setter
    def nas_backup_plan_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nas_backup_plan_name", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This parameter specifies whether to use Windows VSS to define a backup path.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of backup path. Up to 65536 characters. e.g.`["/home", "/var"]`. **Note** You should at least specify a backup path, empty array not allowed here.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "paths", value)

    @_builtins.property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        * `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Backup vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("alicloud:hbr/nasBackupPlan:NasBackupPlan")
class NasBackupPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nas_backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 retention: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a HBR Nas Backup Plan resource.

        For information about HBR Nas Backup Plan and how to use it, see [What is Nas Backup Plan](https://www.alibabacloud.com/help/doc-detail/132248.htm).

        > **NOTE:** Available since v1.132.0.

        > **NOTE:** Deprecated since v1.249.0.

        > **DEPRECATED:** This resource has been deprecated from version `1.249.0`. Please use new resource hbr.Policy and alicloud_hbr_policy_binding.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_vault = alicloud.hbr.Vault("default", vault_name=f"terraform-example-{default['result']}")
        default_file_system = alicloud.nas.FileSystem("default",
            protocol_type="NFS",
            storage_type="Performance",
            description="terraform-example",
            encrypt_type=1)
        default_nas_backup_plan = alicloud.hbr.NasBackupPlan("default",
            nas_backup_plan_name="terraform-example",
            file_system_id=default_file_system.id,
            schedule="I|1602673264|PT2H",
            backup_type="COMPLETE",
            vault_id=default_vault.id,
            retention="2",
            paths=["/"])
        ```

        ## Import

        HBR Nas Backup Plan can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbr/nasBackupPlan:NasBackupPlan example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[_builtins.str] create_time: This field has been deprecated from provider version 1.153.0+. The creation time of NAS file system. **Note** The time format of the API adopts the ISO 8601, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
               
               > **Note** `hbr.NasBackupPlan` depends on the `nas.FileSystem` and creates a mount point on the file system. If this dependency has not declared, the file system may not be deleted correctly.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] file_system_id: The File System ID of Nas.
        :param pulumi.Input[_builtins.str] nas_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[_builtins.str] options: This parameter specifies whether to use Windows VSS to define a backup path.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] paths: List of backup path. Up to 65536 characters. e.g.`["/home", "/var"]`. **Note** You should at least specify a backup path, empty array not allowed here.
        :param pulumi.Input[_builtins.str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[_builtins.str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               * `startTime` Backup start time, UNIX time seconds.
        :param pulumi.Input[_builtins.str] vault_id: The ID of Backup vault.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NasBackupPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a HBR Nas Backup Plan resource.

        For information about HBR Nas Backup Plan and how to use it, see [What is Nas Backup Plan](https://www.alibabacloud.com/help/doc-detail/132248.htm).

        > **NOTE:** Available since v1.132.0.

        > **NOTE:** Deprecated since v1.249.0.

        > **DEPRECATED:** This resource has been deprecated from version `1.249.0`. Please use new resource hbr.Policy and alicloud_hbr_policy_binding.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_vault = alicloud.hbr.Vault("default", vault_name=f"terraform-example-{default['result']}")
        default_file_system = alicloud.nas.FileSystem("default",
            protocol_type="NFS",
            storage_type="Performance",
            description="terraform-example",
            encrypt_type=1)
        default_nas_backup_plan = alicloud.hbr.NasBackupPlan("default",
            nas_backup_plan_name="terraform-example",
            file_system_id=default_file_system.id,
            schedule="I|1602673264|PT2H",
            backup_type="COMPLETE",
            vault_id=default_vault.id,
            retention="2",
            paths=["/"])
        ```

        ## Import

        HBR Nas Backup Plan can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbr/nasBackupPlan:NasBackupPlan example <id>
        ```

        :param str resource_name: The name of the resource.
        :param NasBackupPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NasBackupPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 nas_backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[_builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 retention: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NasBackupPlanArgs.__new__(NasBackupPlanArgs)

            if backup_type is None and not opts.urn:
                raise TypeError("Missing required property 'backup_type'")
            __props__.__dict__["backup_type"] = backup_type
            __props__.__dict__["create_time"] = create_time
            __props__.__dict__["cross_account_role_name"] = cross_account_role_name
            __props__.__dict__["cross_account_type"] = cross_account_type
            __props__.__dict__["cross_account_user_id"] = cross_account_user_id
            __props__.__dict__["disabled"] = disabled
            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            if nas_backup_plan_name is None and not opts.urn:
                raise TypeError("Missing required property 'nas_backup_plan_name'")
            __props__.__dict__["nas_backup_plan_name"] = nas_backup_plan_name
            __props__.__dict__["options"] = options
            if paths is None and not opts.urn:
                raise TypeError("Missing required property 'paths'")
            __props__.__dict__["paths"] = paths
            if retention is None and not opts.urn:
                raise TypeError("Missing required property 'retention'")
            __props__.__dict__["retention"] = retention
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
        super(NasBackupPlan, __self__).__init__(
            'alicloud:hbr/nasBackupPlan:NasBackupPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_type: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_type: Optional[pulumi.Input[_builtins.str]] = None,
            cross_account_user_id: Optional[pulumi.Input[_builtins.int]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            file_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            nas_backup_plan_name: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[_builtins.str]] = None,
            paths: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            retention: Optional[pulumi.Input[_builtins.str]] = None,
            schedule: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NasBackupPlan':
        """
        Get an existing NasBackupPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[_builtins.str] create_time: This field has been deprecated from provider version 1.153.0+. The creation time of NAS file system. **Note** The time format of the API adopts the ISO 8601, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        :param pulumi.Input[_builtins.str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
               
               > **Note** `hbr.NasBackupPlan` depends on the `nas.FileSystem` and creates a mount point on the file system. If this dependency has not declared, the file system may not be deleted correctly.
        :param pulumi.Input[_builtins.str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[_builtins.int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[_builtins.bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] file_system_id: The File System ID of Nas.
        :param pulumi.Input[_builtins.str] nas_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[_builtins.str] options: This parameter specifies whether to use Windows VSS to define a backup path.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] paths: List of backup path. Up to 65536 characters. e.g.`["/home", "/var"]`. **Note** You should at least specify a backup path, empty array not allowed here.
        :param pulumi.Input[_builtins.str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[_builtins.str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
               * `startTime` Backup start time, UNIX time seconds.
        :param pulumi.Input[_builtins.str] vault_id: The ID of Backup vault.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NasBackupPlanState.__new__(_NasBackupPlanState)

        __props__.__dict__["backup_type"] = backup_type
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cross_account_role_name"] = cross_account_role_name
        __props__.__dict__["cross_account_type"] = cross_account_type
        __props__.__dict__["cross_account_user_id"] = cross_account_user_id
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["nas_backup_plan_name"] = nas_backup_plan_name
        __props__.__dict__["options"] = options
        __props__.__dict__["paths"] = paths
        __props__.__dict__["retention"] = retention
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["vault_id"] = vault_id
        return NasBackupPlan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Output[_builtins.str]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    @_utilities.deprecated("""Field 'create_time' has been deprecated from provider version 1.153.0.""")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        This field has been deprecated from provider version 1.153.0+. The creation time of NAS file system. **Note** The time format of the API adopts the ISO 8601, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.

        > **Note** `hbr.NasBackupPlan` depends on the `nas.FileSystem` and creates a mount point on the file system. If this dependency has not declared, the file system may not be deleted correctly.
        """
        return pulumi.get(self, "cross_account_role_name")

    @_builtins.property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @_builtins.property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The File System ID of Nas.
        """
        return pulumi.get(self, "file_system_id")

    @_builtins.property
    @pulumi.getter(name="nasBackupPlanName")
    def nas_backup_plan_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "nas_backup_plan_name")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This parameter specifies whether to use Windows VSS to define a backup path.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def paths(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of backup path. Up to 65536 characters. e.g.`["/home", "/var"]`. **Note** You should at least specify a backup path, empty array not allowed here.
        """
        return pulumi.get(self, "paths")

    @_builtins.property
    @pulumi.getter
    def retention(self) -> pulumi.Output[_builtins.str]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[_builtins.str]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        * `startTime` Backup start time, UNIX time seconds.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of Backup vault.
        """
        return pulumi.get(self, "vault_id")

