# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VaultArgs', 'Vault']

@pulumi.input_type
class VaultArgs:
    def __init__(__self__, *,
                 vault_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vault_storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_type: Optional[pulumi.Input[_builtins.str]] = None,
                 worm_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Vault resource.
        :param pulumi.Input[_builtins.str] vault_name: The name of Vault.
        :param pulumi.Input[_builtins.str] description: The description of Vault. Defaults to an empty string.
        :param pulumi.Input[_builtins.str] encrypt_type: Source Encryption Type，It is valid only when vault_type is `STANDARD` or `OTS_BACKUP`. Default value: `HBR_PRIVATE`. Valid values:
               - `HBR_PRIVATE`: HBR is fully hosted, uses the backup service's own encryption method.
               - `KMS`: Use Alibaba Cloud Kms to encryption.
        :param pulumi.Input[_builtins.str] kms_key_id: The key id or alias name of Alibaba Cloud Kms. It is required and valid only when encrypt_type is `KMS`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.str] vault_storage_class: The storage class of Vault. Valid values: `STANDARD`.
        :param pulumi.Input[_builtins.str] vault_type: The type of Vault. Valid values:
               - `STANDARD`: Standard backup vault.
               - `OTS_BACKUP`: Backup vault for Tablestore. **NOTE:** We recommend that you use `STANDARD`. The cloud backup product will upgrade the backup vault, and the `vault_type` will be changed from `OTS_BACKUP` to `STANDARD`.
        :param pulumi.Input[_builtins.bool] worm_enabled: Indicates whether the immutable backup feature is enabled. Valid values: `true`, `false`.
        """
        pulumi.set(__self__, "vault_name", vault_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypt_type is not None:
            pulumi.set(__self__, "encrypt_type", encrypt_type)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vault_storage_class is not None:
            pulumi.set(__self__, "vault_storage_class", vault_storage_class)
        if vault_type is not None:
            pulumi.set(__self__, "vault_type", vault_type)
        if worm_enabled is not None:
            pulumi.set(__self__, "worm_enabled", worm_enabled)

    @_builtins.property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of Vault.
        """
        return pulumi.get(self, "vault_name")

    @vault_name.setter
    def vault_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of Vault. Defaults to an empty string.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptType")
    def encrypt_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source Encryption Type，It is valid only when vault_type is `STANDARD` or `OTS_BACKUP`. Default value: `HBR_PRIVATE`. Valid values:
        - `HBR_PRIVATE`: HBR is fully hosted, uses the backup service's own encryption method.
        - `KMS`: Use Alibaba Cloud Kms to encryption.
        """
        return pulumi.get(self, "encrypt_type")

    @encrypt_type.setter
    def encrypt_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypt_type", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key id or alias name of Alibaba Cloud Kms. It is required and valid only when encrypt_type is `KMS`.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vaultStorageClass")
    def vault_storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage class of Vault. Valid values: `STANDARD`.
        """
        return pulumi.get(self, "vault_storage_class")

    @vault_storage_class.setter
    def vault_storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_storage_class", value)

    @_builtins.property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Vault. Valid values:
        - `STANDARD`: Standard backup vault.
        - `OTS_BACKUP`: Backup vault for Tablestore. **NOTE:** We recommend that you use `STANDARD`. The cloud backup product will upgrade the backup vault, and the `vault_type` will be changed from `OTS_BACKUP` to `STANDARD`.
        """
        return pulumi.get(self, "vault_type")

    @vault_type.setter
    def vault_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_type", value)

    @_builtins.property
    @pulumi.getter(name="wormEnabled")
    def worm_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the immutable backup feature is enabled. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "worm_enabled")

    @worm_enabled.setter
    def worm_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "worm_enabled", value)


@pulumi.input_type
class _VaultState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_type: Optional[pulumi.Input[_builtins.str]] = None,
                 worm_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Vault resources.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.243.0) The time when the backup vault was created.
        :param pulumi.Input[_builtins.str] description: The description of Vault. Defaults to an empty string.
        :param pulumi.Input[_builtins.str] encrypt_type: Source Encryption Type，It is valid only when vault_type is `STANDARD` or `OTS_BACKUP`. Default value: `HBR_PRIVATE`. Valid values:
               - `HBR_PRIVATE`: HBR is fully hosted, uses the backup service's own encryption method.
               - `KMS`: Use Alibaba Cloud Kms to encryption.
        :param pulumi.Input[_builtins.str] kms_key_id: The key id or alias name of Alibaba Cloud Kms. It is required and valid only when encrypt_type is `KMS`.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.243.0) The ID of the region in which the backup vault resides.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] status: The status of the Vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.str] vault_name: The name of Vault.
        :param pulumi.Input[_builtins.str] vault_storage_class: The storage class of Vault. Valid values: `STANDARD`.
        :param pulumi.Input[_builtins.str] vault_type: The type of Vault. Valid values:
               - `STANDARD`: Standard backup vault.
               - `OTS_BACKUP`: Backup vault for Tablestore. **NOTE:** We recommend that you use `STANDARD`. The cloud backup product will upgrade the backup vault, and the `vault_type` will be changed from `OTS_BACKUP` to `STANDARD`.
        :param pulumi.Input[_builtins.bool] worm_enabled: Indicates whether the immutable backup feature is enabled. Valid values: `true`, `false`.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypt_type is not None:
            pulumi.set(__self__, "encrypt_type", encrypt_type)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vault_name is not None:
            pulumi.set(__self__, "vault_name", vault_name)
        if vault_storage_class is not None:
            pulumi.set(__self__, "vault_storage_class", vault_storage_class)
        if vault_type is not None:
            pulumi.set(__self__, "vault_type", vault_type)
        if worm_enabled is not None:
            pulumi.set(__self__, "worm_enabled", worm_enabled)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.243.0) The time when the backup vault was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of Vault. Defaults to an empty string.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptType")
    def encrypt_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source Encryption Type，It is valid only when vault_type is `STANDARD` or `OTS_BACKUP`. Default value: `HBR_PRIVATE`. Valid values:
        - `HBR_PRIVATE`: HBR is fully hosted, uses the backup service's own encryption method.
        - `KMS`: Use Alibaba Cloud Kms to encryption.
        """
        return pulumi.get(self, "encrypt_type")

    @encrypt_type.setter
    def encrypt_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encrypt_type", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key id or alias name of Alibaba Cloud Kms. It is required and valid only when encrypt_type is `KMS`.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.243.0) The ID of the region in which the backup vault resides.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Vault.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of Vault.
        """
        return pulumi.get(self, "vault_name")

    @vault_name.setter
    def vault_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_name", value)

    @_builtins.property
    @pulumi.getter(name="vaultStorageClass")
    def vault_storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage class of Vault. Valid values: `STANDARD`.
        """
        return pulumi.get(self, "vault_storage_class")

    @vault_storage_class.setter
    def vault_storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_storage_class", value)

    @_builtins.property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Vault. Valid values:
        - `STANDARD`: Standard backup vault.
        - `OTS_BACKUP`: Backup vault for Tablestore. **NOTE:** We recommend that you use `STANDARD`. The cloud backup product will upgrade the backup vault, and the `vault_type` will be changed from `OTS_BACKUP` to `STANDARD`.
        """
        return pulumi.get(self, "vault_type")

    @vault_type.setter
    def vault_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_type", value)

    @_builtins.property
    @pulumi.getter(name="wormEnabled")
    def worm_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the immutable backup feature is enabled. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "worm_enabled")

    @worm_enabled.setter
    def worm_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "worm_enabled", value)


@pulumi.type_token("alicloud:hbr/vault:Vault")
class Vault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_type: Optional[pulumi.Input[_builtins.str]] = None,
                 worm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Hybrid Backup Recovery (HBR) Vault resource.

        Where backup or archived data is stored.

        For information about Hybrid Backup Recovery (HBR) Vault and how to use it, see [What is Vault](https://www.alibabacloud.com/help/en/hybrid-backup-recovery/latest/api-hbr-2017-09-08-createvault).

        > **NOTE:** Available since v1.129.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        example = alicloud.hbr.Vault("example", vault_name=f"example_value_{default['result']}")
        ```

        ## Import

        Hybrid Backup Recovery (HBR) Vault can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbr/vault:Vault example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of Vault. Defaults to an empty string.
        :param pulumi.Input[_builtins.str] encrypt_type: Source Encryption Type，It is valid only when vault_type is `STANDARD` or `OTS_BACKUP`. Default value: `HBR_PRIVATE`. Valid values:
               - `HBR_PRIVATE`: HBR is fully hosted, uses the backup service's own encryption method.
               - `KMS`: Use Alibaba Cloud Kms to encryption.
        :param pulumi.Input[_builtins.str] kms_key_id: The key id or alias name of Alibaba Cloud Kms. It is required and valid only when encrypt_type is `KMS`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.str] vault_name: The name of Vault.
        :param pulumi.Input[_builtins.str] vault_storage_class: The storage class of Vault. Valid values: `STANDARD`.
        :param pulumi.Input[_builtins.str] vault_type: The type of Vault. Valid values:
               - `STANDARD`: Standard backup vault.
               - `OTS_BACKUP`: Backup vault for Tablestore. **NOTE:** We recommend that you use `STANDARD`. The cloud backup product will upgrade the backup vault, and the `vault_type` will be changed from `OTS_BACKUP` to `STANDARD`.
        :param pulumi.Input[_builtins.bool] worm_enabled: Indicates whether the immutable backup feature is enabled. Valid values: `true`, `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Hybrid Backup Recovery (HBR) Vault resource.

        Where backup or archived data is stored.

        For information about Hybrid Backup Recovery (HBR) Vault and how to use it, see [What is Vault](https://www.alibabacloud.com/help/en/hybrid-backup-recovery/latest/api-hbr-2017-09-08-createvault).

        > **NOTE:** Available since v1.129.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            min=10000,
            max=99999)
        example = alicloud.hbr.Vault("example", vault_name=f"example_value_{default['result']}")
        ```

        ## Import

        Hybrid Backup Recovery (HBR) Vault can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:hbr/vault:Vault example <id>
        ```

        :param str resource_name: The name of the resource.
        :param VaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypt_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_type: Optional[pulumi.Input[_builtins.str]] = None,
                 worm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VaultArgs.__new__(VaultArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["encrypt_type"] = encrypt_type
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            if vault_name is None and not opts.urn:
                raise TypeError("Missing required property 'vault_name'")
            __props__.__dict__["vault_name"] = vault_name
            __props__.__dict__["vault_storage_class"] = vault_storage_class
            __props__.__dict__["vault_type"] = vault_type
            __props__.__dict__["worm_enabled"] = worm_enabled
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(Vault, __self__).__init__(
            'alicloud:hbr/vault:Vault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            encrypt_type: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vault_name: Optional[pulumi.Input[_builtins.str]] = None,
            vault_storage_class: Optional[pulumi.Input[_builtins.str]] = None,
            vault_type: Optional[pulumi.Input[_builtins.str]] = None,
            worm_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Vault':
        """
        Get an existing Vault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.243.0) The time when the backup vault was created.
        :param pulumi.Input[_builtins.str] description: The description of Vault. Defaults to an empty string.
        :param pulumi.Input[_builtins.str] encrypt_type: Source Encryption Type，It is valid only when vault_type is `STANDARD` or `OTS_BACKUP`. Default value: `HBR_PRIVATE`. Valid values:
               - `HBR_PRIVATE`: HBR is fully hosted, uses the backup service's own encryption method.
               - `KMS`: Use Alibaba Cloud Kms to encryption.
        :param pulumi.Input[_builtins.str] kms_key_id: The key id or alias name of Alibaba Cloud Kms. It is required and valid only when encrypt_type is `KMS`.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.243.0) The ID of the region in which the backup vault resides.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] status: The status of the Vault.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.str] vault_name: The name of Vault.
        :param pulumi.Input[_builtins.str] vault_storage_class: The storage class of Vault. Valid values: `STANDARD`.
        :param pulumi.Input[_builtins.str] vault_type: The type of Vault. Valid values:
               - `STANDARD`: Standard backup vault.
               - `OTS_BACKUP`: Backup vault for Tablestore. **NOTE:** We recommend that you use `STANDARD`. The cloud backup product will upgrade the backup vault, and the `vault_type` will be changed from `OTS_BACKUP` to `STANDARD`.
        :param pulumi.Input[_builtins.bool] worm_enabled: Indicates whether the immutable backup feature is enabled. Valid values: `true`, `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VaultState.__new__(_VaultState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["encrypt_type"] = encrypt_type
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vault_name"] = vault_name
        __props__.__dict__["vault_storage_class"] = vault_storage_class
        __props__.__dict__["vault_type"] = vault_type
        __props__.__dict__["worm_enabled"] = worm_enabled
        return Vault(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.243.0) The time when the backup vault was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of Vault. Defaults to an empty string.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="encryptType")
    def encrypt_type(self) -> pulumi.Output[_builtins.str]:
        """
        Source Encryption Type，It is valid only when vault_type is `STANDARD` or `OTS_BACKUP`. Default value: `HBR_PRIVATE`. Valid values:
        - `HBR_PRIVATE`: HBR is fully hosted, uses the backup service's own encryption method.
        - `KMS`: Use Alibaba Cloud Kms to encryption.
        """
        return pulumi.get(self, "encrypt_type")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key id or alias name of Alibaba Cloud Kms. It is required and valid only when encrypt_type is `KMS`.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.243.0) The ID of the region in which the backup vault resides.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Vault.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of Vault.
        """
        return pulumi.get(self, "vault_name")

    @_builtins.property
    @pulumi.getter(name="vaultStorageClass")
    def vault_storage_class(self) -> pulumi.Output[_builtins.str]:
        """
        The storage class of Vault. Valid values: `STANDARD`.
        """
        return pulumi.get(self, "vault_storage_class")

    @_builtins.property
    @pulumi.getter(name="vaultType")
    def vault_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of Vault. Valid values:
        - `STANDARD`: Standard backup vault.
        - `OTS_BACKUP`: Backup vault for Tablestore. **NOTE:** We recommend that you use `STANDARD`. The cloud backup product will upgrade the backup vault, and the `vault_type` will be changed from `OTS_BACKUP` to `STANDARD`.
        """
        return pulumi.get(self, "vault_type")

    @_builtins.property
    @pulumi.getter(name="wormEnabled")
    def worm_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the immutable backup feature is enabled. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "worm_enabled")

