# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[_builtins.str],
                 vswitch_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 zone_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 bind_vpcs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBindVpcArgs']]]] = None,
                 force_delete_without_backup: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_num: Optional[pulumi.Input[_builtins.int]] = None,
                 log: Optional[pulumi.Input[_builtins.str]] = None,
                 log_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 product_version: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_status: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_num: Optional[pulumi.Input[_builtins.int]] = None,
                 spec: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_num: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] vpc_id: Instance VPC id
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: Instance bind vswitches
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zone_ids: zone id
        :param pulumi.Input[Sequence[pulumi.Input['InstanceBindVpcArgs']]] bind_vpcs: Aucillary VPCs used to access this KMS instance See `bind_vpcs` below.
        :param pulumi.Input[_builtins.str] force_delete_without_backup: Whether to force deletion even without backup.
        :param pulumi.Input[_builtins.str] instance_name: The name of the resource
        :param pulumi.Input[_builtins.int] key_num: Maximum number of stored keys. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] log: Instance Audit Log Switch. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.int] log_storage: Instance log capacity. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] payment_type: Payment type,valid values:
               - `Subscription`: Prepaid.
               - `PayAsYouGo`: Postpaid.
        :param pulumi.Input[_builtins.int] period: Purchase cycle, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] product_version: KMS Instance commodity type (software/hardware)
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] renew_status: Renewal options. Valid values: `AutoRenewal`, `ManualRenewal`. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.int] secret_num: Maximum number of Secrets. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.int] spec: The computation performance level of the KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.int] vpc_num: The number of managed accesses. The maximum number of VPCs that can access this KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        pulumi.set(__self__, "zone_ids", zone_ids)
        if bind_vpcs is not None:
            pulumi.set(__self__, "bind_vpcs", bind_vpcs)
        if force_delete_without_backup is not None:
            pulumi.set(__self__, "force_delete_without_backup", force_delete_without_backup)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if key_num is not None:
            pulumi.set(__self__, "key_num", key_num)
        if log is not None:
            pulumi.set(__self__, "log", log)
        if log_storage is not None:
            pulumi.set(__self__, "log_storage", log_storage)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if product_version is not None:
            pulumi.set(__self__, "product_version", product_version)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renew_status is not None:
            pulumi.set(__self__, "renew_status", renew_status)
        if secret_num is not None:
            pulumi.set(__self__, "secret_num", secret_num)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if vpc_num is not None:
            pulumi.set(__self__, "vpc_num", vpc_num)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Instance VPC id
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Instance bind vswitches
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "vswitch_ids", value)

    @_builtins.property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        zone id
        """
        return pulumi.get(self, "zone_ids")

    @zone_ids.setter
    def zone_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "zone_ids", value)

    @_builtins.property
    @pulumi.getter(name="bindVpcs")
    def bind_vpcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBindVpcArgs']]]]:
        """
        Aucillary VPCs used to access this KMS instance See `bind_vpcs` below.
        """
        return pulumi.get(self, "bind_vpcs")

    @bind_vpcs.setter
    def bind_vpcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBindVpcArgs']]]]):
        pulumi.set(self, "bind_vpcs", value)

    @_builtins.property
    @pulumi.getter(name="forceDeleteWithoutBackup")
    def force_delete_without_backup(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to force deletion even without backup.
        """
        return pulumi.get(self, "force_delete_without_backup")

    @force_delete_without_backup.setter
    def force_delete_without_backup(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force_delete_without_backup", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="keyNum")
    def key_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of stored keys. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "key_num")

    @key_num.setter
    def key_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "key_num", value)

    @_builtins.property
    @pulumi.getter
    def log(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance Audit Log Switch. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "log")

    @log.setter
    def log(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log", value)

    @_builtins.property
    @pulumi.getter(name="logStorage")
    def log_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance log capacity. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "log_storage")

    @log_storage.setter
    def log_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_storage", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment type,valid values:
        - `Subscription`: Prepaid.
        - `PayAsYouGo`: Postpaid.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Purchase cycle, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="productVersion")
    def product_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        KMS Instance commodity type (software/hardware)
        """
        return pulumi.get(self, "product_version")

    @product_version.setter
    def product_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_version", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal period, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewStatus")
    def renew_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Renewal options. Valid values: `AutoRenewal`, `ManualRenewal`. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "renew_status")

    @renew_status.setter
    def renew_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renew_status", value)

    @_builtins.property
    @pulumi.getter(name="secretNum")
    def secret_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of Secrets. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "secret_num")

    @secret_num.setter
    def secret_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secret_num", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The computation performance level of the KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter(name="vpcNum")
    def vpc_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of managed accesses. The maximum number of VPCs that can access this KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "vpc_num")

    @vpc_num.setter
    def vpc_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpc_num", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 bind_vpcs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBindVpcArgs']]]] = None,
                 ca_certificate_chain_pem: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 end_date: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete_without_backup: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_num: Optional[pulumi.Input[_builtins.int]] = None,
                 log: Optional[pulumi.Input[_builtins.str]] = None,
                 log_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 product_version: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_status: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_num: Optional[pulumi.Input[_builtins.int]] = None,
                 spec: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_num: Optional[pulumi.Input[_builtins.int]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceBindVpcArgs']]] bind_vpcs: Aucillary VPCs used to access this KMS instance See `bind_vpcs` below.
        :param pulumi.Input[_builtins.str] ca_certificate_chain_pem: KMS instance certificate chain in PEM format.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] end_date: (Available since v1.233.1) Instance expiration time.
        :param pulumi.Input[_builtins.str] force_delete_without_backup: Whether to force deletion even without backup.
        :param pulumi.Input[_builtins.str] instance_name: The name of the resource
        :param pulumi.Input[_builtins.int] key_num: Maximum number of stored keys. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] log: Instance Audit Log Switch. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.int] log_storage: Instance log capacity. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] payment_type: Payment type,valid values:
               - `Subscription`: Prepaid.
               - `PayAsYouGo`: Postpaid.
        :param pulumi.Input[_builtins.int] period: Purchase cycle, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] product_version: KMS Instance commodity type (software/hardware)
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] renew_status: Renewal options. Valid values: `AutoRenewal`, `ManualRenewal`. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.int] secret_num: Maximum number of Secrets. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.int] spec: The computation performance level of the KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] status: Instance status.
        :param pulumi.Input[_builtins.str] vpc_id: Instance VPC id
        :param pulumi.Input[_builtins.int] vpc_num: The number of managed accesses. The maximum number of VPCs that can access this KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: Instance bind vswitches
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zone_ids: zone id
        """
        if bind_vpcs is not None:
            pulumi.set(__self__, "bind_vpcs", bind_vpcs)
        if ca_certificate_chain_pem is not None:
            pulumi.set(__self__, "ca_certificate_chain_pem", ca_certificate_chain_pem)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if force_delete_without_backup is not None:
            pulumi.set(__self__, "force_delete_without_backup", force_delete_without_backup)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if key_num is not None:
            pulumi.set(__self__, "key_num", key_num)
        if log is not None:
            pulumi.set(__self__, "log", log)
        if log_storage is not None:
            pulumi.set(__self__, "log_storage", log_storage)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if product_version is not None:
            pulumi.set(__self__, "product_version", product_version)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renew_status is not None:
            pulumi.set(__self__, "renew_status", renew_status)
        if secret_num is not None:
            pulumi.set(__self__, "secret_num", secret_num)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_num is not None:
            pulumi.set(__self__, "vpc_num", vpc_num)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if zone_ids is not None:
            pulumi.set(__self__, "zone_ids", zone_ids)

    @_builtins.property
    @pulumi.getter(name="bindVpcs")
    def bind_vpcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBindVpcArgs']]]]:
        """
        Aucillary VPCs used to access this KMS instance See `bind_vpcs` below.
        """
        return pulumi.get(self, "bind_vpcs")

    @bind_vpcs.setter
    def bind_vpcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBindVpcArgs']]]]):
        pulumi.set(self, "bind_vpcs", value)

    @_builtins.property
    @pulumi.getter(name="caCertificateChainPem")
    def ca_certificate_chain_pem(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        KMS instance certificate chain in PEM format.
        """
        return pulumi.get(self, "ca_certificate_chain_pem")

    @ca_certificate_chain_pem.setter
    def ca_certificate_chain_pem(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_certificate_chain_pem", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.233.1) Instance expiration time.
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_date", value)

    @_builtins.property
    @pulumi.getter(name="forceDeleteWithoutBackup")
    def force_delete_without_backup(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to force deletion even without backup.
        """
        return pulumi.get(self, "force_delete_without_backup")

    @force_delete_without_backup.setter
    def force_delete_without_backup(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force_delete_without_backup", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="keyNum")
    def key_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of stored keys. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "key_num")

    @key_num.setter
    def key_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "key_num", value)

    @_builtins.property
    @pulumi.getter
    def log(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance Audit Log Switch. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "log")

    @log.setter
    def log(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log", value)

    @_builtins.property
    @pulumi.getter(name="logStorage")
    def log_storage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Instance log capacity. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "log_storage")

    @log_storage.setter
    def log_storage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "log_storage", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Payment type,valid values:
        - `Subscription`: Prepaid.
        - `PayAsYouGo`: Postpaid.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Purchase cycle, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="productVersion")
    def product_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        KMS Instance commodity type (software/hardware)
        """
        return pulumi.get(self, "product_version")

    @product_version.setter
    def product_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_version", value)

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Automatic renewal period, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "renew_period", value)

    @_builtins.property
    @pulumi.getter(name="renewStatus")
    def renew_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Renewal options. Valid values: `AutoRenewal`, `ManualRenewal`. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "renew_status")

    @renew_status.setter
    def renew_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renew_status", value)

    @_builtins.property
    @pulumi.getter(name="secretNum")
    def secret_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of Secrets. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "secret_num")

    @secret_num.setter
    def secret_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secret_num", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The computation performance level of the KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance VPC id
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcNum")
    def vpc_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of managed accesses. The maximum number of VPCs that can access this KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "vpc_num")

    @vpc_num.setter
    def vpc_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vpc_num", value)

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Instance bind vswitches
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vswitch_ids", value)

    @_builtins.property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        zone id
        """
        return pulumi.get(self, "zone_ids")

    @zone_ids.setter
    def zone_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zone_ids", value)


@pulumi.type_token("alicloud:kms/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bind_vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBindVpcArgs', 'InstanceBindVpcArgsDict']]]]] = None,
                 force_delete_without_backup: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_num: Optional[pulumi.Input[_builtins.int]] = None,
                 log: Optional[pulumi.Input[_builtins.str]] = None,
                 log_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 product_version: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_status: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_num: Optional[pulumi.Input[_builtins.int]] = None,
                 spec: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_num: Optional[pulumi.Input[_builtins.int]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a KMS Instance resource.

        For information about KMS Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/zh/key-management-service/latest/kms-instance-management).

        > **NOTE:** Available since v1.210.0.

        ## Import

        KMS Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:kms/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceBindVpcArgs', 'InstanceBindVpcArgsDict']]]] bind_vpcs: Aucillary VPCs used to access this KMS instance See `bind_vpcs` below.
        :param pulumi.Input[_builtins.str] force_delete_without_backup: Whether to force deletion even without backup.
        :param pulumi.Input[_builtins.str] instance_name: The name of the resource
        :param pulumi.Input[_builtins.int] key_num: Maximum number of stored keys. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] log: Instance Audit Log Switch. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.int] log_storage: Instance log capacity. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] payment_type: Payment type,valid values:
               - `Subscription`: Prepaid.
               - `PayAsYouGo`: Postpaid.
        :param pulumi.Input[_builtins.int] period: Purchase cycle, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] product_version: KMS Instance commodity type (software/hardware)
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] renew_status: Renewal options. Valid values: `AutoRenewal`, `ManualRenewal`. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.int] secret_num: Maximum number of Secrets. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.int] spec: The computation performance level of the KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] vpc_id: Instance VPC id
        :param pulumi.Input[_builtins.int] vpc_num: The number of managed accesses. The maximum number of VPCs that can access this KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: Instance bind vswitches
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zone_ids: zone id
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a KMS Instance resource.

        For information about KMS Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/zh/key-management-service/latest/kms-instance-management).

        > **NOTE:** Available since v1.210.0.

        ## Import

        KMS Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:kms/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bind_vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBindVpcArgs', 'InstanceBindVpcArgsDict']]]]] = None,
                 force_delete_without_backup: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_num: Optional[pulumi.Input[_builtins.int]] = None,
                 log: Optional[pulumi.Input[_builtins.str]] = None,
                 log_storage: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 product_version: Optional[pulumi.Input[_builtins.str]] = None,
                 renew_period: Optional[pulumi.Input[_builtins.int]] = None,
                 renew_status: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_num: Optional[pulumi.Input[_builtins.int]] = None,
                 spec: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_num: Optional[pulumi.Input[_builtins.int]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["bind_vpcs"] = bind_vpcs
            __props__.__dict__["force_delete_without_backup"] = force_delete_without_backup
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["key_num"] = key_num
            __props__.__dict__["log"] = log
            __props__.__dict__["log_storage"] = log_storage
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["product_version"] = product_version
            __props__.__dict__["renew_period"] = renew_period
            __props__.__dict__["renew_status"] = renew_status
            __props__.__dict__["secret_num"] = secret_num
            __props__.__dict__["spec"] = spec
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vpc_num"] = vpc_num
            if vswitch_ids is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_ids'")
            __props__.__dict__["vswitch_ids"] = vswitch_ids
            if zone_ids is None and not opts.urn:
                raise TypeError("Missing required property 'zone_ids'")
            __props__.__dict__["zone_ids"] = zone_ids
            __props__.__dict__["ca_certificate_chain_pem"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["end_date"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'alicloud:kms/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bind_vpcs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBindVpcArgs', 'InstanceBindVpcArgsDict']]]]] = None,
            ca_certificate_chain_pem: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            end_date: Optional[pulumi.Input[_builtins.str]] = None,
            force_delete_without_backup: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            key_num: Optional[pulumi.Input[_builtins.int]] = None,
            log: Optional[pulumi.Input[_builtins.str]] = None,
            log_storage: Optional[pulumi.Input[_builtins.int]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            product_version: Optional[pulumi.Input[_builtins.str]] = None,
            renew_period: Optional[pulumi.Input[_builtins.int]] = None,
            renew_status: Optional[pulumi.Input[_builtins.str]] = None,
            secret_num: Optional[pulumi.Input[_builtins.int]] = None,
            spec: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_num: Optional[pulumi.Input[_builtins.int]] = None,
            vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceBindVpcArgs', 'InstanceBindVpcArgsDict']]]] bind_vpcs: Aucillary VPCs used to access this KMS instance See `bind_vpcs` below.
        :param pulumi.Input[_builtins.str] ca_certificate_chain_pem: KMS instance certificate chain in PEM format.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] end_date: (Available since v1.233.1) Instance expiration time.
        :param pulumi.Input[_builtins.str] force_delete_without_backup: Whether to force deletion even without backup.
        :param pulumi.Input[_builtins.str] instance_name: The name of the resource
        :param pulumi.Input[_builtins.int] key_num: Maximum number of stored keys. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] log: Instance Audit Log Switch. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.int] log_storage: Instance log capacity. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] payment_type: Payment type,valid values:
               - `Subscription`: Prepaid.
               - `PayAsYouGo`: Postpaid.
        :param pulumi.Input[_builtins.int] period: Purchase cycle, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] product_version: KMS Instance commodity type (software/hardware)
        :param pulumi.Input[_builtins.int] renew_period: Automatic renewal period, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] renew_status: Renewal options. Valid values: `AutoRenewal`, `ManualRenewal`. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.int] secret_num: Maximum number of Secrets. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.int] spec: The computation performance level of the KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[_builtins.str] status: Instance status.
        :param pulumi.Input[_builtins.str] vpc_id: Instance VPC id
        :param pulumi.Input[_builtins.int] vpc_num: The number of managed accesses. The maximum number of VPCs that can access this KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: Instance bind vswitches
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zone_ids: zone id
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["bind_vpcs"] = bind_vpcs
        __props__.__dict__["ca_certificate_chain_pem"] = ca_certificate_chain_pem
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["end_date"] = end_date
        __props__.__dict__["force_delete_without_backup"] = force_delete_without_backup
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["key_num"] = key_num
        __props__.__dict__["log"] = log
        __props__.__dict__["log_storage"] = log_storage
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["product_version"] = product_version
        __props__.__dict__["renew_period"] = renew_period
        __props__.__dict__["renew_status"] = renew_status
        __props__.__dict__["secret_num"] = secret_num
        __props__.__dict__["spec"] = spec
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_num"] = vpc_num
        __props__.__dict__["vswitch_ids"] = vswitch_ids
        __props__.__dict__["zone_ids"] = zone_ids
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bindVpcs")
    def bind_vpcs(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceBindVpc']]]:
        """
        Aucillary VPCs used to access this KMS instance See `bind_vpcs` below.
        """
        return pulumi.get(self, "bind_vpcs")

    @_builtins.property
    @pulumi.getter(name="caCertificateChainPem")
    def ca_certificate_chain_pem(self) -> pulumi.Output[_builtins.str]:
        """
        KMS instance certificate chain in PEM format.
        """
        return pulumi.get(self, "ca_certificate_chain_pem")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.233.1) Instance expiration time.
        """
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter(name="forceDeleteWithoutBackup")
    def force_delete_without_backup(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to force deletion even without backup.
        """
        return pulumi.get(self, "force_delete_without_backup")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="keyNum")
    def key_num(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum number of stored keys. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "key_num")

    @_builtins.property
    @pulumi.getter
    def log(self) -> pulumi.Output[_builtins.str]:
        """
        Instance Audit Log Switch. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "log")

    @_builtins.property
    @pulumi.getter(name="logStorage")
    def log_storage(self) -> pulumi.Output[_builtins.int]:
        """
        Instance log capacity. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "log_storage")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        Payment type,valid values:
        - `Subscription`: Prepaid.
        - `PayAsYouGo`: Postpaid.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Purchase cycle, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="productVersion")
    def product_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        KMS Instance commodity type (software/hardware)
        """
        return pulumi.get(self, "product_version")

    @_builtins.property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Automatic renewal period, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "renew_period")

    @_builtins.property
    @pulumi.getter(name="renewStatus")
    def renew_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Renewal options. Valid values: `AutoRenewal`, `ManualRenewal`. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "renew_status")

    @_builtins.property
    @pulumi.getter(name="secretNum")
    def secret_num(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum number of Secrets. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "secret_num")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The computation performance level of the KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Instance status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Instance VPC id
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcNum")
    def vpc_num(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of managed accesses. The maximum number of VPCs that can access this KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
        """
        return pulumi.get(self, "vpc_num")

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Instance bind vswitches
        """
        return pulumi.get(self, "vswitch_ids")

    @_builtins.property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        zone id
        """
        return pulumi.get(self, "zone_ids")

