# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StoreArgs', 'Store']

@pulumi.input_type
class StoreArgs:
    def __init__(__self__, *,
                 append_meta: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_split: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_web_tracking: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypt_conf: Optional[pulumi.Input['StoreEncryptConfArgs']] = None,
                 hot_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 infrequent_access_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 logstore_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_split_shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 metering_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 telemetry_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Store resource.
        :param pulumi.Input[_builtins.bool] append_meta: Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        :param pulumi.Input[_builtins.bool] auto_split: Determines whether to automatically split a shard. Default to `false`.
        :param pulumi.Input[_builtins.bool] enable_web_tracking: Whether open webtracking. webtracking network tracing, support the collection of HTML log, H5, Ios and android platforms.
        :param pulumi.Input['StoreEncryptConfArgs'] encrypt_conf: Encrypted storage of data, providing data static protection capability, encrypt_conf can be updated since 1.188.0 (only enable change is supported when updating logstore). See `encrypt_conf` below.
        :param pulumi.Input[_builtins.int] hot_ttl: The ttl of hot storage. Default to 30, at least 30, hot storage ttl must be less than ttl.
        :param pulumi.Input[_builtins.int] infrequent_access_ttl: Low frequency storage time
        :param pulumi.Input[_builtins.str] logstore_name: The log store, which is unique in the same project. You need to specify one of the attributes: `logstore_name`, `name`.
        :param pulumi.Input[_builtins.int] max_split_shard_count: The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        :param pulumi.Input[_builtins.str] metering_mode: Metering mode. The default metering mode of ChargeByFunction, ChargeByDataIngest traffic mode.
        :param pulumi.Input[_builtins.str] mode: The mode of storage. Default to `standard`, must be `standard` or `query`, `lite`.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.215.0. New field 'logstore_name' instead.
        :param pulumi.Input[_builtins.str] project: . Field 'project' has been deprecated from provider version 1.215.0. New field 'project_name' instead.
        :param pulumi.Input[_builtins.str] project_name: The project name to the log store belongs. You need to specify one of the attributes: `project_name`, `project`.
        :param pulumi.Input[_builtins.int] retention_period: The data retention time (in days). Valid values: [1-3650]. Default to 30. Log store data will be stored permanently when the value is 3650.
        :param pulumi.Input[_builtins.int] shard_count: The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/zh/sls/product-overview/shard).
        :param pulumi.Input[_builtins.str] telemetry_type: Determines whether store type is metric. `Metrics` means metric store, empty means log store.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if append_meta is not None:
            pulumi.set(__self__, "append_meta", append_meta)
        if auto_split is not None:
            pulumi.set(__self__, "auto_split", auto_split)
        if enable_web_tracking is not None:
            pulumi.set(__self__, "enable_web_tracking", enable_web_tracking)
        if encrypt_conf is not None:
            pulumi.set(__self__, "encrypt_conf", encrypt_conf)
        if hot_ttl is not None:
            pulumi.set(__self__, "hot_ttl", hot_ttl)
        if infrequent_access_ttl is not None:
            pulumi.set(__self__, "infrequent_access_ttl", infrequent_access_ttl)
        if logstore_name is not None:
            pulumi.set(__self__, "logstore_name", logstore_name)
        if max_split_shard_count is not None:
            pulumi.set(__self__, "max_split_shard_count", max_split_shard_count)
        if metering_mode is not None:
            pulumi.set(__self__, "metering_mode", metering_mode)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.215.0. New field 'logstore_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.215.0. New field 'logstore_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            warnings.warn("""Field 'project' has been deprecated since provider version 1.215.0. New field 'project_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""project is deprecated: Field 'project' has been deprecated since provider version 1.215.0. New field 'project_name' instead.""")
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if telemetry_type is not None:
            pulumi.set(__self__, "telemetry_type", telemetry_type)

    @_builtins.property
    @pulumi.getter(name="appendMeta")
    def append_meta(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        """
        return pulumi.get(self, "append_meta")

    @append_meta.setter
    def append_meta(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "append_meta", value)

    @_builtins.property
    @pulumi.getter(name="autoSplit")
    def auto_split(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines whether to automatically split a shard. Default to `false`.
        """
        return pulumi.get(self, "auto_split")

    @auto_split.setter
    def auto_split(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_split", value)

    @_builtins.property
    @pulumi.getter(name="enableWebTracking")
    def enable_web_tracking(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether open webtracking. webtracking network tracing, support the collection of HTML log, H5, Ios and android platforms.
        """
        return pulumi.get(self, "enable_web_tracking")

    @enable_web_tracking.setter
    def enable_web_tracking(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_web_tracking", value)

    @_builtins.property
    @pulumi.getter(name="encryptConf")
    def encrypt_conf(self) -> Optional[pulumi.Input['StoreEncryptConfArgs']]:
        """
        Encrypted storage of data, providing data static protection capability, encrypt_conf can be updated since 1.188.0 (only enable change is supported when updating logstore). See `encrypt_conf` below.
        """
        return pulumi.get(self, "encrypt_conf")

    @encrypt_conf.setter
    def encrypt_conf(self, value: Optional[pulumi.Input['StoreEncryptConfArgs']]):
        pulumi.set(self, "encrypt_conf", value)

    @_builtins.property
    @pulumi.getter(name="hotTtl")
    def hot_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ttl of hot storage. Default to 30, at least 30, hot storage ttl must be less than ttl.
        """
        return pulumi.get(self, "hot_ttl")

    @hot_ttl.setter
    def hot_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hot_ttl", value)

    @_builtins.property
    @pulumi.getter(name="infrequentAccessTtl")
    def infrequent_access_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Low frequency storage time
        """
        return pulumi.get(self, "infrequent_access_ttl")

    @infrequent_access_ttl.setter
    def infrequent_access_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "infrequent_access_ttl", value)

    @_builtins.property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The log store, which is unique in the same project. You need to specify one of the attributes: `logstore_name`, `name`.
        """
        return pulumi.get(self, "logstore_name")

    @logstore_name.setter
    def logstore_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logstore_name", value)

    @_builtins.property
    @pulumi.getter(name="maxSplitShardCount")
    def max_split_shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        """
        return pulumi.get(self, "max_split_shard_count")

    @max_split_shard_count.setter
    def max_split_shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_split_shard_count", value)

    @_builtins.property
    @pulumi.getter(name="meteringMode")
    def metering_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Metering mode. The default metering mode of ChargeByFunction, ChargeByDataIngest traffic mode.
        """
        return pulumi.get(self, "metering_mode")

    @metering_mode.setter
    def metering_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metering_mode", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode of storage. Default to `standard`, must be `standard` or `query`, `lite`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.215.0. New field 'logstore_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.215.0. New field 'logstore_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'project' has been deprecated since provider version 1.215.0. New field 'project_name' instead.""")
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'project' has been deprecated from provider version 1.215.0. New field 'project_name' instead.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project name to the log store belongs. You need to specify one of the attributes: `project_name`, `project`.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The data retention time (in days). Valid values: [1-3650]. Default to 30. Log store data will be stored permanently when the value is 3650.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_period", value)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/zh/sls/product-overview/shard).
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter(name="telemetryType")
    def telemetry_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines whether store type is metric. `Metrics` means metric store, empty means log store.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "telemetry_type")

    @telemetry_type.setter
    def telemetry_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "telemetry_type", value)


@pulumi.input_type
class _StoreState:
    def __init__(__self__, *,
                 append_meta: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_split: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_web_tracking: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypt_conf: Optional[pulumi.Input['StoreEncryptConfArgs']] = None,
                 hot_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 infrequent_access_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 logstore_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_split_shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 metering_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 shards: Optional[pulumi.Input[Sequence[pulumi.Input['StoreShardArgs']]]] = None,
                 telemetry_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Store resources.
        :param pulumi.Input[_builtins.bool] append_meta: Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        :param pulumi.Input[_builtins.bool] auto_split: Determines whether to automatically split a shard. Default to `false`.
        :param pulumi.Input[_builtins.int] create_time: Log library creation time. Unix timestamp format that represents the number of seconds from 1970-1-1 00:00:00 UTC calculation.
        :param pulumi.Input[_builtins.bool] enable_web_tracking: Whether open webtracking. webtracking network tracing, support the collection of HTML log, H5, Ios and android platforms.
        :param pulumi.Input['StoreEncryptConfArgs'] encrypt_conf: Encrypted storage of data, providing data static protection capability, encrypt_conf can be updated since 1.188.0 (only enable change is supported when updating logstore). See `encrypt_conf` below.
        :param pulumi.Input[_builtins.int] hot_ttl: The ttl of hot storage. Default to 30, at least 30, hot storage ttl must be less than ttl.
        :param pulumi.Input[_builtins.int] infrequent_access_ttl: Low frequency storage time
        :param pulumi.Input[_builtins.str] logstore_name: The log store, which is unique in the same project. You need to specify one of the attributes: `logstore_name`, `name`.
        :param pulumi.Input[_builtins.int] max_split_shard_count: The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        :param pulumi.Input[_builtins.str] metering_mode: Metering mode. The default metering mode of ChargeByFunction, ChargeByDataIngest traffic mode.
        :param pulumi.Input[_builtins.str] mode: The mode of storage. Default to `standard`, must be `standard` or `query`, `lite`.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.215.0. New field 'logstore_name' instead.
        :param pulumi.Input[_builtins.str] project: . Field 'project' has been deprecated from provider version 1.215.0. New field 'project_name' instead.
        :param pulumi.Input[_builtins.str] project_name: The project name to the log store belongs. You need to specify one of the attributes: `project_name`, `project`.
        :param pulumi.Input[_builtins.int] retention_period: The data retention time (in days). Valid values: [1-3650]. Default to 30. Log store data will be stored permanently when the value is 3650.
        :param pulumi.Input[_builtins.int] shard_count: The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/zh/sls/product-overview/shard).
        :param pulumi.Input[Sequence[pulumi.Input['StoreShardArgs']]] shards: The shard attribute.
        :param pulumi.Input[_builtins.str] telemetry_type: Determines whether store type is metric. `Metrics` means metric store, empty means log store.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if append_meta is not None:
            pulumi.set(__self__, "append_meta", append_meta)
        if auto_split is not None:
            pulumi.set(__self__, "auto_split", auto_split)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if enable_web_tracking is not None:
            pulumi.set(__self__, "enable_web_tracking", enable_web_tracking)
        if encrypt_conf is not None:
            pulumi.set(__self__, "encrypt_conf", encrypt_conf)
        if hot_ttl is not None:
            pulumi.set(__self__, "hot_ttl", hot_ttl)
        if infrequent_access_ttl is not None:
            pulumi.set(__self__, "infrequent_access_ttl", infrequent_access_ttl)
        if logstore_name is not None:
            pulumi.set(__self__, "logstore_name", logstore_name)
        if max_split_shard_count is not None:
            pulumi.set(__self__, "max_split_shard_count", max_split_shard_count)
        if metering_mode is not None:
            pulumi.set(__self__, "metering_mode", metering_mode)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.215.0. New field 'logstore_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.215.0. New field 'logstore_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            warnings.warn("""Field 'project' has been deprecated since provider version 1.215.0. New field 'project_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""project is deprecated: Field 'project' has been deprecated since provider version 1.215.0. New field 'project_name' instead.""")
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if shard_count is not None:
            pulumi.set(__self__, "shard_count", shard_count)
        if shards is not None:
            pulumi.set(__self__, "shards", shards)
        if telemetry_type is not None:
            pulumi.set(__self__, "telemetry_type", telemetry_type)

    @_builtins.property
    @pulumi.getter(name="appendMeta")
    def append_meta(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        """
        return pulumi.get(self, "append_meta")

    @append_meta.setter
    def append_meta(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "append_meta", value)

    @_builtins.property
    @pulumi.getter(name="autoSplit")
    def auto_split(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines whether to automatically split a shard. Default to `false`.
        """
        return pulumi.get(self, "auto_split")

    @auto_split.setter
    def auto_split(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_split", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Log library creation time. Unix timestamp format that represents the number of seconds from 1970-1-1 00:00:00 UTC calculation.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="enableWebTracking")
    def enable_web_tracking(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether open webtracking. webtracking network tracing, support the collection of HTML log, H5, Ios and android platforms.
        """
        return pulumi.get(self, "enable_web_tracking")

    @enable_web_tracking.setter
    def enable_web_tracking(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_web_tracking", value)

    @_builtins.property
    @pulumi.getter(name="encryptConf")
    def encrypt_conf(self) -> Optional[pulumi.Input['StoreEncryptConfArgs']]:
        """
        Encrypted storage of data, providing data static protection capability, encrypt_conf can be updated since 1.188.0 (only enable change is supported when updating logstore). See `encrypt_conf` below.
        """
        return pulumi.get(self, "encrypt_conf")

    @encrypt_conf.setter
    def encrypt_conf(self, value: Optional[pulumi.Input['StoreEncryptConfArgs']]):
        pulumi.set(self, "encrypt_conf", value)

    @_builtins.property
    @pulumi.getter(name="hotTtl")
    def hot_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ttl of hot storage. Default to 30, at least 30, hot storage ttl must be less than ttl.
        """
        return pulumi.get(self, "hot_ttl")

    @hot_ttl.setter
    def hot_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hot_ttl", value)

    @_builtins.property
    @pulumi.getter(name="infrequentAccessTtl")
    def infrequent_access_ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Low frequency storage time
        """
        return pulumi.get(self, "infrequent_access_ttl")

    @infrequent_access_ttl.setter
    def infrequent_access_ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "infrequent_access_ttl", value)

    @_builtins.property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The log store, which is unique in the same project. You need to specify one of the attributes: `logstore_name`, `name`.
        """
        return pulumi.get(self, "logstore_name")

    @logstore_name.setter
    def logstore_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logstore_name", value)

    @_builtins.property
    @pulumi.getter(name="maxSplitShardCount")
    def max_split_shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        """
        return pulumi.get(self, "max_split_shard_count")

    @max_split_shard_count.setter
    def max_split_shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_split_shard_count", value)

    @_builtins.property
    @pulumi.getter(name="meteringMode")
    def metering_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Metering mode. The default metering mode of ChargeByFunction, ChargeByDataIngest traffic mode.
        """
        return pulumi.get(self, "metering_mode")

    @metering_mode.setter
    def metering_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metering_mode", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode of storage. Default to `standard`, must be `standard` or `query`, `lite`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.215.0. New field 'logstore_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.215.0. New field 'logstore_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'project' has been deprecated since provider version 1.215.0. New field 'project_name' instead.""")
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'project' has been deprecated from provider version 1.215.0. New field 'project_name' instead.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project name to the log store belongs. You need to specify one of the attributes: `project_name`, `project`.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The data retention time (in days). Valid values: [1-3650]. Default to 30. Log store data will be stored permanently when the value is 3650.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_period", value)

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/zh/sls/product-overview/shard).
        """
        return pulumi.get(self, "shard_count")

    @shard_count.setter
    def shard_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "shard_count", value)

    @_builtins.property
    @pulumi.getter
    def shards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StoreShardArgs']]]]:
        """
        The shard attribute.
        """
        return pulumi.get(self, "shards")

    @shards.setter
    def shards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StoreShardArgs']]]]):
        pulumi.set(self, "shards", value)

    @_builtins.property
    @pulumi.getter(name="telemetryType")
    def telemetry_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines whether store type is metric. `Metrics` means metric store, empty means log store.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "telemetry_type")

    @telemetry_type.setter
    def telemetry_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "telemetry_type", value)


@pulumi.type_token("alicloud:log/store:Store")
class Store(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 append_meta: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_split: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_web_tracking: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypt_conf: Optional[pulumi.Input[Union['StoreEncryptConfArgs', 'StoreEncryptConfArgsDict']]] = None,
                 hot_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 infrequent_access_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 logstore_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_split_shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 metering_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 telemetry_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a SLS Log Store resource.

        For information about SLS Log Store and how to use it, see [What is Log Store](https://www.alibabacloud.com/help/doc-detail/48874.htm).

        > **NOTE:** Available since v1.0.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        example = alicloud.log.Project("example",
            name=f"terraform-example-{default['result']}",
            description="terraform-example")
        example_store = alicloud.log.Store("example",
            project=example.name,
            name="example-store",
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        ```

        Encrypt Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        # The region of kms key.
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        example = alicloud.get_account()
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default.ids[0])
        default_instance = alicloud.kms.Instance("default",
            product_version="3",
            vpc_id=default.ids[0],
            zone_ids=[
                default_get_switches.vswitches[0].zone_id,
                default_get_switches.vswitches[1].zone_id,
            ],
            vswitch_ids=[default_get_switches.ids[0]],
            vpc_num=1,
            key_num=1000,
            secret_num=0,
            spec=1000,
            force_delete_without_backup="true",
            payment_type="PayAsYouGo")
        example_key = alicloud.kms.Key("example",
            description="terraform-example",
            pending_window_in_days=7,
            status="Enabled",
            dkms_instance_id=default_instance.id)
        example_project = alicloud.log.Project("example",
            project_name=f"terraform-example-{default_integer['result']}",
            description="terraform-example")
        example_store = alicloud.log.Store("example",
            project_name=example_project.project_name,
            logstore_name="example-store",
            shard_count=1,
            auto_split=True,
            max_split_shard_count=60,
            encrypt_conf={
                "enable": True,
                "encrypt_type": "default",
                "user_cmk_info": {
                    "cmk_key_id": example_key.id,
                    "arn": f"acs:ram::{example.id}:role/aliyunlogdefaultrole",
                    "region_id": region,
                },
            })
        ```

        ## Module Support

        You can use the existing sls module
        to create SLS project, store and store index one-click, like ECS instances.

        ## Import

        SLS Log Store can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:log/store:Store example <project_name>:<logstore_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] append_meta: Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        :param pulumi.Input[_builtins.bool] auto_split: Determines whether to automatically split a shard. Default to `false`.
        :param pulumi.Input[_builtins.bool] enable_web_tracking: Whether open webtracking. webtracking network tracing, support the collection of HTML log, H5, Ios and android platforms.
        :param pulumi.Input[Union['StoreEncryptConfArgs', 'StoreEncryptConfArgsDict']] encrypt_conf: Encrypted storage of data, providing data static protection capability, encrypt_conf can be updated since 1.188.0 (only enable change is supported when updating logstore). See `encrypt_conf` below.
        :param pulumi.Input[_builtins.int] hot_ttl: The ttl of hot storage. Default to 30, at least 30, hot storage ttl must be less than ttl.
        :param pulumi.Input[_builtins.int] infrequent_access_ttl: Low frequency storage time
        :param pulumi.Input[_builtins.str] logstore_name: The log store, which is unique in the same project. You need to specify one of the attributes: `logstore_name`, `name`.
        :param pulumi.Input[_builtins.int] max_split_shard_count: The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        :param pulumi.Input[_builtins.str] metering_mode: Metering mode. The default metering mode of ChargeByFunction, ChargeByDataIngest traffic mode.
        :param pulumi.Input[_builtins.str] mode: The mode of storage. Default to `standard`, must be `standard` or `query`, `lite`.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.215.0. New field 'logstore_name' instead.
        :param pulumi.Input[_builtins.str] project: . Field 'project' has been deprecated from provider version 1.215.0. New field 'project_name' instead.
        :param pulumi.Input[_builtins.str] project_name: The project name to the log store belongs. You need to specify one of the attributes: `project_name`, `project`.
        :param pulumi.Input[_builtins.int] retention_period: The data retention time (in days). Valid values: [1-3650]. Default to 30. Log store data will be stored permanently when the value is 3650.
        :param pulumi.Input[_builtins.int] shard_count: The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/zh/sls/product-overview/shard).
        :param pulumi.Input[_builtins.str] telemetry_type: Determines whether store type is metric. `Metrics` means metric store, empty means log store.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[StoreArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SLS Log Store resource.

        For information about SLS Log Store and how to use it, see [What is Log Store](https://www.alibabacloud.com/help/doc-detail/48874.htm).

        > **NOTE:** Available since v1.0.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default = random.index.Integer("default",
            max=99999,
            min=10000)
        example = alicloud.log.Project("example",
            name=f"terraform-example-{default['result']}",
            description="terraform-example")
        example_store = alicloud.log.Store("example",
            project=example.name,
            name="example-store",
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        ```

        Encrypt Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        # The region of kms key.
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        example = alicloud.get_account()
        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default.ids[0])
        default_instance = alicloud.kms.Instance("default",
            product_version="3",
            vpc_id=default.ids[0],
            zone_ids=[
                default_get_switches.vswitches[0].zone_id,
                default_get_switches.vswitches[1].zone_id,
            ],
            vswitch_ids=[default_get_switches.ids[0]],
            vpc_num=1,
            key_num=1000,
            secret_num=0,
            spec=1000,
            force_delete_without_backup="true",
            payment_type="PayAsYouGo")
        example_key = alicloud.kms.Key("example",
            description="terraform-example",
            pending_window_in_days=7,
            status="Enabled",
            dkms_instance_id=default_instance.id)
        example_project = alicloud.log.Project("example",
            project_name=f"terraform-example-{default_integer['result']}",
            description="terraform-example")
        example_store = alicloud.log.Store("example",
            project_name=example_project.project_name,
            logstore_name="example-store",
            shard_count=1,
            auto_split=True,
            max_split_shard_count=60,
            encrypt_conf={
                "enable": True,
                "encrypt_type": "default",
                "user_cmk_info": {
                    "cmk_key_id": example_key.id,
                    "arn": f"acs:ram::{example.id}:role/aliyunlogdefaultrole",
                    "region_id": region,
                },
            })
        ```

        ## Module Support

        You can use the existing sls module
        to create SLS project, store and store index one-click, like ECS instances.

        ## Import

        SLS Log Store can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:log/store:Store example <project_name>:<logstore_name>
        ```

        :param str resource_name: The name of the resource.
        :param StoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 append_meta: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_split: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_web_tracking: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypt_conf: Optional[pulumi.Input[Union['StoreEncryptConfArgs', 'StoreEncryptConfArgsDict']]] = None,
                 hot_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 infrequent_access_ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 logstore_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_split_shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 metering_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 shard_count: Optional[pulumi.Input[_builtins.int]] = None,
                 telemetry_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StoreArgs.__new__(StoreArgs)

            __props__.__dict__["append_meta"] = append_meta
            __props__.__dict__["auto_split"] = auto_split
            __props__.__dict__["enable_web_tracking"] = enable_web_tracking
            __props__.__dict__["encrypt_conf"] = encrypt_conf
            __props__.__dict__["hot_ttl"] = hot_ttl
            __props__.__dict__["infrequent_access_ttl"] = infrequent_access_ttl
            __props__.__dict__["logstore_name"] = logstore_name
            __props__.__dict__["max_split_shard_count"] = max_split_shard_count
            __props__.__dict__["metering_mode"] = metering_mode
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["retention_period"] = retention_period
            __props__.__dict__["shard_count"] = shard_count
            __props__.__dict__["telemetry_type"] = telemetry_type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["shards"] = None
        super(Store, __self__).__init__(
            'alicloud:log/store:Store',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            append_meta: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_split: Optional[pulumi.Input[_builtins.bool]] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            enable_web_tracking: Optional[pulumi.Input[_builtins.bool]] = None,
            encrypt_conf: Optional[pulumi.Input[Union['StoreEncryptConfArgs', 'StoreEncryptConfArgsDict']]] = None,
            hot_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            infrequent_access_ttl: Optional[pulumi.Input[_builtins.int]] = None,
            logstore_name: Optional[pulumi.Input[_builtins.str]] = None,
            max_split_shard_count: Optional[pulumi.Input[_builtins.int]] = None,
            metering_mode: Optional[pulumi.Input[_builtins.str]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            project_name: Optional[pulumi.Input[_builtins.str]] = None,
            retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            shard_count: Optional[pulumi.Input[_builtins.int]] = None,
            shards: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StoreShardArgs', 'StoreShardArgsDict']]]]] = None,
            telemetry_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Store':
        """
        Get an existing Store resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] append_meta: Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        :param pulumi.Input[_builtins.bool] auto_split: Determines whether to automatically split a shard. Default to `false`.
        :param pulumi.Input[_builtins.int] create_time: Log library creation time. Unix timestamp format that represents the number of seconds from 1970-1-1 00:00:00 UTC calculation.
        :param pulumi.Input[_builtins.bool] enable_web_tracking: Whether open webtracking. webtracking network tracing, support the collection of HTML log, H5, Ios and android platforms.
        :param pulumi.Input[Union['StoreEncryptConfArgs', 'StoreEncryptConfArgsDict']] encrypt_conf: Encrypted storage of data, providing data static protection capability, encrypt_conf can be updated since 1.188.0 (only enable change is supported when updating logstore). See `encrypt_conf` below.
        :param pulumi.Input[_builtins.int] hot_ttl: The ttl of hot storage. Default to 30, at least 30, hot storage ttl must be less than ttl.
        :param pulumi.Input[_builtins.int] infrequent_access_ttl: Low frequency storage time
        :param pulumi.Input[_builtins.str] logstore_name: The log store, which is unique in the same project. You need to specify one of the attributes: `logstore_name`, `name`.
        :param pulumi.Input[_builtins.int] max_split_shard_count: The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        :param pulumi.Input[_builtins.str] metering_mode: Metering mode. The default metering mode of ChargeByFunction, ChargeByDataIngest traffic mode.
        :param pulumi.Input[_builtins.str] mode: The mode of storage. Default to `standard`, must be `standard` or `query`, `lite`.
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.215.0. New field 'logstore_name' instead.
        :param pulumi.Input[_builtins.str] project: . Field 'project' has been deprecated from provider version 1.215.0. New field 'project_name' instead.
        :param pulumi.Input[_builtins.str] project_name: The project name to the log store belongs. You need to specify one of the attributes: `project_name`, `project`.
        :param pulumi.Input[_builtins.int] retention_period: The data retention time (in days). Valid values: [1-3650]. Default to 30. Log store data will be stored permanently when the value is 3650.
        :param pulumi.Input[_builtins.int] shard_count: The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/zh/sls/product-overview/shard).
        :param pulumi.Input[Sequence[pulumi.Input[Union['StoreShardArgs', 'StoreShardArgsDict']]]] shards: The shard attribute.
        :param pulumi.Input[_builtins.str] telemetry_type: Determines whether store type is metric. `Metrics` means metric store, empty means log store.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StoreState.__new__(_StoreState)

        __props__.__dict__["append_meta"] = append_meta
        __props__.__dict__["auto_split"] = auto_split
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["enable_web_tracking"] = enable_web_tracking
        __props__.__dict__["encrypt_conf"] = encrypt_conf
        __props__.__dict__["hot_ttl"] = hot_ttl
        __props__.__dict__["infrequent_access_ttl"] = infrequent_access_ttl
        __props__.__dict__["logstore_name"] = logstore_name
        __props__.__dict__["max_split_shard_count"] = max_split_shard_count
        __props__.__dict__["metering_mode"] = metering_mode
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["retention_period"] = retention_period
        __props__.__dict__["shard_count"] = shard_count
        __props__.__dict__["shards"] = shards
        __props__.__dict__["telemetry_type"] = telemetry_type
        return Store(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appendMeta")
    def append_meta(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Determines whether to append log meta automatically. The meta includes log receive time and client IP address. Default to `true`.
        """
        return pulumi.get(self, "append_meta")

    @_builtins.property
    @pulumi.getter(name="autoSplit")
    def auto_split(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Determines whether to automatically split a shard. Default to `false`.
        """
        return pulumi.get(self, "auto_split")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        Log library creation time. Unix timestamp format that represents the number of seconds from 1970-1-1 00:00:00 UTC calculation.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="enableWebTracking")
    def enable_web_tracking(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether open webtracking. webtracking network tracing, support the collection of HTML log, H5, Ios and android platforms.
        """
        return pulumi.get(self, "enable_web_tracking")

    @_builtins.property
    @pulumi.getter(name="encryptConf")
    def encrypt_conf(self) -> pulumi.Output['outputs.StoreEncryptConf']:
        """
        Encrypted storage of data, providing data static protection capability, encrypt_conf can be updated since 1.188.0 (only enable change is supported when updating logstore). See `encrypt_conf` below.
        """
        return pulumi.get(self, "encrypt_conf")

    @_builtins.property
    @pulumi.getter(name="hotTtl")
    def hot_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ttl of hot storage. Default to 30, at least 30, hot storage ttl must be less than ttl.
        """
        return pulumi.get(self, "hot_ttl")

    @_builtins.property
    @pulumi.getter(name="infrequentAccessTtl")
    def infrequent_access_ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Low frequency storage time
        """
        return pulumi.get(self, "infrequent_access_ttl")

    @_builtins.property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> pulumi.Output[_builtins.str]:
        """
        The log store, which is unique in the same project. You need to specify one of the attributes: `logstore_name`, `name`.
        """
        return pulumi.get(self, "logstore_name")

    @_builtins.property
    @pulumi.getter(name="maxSplitShardCount")
    def max_split_shard_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of shards for automatic split, which is in the range of 1 to 256. You must specify this parameter when autoSplit is true.
        """
        return pulumi.get(self, "max_split_shard_count")

    @_builtins.property
    @pulumi.getter(name="meteringMode")
    def metering_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Metering mode. The default metering mode of ChargeByFunction, ChargeByDataIngest traffic mode.
        """
        return pulumi.get(self, "metering_mode")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        The mode of storage. Default to `standard`, must be `standard` or `query`, `lite`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated since provider version 1.215.0. New field 'logstore_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'name' has been deprecated from provider version 1.215.0. New field 'logstore_name' instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'project' has been deprecated since provider version 1.215.0. New field 'project_name' instead.""")
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'project' has been deprecated from provider version 1.215.0. New field 'project_name' instead.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[_builtins.str]:
        """
        The project name to the log store belongs. You need to specify one of the attributes: `project_name`, `project`.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The data retention time (in days). Valid values: [1-3650]. Default to 30. Log store data will be stored permanently when the value is 3650.
        """
        return pulumi.get(self, "retention_period")

    @_builtins.property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of shards in this log store. Default to 2. You can modify it by "Split" or "Merge" operations. [Refer to details](https://www.alibabacloud.com/help/zh/sls/product-overview/shard).
        """
        return pulumi.get(self, "shard_count")

    @_builtins.property
    @pulumi.getter
    def shards(self) -> pulumi.Output[Sequence['outputs.StoreShard']]:
        """
        The shard attribute.
        """
        return pulumi.get(self, "shards")

    @_builtins.property
    @pulumi.getter(name="telemetryType")
    def telemetry_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determines whether store type is metric. `Metrics` means metric store, empty means log store.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "telemetry_type")

