# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccessRuleArgs', 'AccessRule']

@pulumi.input_type
class AccessRuleArgs:
    def __init__(__self__, *,
                 access_group_name: pulumi.Input[_builtins.str],
                 file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_source_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 rw_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 user_access_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccessRule resource.
        :param pulumi.Input[_builtins.str] access_group_name: AccessGroupName.
        :param pulumi.Input[_builtins.str] file_system_type: filesystem type. include standard, extreme.
        :param pulumi.Input[_builtins.str] ipv6_source_cidr_ip: Ipv6SourceCidrIp.
        :param pulumi.Input[_builtins.int] priority: Priority.
        :param pulumi.Input[_builtins.str] rw_access_type: RWAccess.
        :param pulumi.Input[_builtins.str] source_cidr_ip: SourceCidrIp.
        :param pulumi.Input[_builtins.str] user_access_type: UserAccess.
        """
        pulumi.set(__self__, "access_group_name", access_group_name)
        if file_system_type is not None:
            pulumi.set(__self__, "file_system_type", file_system_type)
        if ipv6_source_cidr_ip is not None:
            pulumi.set(__self__, "ipv6_source_cidr_ip", ipv6_source_cidr_ip)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rw_access_type is not None:
            pulumi.set(__self__, "rw_access_type", rw_access_type)
        if source_cidr_ip is not None:
            pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)
        if user_access_type is not None:
            pulumi.set(__self__, "user_access_type", user_access_type)

    @_builtins.property
    @pulumi.getter(name="accessGroupName")
    def access_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        AccessGroupName.
        """
        return pulumi.get(self, "access_group_name")

    @access_group_name.setter
    def access_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_group_name", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        filesystem type. include standard, extreme.
        """
        return pulumi.get(self, "file_system_type")

    @file_system_type.setter
    def file_system_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6SourceCidrIp")
    def ipv6_source_cidr_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ipv6SourceCidrIp.
        """
        return pulumi.get(self, "ipv6_source_cidr_ip")

    @ipv6_source_cidr_ip.setter
    def ipv6_source_cidr_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_source_cidr_ip", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="rwAccessType")
    def rw_access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RWAccess.
        """
        return pulumi.get(self, "rw_access_type")

    @rw_access_type.setter
    def rw_access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rw_access_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SourceCidrIp.
        """
        return pulumi.get(self, "source_cidr_ip")

    @source_cidr_ip.setter
    def source_cidr_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_cidr_ip", value)

    @_builtins.property
    @pulumi.getter(name="userAccessType")
    def user_access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UserAccess.
        """
        return pulumi.get(self, "user_access_type")

    @user_access_type.setter
    def user_access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_access_type", value)


@pulumi.input_type
class _AccessRuleState:
    def __init__(__self__, *,
                 access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 access_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_source_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 rw_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 user_access_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccessRule resources.
        :param pulumi.Input[_builtins.str] access_group_name: AccessGroupName.
        :param pulumi.Input[_builtins.str] access_rule_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] file_system_type: filesystem type. include standard, extreme.
        :param pulumi.Input[_builtins.str] ipv6_source_cidr_ip: Ipv6SourceCidrIp.
        :param pulumi.Input[_builtins.int] priority: Priority.
        :param pulumi.Input[_builtins.str] rw_access_type: RWAccess.
        :param pulumi.Input[_builtins.str] source_cidr_ip: SourceCidrIp.
        :param pulumi.Input[_builtins.str] user_access_type: UserAccess.
        """
        if access_group_name is not None:
            pulumi.set(__self__, "access_group_name", access_group_name)
        if access_rule_id is not None:
            pulumi.set(__self__, "access_rule_id", access_rule_id)
        if file_system_type is not None:
            pulumi.set(__self__, "file_system_type", file_system_type)
        if ipv6_source_cidr_ip is not None:
            pulumi.set(__self__, "ipv6_source_cidr_ip", ipv6_source_cidr_ip)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rw_access_type is not None:
            pulumi.set(__self__, "rw_access_type", rw_access_type)
        if source_cidr_ip is not None:
            pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)
        if user_access_type is not None:
            pulumi.set(__self__, "user_access_type", user_access_type)

    @_builtins.property
    @pulumi.getter(name="accessGroupName")
    def access_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AccessGroupName.
        """
        return pulumi.get(self, "access_group_name")

    @access_group_name.setter
    def access_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_group_name", value)

    @_builtins.property
    @pulumi.getter(name="accessRuleId")
    def access_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "access_rule_id")

    @access_rule_id.setter
    def access_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_rule_id", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        filesystem type. include standard, extreme.
        """
        return pulumi.get(self, "file_system_type")

    @file_system_type.setter
    def file_system_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_system_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6SourceCidrIp")
    def ipv6_source_cidr_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ipv6SourceCidrIp.
        """
        return pulumi.get(self, "ipv6_source_cidr_ip")

    @ipv6_source_cidr_ip.setter
    def ipv6_source_cidr_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_source_cidr_ip", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="rwAccessType")
    def rw_access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RWAccess.
        """
        return pulumi.get(self, "rw_access_type")

    @rw_access_type.setter
    def rw_access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rw_access_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SourceCidrIp.
        """
        return pulumi.get(self, "source_cidr_ip")

    @source_cidr_ip.setter
    def source_cidr_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_cidr_ip", value)

    @_builtins.property
    @pulumi.getter(name="userAccessType")
    def user_access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UserAccess.
        """
        return pulumi.get(self, "user_access_type")

    @user_access_type.setter
    def user_access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_access_type", value)


@pulumi.type_token("alicloud:nas/accessRule:AccessRule")
class AccessRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_source_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 rw_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 user_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a NAS Access Rule resource.

        For information about NAS Access Rule and how to use it, see [What is Access Rule](https://www.alibabacloud.com/help/en/nas/developer-reference/api-nas-2017-06-26-createaccessrule).

        > **NOTE:** Available since v1.34.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_access_group = alicloud.nas.AccessGroup("default",
            access_group_type="Vpc",
            description="ExtremeAccessGroup",
            access_group_name=f"terraform-example-{default['result']}",
            file_system_type="extreme")
        default_access_rule = alicloud.nas.AccessRule("default",
            access_group_name=default_access_group.access_group_name,
            rw_access_type="RDONLY",
            ipv6_source_cidr_ip="::1",
            user_access_type="no_squash",
            priority=1,
            file_system_type="extreme")
        ```

        ## Import

        NAS Access Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nas/accessRule:AccessRule example <access_group_name>:<file_system_type>:<access_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_group_name: AccessGroupName.
        :param pulumi.Input[_builtins.str] file_system_type: filesystem type. include standard, extreme.
        :param pulumi.Input[_builtins.str] ipv6_source_cidr_ip: Ipv6SourceCidrIp.
        :param pulumi.Input[_builtins.int] priority: Priority.
        :param pulumi.Input[_builtins.str] rw_access_type: RWAccess.
        :param pulumi.Input[_builtins.str] source_cidr_ip: SourceCidrIp.
        :param pulumi.Input[_builtins.str] user_access_type: UserAccess.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a NAS Access Rule resource.

        For information about NAS Access Rule and how to use it, see [What is Access Rule](https://www.alibabacloud.com/help/en/nas/developer-reference/api-nas-2017-06-26-createaccessrule).

        > **NOTE:** Available since v1.34.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        default_access_group = alicloud.nas.AccessGroup("default",
            access_group_type="Vpc",
            description="ExtremeAccessGroup",
            access_group_name=f"terraform-example-{default['result']}",
            file_system_type="extreme")
        default_access_rule = alicloud.nas.AccessRule("default",
            access_group_name=default_access_group.access_group_name,
            rw_access_type="RDONLY",
            ipv6_source_cidr_ip="::1",
            user_access_type="no_squash",
            priority=1,
            file_system_type="extreme")
        ```

        ## Import

        NAS Access Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:nas/accessRule:AccessRule example <access_group_name>:<file_system_type>:<access_rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param AccessRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_source_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 rw_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 user_access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessRuleArgs.__new__(AccessRuleArgs)

            if access_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'access_group_name'")
            __props__.__dict__["access_group_name"] = access_group_name
            __props__.__dict__["file_system_type"] = file_system_type
            __props__.__dict__["ipv6_source_cidr_ip"] = ipv6_source_cidr_ip
            __props__.__dict__["priority"] = priority
            __props__.__dict__["rw_access_type"] = rw_access_type
            __props__.__dict__["source_cidr_ip"] = source_cidr_ip
            __props__.__dict__["user_access_type"] = user_access_type
            __props__.__dict__["access_rule_id"] = None
        super(AccessRule, __self__).__init__(
            'alicloud:nas/accessRule:AccessRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            access_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            file_system_type: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_source_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            rw_access_type: Optional[pulumi.Input[_builtins.str]] = None,
            source_cidr_ip: Optional[pulumi.Input[_builtins.str]] = None,
            user_access_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccessRule':
        """
        Get an existing AccessRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_group_name: AccessGroupName.
        :param pulumi.Input[_builtins.str] access_rule_id: The first ID of the resource.
        :param pulumi.Input[_builtins.str] file_system_type: filesystem type. include standard, extreme.
        :param pulumi.Input[_builtins.str] ipv6_source_cidr_ip: Ipv6SourceCidrIp.
        :param pulumi.Input[_builtins.int] priority: Priority.
        :param pulumi.Input[_builtins.str] rw_access_type: RWAccess.
        :param pulumi.Input[_builtins.str] source_cidr_ip: SourceCidrIp.
        :param pulumi.Input[_builtins.str] user_access_type: UserAccess.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessRuleState.__new__(_AccessRuleState)

        __props__.__dict__["access_group_name"] = access_group_name
        __props__.__dict__["access_rule_id"] = access_rule_id
        __props__.__dict__["file_system_type"] = file_system_type
        __props__.__dict__["ipv6_source_cidr_ip"] = ipv6_source_cidr_ip
        __props__.__dict__["priority"] = priority
        __props__.__dict__["rw_access_type"] = rw_access_type
        __props__.__dict__["source_cidr_ip"] = source_cidr_ip
        __props__.__dict__["user_access_type"] = user_access_type
        return AccessRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessGroupName")
    def access_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        AccessGroupName.
        """
        return pulumi.get(self, "access_group_name")

    @_builtins.property
    @pulumi.getter(name="accessRuleId")
    def access_rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "access_rule_id")

    @_builtins.property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> pulumi.Output[_builtins.str]:
        """
        filesystem type. include standard, extreme.
        """
        return pulumi.get(self, "file_system_type")

    @_builtins.property
    @pulumi.getter(name="ipv6SourceCidrIp")
    def ipv6_source_cidr_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Ipv6SourceCidrIp.
        """
        return pulumi.get(self, "ipv6_source_cidr_ip")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="rwAccessType")
    def rw_access_type(self) -> pulumi.Output[_builtins.str]:
        """
        RWAccess.
        """
        return pulumi.get(self, "rw_access_type")

    @_builtins.property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SourceCidrIp.
        """
        return pulumi.get(self, "source_cidr_ip")

    @_builtins.property
    @pulumi.getter(name="userAccessType")
    def user_access_type(self) -> pulumi.Output[_builtins.str]:
        """
        UserAccess.
        """
        return pulumi.get(self, "user_access_type")

