# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetListenersResult',
    'AwaitableGetListenersResult',
    'get_listeners',
    'get_listeners_output',
]

@pulumi.output_type
class GetListenersResult:
    """
    A collection of values returned by getListeners.
    """
    def __init__(__self__, id=None, ids=None, listener_protocol=None, listeners=None, load_balancer_ids=None, output_file=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if listener_protocol and not isinstance(listener_protocol, str):
            raise TypeError("Expected argument 'listener_protocol' to be a str")
        pulumi.set(__self__, "listener_protocol", listener_protocol)
        if listeners and not isinstance(listeners, list):
            raise TypeError("Expected argument 'listeners' to be a list")
        pulumi.set(__self__, "listeners", listeners)
        if load_balancer_ids and not isinstance(load_balancer_ids, list):
            raise TypeError("Expected argument 'load_balancer_ids' to be a list")
        pulumi.set(__self__, "load_balancer_ids", load_balancer_ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> Optional[_builtins.str]:
        """
        The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
        """
        return pulumi.get(self, "listener_protocol")

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Sequence['outputs.GetListenersListenerResult']:
        """
        A list of Nlb Listeners. Each element contains the following attributes:
        """
        return pulumi.get(self, "listeners")

    @_builtins.property
    @pulumi.getter(name="loadBalancerIds")
    def load_balancer_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "load_balancer_ids")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetListenersResult(GetListenersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListenersResult(
            id=self.id,
            ids=self.ids,
            listener_protocol=self.listener_protocol,
            listeners=self.listeners,
            load_balancer_ids=self.load_balancer_ids,
            output_file=self.output_file)


def get_listeners(ids: Optional[Sequence[_builtins.str]] = None,
                  listener_protocol: Optional[_builtins.str] = None,
                  load_balancer_ids: Optional[Sequence[_builtins.str]] = None,
                  output_file: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListenersResult:
    """
    This data source provides the Nlb Listeners of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.191.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.nlb.get_listeners(ids=["example_value"])
    pulumi.export("alicloudNlbListenerId1", ids.listeners[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Listener IDs.
    :param _builtins.str listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
    :param Sequence[_builtins.str] load_balancer_ids: The ID of the NLB instance. You can specify at most 20 IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['listenerProtocol'] = listener_protocol
    __args__['loadBalancerIds'] = load_balancer_ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:nlb/getListeners:getListeners', __args__, opts=opts, typ=GetListenersResult).value

    return AwaitableGetListenersResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        listener_protocol=pulumi.get(__ret__, 'listener_protocol'),
        listeners=pulumi.get(__ret__, 'listeners'),
        load_balancer_ids=pulumi.get(__ret__, 'load_balancer_ids'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_listeners_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                         listener_protocol: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         load_balancer_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                         output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetListenersResult]:
    """
    This data source provides the Nlb Listeners of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.191.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.nlb.get_listeners(ids=["example_value"])
    pulumi.export("alicloudNlbListenerId1", ids.listeners[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Listener IDs.
    :param _builtins.str listener_protocol: The listening protocol. Valid values: `TCP`, `UDP`, or `TCPSSL`.
    :param Sequence[_builtins.str] load_balancer_ids: The ID of the NLB instance. You can specify at most 20 IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['listenerProtocol'] = listener_protocol
    __args__['loadBalancerIds'] = load_balancer_ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:nlb/getListeners:getListeners', __args__, opts=opts, typ=GetListenersResult)
    return __ret__.apply(lambda __response__: GetListenersResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        listener_protocol=pulumi.get(__response__, 'listener_protocol'),
        listeners=pulumi.get(__response__, 'listeners'),
        load_balancer_ids=pulumi.get(__response__, 'load_balancer_ids'),
        output_file=pulumi.get(__response__, 'output_file')))
