# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetApplicationGroupsResult',
    'AwaitableGetApplicationGroupsResult',
    'get_application_groups',
    'get_application_groups_output',
]

@pulumi.output_type
class GetApplicationGroupsResult:
    """
    A collection of values returned by getApplicationGroups.
    """
    def __init__(__self__, application_name=None, deploy_region_id=None, groups=None, id=None, ids=None, name_regex=None, names=None, output_file=None):
        if application_name and not isinstance(application_name, str):
            raise TypeError("Expected argument 'application_name' to be a str")
        pulumi.set(__self__, "application_name", application_name)
        if deploy_region_id and not isinstance(deploy_region_id, str):
            raise TypeError("Expected argument 'deploy_region_id' to be a str")
        pulumi.set(__self__, "deploy_region_id", deploy_region_id)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> _builtins.str:
        return pulumi.get(self, "application_name")

    @_builtins.property
    @pulumi.getter(name="deployRegionId")
    def deploy_region_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "deploy_region_id")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetApplicationGroupsGroupResult']:
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetApplicationGroupsResult(GetApplicationGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationGroupsResult(
            application_name=self.application_name,
            deploy_region_id=self.deploy_region_id,
            groups=self.groups,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file)


def get_application_groups(application_name: Optional[_builtins.str] = None,
                           deploy_region_id: Optional[_builtins.str] = None,
                           ids: Optional[Sequence[_builtins.str]] = None,
                           name_regex: Optional[_builtins.str] = None,
                           output_file: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationGroupsResult:
    """
    This data source provides the Oos Application Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.146.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.oos.get_application_groups(application_name="example_value",
        ids=[
            "my-ApplicationGroup-1",
            "my-ApplicationGroup-2",
        ])
    pulumi.export("oosApplicationGroupId1", ids.groups[0].id)
    name_regex = alicloud.oos.get_application_groups(application_name="example_value",
        name_regex="^my-ApplicationGroup")
    pulumi.export("oosApplicationGroupId2", name_regex.groups[0].id)
    ```


    :param _builtins.str application_name: The name of the Application.
    :param _builtins.str deploy_region_id: The region ID of the deployment.
    :param Sequence[_builtins.str] ids: A list of Application Group IDs. Its element value is same as Application Group Name.
    :param _builtins.str name_regex: A regex string to filter results by Application Group name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['applicationName'] = application_name
    __args__['deployRegionId'] = deploy_region_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:oos/getApplicationGroups:getApplicationGroups', __args__, opts=opts, typ=GetApplicationGroupsResult).value

    return AwaitableGetApplicationGroupsResult(
        application_name=pulumi.get(__ret__, 'application_name'),
        deploy_region_id=pulumi.get(__ret__, 'deploy_region_id'),
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_application_groups_output(application_name: Optional[pulumi.Input[_builtins.str]] = None,
                                  deploy_region_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                  name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationGroupsResult]:
    """
    This data source provides the Oos Application Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.146.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.oos.get_application_groups(application_name="example_value",
        ids=[
            "my-ApplicationGroup-1",
            "my-ApplicationGroup-2",
        ])
    pulumi.export("oosApplicationGroupId1", ids.groups[0].id)
    name_regex = alicloud.oos.get_application_groups(application_name="example_value",
        name_regex="^my-ApplicationGroup")
    pulumi.export("oosApplicationGroupId2", name_regex.groups[0].id)
    ```


    :param _builtins.str application_name: The name of the Application.
    :param _builtins.str deploy_region_id: The region ID of the deployment.
    :param Sequence[_builtins.str] ids: A list of Application Group IDs. Its element value is same as Application Group Name.
    :param _builtins.str name_regex: A regex string to filter results by Application Group name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['applicationName'] = application_name
    __args__['deployRegionId'] = deploy_region_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:oos/getApplicationGroups:getApplicationGroups', __args__, opts=opts, typ=GetApplicationGroupsResult)
    return __ret__.apply(lambda __response__: GetApplicationGroupsResult(
        application_name=pulumi.get(__response__, 'application_name'),
        deploy_region_id=pulumi.get(__response__, 'deploy_region_id'),
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file')))
