# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PatchBaselineArgs', 'PatchBaseline']

@pulumi.input_type
class PatchBaselineArgs:
    def __init__(__self__, *,
                 approval_rules: pulumi.Input[_builtins.str],
                 operation_system: pulumi.Input[_builtins.str],
                 patch_baseline_name: pulumi.Input[_builtins.str],
                 approved_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 approved_patches_enable_non_security: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 rejected_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rejected_patches_action: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a PatchBaseline resource.
        :param pulumi.Input[_builtins.str] approval_rules: Accept the rules. This value follows the json format. For more details, see the description of [ApprovalRules in the Request parameters table for details](https://www.alibabacloud.com/help/zh/operation-orchestration-service/latest/api-oos-2019-06-01-createpatchbaseline).
        :param pulumi.Input[_builtins.str] operation_system: Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`, `AlmaLinux`.
        :param pulumi.Input[_builtins.str] patch_baseline_name: The name of the patch baseline.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] approved_patches: Approved Patch.
        :param pulumi.Input[_builtins.bool] approved_patches_enable_non_security: ApprovedPatchesEnableNonSecurity.
        :param pulumi.Input[_builtins.str] description: Patches baseline description information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rejected_patches: Reject patches.
        :param pulumi.Input[_builtins.str] rejected_patches_action: Rejected patches action. Valid values: `ALLOW_AS_DEPENDENCY`, `BLOCK`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: Source.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label.
        """
        pulumi.set(__self__, "approval_rules", approval_rules)
        pulumi.set(__self__, "operation_system", operation_system)
        pulumi.set(__self__, "patch_baseline_name", patch_baseline_name)
        if approved_patches is not None:
            pulumi.set(__self__, "approved_patches", approved_patches)
        if approved_patches_enable_non_security is not None:
            pulumi.set(__self__, "approved_patches_enable_non_security", approved_patches_enable_non_security)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if rejected_patches is not None:
            pulumi.set(__self__, "rejected_patches", rejected_patches)
        if rejected_patches_action is not None:
            pulumi.set(__self__, "rejected_patches_action", rejected_patches_action)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> pulumi.Input[_builtins.str]:
        """
        Accept the rules. This value follows the json format. For more details, see the description of [ApprovalRules in the Request parameters table for details](https://www.alibabacloud.com/help/zh/operation-orchestration-service/latest/api-oos-2019-06-01-createpatchbaseline).
        """
        return pulumi.get(self, "approval_rules")

    @approval_rules.setter
    def approval_rules(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "approval_rules", value)

    @_builtins.property
    @pulumi.getter(name="operationSystem")
    def operation_system(self) -> pulumi.Input[_builtins.str]:
        """
        Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`, `AlmaLinux`.
        """
        return pulumi.get(self, "operation_system")

    @operation_system.setter
    def operation_system(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "operation_system", value)

    @_builtins.property
    @pulumi.getter(name="patchBaselineName")
    def patch_baseline_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the patch baseline.
        """
        return pulumi.get(self, "patch_baseline_name")

    @patch_baseline_name.setter
    def patch_baseline_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "patch_baseline_name", value)

    @_builtins.property
    @pulumi.getter(name="approvedPatches")
    def approved_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Approved Patch.
        """
        return pulumi.get(self, "approved_patches")

    @approved_patches.setter
    def approved_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "approved_patches", value)

    @_builtins.property
    @pulumi.getter(name="approvedPatchesEnableNonSecurity")
    def approved_patches_enable_non_security(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        ApprovedPatchesEnableNonSecurity.
        """
        return pulumi.get(self, "approved_patches_enable_non_security")

    @approved_patches_enable_non_security.setter
    def approved_patches_enable_non_security(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "approved_patches_enable_non_security", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Patches baseline description information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="rejectedPatches")
    def rejected_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Reject patches.
        """
        return pulumi.get(self, "rejected_patches")

    @rejected_patches.setter
    def rejected_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rejected_patches", value)

    @_builtins.property
    @pulumi.getter(name="rejectedPatchesAction")
    def rejected_patches_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rejected patches action. Valid values: `ALLOW_AS_DEPENDENCY`, `BLOCK`.
        """
        return pulumi.get(self, "rejected_patches_action")

    @rejected_patches_action.setter
    def rejected_patches_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rejected_patches_action", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Source.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Label.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PatchBaselineState:
    def __init__(__self__, *,
                 approval_rules: Optional[pulumi.Input[_builtins.str]] = None,
                 approved_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 approved_patches_enable_non_security: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_system: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_baseline_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rejected_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rejected_patches_action: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering PatchBaseline resources.
        :param pulumi.Input[_builtins.str] approval_rules: Accept the rules. This value follows the json format. For more details, see the description of [ApprovalRules in the Request parameters table for details](https://www.alibabacloud.com/help/zh/operation-orchestration-service/latest/api-oos-2019-06-01-createpatchbaseline).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] approved_patches: Approved Patch.
        :param pulumi.Input[_builtins.bool] approved_patches_enable_non_security: ApprovedPatchesEnableNonSecurity.
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.str] description: Patches baseline description information.
        :param pulumi.Input[_builtins.str] operation_system: Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`, `AlmaLinux`.
        :param pulumi.Input[_builtins.str] patch_baseline_name: The name of the patch baseline.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rejected_patches: Reject patches.
        :param pulumi.Input[_builtins.str] rejected_patches_action: Rejected patches action. Valid values: `ALLOW_AS_DEPENDENCY`, `BLOCK`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: Source.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label.
        """
        if approval_rules is not None:
            pulumi.set(__self__, "approval_rules", approval_rules)
        if approved_patches is not None:
            pulumi.set(__self__, "approved_patches", approved_patches)
        if approved_patches_enable_non_security is not None:
            pulumi.set(__self__, "approved_patches_enable_non_security", approved_patches_enable_non_security)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if operation_system is not None:
            pulumi.set(__self__, "operation_system", operation_system)
        if patch_baseline_name is not None:
            pulumi.set(__self__, "patch_baseline_name", patch_baseline_name)
        if rejected_patches is not None:
            pulumi.set(__self__, "rejected_patches", rejected_patches)
        if rejected_patches_action is not None:
            pulumi.set(__self__, "rejected_patches_action", rejected_patches_action)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Accept the rules. This value follows the json format. For more details, see the description of [ApprovalRules in the Request parameters table for details](https://www.alibabacloud.com/help/zh/operation-orchestration-service/latest/api-oos-2019-06-01-createpatchbaseline).
        """
        return pulumi.get(self, "approval_rules")

    @approval_rules.setter
    def approval_rules(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "approval_rules", value)

    @_builtins.property
    @pulumi.getter(name="approvedPatches")
    def approved_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Approved Patch.
        """
        return pulumi.get(self, "approved_patches")

    @approved_patches.setter
    def approved_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "approved_patches", value)

    @_builtins.property
    @pulumi.getter(name="approvedPatchesEnableNonSecurity")
    def approved_patches_enable_non_security(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        ApprovedPatchesEnableNonSecurity.
        """
        return pulumi.get(self, "approved_patches_enable_non_security")

    @approved_patches_enable_non_security.setter
    def approved_patches_enable_non_security(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "approved_patches_enable_non_security", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Patches baseline description information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="operationSystem")
    def operation_system(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`, `AlmaLinux`.
        """
        return pulumi.get(self, "operation_system")

    @operation_system.setter
    def operation_system(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_system", value)

    @_builtins.property
    @pulumi.getter(name="patchBaselineName")
    def patch_baseline_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the patch baseline.
        """
        return pulumi.get(self, "patch_baseline_name")

    @patch_baseline_name.setter
    def patch_baseline_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "patch_baseline_name", value)

    @_builtins.property
    @pulumi.getter(name="rejectedPatches")
    def rejected_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Reject patches.
        """
        return pulumi.get(self, "rejected_patches")

    @rejected_patches.setter
    def rejected_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rejected_patches", value)

    @_builtins.property
    @pulumi.getter(name="rejectedPatchesAction")
    def rejected_patches_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rejected patches action. Valid values: `ALLOW_AS_DEPENDENCY`, `BLOCK`.
        """
        return pulumi.get(self, "rejected_patches_action")

    @rejected_patches_action.setter
    def rejected_patches_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rejected_patches_action", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Source.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Label.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:oos/patchBaseline:PatchBaseline")
class PatchBaseline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rules: Optional[pulumi.Input[_builtins.str]] = None,
                 approved_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 approved_patches_enable_non_security: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_system: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_baseline_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rejected_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rejected_patches_action: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a OOS Patch Baseline resource.

        For information about OOS Patch Baseline and how to use it, see [What is Patch Baseline](https://www.alibabacloud.com/help/en/operation-orchestration-service/latest/patch-manager-overview).

        > **NOTE:** Available since v1.146.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.oos.PatchBaseline("default",
            patch_baseline_name=name,
            operation_system="Windows",
            approval_rules="{\\"PatchRules\\":[{\\"EnableNonSecurity\\":true,\\"PatchFilterGroup\\":[{\\"Values\\":[\\"*\\"],\\"Key\\":\\"Product\\"},{\\"Values\\":[\\"Security\\",\\"Bugfix\\"],\\"Key\\":\\"Classification\\"},{\\"Values\\":[\\"Critical\\",\\"Important\\"],\\"Key\\":\\"Severity\\"}],\\"ApproveAfterDays\\":7,\\"ComplianceLevel\\":\\"Unspecified\\"}]}")
        ```

        ## Import

        OOS Patch Baseline can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oos/patchBaseline:PatchBaseline example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] approval_rules: Accept the rules. This value follows the json format. For more details, see the description of [ApprovalRules in the Request parameters table for details](https://www.alibabacloud.com/help/zh/operation-orchestration-service/latest/api-oos-2019-06-01-createpatchbaseline).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] approved_patches: Approved Patch.
        :param pulumi.Input[_builtins.bool] approved_patches_enable_non_security: ApprovedPatchesEnableNonSecurity.
        :param pulumi.Input[_builtins.str] description: Patches baseline description information.
        :param pulumi.Input[_builtins.str] operation_system: Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`, `AlmaLinux`.
        :param pulumi.Input[_builtins.str] patch_baseline_name: The name of the patch baseline.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rejected_patches: Reject patches.
        :param pulumi.Input[_builtins.str] rejected_patches_action: Rejected patches action. Valid values: `ALLOW_AS_DEPENDENCY`, `BLOCK`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: Source.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PatchBaselineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a OOS Patch Baseline resource.

        For information about OOS Patch Baseline and how to use it, see [What is Patch Baseline](https://www.alibabacloud.com/help/en/operation-orchestration-service/latest/patch-manager-overview).

        > **NOTE:** Available since v1.146.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.oos.PatchBaseline("default",
            patch_baseline_name=name,
            operation_system="Windows",
            approval_rules="{\\"PatchRules\\":[{\\"EnableNonSecurity\\":true,\\"PatchFilterGroup\\":[{\\"Values\\":[\\"*\\"],\\"Key\\":\\"Product\\"},{\\"Values\\":[\\"Security\\",\\"Bugfix\\"],\\"Key\\":\\"Classification\\"},{\\"Values\\":[\\"Critical\\",\\"Important\\"],\\"Key\\":\\"Severity\\"}],\\"ApproveAfterDays\\":7,\\"ComplianceLevel\\":\\"Unspecified\\"}]}")
        ```

        ## Import

        OOS Patch Baseline can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:oos/patchBaseline:PatchBaseline example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PatchBaselineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PatchBaselineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rules: Optional[pulumi.Input[_builtins.str]] = None,
                 approved_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 approved_patches_enable_non_security: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_system: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_baseline_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rejected_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rejected_patches_action: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PatchBaselineArgs.__new__(PatchBaselineArgs)

            if approval_rules is None and not opts.urn:
                raise TypeError("Missing required property 'approval_rules'")
            __props__.__dict__["approval_rules"] = approval_rules
            __props__.__dict__["approved_patches"] = approved_patches
            __props__.__dict__["approved_patches_enable_non_security"] = approved_patches_enable_non_security
            __props__.__dict__["description"] = description
            if operation_system is None and not opts.urn:
                raise TypeError("Missing required property 'operation_system'")
            __props__.__dict__["operation_system"] = operation_system
            if patch_baseline_name is None and not opts.urn:
                raise TypeError("Missing required property 'patch_baseline_name'")
            __props__.__dict__["patch_baseline_name"] = patch_baseline_name
            __props__.__dict__["rejected_patches"] = rejected_patches
            __props__.__dict__["rejected_patches_action"] = rejected_patches_action
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["sources"] = sources
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
        super(PatchBaseline, __self__).__init__(
            'alicloud:oos/patchBaseline:PatchBaseline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approval_rules: Optional[pulumi.Input[_builtins.str]] = None,
            approved_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            approved_patches_enable_non_security: Optional[pulumi.Input[_builtins.bool]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            operation_system: Optional[pulumi.Input[_builtins.str]] = None,
            patch_baseline_name: Optional[pulumi.Input[_builtins.str]] = None,
            rejected_patches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rejected_patches_action: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'PatchBaseline':
        """
        Get an existing PatchBaseline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] approval_rules: Accept the rules. This value follows the json format. For more details, see the description of [ApprovalRules in the Request parameters table for details](https://www.alibabacloud.com/help/zh/operation-orchestration-service/latest/api-oos-2019-06-01-createpatchbaseline).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] approved_patches: Approved Patch.
        :param pulumi.Input[_builtins.bool] approved_patches_enable_non_security: ApprovedPatchesEnableNonSecurity.
        :param pulumi.Input[_builtins.str] create_time: Creation time.
        :param pulumi.Input[_builtins.str] description: Patches baseline description information.
        :param pulumi.Input[_builtins.str] operation_system: Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`, `AlmaLinux`.
        :param pulumi.Input[_builtins.str] patch_baseline_name: The name of the patch baseline.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] rejected_patches: Reject patches.
        :param pulumi.Input[_builtins.str] rejected_patches_action: Rejected patches action. Valid values: `ALLOW_AS_DEPENDENCY`, `BLOCK`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sources: Source.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PatchBaselineState.__new__(_PatchBaselineState)

        __props__.__dict__["approval_rules"] = approval_rules
        __props__.__dict__["approved_patches"] = approved_patches
        __props__.__dict__["approved_patches_enable_non_security"] = approved_patches_enable_non_security
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["operation_system"] = operation_system
        __props__.__dict__["patch_baseline_name"] = patch_baseline_name
        __props__.__dict__["rejected_patches"] = rejected_patches
        __props__.__dict__["rejected_patches_action"] = rejected_patches_action
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["sources"] = sources
        __props__.__dict__["tags"] = tags
        return PatchBaseline(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> pulumi.Output[_builtins.str]:
        """
        Accept the rules. This value follows the json format. For more details, see the description of [ApprovalRules in the Request parameters table for details](https://www.alibabacloud.com/help/zh/operation-orchestration-service/latest/api-oos-2019-06-01-createpatchbaseline).
        """
        return pulumi.get(self, "approval_rules")

    @_builtins.property
    @pulumi.getter(name="approvedPatches")
    def approved_patches(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Approved Patch.
        """
        return pulumi.get(self, "approved_patches")

    @_builtins.property
    @pulumi.getter(name="approvedPatchesEnableNonSecurity")
    def approved_patches_enable_non_security(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        ApprovedPatchesEnableNonSecurity.
        """
        return pulumi.get(self, "approved_patches_enable_non_security")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Patches baseline description information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="operationSystem")
    def operation_system(self) -> pulumi.Output[_builtins.str]:
        """
        Operating system type. Valid values: `AliyunLinux`, `Anolis`, `CentOS`, `Debian`, `RedhatEnterpriseLinux`, `Ubuntu`, `Windows`, `AlmaLinux`.
        """
        return pulumi.get(self, "operation_system")

    @_builtins.property
    @pulumi.getter(name="patchBaselineName")
    def patch_baseline_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the patch baseline.
        """
        return pulumi.get(self, "patch_baseline_name")

    @_builtins.property
    @pulumi.getter(name="rejectedPatches")
    def rejected_patches(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Reject patches.
        """
        return pulumi.get(self, "rejected_patches")

    @_builtins.property
    @pulumi.getter(name="rejectedPatchesAction")
    def rejected_patches_action(self) -> pulumi.Output[_builtins.str]:
        """
        Rejected patches action. Valid values: `ALLOW_AS_DEPENDENCY`, `BLOCK`.
        """
        return pulumi.get(self, "rejected_patches_action")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Source.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Label.
        """
        return pulumi.get(self, "tags")

