# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[_builtins.str] comments: The Group comment information. The maximum length is 128 characters.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the Group. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] group_name: The group name. You must specify at least one of the `group_name` and `name`.
               It can be 1 to 64 characters in length and can contain letters, digits, periods (.), underscores (_), and dashes (-).
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.120.0. New field 'group_name' instead.
        """
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.245.0. New field `group_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.245.0. New field `group_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Group comment information. The maximum length is 128 characters.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to force delete the Group. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group name. You must specify at least one of the `group_name` and `name`.
        It can be 1 to 64 characters in length and can contain letters, digits, periods (.), underscores (_), and dashes (-).

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.245.0. New field `group_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.120.0. New field 'group_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[_builtins.str] comments: The Group comment information. The maximum length is 128 characters.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.245.0) The create time of the group.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the Group. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] group_name: The group name. You must specify at least one of the `group_name` and `name`.
               It can be 1 to 64 characters in length and can contain letters, digits, periods (.), underscores (_), and dashes (-).
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.120.0. New field 'group_name' instead.
        """
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.245.0. New field `group_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.245.0. New field `group_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Group comment information. The maximum length is 128 characters.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.245.0) The create time of the group.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to force delete the Group. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group name. You must specify at least one of the `group_name` and `name`.
        It can be 1 to 64 characters in length and can contain letters, digits, periods (.), underscores (_), and dashes (-).

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.245.0. New field `group_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        . Field 'name' has been deprecated from provider version 1.120.0. New field 'group_name' instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("alicloud:ram/group:Group")
class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RAM Group resource.

        The group that users can join.

        For information about RAM Group and how to use it, see [What is Group](https://www.alibabacloud.com/help/en/ram/developer-reference/api-ram-2015-05-01-creategroup).

        > **NOTE:** Available since v1.0.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        group = alicloud.ram.Group("group",
            group_name=name,
            comments=name,
            force=True)
        ```

        ## Import

        RAM Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/group:Group example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comments: The Group comment information. The maximum length is 128 characters.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the Group. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] group_name: The group name. You must specify at least one of the `group_name` and `name`.
               It can be 1 to 64 characters in length and can contain letters, digits, periods (.), underscores (_), and dashes (-).
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.120.0. New field 'group_name' instead.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RAM Group resource.

        The group that users can join.

        For information about RAM Group and how to use it, see [What is Group](https://www.alibabacloud.com/help/en/ram/developer-reference/api-ram-2015-05-01-creategroup).

        > **NOTE:** Available since v1.0.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        group = alicloud.ram.Group("group",
            group_name=name,
            comments=name,
            force=True)
        ```

        ## Import

        RAM Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/group:Group example <id>
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["comments"] = comments
            __props__.__dict__["force"] = force
            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["name"] = name
            __props__.__dict__["create_time"] = None
        super(Group, __self__).__init__(
            'alicloud:ram/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comments: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            group_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comments: The Group comment information. The maximum length is 128 characters.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.245.0) The create time of the group.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the Group. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] group_name: The group name. You must specify at least one of the `group_name` and `name`.
               It can be 1 to 64 characters in length and can contain letters, digits, periods (.), underscores (_), and dashes (-).
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        :param pulumi.Input[_builtins.str] name: . Field 'name' has been deprecated from provider version 1.120.0. New field 'group_name' instead.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["comments"] = comments
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["force"] = force
        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["name"] = name
        return Group(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Group comment information. The maximum length is 128 characters.
        """
        return pulumi.get(self, "comments")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.245.0) The create time of the group.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to force delete the Group. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The group name. You must specify at least one of the `group_name` and `name`.
        It can be 1 to 64 characters in length and can contain letters, digits, periods (.), underscores (_), and dashes (-).

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.245.0. New field `group_name` instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        . Field 'name' has been deprecated from provider version 1.120.0. New field 'group_name' instead.
        """
        return pulumi.get(self, "name")

