# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 document: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 statements: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyStatementArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[_builtins.str] description: The description of the policy. It can be 1 to 1024 characters in length.
        :param pulumi.Input[_builtins.str] document: Field `document` has been deprecated from provider version 1.114.0. New field `policy_document` instead.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the Policy. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.114.0. New field `policy_name` instead.
        :param pulumi.Input[_builtins.str] policy_document: The content of the policy. The maximum length is 6144 bytes.
        :param pulumi.Input[_builtins.str] policy_name: The policy name. It can be 1 to 128 characters in length and can contain English letters, digits, and dashes (-).
        :param pulumi.Input[_builtins.str] rotate_strategy: The automatic rotation mechanism of policy versions can delete historical policy versions. The default value is None. Valid values:
               - `None`: Turn off the rotation mechanism.
               - `DeleteOldestNonDefaultVersionWhenLimitExceeded`: When the number of permission policy versions exceeds the limit, the oldest and inactive version is deleted.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyStatementArgs']]] statements: Field `statement` has been deprecated from provider version 1.49.0. New field `document` instead. See `statement` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags on the policy.
        :param pulumi.Input[_builtins.str] version: Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if document is not None:
            warnings.warn("""Field 'document' has been deprecated from provider version 1.114.0. New field 'policy_document' instead.""", DeprecationWarning)
            pulumi.log.warn("""document is deprecated: Field 'document' has been deprecated from provider version 1.114.0. New field 'policy_document' instead.""")
        if document is not None:
            pulumi.set(__self__, "document", document)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.114.0. New field 'policy_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.114.0. New field 'policy_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if rotate_strategy is not None:
            pulumi.set(__self__, "rotate_strategy", rotate_strategy)
        if statements is not None:
            warnings.warn("""Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. """, DeprecationWarning)
            pulumi.log.warn("""statements is deprecated: Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. """)
        if statements is not None:
            pulumi.set(__self__, "statements", statements)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            warnings.warn("""Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. """, DeprecationWarning)
            pulumi.log.warn("""version is deprecated: Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. """)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the policy. It can be 1 to 1024 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'document' has been deprecated from provider version 1.114.0. New field 'policy_document' instead.""")
    def document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `document` has been deprecated from provider version 1.114.0. New field `policy_document` instead.
        """
        return pulumi.get(self, "document")

    @document.setter
    def document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "document", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to force delete the Policy. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.114.0. New field 'policy_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.114.0. New field `policy_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the policy. The maximum length is 6144 bytes.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_document", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy name. It can be 1 to 128 characters in length and can contain English letters, digits, and dashes (-).
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter(name="rotateStrategy")
    def rotate_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The automatic rotation mechanism of policy versions can delete historical policy versions. The default value is None. Valid values:
        - `None`: Turn off the rotation mechanism.
        - `DeleteOldestNonDefaultVersionWhenLimitExceeded`: When the number of permission policy versions exceeds the limit, the oldest and inactive version is deleted.
        """
        return pulumi.get(self, "rotate_strategy")

    @rotate_strategy.setter
    def rotate_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotate_strategy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. """)
    def statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyStatementArgs']]]]:
        """
        Field `statement` has been deprecated from provider version 1.49.0. New field `document` instead. See `statement` below.
        """
        return pulumi.get(self, "statements")

    @statements.setter
    def statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyStatementArgs']]]]):
        pulumi.set(self, "statements", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The list of tags on the policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. """)
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 attachment_count: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 default_version: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 document: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 statements: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyStatementArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[_builtins.int] attachment_count: Number of attachments of the policy.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.246.0) The create time of the policy.
        :param pulumi.Input[_builtins.str] default_version: The default version ID of the policy.
        :param pulumi.Input[_builtins.str] description: The description of the policy. It can be 1 to 1024 characters in length.
        :param pulumi.Input[_builtins.str] document: Field `document` has been deprecated from provider version 1.114.0. New field `policy_document` instead.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the Policy. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.114.0. New field `policy_name` instead.
        :param pulumi.Input[_builtins.str] policy_document: The content of the policy. The maximum length is 6144 bytes.
        :param pulumi.Input[_builtins.str] policy_name: The policy name. It can be 1 to 128 characters in length and can contain English letters, digits, and dashes (-).
        :param pulumi.Input[_builtins.str] rotate_strategy: The automatic rotation mechanism of policy versions can delete historical policy versions. The default value is None. Valid values:
               - `None`: Turn off the rotation mechanism.
               - `DeleteOldestNonDefaultVersionWhenLimitExceeded`: When the number of permission policy versions exceeds the limit, the oldest and inactive version is deleted.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyStatementArgs']]] statements: Field `statement` has been deprecated from provider version 1.49.0. New field `document` instead. See `statement` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags on the policy.
        :param pulumi.Input[_builtins.str] type: The type of the policy.
        :param pulumi.Input[_builtins.str] version: Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        :param pulumi.Input[_builtins.str] version_id: The ID of the default policy version.
        """
        if attachment_count is not None:
            pulumi.set(__self__, "attachment_count", attachment_count)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if default_version is not None:
            pulumi.set(__self__, "default_version", default_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if document is not None:
            warnings.warn("""Field 'document' has been deprecated from provider version 1.114.0. New field 'policy_document' instead.""", DeprecationWarning)
            pulumi.log.warn("""document is deprecated: Field 'document' has been deprecated from provider version 1.114.0. New field 'policy_document' instead.""")
        if document is not None:
            pulumi.set(__self__, "document", document)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.114.0. New field 'policy_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.114.0. New field 'policy_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if rotate_strategy is not None:
            pulumi.set(__self__, "rotate_strategy", rotate_strategy)
        if statements is not None:
            warnings.warn("""Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. """, DeprecationWarning)
            pulumi.log.warn("""statements is deprecated: Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. """)
        if statements is not None:
            pulumi.set(__self__, "statements", statements)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            warnings.warn("""Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. """, DeprecationWarning)
            pulumi.log.warn("""version is deprecated: Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. """)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @_builtins.property
    @pulumi.getter(name="attachmentCount")
    def attachment_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of attachments of the policy.
        """
        return pulumi.get(self, "attachment_count")

    @attachment_count.setter
    def attachment_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "attachment_count", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.246.0) The create time of the policy.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default version ID of the policy.
        """
        return pulumi.get(self, "default_version")

    @default_version.setter
    def default_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the policy. It can be 1 to 1024 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'document' has been deprecated from provider version 1.114.0. New field 'policy_document' instead.""")
    def document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `document` has been deprecated from provider version 1.114.0. New field `policy_document` instead.
        """
        return pulumi.get(self, "document")

    @document.setter
    def document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "document", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to force delete the Policy. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.114.0. New field 'policy_name' instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.114.0. New field `policy_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the policy. The maximum length is 6144 bytes.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_document", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy name. It can be 1 to 128 characters in length and can contain English letters, digits, and dashes (-).
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter(name="rotateStrategy")
    def rotate_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The automatic rotation mechanism of policy versions can delete historical policy versions. The default value is None. Valid values:
        - `None`: Turn off the rotation mechanism.
        - `DeleteOldestNonDefaultVersionWhenLimitExceeded`: When the number of permission policy versions exceeds the limit, the oldest and inactive version is deleted.
        """
        return pulumi.get(self, "rotate_strategy")

    @rotate_strategy.setter
    def rotate_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotate_strategy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. """)
    def statements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyStatementArgs']]]]:
        """
        Field `statement` has been deprecated from provider version 1.49.0. New field `document` instead. See `statement` below.
        """
        return pulumi.get(self, "statements")

    @statements.setter
    def statements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyStatementArgs']]]]):
        pulumi.set(self, "statements", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The list of tags on the policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the policy.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. """)
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the default policy version.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_id", value)


@pulumi.type_token("alicloud:ram/policy:Policy")
class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 document: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 statements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyStatementArgs', 'PolicyStatementArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RAM Policy resource.

        For information about RAM Policy and how to use it, see [What is Policy](https://www.alibabacloud.com/help/en/ram/developer-reference/api-ram-2015-05-01-createpolicy).

        > **NOTE:** Available since v1.0.0.

        > **NOTE:** When you want to destroy this resource forcefully(means remove all the relationships associated with it automatically and then destroy it) without set `force`  with `true` at beginning, you need add `force = true` to configuration file and run `pulumi preview`, then you can delete resource forcefully.

        > **NOTE:** Each policy can own at most 5 versions and the oldest version will be removed after its version achieves 5.

        > **NOTE:** If the policy has multiple versions, all non-default versions will be deleted first when deleting policy.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        # Create a new RAM Policy.
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        policy = alicloud.ram.Policy("policy",
            policy_name=f"tf-example-{default['result']}",
            policy_document=\"\"\"  {
            "Statement": [
              {
                "Action": [
                  "oss:ListObjects",
                  "oss:GetObject"
                ],
                "Effect": "Allow",
                "Resource": [
                  "acs:oss:*:*:mybucket",
                  "acs:oss:*:*:mybucket/*"
                ]
              }
            ],
              "Version": "1"
          }
        \"\"\",
            description="this is a policy test")
        ```

        ## Import

        RAM Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/policy:Policy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the policy. It can be 1 to 1024 characters in length.
        :param pulumi.Input[_builtins.str] document: Field `document` has been deprecated from provider version 1.114.0. New field `policy_document` instead.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the Policy. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.114.0. New field `policy_name` instead.
        :param pulumi.Input[_builtins.str] policy_document: The content of the policy. The maximum length is 6144 bytes.
        :param pulumi.Input[_builtins.str] policy_name: The policy name. It can be 1 to 128 characters in length and can contain English letters, digits, and dashes (-).
        :param pulumi.Input[_builtins.str] rotate_strategy: The automatic rotation mechanism of policy versions can delete historical policy versions. The default value is None. Valid values:
               - `None`: Turn off the rotation mechanism.
               - `DeleteOldestNonDefaultVersionWhenLimitExceeded`: When the number of permission policy versions exceeds the limit, the oldest and inactive version is deleted.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyStatementArgs', 'PolicyStatementArgsDict']]]] statements: Field `statement` has been deprecated from provider version 1.49.0. New field `document` instead. See `statement` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags on the policy.
        :param pulumi.Input[_builtins.str] version: Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RAM Policy resource.

        For information about RAM Policy and how to use it, see [What is Policy](https://www.alibabacloud.com/help/en/ram/developer-reference/api-ram-2015-05-01-createpolicy).

        > **NOTE:** Available since v1.0.0.

        > **NOTE:** When you want to destroy this resource forcefully(means remove all the relationships associated with it automatically and then destroy it) without set `force`  with `true` at beginning, you need add `force = true` to configuration file and run `pulumi preview`, then you can delete resource forcefully.

        > **NOTE:** Each policy can own at most 5 versions and the oldest version will be removed after its version achieves 5.

        > **NOTE:** If the policy has multiple versions, all non-default versions will be deleted first when deleting policy.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        # Create a new RAM Policy.
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        policy = alicloud.ram.Policy("policy",
            policy_name=f"tf-example-{default['result']}",
            policy_document=\"\"\"  {
            "Statement": [
              {
                "Action": [
                  "oss:ListObjects",
                  "oss:GetObject"
                ],
                "Effect": "Allow",
                "Resource": [
                  "acs:oss:*:*:mybucket",
                  "acs:oss:*:*:mybucket/*"
                ]
              }
            ],
              "Version": "1"
          }
        \"\"\",
            description="this is a policy test")
        ```

        ## Import

        RAM Policy can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ram/policy:Policy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 document: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_document: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 statements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyStatementArgs', 'PolicyStatementArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["document"] = document
            __props__.__dict__["force"] = force
            __props__.__dict__["name"] = name
            __props__.__dict__["policy_document"] = policy_document
            __props__.__dict__["policy_name"] = policy_name
            __props__.__dict__["rotate_strategy"] = rotate_strategy
            __props__.__dict__["statements"] = statements
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version"] = version
            __props__.__dict__["attachment_count"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["default_version"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["version_id"] = None
        super(Policy, __self__).__init__(
            'alicloud:ram/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachment_count: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            default_version: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            document: Optional[pulumi.Input[_builtins.str]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_document: Optional[pulumi.Input[_builtins.str]] = None,
            policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            rotate_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            statements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyStatementArgs', 'PolicyStatementArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            version_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] attachment_count: Number of attachments of the policy.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.246.0) The create time of the policy.
        :param pulumi.Input[_builtins.str] default_version: The default version ID of the policy.
        :param pulumi.Input[_builtins.str] description: The description of the policy. It can be 1 to 1024 characters in length.
        :param pulumi.Input[_builtins.str] document: Field `document` has been deprecated from provider version 1.114.0. New field `policy_document` instead.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to force delete the Policy. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.114.0. New field `policy_name` instead.
        :param pulumi.Input[_builtins.str] policy_document: The content of the policy. The maximum length is 6144 bytes.
        :param pulumi.Input[_builtins.str] policy_name: The policy name. It can be 1 to 128 characters in length and can contain English letters, digits, and dashes (-).
        :param pulumi.Input[_builtins.str] rotate_strategy: The automatic rotation mechanism of policy versions can delete historical policy versions. The default value is None. Valid values:
               - `None`: Turn off the rotation mechanism.
               - `DeleteOldestNonDefaultVersionWhenLimitExceeded`: When the number of permission policy versions exceeds the limit, the oldest and inactive version is deleted.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyStatementArgs', 'PolicyStatementArgsDict']]]] statements: Field `statement` has been deprecated from provider version 1.49.0. New field `document` instead. See `statement` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The list of tags on the policy.
        :param pulumi.Input[_builtins.str] type: The type of the policy.
        :param pulumi.Input[_builtins.str] version: Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        :param pulumi.Input[_builtins.str] version_id: The ID of the default policy version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["attachment_count"] = attachment_count
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["default_version"] = default_version
        __props__.__dict__["description"] = description
        __props__.__dict__["document"] = document
        __props__.__dict__["force"] = force
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_document"] = policy_document
        __props__.__dict__["policy_name"] = policy_name
        __props__.__dict__["rotate_strategy"] = rotate_strategy
        __props__.__dict__["statements"] = statements
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["version"] = version
        __props__.__dict__["version_id"] = version_id
        return Policy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="attachmentCount")
    def attachment_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of attachments of the policy.
        """
        return pulumi.get(self, "attachment_count")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.246.0) The create time of the policy.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> pulumi.Output[_builtins.str]:
        """
        The default version ID of the policy.
        """
        return pulumi.get(self, "default_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the policy. It can be 1 to 1024 characters in length.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'document' has been deprecated from provider version 1.114.0. New field 'policy_document' instead.""")
    def document(self) -> pulumi.Output[_builtins.str]:
        """
        Field `document` has been deprecated from provider version 1.114.0. New field `policy_document` instead.
        """
        return pulumi.get(self, "document")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to force delete the Policy. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.114.0. New field 'policy_name' instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field `name` has been deprecated from provider version 1.114.0. New field `policy_name` instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[_builtins.str]:
        """
        The content of the policy. The maximum length is 6144 bytes.
        """
        return pulumi.get(self, "policy_document")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Output[_builtins.str]:
        """
        The policy name. It can be 1 to 128 characters in length and can contain English letters, digits, and dashes (-).
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter(name="rotateStrategy")
    def rotate_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The automatic rotation mechanism of policy versions can delete historical policy versions. The default value is None. Valid values:
        - `None`: Turn off the rotation mechanism.
        - `DeleteOldestNonDefaultVersionWhenLimitExceeded`: When the number of permission policy versions exceeds the limit, the oldest and inactive version is deleted.
        """
        return pulumi.get(self, "rotate_strategy")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'statement' has been deprecated from version 1.49.0, and use field 'document' to replace. """)
    def statements(self) -> pulumi.Output[Sequence['outputs.PolicyStatement']]:
        """
        Field `statement` has been deprecated from provider version 1.49.0. New field `document` instead. See `statement` below.
        """
        return pulumi.get(self, "statements")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The list of tags on the policy.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the policy.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'version' has been deprecated from version 1.49.0, and use field 'document' to replace. """)
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Field `version` has been deprecated from provider version 1.49.0. New field `document` instead.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the default policy version.
        """
        return pulumi.get(self, "version_id")

