# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RoleAttachmentArgs', 'RoleAttachment']

@pulumi.input_type
class RoleAttachmentArgs:
    def __init__(__self__, *,
                 instance_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 role_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a RoleAttachment resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_ids: The list of ECS instance's IDs.
        :param pulumi.Input[_builtins.str] role_name: The name of role used to bind. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-", "_", and must not begin with a hyphen.
        """
        pulumi.set(__self__, "instance_ids", instance_ids)
        pulumi.set(__self__, "role_name", role_name)

    @_builtins.property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of ECS instance's IDs.
        """
        return pulumi.get(self, "instance_ids")

    @instance_ids.setter
    def instance_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "instance_ids", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of role used to bind. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-", "_", and must not begin with a hyphen.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_name", value)


@pulumi.input_type
class _RoleAttachmentState:
    def __init__(__self__, *,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RoleAttachment resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_ids: The list of ECS instance's IDs.
        :param pulumi.Input[_builtins.str] role_name: The name of role used to bind. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-", "_", and must not begin with a hyphen.
        """
        if instance_ids is not None:
            pulumi.set(__self__, "instance_ids", instance_ids)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)

    @_builtins.property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of ECS instance's IDs.
        """
        return pulumi.get(self, "instance_ids")

    @instance_ids.setter
    def instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_ids", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of role used to bind. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-", "_", and must not begin with a hyphen.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)


@pulumi.type_token("alicloud:ram/roleAttachment:RoleAttachment")
class RoleAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a RAM role attachment resource to bind role for several ECS instances.

        > **NOTE:** Deprecated since v1.250.0.

        > **DEPRECATED:** This resource has been deprecated from version `1.250.0`. Please use new resource alicloud_ecs_ram_role_attachment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=2,
            memory_size=8,
            instance_type_family="ecs.g6")
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "ecsInstanceVPCExample"
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            security_group_name=name,
            vpc_id=default_network.id)
        default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
            type="ingress",
            ip_protocol="tcp",
            nic_type="intranet",
            policy="accept",
            port_range="22/22",
            priority=1,
            security_group_id=default_security_group.id,
            cidr_ip="172.16.0.0/24")
        foo = alicloud.ecs.Instance("foo",
            vswitch_id=default_switch.id,
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            system_disk_category="cloud_efficiency",
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=5,
            security_groups=[default_security_group.id],
            instance_name=name)
        role = alicloud.ram.Role("role",
            name="terraform-example",
            document=\"\"\"  {
            "Statement": [
              {
                "Action": "sts:AssumeRole",
                "Effect": "Allow",
                "Principal": {
                  "Service": [
                    "ecs.aliyuncs.com"
                  ]
                }
              }
            ],
            "Version": "1"
          }

        \"\"\",
            description="this is a test",
            force=True)
        attach = alicloud.ram.RoleAttachment("attach",
            role_name=role.name,
            instance_ids=[__item.id for __item in [foo]])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_ids: The list of ECS instance's IDs.
        :param pulumi.Input[_builtins.str] role_name: The name of role used to bind. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-", "_", and must not begin with a hyphen.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoleAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a RAM role attachment resource to bind role for several ECS instances.

        > **NOTE:** Deprecated since v1.250.0.

        > **DEPRECATED:** This resource has been deprecated from version `1.250.0`. Please use new resource alicloud_ecs_ram_role_attachment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=2,
            memory_size=8,
            instance_type_family="ecs.g6")
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "ecsInstanceVPCExample"
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("default",
            security_group_name=name,
            vpc_id=default_network.id)
        default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
            type="ingress",
            ip_protocol="tcp",
            nic_type="intranet",
            policy="accept",
            port_range="22/22",
            priority=1,
            security_group_id=default_security_group.id,
            cidr_ip="172.16.0.0/24")
        foo = alicloud.ecs.Instance("foo",
            vswitch_id=default_switch.id,
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            system_disk_category="cloud_efficiency",
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=5,
            security_groups=[default_security_group.id],
            instance_name=name)
        role = alicloud.ram.Role("role",
            name="terraform-example",
            document=\"\"\"  {
            "Statement": [
              {
                "Action": "sts:AssumeRole",
                "Effect": "Allow",
                "Principal": {
                  "Service": [
                    "ecs.aliyuncs.com"
                  ]
                }
              }
            ],
            "Version": "1"
          }

        \"\"\",
            description="this is a test",
            force=True)
        attach = alicloud.ram.RoleAttachment("attach",
            role_name=role.name,
            instance_ids=[__item.id for __item in [foo]])
        ```

        :param str resource_name: The name of the resource.
        :param RoleAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoleAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoleAttachmentArgs.__new__(RoleAttachmentArgs)

            if instance_ids is None and not opts.urn:
                raise TypeError("Missing required property 'instance_ids'")
            __props__.__dict__["instance_ids"] = instance_ids
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
        super(RoleAttachment, __self__).__init__(
            'alicloud:ram/roleAttachment:RoleAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'RoleAttachment':
        """
        Get an existing RoleAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_ids: The list of ECS instance's IDs.
        :param pulumi.Input[_builtins.str] role_name: The name of role used to bind. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-", "_", and must not begin with a hyphen.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoleAttachmentState.__new__(_RoleAttachmentState)

        __props__.__dict__["instance_ids"] = instance_ids
        __props__.__dict__["role_name"] = role_name
        return RoleAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of ECS instance's IDs.
        """
        return pulumi.get(self, "instance_ids")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of role used to bind. This name can have a string of 1 to 64 characters, must contain only alphanumeric characters or hyphens, such as "-", "_", and must not begin with a hyphen.
        """
        return pulumi.get(self, "role_name")

