# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WhitelistTemplateArgs', 'WhitelistTemplate']

@pulumi.input_type
class WhitelistTemplateArgs:
    def __init__(__self__, *,
                 ip_white_list: pulumi.Input[_builtins.str],
                 template_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a WhitelistTemplate resource.
        :param pulumi.Input[_builtins.str] ip_white_list: IP whitelist, multiple IP addresses should be separated by commas (,) and cannot be duplicated.Supports the following two formats:
               - IP address format, for example: 10.23.XX.XX.
               - CIDR format, for example: 10.23.XX.XX/24 (no inter domain routing, 24 represents the length of the prefix in the address, ranging from 1 to 32).
        :param pulumi.Input[_builtins.str] template_name: Whitelist template name. Passed in when creating a template, and cannot have the same name under the same account, starting with a letter.
        """
        pulumi.set(__self__, "ip_white_list", ip_white_list)
        pulumi.set(__self__, "template_name", template_name)

    @_builtins.property
    @pulumi.getter(name="ipWhiteList")
    def ip_white_list(self) -> pulumi.Input[_builtins.str]:
        """
        IP whitelist, multiple IP addresses should be separated by commas (,) and cannot be duplicated.Supports the following two formats:
        - IP address format, for example: 10.23.XX.XX.
        - CIDR format, for example: 10.23.XX.XX/24 (no inter domain routing, 24 represents the length of the prefix in the address, ranging from 1 to 32).
        """
        return pulumi.get(self, "ip_white_list")

    @ip_white_list.setter
    def ip_white_list(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip_white_list", value)

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Input[_builtins.str]:
        """
        Whitelist template name. Passed in when creating a template, and cannot have the same name under the same account, starting with a letter.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "template_name", value)


@pulumi.input_type
class _WhitelistTemplateState:
    def __init__(__self__, *,
                 ip_white_list: Optional[pulumi.Input[_builtins.str]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WhitelistTemplate resources.
        :param pulumi.Input[_builtins.str] ip_white_list: IP whitelist, multiple IP addresses should be separated by commas (,) and cannot be duplicated.Supports the following two formats:
               - IP address format, for example: 10.23.XX.XX.
               - CIDR format, for example: 10.23.XX.XX/24 (no inter domain routing, 24 represents the length of the prefix in the address, ranging from 1 to 32).
        :param pulumi.Input[_builtins.str] template_name: Whitelist template name. Passed in when creating a template, and cannot have the same name under the same account, starting with a letter.
        """
        if ip_white_list is not None:
            pulumi.set(__self__, "ip_white_list", ip_white_list)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)

    @_builtins.property
    @pulumi.getter(name="ipWhiteList")
    def ip_white_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP whitelist, multiple IP addresses should be separated by commas (,) and cannot be duplicated.Supports the following two formats:
        - IP address format, for example: 10.23.XX.XX.
        - CIDR format, for example: 10.23.XX.XX/24 (no inter domain routing, 24 represents the length of the prefix in the address, ranging from 1 to 32).
        """
        return pulumi.get(self, "ip_white_list")

    @ip_white_list.setter
    def ip_white_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_white_list", value)

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whitelist template name. Passed in when creating a template, and cannot have the same name under the same account, starting with a letter.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_name", value)


@pulumi.type_token("alicloud:rds/whitelistTemplate:WhitelistTemplate")
class WhitelistTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_white_list: Optional[pulumi.Input[_builtins.str]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provide a whitelist template resource.

        For information about Resource AliCloudWhitelistTemplate and how to use it, see [What is Whitelist Template](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-modifywhitelisttemplate?).

        > **NOTE:** Available since v1.254.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.rds.WhitelistTemplate("example",
            ip_white_list="172.16.0.0",
            template_name="example-whitelist")
        ```

        ## Import

        You can use the whitelist template ID to import whitelist templates, e.g.

        ```sh
        $ pulumi import alicloud:rds/whitelistTemplate:WhitelistTemplate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ip_white_list: IP whitelist, multiple IP addresses should be separated by commas (,) and cannot be duplicated.Supports the following two formats:
               - IP address format, for example: 10.23.XX.XX.
               - CIDR format, for example: 10.23.XX.XX/24 (no inter domain routing, 24 represents the length of the prefix in the address, ranging from 1 to 32).
        :param pulumi.Input[_builtins.str] template_name: Whitelist template name. Passed in when creating a template, and cannot have the same name under the same account, starting with a letter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WhitelistTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provide a whitelist template resource.

        For information about Resource AliCloudWhitelistTemplate and how to use it, see [What is Whitelist Template](https://www.alibabacloud.com/help/en/rds/developer-reference/api-rds-2014-08-15-modifywhitelisttemplate?).

        > **NOTE:** Available since v1.254.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.rds.WhitelistTemplate("example",
            ip_white_list="172.16.0.0",
            template_name="example-whitelist")
        ```

        ## Import

        You can use the whitelist template ID to import whitelist templates, e.g.

        ```sh
        $ pulumi import alicloud:rds/whitelistTemplate:WhitelistTemplate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param WhitelistTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WhitelistTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_white_list: Optional[pulumi.Input[_builtins.str]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WhitelistTemplateArgs.__new__(WhitelistTemplateArgs)

            if ip_white_list is None and not opts.urn:
                raise TypeError("Missing required property 'ip_white_list'")
            __props__.__dict__["ip_white_list"] = ip_white_list
            if template_name is None and not opts.urn:
                raise TypeError("Missing required property 'template_name'")
            __props__.__dict__["template_name"] = template_name
        super(WhitelistTemplate, __self__).__init__(
            'alicloud:rds/whitelistTemplate:WhitelistTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ip_white_list: Optional[pulumi.Input[_builtins.str]] = None,
            template_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'WhitelistTemplate':
        """
        Get an existing WhitelistTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ip_white_list: IP whitelist, multiple IP addresses should be separated by commas (,) and cannot be duplicated.Supports the following two formats:
               - IP address format, for example: 10.23.XX.XX.
               - CIDR format, for example: 10.23.XX.XX/24 (no inter domain routing, 24 represents the length of the prefix in the address, ranging from 1 to 32).
        :param pulumi.Input[_builtins.str] template_name: Whitelist template name. Passed in when creating a template, and cannot have the same name under the same account, starting with a letter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WhitelistTemplateState.__new__(_WhitelistTemplateState)

        __props__.__dict__["ip_white_list"] = ip_white_list
        __props__.__dict__["template_name"] = template_name
        return WhitelistTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ipWhiteList")
    def ip_white_list(self) -> pulumi.Output[_builtins.str]:
        """
        IP whitelist, multiple IP addresses should be separated by commas (,) and cannot be duplicated.Supports the following two formats:
        - IP address format, for example: 10.23.XX.XX.
        - CIDR format, for example: 10.23.XX.XX/24 (no inter domain routing, 24 represents the length of the prefix in the address, ranging from 1 to 32).
        """
        return pulumi.get(self, "ip_white_list")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[_builtins.str]:
        """
        Whitelist template name. Passed in when creating a template, and cannot have the same name under the same account, starting with a letter.
        """
        return pulumi.get(self, "template_name")

