# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StackInstanceArgs', 'StackInstance']

@pulumi.input_type
class StackInstanceArgs:
    def __init__(__self__, *,
                 stack_group_name: pulumi.Input[_builtins.str],
                 stack_instance_account_id: pulumi.Input[_builtins.str],
                 stack_instance_region_id: pulumi.Input[_builtins.str],
                 operation_description: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_preferences: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['StackInstanceParameterOverrideArgs']]]] = None,
                 retain_stacks: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeout_in_minutes: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StackInstance resource.
        :param pulumi.Input[_builtins.str] stack_group_name: The name of the stack group.
        :param pulumi.Input[_builtins.str] stack_instance_account_id: The account to which the stack instance belongs.
        :param pulumi.Input[_builtins.str] stack_instance_region_id: The region of the stack instance.
        :param pulumi.Input[_builtins.str] operation_description: The operation description.
        :param pulumi.Input[_builtins.str] operation_preferences: The operation preferences. The operation settings. The following fields are supported:
               * `FailureToleranceCount` The maximum number of stack group operation failures that can occur. In a stack group operation, if the total number of failures does not exceed the FailureToleranceCount value, the operation succeeds. Otherwise, the operation fails. If the FailureToleranceCount parameter is not specified, the default value 0 is used. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `20`.
               * `FailureTolerancePercentage`: The percentage of stack group operation failures that can occur. In a stack group operation, if the percentage of failures does not exceed the FailureTolerancePercentage value, the operation succeeds. Otherwise, the operation fails. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `100`.
               * `MaxConcurrentCount`: The maximum number of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `20`.
               * `MaxConcurrentPercentage`: The maximum percentage of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `100`
        :param pulumi.Input[Sequence[pulumi.Input['StackInstanceParameterOverrideArgs']]] parameter_overrides: ParameterOverrides. See the following `Block parameter_overrides`.
        :param pulumi.Input[_builtins.bool] retain_stacks: Specifies whether to retain the stack corresponding to the stack instance.Default value `false`. **NOTE:** When `retain_stacks` is `true`, the stack is retained. If the stack is retained, the corresponding stack is not deleted when the stack instance is deleted from the stack group.
        :param pulumi.Input[_builtins.str] timeout_in_minutes: The timeout period that is specified for the stack creation request. Default value: `60`. Unit: `minutes`.
        """
        pulumi.set(__self__, "stack_group_name", stack_group_name)
        pulumi.set(__self__, "stack_instance_account_id", stack_instance_account_id)
        pulumi.set(__self__, "stack_instance_region_id", stack_instance_region_id)
        if operation_description is not None:
            pulumi.set(__self__, "operation_description", operation_description)
        if operation_preferences is not None:
            pulumi.set(__self__, "operation_preferences", operation_preferences)
        if parameter_overrides is not None:
            pulumi.set(__self__, "parameter_overrides", parameter_overrides)
        if retain_stacks is not None:
            pulumi.set(__self__, "retain_stacks", retain_stacks)
        if timeout_in_minutes is not None:
            pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @_builtins.property
    @pulumi.getter(name="stackGroupName")
    def stack_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the stack group.
        """
        return pulumi.get(self, "stack_group_name")

    @stack_group_name.setter
    def stack_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack_group_name", value)

    @_builtins.property
    @pulumi.getter(name="stackInstanceAccountId")
    def stack_instance_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The account to which the stack instance belongs.
        """
        return pulumi.get(self, "stack_instance_account_id")

    @stack_instance_account_id.setter
    def stack_instance_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack_instance_account_id", value)

    @_builtins.property
    @pulumi.getter(name="stackInstanceRegionId")
    def stack_instance_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The region of the stack instance.
        """
        return pulumi.get(self, "stack_instance_region_id")

    @stack_instance_region_id.setter
    def stack_instance_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stack_instance_region_id", value)

    @_builtins.property
    @pulumi.getter(name="operationDescription")
    def operation_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation description.
        """
        return pulumi.get(self, "operation_description")

    @operation_description.setter
    def operation_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_description", value)

    @_builtins.property
    @pulumi.getter(name="operationPreferences")
    def operation_preferences(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation preferences. The operation settings. The following fields are supported:
        * `FailureToleranceCount` The maximum number of stack group operation failures that can occur. In a stack group operation, if the total number of failures does not exceed the FailureToleranceCount value, the operation succeeds. Otherwise, the operation fails. If the FailureToleranceCount parameter is not specified, the default value 0 is used. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `20`.
        * `FailureTolerancePercentage`: The percentage of stack group operation failures that can occur. In a stack group operation, if the percentage of failures does not exceed the FailureTolerancePercentage value, the operation succeeds. Otherwise, the operation fails. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `100`.
        * `MaxConcurrentCount`: The maximum number of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `20`.
        * `MaxConcurrentPercentage`: The maximum percentage of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `100`
        """
        return pulumi.get(self, "operation_preferences")

    @operation_preferences.setter
    def operation_preferences(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_preferences", value)

    @_builtins.property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackInstanceParameterOverrideArgs']]]]:
        """
        ParameterOverrides. See the following `Block parameter_overrides`.
        """
        return pulumi.get(self, "parameter_overrides")

    @parameter_overrides.setter
    def parameter_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackInstanceParameterOverrideArgs']]]]):
        pulumi.set(self, "parameter_overrides", value)

    @_builtins.property
    @pulumi.getter(name="retainStacks")
    def retain_stacks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to retain the stack corresponding to the stack instance.Default value `false`. **NOTE:** When `retain_stacks` is `true`, the stack is retained. If the stack is retained, the corresponding stack is not deleted when the stack instance is deleted from the stack group.
        """
        return pulumi.get(self, "retain_stacks")

    @retain_stacks.setter
    def retain_stacks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retain_stacks", value)

    @_builtins.property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timeout period that is specified for the stack creation request. Default value: `60`. Unit: `minutes`.
        """
        return pulumi.get(self, "timeout_in_minutes")

    @timeout_in_minutes.setter
    def timeout_in_minutes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timeout_in_minutes", value)


@pulumi.input_type
class _StackInstanceState:
    def __init__(__self__, *,
                 operation_description: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_preferences: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['StackInstanceParameterOverrideArgs']]]] = None,
                 retain_stacks: Optional[pulumi.Input[_builtins.bool]] = None,
                 stack_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_instance_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_instance_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_in_minutes: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StackInstance resources.
        :param pulumi.Input[_builtins.str] operation_description: The operation description.
        :param pulumi.Input[_builtins.str] operation_preferences: The operation preferences. The operation settings. The following fields are supported:
               * `FailureToleranceCount` The maximum number of stack group operation failures that can occur. In a stack group operation, if the total number of failures does not exceed the FailureToleranceCount value, the operation succeeds. Otherwise, the operation fails. If the FailureToleranceCount parameter is not specified, the default value 0 is used. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `20`.
               * `FailureTolerancePercentage`: The percentage of stack group operation failures that can occur. In a stack group operation, if the percentage of failures does not exceed the FailureTolerancePercentage value, the operation succeeds. Otherwise, the operation fails. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `100`.
               * `MaxConcurrentCount`: The maximum number of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `20`.
               * `MaxConcurrentPercentage`: The maximum percentage of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `100`
        :param pulumi.Input[Sequence[pulumi.Input['StackInstanceParameterOverrideArgs']]] parameter_overrides: ParameterOverrides. See the following `Block parameter_overrides`.
        :param pulumi.Input[_builtins.bool] retain_stacks: Specifies whether to retain the stack corresponding to the stack instance.Default value `false`. **NOTE:** When `retain_stacks` is `true`, the stack is retained. If the stack is retained, the corresponding stack is not deleted when the stack instance is deleted from the stack group.
        :param pulumi.Input[_builtins.str] stack_group_name: The name of the stack group.
        :param pulumi.Input[_builtins.str] stack_instance_account_id: The account to which the stack instance belongs.
        :param pulumi.Input[_builtins.str] stack_instance_region_id: The region of the stack instance.
        :param pulumi.Input[_builtins.str] status: The status of the stack instance. Valid values: `CURRENT` or `OUTDATED`. 
               * `CURRENT`: The stack corresponding to the stack instance is up to date with the stack group.
               * `OUTDATED`: The stack corresponding to the stack instance is not up to date with the stack group. The `OUTDATED` state has the following possible causes:
               * When the CreateStackInstances operation is called to create stack instances, the corresponding stacks fail to be created.
               * When the UpdateStackInstances or UpdateStackGroup operation is called to update stack instances, the corresponding stacks fail to be updated, or only some of the stack instances are updated.
               * The create or update operation is not complete.
        :param pulumi.Input[_builtins.str] timeout_in_minutes: The timeout period that is specified for the stack creation request. Default value: `60`. Unit: `minutes`.
        """
        if operation_description is not None:
            pulumi.set(__self__, "operation_description", operation_description)
        if operation_preferences is not None:
            pulumi.set(__self__, "operation_preferences", operation_preferences)
        if parameter_overrides is not None:
            pulumi.set(__self__, "parameter_overrides", parameter_overrides)
        if retain_stacks is not None:
            pulumi.set(__self__, "retain_stacks", retain_stacks)
        if stack_group_name is not None:
            pulumi.set(__self__, "stack_group_name", stack_group_name)
        if stack_instance_account_id is not None:
            pulumi.set(__self__, "stack_instance_account_id", stack_instance_account_id)
        if stack_instance_region_id is not None:
            pulumi.set(__self__, "stack_instance_region_id", stack_instance_region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timeout_in_minutes is not None:
            pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @_builtins.property
    @pulumi.getter(name="operationDescription")
    def operation_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation description.
        """
        return pulumi.get(self, "operation_description")

    @operation_description.setter
    def operation_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_description", value)

    @_builtins.property
    @pulumi.getter(name="operationPreferences")
    def operation_preferences(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation preferences. The operation settings. The following fields are supported:
        * `FailureToleranceCount` The maximum number of stack group operation failures that can occur. In a stack group operation, if the total number of failures does not exceed the FailureToleranceCount value, the operation succeeds. Otherwise, the operation fails. If the FailureToleranceCount parameter is not specified, the default value 0 is used. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `20`.
        * `FailureTolerancePercentage`: The percentage of stack group operation failures that can occur. In a stack group operation, if the percentage of failures does not exceed the FailureTolerancePercentage value, the operation succeeds. Otherwise, the operation fails. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `100`.
        * `MaxConcurrentCount`: The maximum number of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `20`.
        * `MaxConcurrentPercentage`: The maximum percentage of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `100`
        """
        return pulumi.get(self, "operation_preferences")

    @operation_preferences.setter
    def operation_preferences(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation_preferences", value)

    @_builtins.property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackInstanceParameterOverrideArgs']]]]:
        """
        ParameterOverrides. See the following `Block parameter_overrides`.
        """
        return pulumi.get(self, "parameter_overrides")

    @parameter_overrides.setter
    def parameter_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackInstanceParameterOverrideArgs']]]]):
        pulumi.set(self, "parameter_overrides", value)

    @_builtins.property
    @pulumi.getter(name="retainStacks")
    def retain_stacks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to retain the stack corresponding to the stack instance.Default value `false`. **NOTE:** When `retain_stacks` is `true`, the stack is retained. If the stack is retained, the corresponding stack is not deleted when the stack instance is deleted from the stack group.
        """
        return pulumi.get(self, "retain_stacks")

    @retain_stacks.setter
    def retain_stacks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retain_stacks", value)

    @_builtins.property
    @pulumi.getter(name="stackGroupName")
    def stack_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the stack group.
        """
        return pulumi.get(self, "stack_group_name")

    @stack_group_name.setter
    def stack_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_group_name", value)

    @_builtins.property
    @pulumi.getter(name="stackInstanceAccountId")
    def stack_instance_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account to which the stack instance belongs.
        """
        return pulumi.get(self, "stack_instance_account_id")

    @stack_instance_account_id.setter
    def stack_instance_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_instance_account_id", value)

    @_builtins.property
    @pulumi.getter(name="stackInstanceRegionId")
    def stack_instance_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the stack instance.
        """
        return pulumi.get(self, "stack_instance_region_id")

    @stack_instance_region_id.setter
    def stack_instance_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_instance_region_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the stack instance. Valid values: `CURRENT` or `OUTDATED`. 
        * `CURRENT`: The stack corresponding to the stack instance is up to date with the stack group.
        * `OUTDATED`: The stack corresponding to the stack instance is not up to date with the stack group. The `OUTDATED` state has the following possible causes:
        * When the CreateStackInstances operation is called to create stack instances, the corresponding stacks fail to be created.
        * When the UpdateStackInstances or UpdateStackGroup operation is called to update stack instances, the corresponding stacks fail to be updated, or only some of the stack instances are updated.
        * The create or update operation is not complete.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timeout period that is specified for the stack creation request. Default value: `60`. Unit: `minutes`.
        """
        return pulumi.get(self, "timeout_in_minutes")

    @timeout_in_minutes.setter
    def timeout_in_minutes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timeout_in_minutes", value)


@pulumi.type_token("alicloud:ros/stackInstance:StackInstance")
class StackInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 operation_description: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_preferences: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackInstanceParameterOverrideArgs', 'StackInstanceParameterOverrideArgsDict']]]]] = None,
                 retain_stacks: Optional[pulumi.Input[_builtins.bool]] = None,
                 stack_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_instance_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_instance_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_in_minutes: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ROS Stack Instance resource.

        For information about ROS Stack Instance and how to use it, see [What is Stack Instance](https://www.alibabacloud.com/help/en/doc-detail/151338.html).

        > **NOTE:** Available since v1.145.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        this = alicloud.get_account()
        default = alicloud.ros.get_regions()
        default_stack_group = alicloud.ros.StackGroup("default",
            stack_group_name=name,
            template_body="{\\"ROSTemplateFormatVersion\\":\\"2015-09-01\\", \\"Parameters\\": {\\"VpcName\\": {\\"Type\\": \\"String\\"},\\"InstanceType\\": {\\"Type\\": \\"String\\"}}}",
            description="test for stack groups",
            parameters=[
                {
                    "parameter_key": "VpcName",
                    "parameter_value": "VpcName",
                },
                {
                    "parameter_key": "InstanceType",
                    "parameter_value": "InstanceType",
                },
            ])
        example = alicloud.ros.StackInstance("example",
            stack_group_name=default_stack_group.stack_group_name,
            stack_instance_account_id=this.id,
            stack_instance_region_id=default.regions[0].region_id,
            operation_preferences="{\\"FailureToleranceCount\\": 1, \\"MaxConcurrentCount\\": 2}",
            timeout_in_minutes="60",
            operation_description="tf-example",
            retain_stacks=True,
            parameter_overrides=[{
                "parameter_value": "VpcName",
                "parameter_key": "VpcName",
            }])
        ```

        ## Import

        ROS Stack Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ros/stackInstance:StackInstance example <stack_group_name>:<stack_instance_account_id>:<stack_instance_region_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] operation_description: The operation description.
        :param pulumi.Input[_builtins.str] operation_preferences: The operation preferences. The operation settings. The following fields are supported:
               * `FailureToleranceCount` The maximum number of stack group operation failures that can occur. In a stack group operation, if the total number of failures does not exceed the FailureToleranceCount value, the operation succeeds. Otherwise, the operation fails. If the FailureToleranceCount parameter is not specified, the default value 0 is used. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `20`.
               * `FailureTolerancePercentage`: The percentage of stack group operation failures that can occur. In a stack group operation, if the percentage of failures does not exceed the FailureTolerancePercentage value, the operation succeeds. Otherwise, the operation fails. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `100`.
               * `MaxConcurrentCount`: The maximum number of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `20`.
               * `MaxConcurrentPercentage`: The maximum percentage of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `100`
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackInstanceParameterOverrideArgs', 'StackInstanceParameterOverrideArgsDict']]]] parameter_overrides: ParameterOverrides. See the following `Block parameter_overrides`.
        :param pulumi.Input[_builtins.bool] retain_stacks: Specifies whether to retain the stack corresponding to the stack instance.Default value `false`. **NOTE:** When `retain_stacks` is `true`, the stack is retained. If the stack is retained, the corresponding stack is not deleted when the stack instance is deleted from the stack group.
        :param pulumi.Input[_builtins.str] stack_group_name: The name of the stack group.
        :param pulumi.Input[_builtins.str] stack_instance_account_id: The account to which the stack instance belongs.
        :param pulumi.Input[_builtins.str] stack_instance_region_id: The region of the stack instance.
        :param pulumi.Input[_builtins.str] timeout_in_minutes: The timeout period that is specified for the stack creation request. Default value: `60`. Unit: `minutes`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StackInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ROS Stack Instance resource.

        For information about ROS Stack Instance and how to use it, see [What is Stack Instance](https://www.alibabacloud.com/help/en/doc-detail/151338.html).

        > **NOTE:** Available since v1.145.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        this = alicloud.get_account()
        default = alicloud.ros.get_regions()
        default_stack_group = alicloud.ros.StackGroup("default",
            stack_group_name=name,
            template_body="{\\"ROSTemplateFormatVersion\\":\\"2015-09-01\\", \\"Parameters\\": {\\"VpcName\\": {\\"Type\\": \\"String\\"},\\"InstanceType\\": {\\"Type\\": \\"String\\"}}}",
            description="test for stack groups",
            parameters=[
                {
                    "parameter_key": "VpcName",
                    "parameter_value": "VpcName",
                },
                {
                    "parameter_key": "InstanceType",
                    "parameter_value": "InstanceType",
                },
            ])
        example = alicloud.ros.StackInstance("example",
            stack_group_name=default_stack_group.stack_group_name,
            stack_instance_account_id=this.id,
            stack_instance_region_id=default.regions[0].region_id,
            operation_preferences="{\\"FailureToleranceCount\\": 1, \\"MaxConcurrentCount\\": 2}",
            timeout_in_minutes="60",
            operation_description="tf-example",
            retain_stacks=True,
            parameter_overrides=[{
                "parameter_value": "VpcName",
                "parameter_key": "VpcName",
            }])
        ```

        ## Import

        ROS Stack Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ros/stackInstance:StackInstance example <stack_group_name>:<stack_instance_account_id>:<stack_instance_region_id>
        ```

        :param str resource_name: The name of the resource.
        :param StackInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StackInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 operation_description: Optional[pulumi.Input[_builtins.str]] = None,
                 operation_preferences: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackInstanceParameterOverrideArgs', 'StackInstanceParameterOverrideArgsDict']]]]] = None,
                 retain_stacks: Optional[pulumi.Input[_builtins.bool]] = None,
                 stack_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_instance_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_instance_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_in_minutes: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StackInstanceArgs.__new__(StackInstanceArgs)

            __props__.__dict__["operation_description"] = operation_description
            __props__.__dict__["operation_preferences"] = operation_preferences
            __props__.__dict__["parameter_overrides"] = None if parameter_overrides is None else pulumi.Output.secret(parameter_overrides)
            __props__.__dict__["retain_stacks"] = retain_stacks
            if stack_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'stack_group_name'")
            __props__.__dict__["stack_group_name"] = stack_group_name
            if stack_instance_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'stack_instance_account_id'")
            __props__.__dict__["stack_instance_account_id"] = stack_instance_account_id
            if stack_instance_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'stack_instance_region_id'")
            __props__.__dict__["stack_instance_region_id"] = stack_instance_region_id
            __props__.__dict__["timeout_in_minutes"] = timeout_in_minutes
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["parameterOverrides"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(StackInstance, __self__).__init__(
            'alicloud:ros/stackInstance:StackInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            operation_description: Optional[pulumi.Input[_builtins.str]] = None,
            operation_preferences: Optional[pulumi.Input[_builtins.str]] = None,
            parameter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackInstanceParameterOverrideArgs', 'StackInstanceParameterOverrideArgsDict']]]]] = None,
            retain_stacks: Optional[pulumi.Input[_builtins.bool]] = None,
            stack_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            stack_instance_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            stack_instance_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            timeout_in_minutes: Optional[pulumi.Input[_builtins.str]] = None) -> 'StackInstance':
        """
        Get an existing StackInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] operation_description: The operation description.
        :param pulumi.Input[_builtins.str] operation_preferences: The operation preferences. The operation settings. The following fields are supported:
               * `FailureToleranceCount` The maximum number of stack group operation failures that can occur. In a stack group operation, if the total number of failures does not exceed the FailureToleranceCount value, the operation succeeds. Otherwise, the operation fails. If the FailureToleranceCount parameter is not specified, the default value 0 is used. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `20`.
               * `FailureTolerancePercentage`: The percentage of stack group operation failures that can occur. In a stack group operation, if the percentage of failures does not exceed the FailureTolerancePercentage value, the operation succeeds. Otherwise, the operation fails. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `100`.
               * `MaxConcurrentCount`: The maximum number of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `20`.
               * `MaxConcurrentPercentage`: The maximum percentage of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `100`
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackInstanceParameterOverrideArgs', 'StackInstanceParameterOverrideArgsDict']]]] parameter_overrides: ParameterOverrides. See the following `Block parameter_overrides`.
        :param pulumi.Input[_builtins.bool] retain_stacks: Specifies whether to retain the stack corresponding to the stack instance.Default value `false`. **NOTE:** When `retain_stacks` is `true`, the stack is retained. If the stack is retained, the corresponding stack is not deleted when the stack instance is deleted from the stack group.
        :param pulumi.Input[_builtins.str] stack_group_name: The name of the stack group.
        :param pulumi.Input[_builtins.str] stack_instance_account_id: The account to which the stack instance belongs.
        :param pulumi.Input[_builtins.str] stack_instance_region_id: The region of the stack instance.
        :param pulumi.Input[_builtins.str] status: The status of the stack instance. Valid values: `CURRENT` or `OUTDATED`. 
               * `CURRENT`: The stack corresponding to the stack instance is up to date with the stack group.
               * `OUTDATED`: The stack corresponding to the stack instance is not up to date with the stack group. The `OUTDATED` state has the following possible causes:
               * When the CreateStackInstances operation is called to create stack instances, the corresponding stacks fail to be created.
               * When the UpdateStackInstances or UpdateStackGroup operation is called to update stack instances, the corresponding stacks fail to be updated, or only some of the stack instances are updated.
               * The create or update operation is not complete.
        :param pulumi.Input[_builtins.str] timeout_in_minutes: The timeout period that is specified for the stack creation request. Default value: `60`. Unit: `minutes`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StackInstanceState.__new__(_StackInstanceState)

        __props__.__dict__["operation_description"] = operation_description
        __props__.__dict__["operation_preferences"] = operation_preferences
        __props__.__dict__["parameter_overrides"] = parameter_overrides
        __props__.__dict__["retain_stacks"] = retain_stacks
        __props__.__dict__["stack_group_name"] = stack_group_name
        __props__.__dict__["stack_instance_account_id"] = stack_instance_account_id
        __props__.__dict__["stack_instance_region_id"] = stack_instance_region_id
        __props__.__dict__["status"] = status
        __props__.__dict__["timeout_in_minutes"] = timeout_in_minutes
        return StackInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="operationDescription")
    def operation_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The operation description.
        """
        return pulumi.get(self, "operation_description")

    @_builtins.property
    @pulumi.getter(name="operationPreferences")
    def operation_preferences(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The operation preferences. The operation settings. The following fields are supported:
        * `FailureToleranceCount` The maximum number of stack group operation failures that can occur. In a stack group operation, if the total number of failures does not exceed the FailureToleranceCount value, the operation succeeds. Otherwise, the operation fails. If the FailureToleranceCount parameter is not specified, the default value 0 is used. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `20`.
        * `FailureTolerancePercentage`: The percentage of stack group operation failures that can occur. In a stack group operation, if the percentage of failures does not exceed the FailureTolerancePercentage value, the operation succeeds. Otherwise, the operation fails. You cannot specify both FailureToleranceCount and FailureTolerancePercentage. Valid values: `0` to `100`.
        * `MaxConcurrentCount`: The maximum number of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `20`.
        * `MaxConcurrentPercentage`: The maximum percentage of accounts within which to perform this operation at one time. You cannot specify both MaxConcurrentCount and MaxConcurrentPercentage. Valid values: `1` to `100`
        """
        return pulumi.get(self, "operation_preferences")

    @_builtins.property
    @pulumi.getter(name="parameterOverrides")
    def parameter_overrides(self) -> pulumi.Output[Optional[Sequence['outputs.StackInstanceParameterOverride']]]:
        """
        ParameterOverrides. See the following `Block parameter_overrides`.
        """
        return pulumi.get(self, "parameter_overrides")

    @_builtins.property
    @pulumi.getter(name="retainStacks")
    def retain_stacks(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to retain the stack corresponding to the stack instance.Default value `false`. **NOTE:** When `retain_stacks` is `true`, the stack is retained. If the stack is retained, the corresponding stack is not deleted when the stack instance is deleted from the stack group.
        """
        return pulumi.get(self, "retain_stacks")

    @_builtins.property
    @pulumi.getter(name="stackGroupName")
    def stack_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the stack group.
        """
        return pulumi.get(self, "stack_group_name")

    @_builtins.property
    @pulumi.getter(name="stackInstanceAccountId")
    def stack_instance_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The account to which the stack instance belongs.
        """
        return pulumi.get(self, "stack_instance_account_id")

    @_builtins.property
    @pulumi.getter(name="stackInstanceRegionId")
    def stack_instance_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the stack instance.
        """
        return pulumi.get(self, "stack_instance_region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the stack instance. Valid values: `CURRENT` or `OUTDATED`. 
        * `CURRENT`: The stack corresponding to the stack instance is up to date with the stack group.
        * `OUTDATED`: The stack corresponding to the stack instance is not up to date with the stack group. The `OUTDATED` state has the following possible causes:
        * When the CreateStackInstances operation is called to create stack instances, the corresponding stacks fail to be created.
        * When the UpdateStackInstances or UpdateStackGroup operation is called to update stack instances, the corresponding stacks fail to be updated, or only some of the stack instances are updated.
        * The create or update operation is not complete.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The timeout period that is specified for the stack creation request. Default value: `60`. Unit: `minutes`.
        """
        return pulumi.get(self, "timeout_in_minutes")

