# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[_builtins.str],
                 sources: pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]],
                 biz_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_infos: Optional[pulumi.Input[Sequence[pulumi.Input['DomainCertInfoArgs']]]] = None,
                 check_url: Optional[pulumi.Input[_builtins.str]] = None,
                 force_set: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[_builtins.str] domain_name: The name of domain.
        :param pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]] sources: the Origin Server Information. See the following `Block sources`.
        :param pulumi.Input[_builtins.str] biz_name: Attribute perm has been deprecated and suggest removing it from your template.
        :param pulumi.Input[Sequence[pulumi.Input['DomainCertInfoArgs']]] cert_infos: Certificate Information. See the following `Block cert_infos`.
        :param pulumi.Input[_builtins.str] check_url: The health check url.
        :param pulumi.Input[_builtins.str] force_set: Whether to set certificate forcibly.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group id.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `offline`, `online`.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "sources", sources)
        if biz_name is not None:
            warnings.warn("""Attribute biz_name has been deprecated and suggest removing it from your template.""", DeprecationWarning)
            pulumi.log.warn("""biz_name is deprecated: Attribute biz_name has been deprecated and suggest removing it from your template.""")
        if biz_name is not None:
            pulumi.set(__self__, "biz_name", biz_name)
        if cert_infos is not None:
            pulumi.set(__self__, "cert_infos", cert_infos)
        if check_url is not None:
            pulumi.set(__self__, "check_url", check_url)
        if force_set is not None:
            pulumi.set(__self__, "force_set", force_set)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]:
        """
        the Origin Server Information. See the following `Block sources`.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter(name="bizName")
    @_utilities.deprecated("""Attribute biz_name has been deprecated and suggest removing it from your template.""")
    def biz_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute perm has been deprecated and suggest removing it from your template.
        """
        return pulumi.get(self, "biz_name")

    @biz_name.setter
    def biz_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "biz_name", value)

    @_builtins.property
    @pulumi.getter(name="certInfos")
    def cert_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainCertInfoArgs']]]]:
        """
        Certificate Information. See the following `Block cert_infos`.
        """
        return pulumi.get(self, "cert_infos")

    @cert_infos.setter
    def cert_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainCertInfoArgs']]]]):
        pulumi.set(self, "cert_infos", value)

    @_builtins.property
    @pulumi.getter(name="checkUrl")
    def check_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The health check url.
        """
        return pulumi.get(self, "check_url")

    @check_url.setter
    def check_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check_url", value)

    @_builtins.property
    @pulumi.getter(name="forceSet")
    def force_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to set certificate forcibly.
        """
        return pulumi.get(self, "force_set")

    @force_set.setter
    def force_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force_set", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `offline`, `online`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 biz_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_infos: Optional[pulumi.Input[Sequence[pulumi.Input['DomainCertInfoArgs']]]] = None,
                 check_url: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 force_set: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input[_builtins.str] biz_name: Attribute perm has been deprecated and suggest removing it from your template.
        :param pulumi.Input[Sequence[pulumi.Input['DomainCertInfoArgs']]] cert_infos: Certificate Information. See the following `Block cert_infos`.
        :param pulumi.Input[_builtins.str] check_url: The health check url.
        :param pulumi.Input[_builtins.str] domain_name: The name of domain.
        :param pulumi.Input[_builtins.str] force_set: Whether to set certificate forcibly.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group id.
        :param pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]] sources: the Origin Server Information. See the following `Block sources`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `offline`, `online`.
        """
        if biz_name is not None:
            warnings.warn("""Attribute biz_name has been deprecated and suggest removing it from your template.""", DeprecationWarning)
            pulumi.log.warn("""biz_name is deprecated: Attribute biz_name has been deprecated and suggest removing it from your template.""")
        if biz_name is not None:
            pulumi.set(__self__, "biz_name", biz_name)
        if cert_infos is not None:
            pulumi.set(__self__, "cert_infos", cert_infos)
        if check_url is not None:
            pulumi.set(__self__, "check_url", check_url)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if force_set is not None:
            pulumi.set(__self__, "force_set", force_set)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="bizName")
    @_utilities.deprecated("""Attribute biz_name has been deprecated and suggest removing it from your template.""")
    def biz_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Attribute perm has been deprecated and suggest removing it from your template.
        """
        return pulumi.get(self, "biz_name")

    @biz_name.setter
    def biz_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "biz_name", value)

    @_builtins.property
    @pulumi.getter(name="certInfos")
    def cert_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainCertInfoArgs']]]]:
        """
        Certificate Information. See the following `Block cert_infos`.
        """
        return pulumi.get(self, "cert_infos")

    @cert_infos.setter
    def cert_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainCertInfoArgs']]]]):
        pulumi.set(self, "cert_infos", value)

    @_builtins.property
    @pulumi.getter(name="checkUrl")
    def check_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The health check url.
        """
        return pulumi.get(self, "check_url")

    @check_url.setter
    def check_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check_url", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="forceSet")
    def force_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to set certificate forcibly.
        """
        return pulumi.get(self, "force_set")

    @force_set.setter
    def force_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force_set", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]]:
        """
        the Origin Server Information. See the following `Block sources`.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `offline`, `online`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:scdn/domain:Domain")
class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 biz_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainCertInfoArgs', 'DomainCertInfoArgsDict']]]]] = None,
                 check_url: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 force_set: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainSourceArgs', 'DomainSourceArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a SCDN Domain resource.

        For information about SCDN Domain and how to use it, see [What is Domain](https://help.aliyun.com/document_detail/63672.html).

        > **NOTE:** Available since v1.131.0.

        > **NOTE:** Alibaba Cloud SCDN has stopped new customer purchases from January 26, 2023, and you can choose to buy Alibaba Cloud DCDN products with more comprehensive acceleration and protection capabilities. If you are already a SCDN customer, you can submit a work order at any time to apply for a smooth migration to Alibaba Cloud DCDN products. In the future, we will provide better acceleration and security protection services in Alibaba Cloud DCDN, thank you for your understanding and cooperation.

        > **DEPRECATED:**  This resource has been [deprecated](https://www.aliyun.com/product/scdn) from version `1.219.0`.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.scdn.Domain("example",
            domain_name="my-Domain",
            sources=[{
                "content": "xxx.aliyuncs.com",
                "enabled": "online",
                "port": 80,
                "priority": "20",
                "type": "oss",
            }])
        ```

        ## Import

        SCDN Domain can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:scdn/domain:Domain example <domain_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] biz_name: Attribute perm has been deprecated and suggest removing it from your template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainCertInfoArgs', 'DomainCertInfoArgsDict']]]] cert_infos: Certificate Information. See the following `Block cert_infos`.
        :param pulumi.Input[_builtins.str] check_url: The health check url.
        :param pulumi.Input[_builtins.str] domain_name: The name of domain.
        :param pulumi.Input[_builtins.str] force_set: Whether to set certificate forcibly.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group id.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainSourceArgs', 'DomainSourceArgsDict']]]] sources: the Origin Server Information. See the following `Block sources`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `offline`, `online`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SCDN Domain resource.

        For information about SCDN Domain and how to use it, see [What is Domain](https://help.aliyun.com/document_detail/63672.html).

        > **NOTE:** Available since v1.131.0.

        > **NOTE:** Alibaba Cloud SCDN has stopped new customer purchases from January 26, 2023, and you can choose to buy Alibaba Cloud DCDN products with more comprehensive acceleration and protection capabilities. If you are already a SCDN customer, you can submit a work order at any time to apply for a smooth migration to Alibaba Cloud DCDN products. In the future, we will provide better acceleration and security protection services in Alibaba Cloud DCDN, thank you for your understanding and cooperation.

        > **DEPRECATED:**  This resource has been [deprecated](https://www.aliyun.com/product/scdn) from version `1.219.0`.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.scdn.Domain("example",
            domain_name="my-Domain",
            sources=[{
                "content": "xxx.aliyuncs.com",
                "enabled": "online",
                "port": 80,
                "priority": "20",
                "type": "oss",
            }])
        ```

        ## Import

        SCDN Domain can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:scdn/domain:Domain example <domain_name>
        ```

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 biz_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainCertInfoArgs', 'DomainCertInfoArgsDict']]]]] = None,
                 check_url: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 force_set: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainSourceArgs', 'DomainSourceArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["biz_name"] = biz_name
            __props__.__dict__["cert_infos"] = cert_infos
            __props__.__dict__["check_url"] = check_url
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["force_set"] = force_set
            __props__.__dict__["resource_group_id"] = resource_group_id
            if sources is None and not opts.urn:
                raise TypeError("Missing required property 'sources'")
            __props__.__dict__["sources"] = sources
            __props__.__dict__["status"] = status
        super(Domain, __self__).__init__(
            'alicloud:scdn/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            biz_name: Optional[pulumi.Input[_builtins.str]] = None,
            cert_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainCertInfoArgs', 'DomainCertInfoArgsDict']]]]] = None,
            check_url: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            force_set: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainSourceArgs', 'DomainSourceArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] biz_name: Attribute perm has been deprecated and suggest removing it from your template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainCertInfoArgs', 'DomainCertInfoArgsDict']]]] cert_infos: Certificate Information. See the following `Block cert_infos`.
        :param pulumi.Input[_builtins.str] check_url: The health check url.
        :param pulumi.Input[_builtins.str] domain_name: The name of domain.
        :param pulumi.Input[_builtins.str] force_set: Whether to set certificate forcibly.
        :param pulumi.Input[_builtins.str] resource_group_id: The resource group id.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainSourceArgs', 'DomainSourceArgsDict']]]] sources: the Origin Server Information. See the following `Block sources`.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `offline`, `online`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["biz_name"] = biz_name
        __props__.__dict__["cert_infos"] = cert_infos
        __props__.__dict__["check_url"] = check_url
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["force_set"] = force_set
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["sources"] = sources
        __props__.__dict__["status"] = status
        return Domain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bizName")
    @_utilities.deprecated("""Attribute biz_name has been deprecated and suggest removing it from your template.""")
    def biz_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Attribute perm has been deprecated and suggest removing it from your template.
        """
        return pulumi.get(self, "biz_name")

    @_builtins.property
    @pulumi.getter(name="certInfos")
    def cert_infos(self) -> pulumi.Output[Optional[Sequence['outputs.DomainCertInfo']]]:
        """
        Certificate Information. See the following `Block cert_infos`.
        """
        return pulumi.get(self, "cert_infos")

    @_builtins.property
    @pulumi.getter(name="checkUrl")
    def check_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The health check url.
        """
        return pulumi.get(self, "check_url")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of domain.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="forceSet")
    def force_set(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to set certificate forcibly.
        """
        return pulumi.get(self, "force_set")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Sequence['outputs.DomainSource']]:
        """
        the Origin Server Information. See the following `Block sources`.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource. Valid values: `offline`, `online`.
        """
        return pulumi.get(self, "status")

