# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbInstanceArgs', 'DbInstance']

@pulumi.input_type
class DbInstanceArgs:
    def __init__(__self__, *,
                 cache_size: pulumi.Input[_builtins.int],
                 db_instance_class: pulumi.Input[_builtins.str],
                 db_instance_description: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 admin_pass: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDesiredSecurityIpListArgs']]]] = None,
                 enable_public_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 period_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgraded_engine_minor_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DbInstance resource.
        :param pulumi.Input[_builtins.int] cache_size: The cache size in DBInstance on creating default cluster. The number should be divided by 100.
        :param pulumi.Input[_builtins.str] db_instance_class: The class for default cluster in DBInstance. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        :param pulumi.Input[_builtins.str] db_instance_description: The DBInstance description.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC for DBInstance.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of vswitch for DBInstance.
        :param pulumi.Input[_builtins.str] zone_id: The ID of zone for DBInstance.
        :param pulumi.Input[_builtins.str] admin_pass: The password for DBInstance using admin account.
        :param pulumi.Input[Sequence[pulumi.Input['DbInstanceDesiredSecurityIpListArgs']]] desired_security_ip_lists: The modified IP address whitelists. See `desired_security_ip_lists` below.
        :param pulumi.Input[_builtins.bool] enable_public_network: If DBInstance need to open public network, set it to `true`.
        :param pulumi.Input[_builtins.str] engine_minor_version: The DBInstance minor version. Valid values: `3.0.12`,`4.0.4`.
        :param pulumi.Input[_builtins.str] period: It is valid when payment_type is `Subscription`. Valid values are `Year`, `Month`.
        :param pulumi.Input[_builtins.int] period_time: The duration that you will buy DBInstance. It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] upgraded_engine_minor_version: Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.
        """
        pulumi.set(__self__, "cache_size", cache_size)
        pulumi.set(__self__, "db_instance_class", db_instance_class)
        pulumi.set(__self__, "db_instance_description", db_instance_description)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if desired_security_ip_lists is not None:
            pulumi.set(__self__, "desired_security_ip_lists", desired_security_ip_lists)
        if enable_public_network is not None:
            pulumi.set(__self__, "enable_public_network", enable_public_network)
        if engine_minor_version is not None:
            pulumi.set(__self__, "engine_minor_version", engine_minor_version)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_time is not None:
            pulumi.set(__self__, "period_time", period_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upgraded_engine_minor_version is not None:
            warnings.warn("""Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.""", DeprecationWarning)
            pulumi.log.warn("""upgraded_engine_minor_version is deprecated: Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.""")
        if upgraded_engine_minor_version is not None:
            pulumi.set(__self__, "upgraded_engine_minor_version", upgraded_engine_minor_version)

    @_builtins.property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> pulumi.Input[_builtins.int]:
        """
        The cache size in DBInstance on creating default cluster. The number should be divided by 100.
        """
        return pulumi.get(self, "cache_size")

    @cache_size.setter
    def cache_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cache_size", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> pulumi.Input[_builtins.str]:
        """
        The class for default cluster in DBInstance. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        """
        return pulumi.get(self, "db_instance_class")

    @db_instance_class.setter
    def db_instance_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_class", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> pulumi.Input[_builtins.str]:
        """
        The DBInstance description.
        """
        return pulumi.get(self, "db_instance_description")

    @db_instance_description.setter
    def db_instance_description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_description", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC for DBInstance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of vswitch for DBInstance.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of zone for DBInstance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for DBInstance using admin account.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_pass", value)

    @_builtins.property
    @pulumi.getter(name="desiredSecurityIpLists")
    def desired_security_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDesiredSecurityIpListArgs']]]]:
        """
        The modified IP address whitelists. See `desired_security_ip_lists` below.
        """
        return pulumi.get(self, "desired_security_ip_lists")

    @desired_security_ip_lists.setter
    def desired_security_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDesiredSecurityIpListArgs']]]]):
        pulumi.set(self, "desired_security_ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="enablePublicNetwork")
    def enable_public_network(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If DBInstance need to open public network, set it to `true`.
        """
        return pulumi.get(self, "enable_public_network")

    @enable_public_network.setter
    def enable_public_network(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_public_network", value)

    @_builtins.property
    @pulumi.getter(name="engineMinorVersion")
    def engine_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DBInstance minor version. Valid values: `3.0.12`,`4.0.4`.
        """
        return pulumi.get(self, "engine_minor_version")

    @engine_minor_version.setter
    def engine_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_minor_version", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It is valid when payment_type is `Subscription`. Valid values are `Year`, `Month`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodTime")
    def period_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy DBInstance. It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
        """
        return pulumi.get(self, "period_time")

    @period_time.setter
    def period_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period_time", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="upgradedEngineMinorVersion")
    @_utilities.deprecated("""Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.""")
    def upgraded_engine_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.
        """
        return pulumi.get(self, "upgraded_engine_minor_version")

    @upgraded_engine_minor_version.setter
    def upgraded_engine_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgraded_engine_minor_version", value)


@pulumi.input_type
class _DbInstanceState:
    def __init__(__self__, *,
                 admin_pass: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_size_postpaid: Optional[pulumi.Input[_builtins.int]] = None,
                 cache_size_prepaid: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_count_postpaid: Optional[pulumi.Input[_builtins.int]] = None,
                 cluster_count_prepaid: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_postpaid: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_prepaid: Optional[pulumi.Input[_builtins.int]] = None,
                 db_instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDesiredSecurityIpListArgs']]]] = None,
                 enable_public_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 gmt_created: Optional[pulumi.Input[_builtins.str]] = None,
                 gmt_expired: Optional[pulumi.Input[_builtins.str]] = None,
                 gmt_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_net_infos: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceInstanceNetInfoArgs']]]] = None,
                 lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_postpaid: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_prepaid: Optional[pulumi.Input[_builtins.int]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 period_time: Optional[pulumi.Input[_builtins.int]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceSecurityIpListArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgraded_engine_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbInstance resources.
        :param pulumi.Input[_builtins.str] admin_pass: The password for DBInstance using admin account.
        :param pulumi.Input[_builtins.int] cache_size: The cache size in DBInstance on creating default cluster. The number should be divided by 100.
        :param pulumi.Input[_builtins.int] cache_size_postpaid: The sum of cache size for every `PayAsYouGo` clusters in DBInstance.
        :param pulumi.Input[_builtins.int] cache_size_prepaid: The sum of cache size for every `Subscription` clusters in DBInstance.
        :param pulumi.Input[_builtins.int] cluster_count_postpaid: The sum of cluster counts for `PayAsYouGo` clusters in DBInstance.
        :param pulumi.Input[_builtins.int] cluster_count_prepaid: The sum of cluster counts for `Subscription` clusters in DBInstance.
        :param pulumi.Input[_builtins.int] cpu_postpaid: The sum of cpu resource amount for every `PayAsYouGo` clusters in DBInstance.
        :param pulumi.Input[_builtins.int] cpu_prepaid: The sum of cpu resource amount for every `Subscription` clusters in DBInstance.
        :param pulumi.Input[_builtins.str] db_instance_class: The class for default cluster in DBInstance. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        :param pulumi.Input[_builtins.str] db_instance_description: The DBInstance description.
        :param pulumi.Input[Sequence[pulumi.Input['DbInstanceDesiredSecurityIpListArgs']]] desired_security_ip_lists: The modified IP address whitelists. See `desired_security_ip_lists` below.
        :param pulumi.Input[_builtins.bool] enable_public_network: If DBInstance need to open public network, set it to `true`.
        :param pulumi.Input[_builtins.str] engine: The engine of DBInstance. Always `selectdb`.
        :param pulumi.Input[_builtins.str] engine_minor_version: The DBInstance minor version. Valid values: `3.0.12`,`4.0.4`.
        :param pulumi.Input[_builtins.str] gmt_created: The time when DBInstance is created.
        :param pulumi.Input[_builtins.str] gmt_expired: The time when DBInstance will be expired. Available on `Subscription` DBInstance.
        :param pulumi.Input[_builtins.str] gmt_modified: The time when DBInstance is modified.
        :param pulumi.Input[Sequence[pulumi.Input['DbInstanceInstanceNetInfoArgs']]] instance_net_infos: The net infos for instances.
        :param pulumi.Input[_builtins.str] lock_mode: The lock mode of the instance. Set the value to lock, which specifies that the instance is locked when it automatically expires or has an overdue payment.
        :param pulumi.Input[_builtins.str] lock_reason: The reason why the instance is locked.
        :param pulumi.Input[_builtins.int] memory_postpaid: The sum of memory resource amount offor every `PayAsYouGo` clusters in DBInstance.
        :param pulumi.Input[_builtins.int] memory_prepaid: The sum of memory resource amount offor every `Subscription` clusters in DBInstance.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[_builtins.str] period: It is valid when payment_type is `Subscription`. Valid values are `Year`, `Month`.
        :param pulumi.Input[_builtins.int] period_time: The duration that you will buy DBInstance. It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the instance.
        :param pulumi.Input[Sequence[pulumi.Input['DbInstanceSecurityIpListArgs']]] security_ip_lists: The details about each IP address whitelist returned.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
        :param pulumi.Input[_builtins.str] sub_domain: The sub domain of DBInstance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] upgraded_engine_minor_version: Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC for DBInstance.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of vswitch for DBInstance.
        :param pulumi.Input[_builtins.str] zone_id: The ID of zone for DBInstance.
        """
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if cache_size is not None:
            pulumi.set(__self__, "cache_size", cache_size)
        if cache_size_postpaid is not None:
            pulumi.set(__self__, "cache_size_postpaid", cache_size_postpaid)
        if cache_size_prepaid is not None:
            pulumi.set(__self__, "cache_size_prepaid", cache_size_prepaid)
        if cluster_count_postpaid is not None:
            pulumi.set(__self__, "cluster_count_postpaid", cluster_count_postpaid)
        if cluster_count_prepaid is not None:
            pulumi.set(__self__, "cluster_count_prepaid", cluster_count_prepaid)
        if cpu_postpaid is not None:
            pulumi.set(__self__, "cpu_postpaid", cpu_postpaid)
        if cpu_prepaid is not None:
            pulumi.set(__self__, "cpu_prepaid", cpu_prepaid)
        if db_instance_class is not None:
            pulumi.set(__self__, "db_instance_class", db_instance_class)
        if db_instance_description is not None:
            pulumi.set(__self__, "db_instance_description", db_instance_description)
        if desired_security_ip_lists is not None:
            pulumi.set(__self__, "desired_security_ip_lists", desired_security_ip_lists)
        if enable_public_network is not None:
            pulumi.set(__self__, "enable_public_network", enable_public_network)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_minor_version is not None:
            pulumi.set(__self__, "engine_minor_version", engine_minor_version)
        if gmt_created is not None:
            pulumi.set(__self__, "gmt_created", gmt_created)
        if gmt_expired is not None:
            pulumi.set(__self__, "gmt_expired", gmt_expired)
        if gmt_modified is not None:
            pulumi.set(__self__, "gmt_modified", gmt_modified)
        if instance_net_infos is not None:
            pulumi.set(__self__, "instance_net_infos", instance_net_infos)
        if lock_mode is not None:
            pulumi.set(__self__, "lock_mode", lock_mode)
        if lock_reason is not None:
            pulumi.set(__self__, "lock_reason", lock_reason)
        if memory_postpaid is not None:
            pulumi.set(__self__, "memory_postpaid", memory_postpaid)
        if memory_prepaid is not None:
            pulumi.set(__self__, "memory_prepaid", memory_prepaid)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_time is not None:
            pulumi.set(__self__, "period_time", period_time)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if security_ip_lists is not None:
            pulumi.set(__self__, "security_ip_lists", security_ip_lists)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_domain is not None:
            pulumi.set(__self__, "sub_domain", sub_domain)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upgraded_engine_minor_version is not None:
            warnings.warn("""Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.""", DeprecationWarning)
            pulumi.log.warn("""upgraded_engine_minor_version is deprecated: Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.""")
        if upgraded_engine_minor_version is not None:
            pulumi.set(__self__, "upgraded_engine_minor_version", upgraded_engine_minor_version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for DBInstance using admin account.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_pass", value)

    @_builtins.property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The cache size in DBInstance on creating default cluster. The number should be divided by 100.
        """
        return pulumi.get(self, "cache_size")

    @cache_size.setter
    def cache_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_size", value)

    @_builtins.property
    @pulumi.getter(name="cacheSizePostpaid")
    def cache_size_postpaid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sum of cache size for every `PayAsYouGo` clusters in DBInstance.
        """
        return pulumi.get(self, "cache_size_postpaid")

    @cache_size_postpaid.setter
    def cache_size_postpaid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_size_postpaid", value)

    @_builtins.property
    @pulumi.getter(name="cacheSizePrepaid")
    def cache_size_prepaid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sum of cache size for every `Subscription` clusters in DBInstance.
        """
        return pulumi.get(self, "cache_size_prepaid")

    @cache_size_prepaid.setter
    def cache_size_prepaid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_size_prepaid", value)

    @_builtins.property
    @pulumi.getter(name="clusterCountPostpaid")
    def cluster_count_postpaid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sum of cluster counts for `PayAsYouGo` clusters in DBInstance.
        """
        return pulumi.get(self, "cluster_count_postpaid")

    @cluster_count_postpaid.setter
    def cluster_count_postpaid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cluster_count_postpaid", value)

    @_builtins.property
    @pulumi.getter(name="clusterCountPrepaid")
    def cluster_count_prepaid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sum of cluster counts for `Subscription` clusters in DBInstance.
        """
        return pulumi.get(self, "cluster_count_prepaid")

    @cluster_count_prepaid.setter
    def cluster_count_prepaid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cluster_count_prepaid", value)

    @_builtins.property
    @pulumi.getter(name="cpuPostpaid")
    def cpu_postpaid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sum of cpu resource amount for every `PayAsYouGo` clusters in DBInstance.
        """
        return pulumi.get(self, "cpu_postpaid")

    @cpu_postpaid.setter
    def cpu_postpaid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_postpaid", value)

    @_builtins.property
    @pulumi.getter(name="cpuPrepaid")
    def cpu_prepaid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sum of cpu resource amount for every `Subscription` clusters in DBInstance.
        """
        return pulumi.get(self, "cpu_prepaid")

    @cpu_prepaid.setter
    def cpu_prepaid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_prepaid", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The class for default cluster in DBInstance. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        """
        return pulumi.get(self, "db_instance_class")

    @db_instance_class.setter
    def db_instance_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_class", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DBInstance description.
        """
        return pulumi.get(self, "db_instance_description")

    @db_instance_description.setter
    def db_instance_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_description", value)

    @_builtins.property
    @pulumi.getter(name="desiredSecurityIpLists")
    def desired_security_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDesiredSecurityIpListArgs']]]]:
        """
        The modified IP address whitelists. See `desired_security_ip_lists` below.
        """
        return pulumi.get(self, "desired_security_ip_lists")

    @desired_security_ip_lists.setter
    def desired_security_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceDesiredSecurityIpListArgs']]]]):
        pulumi.set(self, "desired_security_ip_lists", value)

    @_builtins.property
    @pulumi.getter(name="enablePublicNetwork")
    def enable_public_network(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If DBInstance need to open public network, set it to `true`.
        """
        return pulumi.get(self, "enable_public_network")

    @enable_public_network.setter
    def enable_public_network(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_public_network", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The engine of DBInstance. Always `selectdb`.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineMinorVersion")
    def engine_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DBInstance minor version. Valid values: `3.0.12`,`4.0.4`.
        """
        return pulumi.get(self, "engine_minor_version")

    @engine_minor_version.setter
    def engine_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="gmtCreated")
    def gmt_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when DBInstance is created.
        """
        return pulumi.get(self, "gmt_created")

    @gmt_created.setter
    def gmt_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gmt_created", value)

    @_builtins.property
    @pulumi.getter(name="gmtExpired")
    def gmt_expired(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when DBInstance will be expired. Available on `Subscription` DBInstance.
        """
        return pulumi.get(self, "gmt_expired")

    @gmt_expired.setter
    def gmt_expired(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gmt_expired", value)

    @_builtins.property
    @pulumi.getter(name="gmtModified")
    def gmt_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when DBInstance is modified.
        """
        return pulumi.get(self, "gmt_modified")

    @gmt_modified.setter
    def gmt_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gmt_modified", value)

    @_builtins.property
    @pulumi.getter(name="instanceNetInfos")
    def instance_net_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceInstanceNetInfoArgs']]]]:
        """
        The net infos for instances.
        """
        return pulumi.get(self, "instance_net_infos")

    @instance_net_infos.setter
    def instance_net_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceInstanceNetInfoArgs']]]]):
        pulumi.set(self, "instance_net_infos", value)

    @_builtins.property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lock mode of the instance. Set the value to lock, which specifies that the instance is locked when it automatically expires or has an overdue payment.
        """
        return pulumi.get(self, "lock_mode")

    @lock_mode.setter
    def lock_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lock_mode", value)

    @_builtins.property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason why the instance is locked.
        """
        return pulumi.get(self, "lock_reason")

    @lock_reason.setter
    def lock_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lock_reason", value)

    @_builtins.property
    @pulumi.getter(name="memoryPostpaid")
    def memory_postpaid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sum of memory resource amount offor every `PayAsYouGo` clusters in DBInstance.
        """
        return pulumi.get(self, "memory_postpaid")

    @memory_postpaid.setter
    def memory_postpaid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_postpaid", value)

    @_builtins.property
    @pulumi.getter(name="memoryPrepaid")
    def memory_prepaid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sum of memory resource amount offor every `Subscription` clusters in DBInstance.
        """
        return pulumi.get(self, "memory_prepaid")

    @memory_prepaid.setter
    def memory_prepaid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_prepaid", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        It is valid when payment_type is `Subscription`. Valid values are `Year`, `Month`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodTime")
    def period_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy DBInstance. It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
        """
        return pulumi.get(self, "period_time")

    @period_time.setter
    def period_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period_time", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the instance.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="securityIpLists")
    def security_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceSecurityIpListArgs']]]]:
        """
        The details about each IP address whitelist returned.
        """
        return pulumi.get(self, "security_ip_lists")

    @security_ip_lists.setter
    def security_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbInstanceSecurityIpListArgs']]]]):
        pulumi.set(self, "security_ip_lists", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subDomain")
    def sub_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sub domain of DBInstance.
        """
        return pulumi.get(self, "sub_domain")

    @sub_domain.setter
    def sub_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_domain", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="upgradedEngineMinorVersion")
    @_utilities.deprecated("""Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.""")
    def upgraded_engine_minor_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.
        """
        return pulumi.get(self, "upgraded_engine_minor_version")

    @upgraded_engine_minor_version.setter
    def upgraded_engine_minor_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgraded_engine_minor_version", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC for DBInstance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of vswitch for DBInstance.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of zone for DBInstance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:selectdb/dbInstance:DbInstance")
class DbInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 db_instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceDesiredSecurityIpListArgs', 'DbInstanceDesiredSecurityIpListArgsDict']]]]] = None,
                 enable_public_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 period_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgraded_engine_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a SelectDB DBInstance resource.

        For information about SelectDB DBInstance and how to use it, see [What is DBInstance](https://www.alibabacloud.com/help/zh/selectdb/latest/api-selectdb-2023-05-22-createdbinstance).

        > **NOTE:** Available since v1.229.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_zones(available_resource_creation="VSwitch")
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default.zones[0].id)
        default_db_instance = alicloud.selectdb.DbInstance("default",
            db_instance_class="selectdb.xlarge",
            db_instance_description=name,
            cache_size=200,
            payment_type="PayAsYouGo",
            engine_minor_version="3.0.12",
            vpc_id=default_get_switches.vswitches[0].vpc_id,
            zone_id=default_get_switches.vswitches[0].zone_id,
            vswitch_id=default_get_switches.vswitches[0].id)
        ```

        ## Import

        SelectDB DBInstance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:selectdb/dbInstance:DbInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_pass: The password for DBInstance using admin account.
        :param pulumi.Input[_builtins.int] cache_size: The cache size in DBInstance on creating default cluster. The number should be divided by 100.
        :param pulumi.Input[_builtins.str] db_instance_class: The class for default cluster in DBInstance. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        :param pulumi.Input[_builtins.str] db_instance_description: The DBInstance description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceDesiredSecurityIpListArgs', 'DbInstanceDesiredSecurityIpListArgsDict']]]] desired_security_ip_lists: The modified IP address whitelists. See `desired_security_ip_lists` below.
        :param pulumi.Input[_builtins.bool] enable_public_network: If DBInstance need to open public network, set it to `true`.
        :param pulumi.Input[_builtins.str] engine_minor_version: The DBInstance minor version. Valid values: `3.0.12`,`4.0.4`.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[_builtins.str] period: It is valid when payment_type is `Subscription`. Valid values are `Year`, `Month`.
        :param pulumi.Input[_builtins.int] period_time: The duration that you will buy DBInstance. It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] upgraded_engine_minor_version: Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC for DBInstance.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of vswitch for DBInstance.
        :param pulumi.Input[_builtins.str] zone_id: The ID of zone for DBInstance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SelectDB DBInstance resource.

        For information about SelectDB DBInstance and how to use it, see [What is DBInstance](https://www.alibabacloud.com/help/zh/selectdb/latest/api-selectdb-2023-05-22-createdbinstance).

        > **NOTE:** Available since v1.229.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_zones(available_resource_creation="VSwitch")
        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform_example"
        default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0],
            zone_id=default.zones[0].id)
        default_db_instance = alicloud.selectdb.DbInstance("default",
            db_instance_class="selectdb.xlarge",
            db_instance_description=name,
            cache_size=200,
            payment_type="PayAsYouGo",
            engine_minor_version="3.0.12",
            vpc_id=default_get_switches.vswitches[0].vpc_id,
            zone_id=default_get_switches.vswitches[0].zone_id,
            vswitch_id=default_get_switches.vswitches[0].id)
        ```

        ## Import

        SelectDB DBInstance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:selectdb/dbInstance:DbInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DbInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_size: Optional[pulumi.Input[_builtins.int]] = None,
                 db_instance_class: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceDesiredSecurityIpListArgs', 'DbInstanceDesiredSecurityIpListArgsDict']]]]] = None,
                 enable_public_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None,
                 period_time: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgraded_engine_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbInstanceArgs.__new__(DbInstanceArgs)

            __props__.__dict__["admin_pass"] = None if admin_pass is None else pulumi.Output.secret(admin_pass)
            if cache_size is None and not opts.urn:
                raise TypeError("Missing required property 'cache_size'")
            __props__.__dict__["cache_size"] = cache_size
            if db_instance_class is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_class'")
            __props__.__dict__["db_instance_class"] = db_instance_class
            if db_instance_description is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_description'")
            __props__.__dict__["db_instance_description"] = db_instance_description
            __props__.__dict__["desired_security_ip_lists"] = desired_security_ip_lists
            __props__.__dict__["enable_public_network"] = enable_public_network
            __props__.__dict__["engine_minor_version"] = engine_minor_version
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_time"] = period_time
            __props__.__dict__["tags"] = tags
            __props__.__dict__["upgraded_engine_minor_version"] = upgraded_engine_minor_version
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["cache_size_postpaid"] = None
            __props__.__dict__["cache_size_prepaid"] = None
            __props__.__dict__["cluster_count_postpaid"] = None
            __props__.__dict__["cluster_count_prepaid"] = None
            __props__.__dict__["cpu_postpaid"] = None
            __props__.__dict__["cpu_prepaid"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["gmt_created"] = None
            __props__.__dict__["gmt_expired"] = None
            __props__.__dict__["gmt_modified"] = None
            __props__.__dict__["instance_net_infos"] = None
            __props__.__dict__["lock_mode"] = None
            __props__.__dict__["lock_reason"] = None
            __props__.__dict__["memory_postpaid"] = None
            __props__.__dict__["memory_prepaid"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["security_ip_lists"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["sub_domain"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPass"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DbInstance, __self__).__init__(
            'alicloud:selectdb/dbInstance:DbInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_pass: Optional[pulumi.Input[_builtins.str]] = None,
            cache_size: Optional[pulumi.Input[_builtins.int]] = None,
            cache_size_postpaid: Optional[pulumi.Input[_builtins.int]] = None,
            cache_size_prepaid: Optional[pulumi.Input[_builtins.int]] = None,
            cluster_count_postpaid: Optional[pulumi.Input[_builtins.int]] = None,
            cluster_count_prepaid: Optional[pulumi.Input[_builtins.int]] = None,
            cpu_postpaid: Optional[pulumi.Input[_builtins.int]] = None,
            cpu_prepaid: Optional[pulumi.Input[_builtins.int]] = None,
            db_instance_class: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_description: Optional[pulumi.Input[_builtins.str]] = None,
            desired_security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceDesiredSecurityIpListArgs', 'DbInstanceDesiredSecurityIpListArgsDict']]]]] = None,
            enable_public_network: Optional[pulumi.Input[_builtins.bool]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
            gmt_created: Optional[pulumi.Input[_builtins.str]] = None,
            gmt_expired: Optional[pulumi.Input[_builtins.str]] = None,
            gmt_modified: Optional[pulumi.Input[_builtins.str]] = None,
            instance_net_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceInstanceNetInfoArgs', 'DbInstanceInstanceNetInfoArgsDict']]]]] = None,
            lock_mode: Optional[pulumi.Input[_builtins.str]] = None,
            lock_reason: Optional[pulumi.Input[_builtins.str]] = None,
            memory_postpaid: Optional[pulumi.Input[_builtins.int]] = None,
            memory_prepaid: Optional[pulumi.Input[_builtins.int]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.str]] = None,
            period_time: Optional[pulumi.Input[_builtins.int]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceSecurityIpListArgs', 'DbInstanceSecurityIpListArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            sub_domain: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            upgraded_engine_minor_version: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DbInstance':
        """
        Get an existing DbInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_pass: The password for DBInstance using admin account.
        :param pulumi.Input[_builtins.int] cache_size: The cache size in DBInstance on creating default cluster. The number should be divided by 100.
        :param pulumi.Input[_builtins.int] cache_size_postpaid: The sum of cache size for every `PayAsYouGo` clusters in DBInstance.
        :param pulumi.Input[_builtins.int] cache_size_prepaid: The sum of cache size for every `Subscription` clusters in DBInstance.
        :param pulumi.Input[_builtins.int] cluster_count_postpaid: The sum of cluster counts for `PayAsYouGo` clusters in DBInstance.
        :param pulumi.Input[_builtins.int] cluster_count_prepaid: The sum of cluster counts for `Subscription` clusters in DBInstance.
        :param pulumi.Input[_builtins.int] cpu_postpaid: The sum of cpu resource amount for every `PayAsYouGo` clusters in DBInstance.
        :param pulumi.Input[_builtins.int] cpu_prepaid: The sum of cpu resource amount for every `Subscription` clusters in DBInstance.
        :param pulumi.Input[_builtins.str] db_instance_class: The class for default cluster in DBInstance. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        :param pulumi.Input[_builtins.str] db_instance_description: The DBInstance description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceDesiredSecurityIpListArgs', 'DbInstanceDesiredSecurityIpListArgsDict']]]] desired_security_ip_lists: The modified IP address whitelists. See `desired_security_ip_lists` below.
        :param pulumi.Input[_builtins.bool] enable_public_network: If DBInstance need to open public network, set it to `true`.
        :param pulumi.Input[_builtins.str] engine: The engine of DBInstance. Always `selectdb`.
        :param pulumi.Input[_builtins.str] engine_minor_version: The DBInstance minor version. Valid values: `3.0.12`,`4.0.4`.
        :param pulumi.Input[_builtins.str] gmt_created: The time when DBInstance is created.
        :param pulumi.Input[_builtins.str] gmt_expired: The time when DBInstance will be expired. Available on `Subscription` DBInstance.
        :param pulumi.Input[_builtins.str] gmt_modified: The time when DBInstance is modified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceInstanceNetInfoArgs', 'DbInstanceInstanceNetInfoArgsDict']]]] instance_net_infos: The net infos for instances.
        :param pulumi.Input[_builtins.str] lock_mode: The lock mode of the instance. Set the value to lock, which specifies that the instance is locked when it automatically expires or has an overdue payment.
        :param pulumi.Input[_builtins.str] lock_reason: The reason why the instance is locked.
        :param pulumi.Input[_builtins.int] memory_postpaid: The sum of memory resource amount offor every `PayAsYouGo` clusters in DBInstance.
        :param pulumi.Input[_builtins.int] memory_prepaid: The sum of memory resource amount offor every `Subscription` clusters in DBInstance.
        :param pulumi.Input[_builtins.str] payment_type: The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        :param pulumi.Input[_builtins.str] period: It is valid when payment_type is `Subscription`. Valid values are `Year`, `Month`.
        :param pulumi.Input[_builtins.int] period_time: The duration that you will buy DBInstance. It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DbInstanceSecurityIpListArgs', 'DbInstanceSecurityIpListArgsDict']]]] security_ip_lists: The details about each IP address whitelist returned.
        :param pulumi.Input[_builtins.str] status: The status of the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
        :param pulumi.Input[_builtins.str] sub_domain: The sub domain of DBInstance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[_builtins.str] upgraded_engine_minor_version: Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC for DBInstance.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of vswitch for DBInstance.
        :param pulumi.Input[_builtins.str] zone_id: The ID of zone for DBInstance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbInstanceState.__new__(_DbInstanceState)

        __props__.__dict__["admin_pass"] = admin_pass
        __props__.__dict__["cache_size"] = cache_size
        __props__.__dict__["cache_size_postpaid"] = cache_size_postpaid
        __props__.__dict__["cache_size_prepaid"] = cache_size_prepaid
        __props__.__dict__["cluster_count_postpaid"] = cluster_count_postpaid
        __props__.__dict__["cluster_count_prepaid"] = cluster_count_prepaid
        __props__.__dict__["cpu_postpaid"] = cpu_postpaid
        __props__.__dict__["cpu_prepaid"] = cpu_prepaid
        __props__.__dict__["db_instance_class"] = db_instance_class
        __props__.__dict__["db_instance_description"] = db_instance_description
        __props__.__dict__["desired_security_ip_lists"] = desired_security_ip_lists
        __props__.__dict__["enable_public_network"] = enable_public_network
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_minor_version"] = engine_minor_version
        __props__.__dict__["gmt_created"] = gmt_created
        __props__.__dict__["gmt_expired"] = gmt_expired
        __props__.__dict__["gmt_modified"] = gmt_modified
        __props__.__dict__["instance_net_infos"] = instance_net_infos
        __props__.__dict__["lock_mode"] = lock_mode
        __props__.__dict__["lock_reason"] = lock_reason
        __props__.__dict__["memory_postpaid"] = memory_postpaid
        __props__.__dict__["memory_prepaid"] = memory_prepaid
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_time"] = period_time
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["security_ip_lists"] = security_ip_lists
        __props__.__dict__["status"] = status
        __props__.__dict__["sub_domain"] = sub_domain
        __props__.__dict__["tags"] = tags
        __props__.__dict__["upgraded_engine_minor_version"] = upgraded_engine_minor_version
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return DbInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password for DBInstance using admin account.
        """
        return pulumi.get(self, "admin_pass")

    @_builtins.property
    @pulumi.getter(name="cacheSize")
    def cache_size(self) -> pulumi.Output[_builtins.int]:
        """
        The cache size in DBInstance on creating default cluster. The number should be divided by 100.
        """
        return pulumi.get(self, "cache_size")

    @_builtins.property
    @pulumi.getter(name="cacheSizePostpaid")
    def cache_size_postpaid(self) -> pulumi.Output[_builtins.int]:
        """
        The sum of cache size for every `PayAsYouGo` clusters in DBInstance.
        """
        return pulumi.get(self, "cache_size_postpaid")

    @_builtins.property
    @pulumi.getter(name="cacheSizePrepaid")
    def cache_size_prepaid(self) -> pulumi.Output[_builtins.int]:
        """
        The sum of cache size for every `Subscription` clusters in DBInstance.
        """
        return pulumi.get(self, "cache_size_prepaid")

    @_builtins.property
    @pulumi.getter(name="clusterCountPostpaid")
    def cluster_count_postpaid(self) -> pulumi.Output[_builtins.int]:
        """
        The sum of cluster counts for `PayAsYouGo` clusters in DBInstance.
        """
        return pulumi.get(self, "cluster_count_postpaid")

    @_builtins.property
    @pulumi.getter(name="clusterCountPrepaid")
    def cluster_count_prepaid(self) -> pulumi.Output[_builtins.int]:
        """
        The sum of cluster counts for `Subscription` clusters in DBInstance.
        """
        return pulumi.get(self, "cluster_count_prepaid")

    @_builtins.property
    @pulumi.getter(name="cpuPostpaid")
    def cpu_postpaid(self) -> pulumi.Output[_builtins.int]:
        """
        The sum of cpu resource amount for every `PayAsYouGo` clusters in DBInstance.
        """
        return pulumi.get(self, "cpu_postpaid")

    @_builtins.property
    @pulumi.getter(name="cpuPrepaid")
    def cpu_prepaid(self) -> pulumi.Output[_builtins.int]:
        """
        The sum of cpu resource amount for every `Subscription` clusters in DBInstance.
        """
        return pulumi.get(self, "cpu_prepaid")

    @_builtins.property
    @pulumi.getter(name="dbInstanceClass")
    def db_instance_class(self) -> pulumi.Output[_builtins.str]:
        """
        The class for default cluster in DBInstance. db_cluster_class has a range of class from `selectdb.xlarge` to `selectdb.256xlarge`.
        """
        return pulumi.get(self, "db_instance_class")

    @_builtins.property
    @pulumi.getter(name="dbInstanceDescription")
    def db_instance_description(self) -> pulumi.Output[_builtins.str]:
        """
        The DBInstance description.
        """
        return pulumi.get(self, "db_instance_description")

    @_builtins.property
    @pulumi.getter(name="desiredSecurityIpLists")
    def desired_security_ip_lists(self) -> pulumi.Output[Optional[Sequence['outputs.DbInstanceDesiredSecurityIpList']]]:
        """
        The modified IP address whitelists. See `desired_security_ip_lists` below.
        """
        return pulumi.get(self, "desired_security_ip_lists")

    @_builtins.property
    @pulumi.getter(name="enablePublicNetwork")
    def enable_public_network(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If DBInstance need to open public network, set it to `true`.
        """
        return pulumi.get(self, "enable_public_network")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        The engine of DBInstance. Always `selectdb`.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineMinorVersion")
    def engine_minor_version(self) -> pulumi.Output[_builtins.str]:
        """
        The DBInstance minor version. Valid values: `3.0.12`,`4.0.4`.
        """
        return pulumi.get(self, "engine_minor_version")

    @_builtins.property
    @pulumi.getter(name="gmtCreated")
    def gmt_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time when DBInstance is created.
        """
        return pulumi.get(self, "gmt_created")

    @_builtins.property
    @pulumi.getter(name="gmtExpired")
    def gmt_expired(self) -> pulumi.Output[_builtins.str]:
        """
        The time when DBInstance will be expired. Available on `Subscription` DBInstance.
        """
        return pulumi.get(self, "gmt_expired")

    @_builtins.property
    @pulumi.getter(name="gmtModified")
    def gmt_modified(self) -> pulumi.Output[_builtins.str]:
        """
        The time when DBInstance is modified.
        """
        return pulumi.get(self, "gmt_modified")

    @_builtins.property
    @pulumi.getter(name="instanceNetInfos")
    def instance_net_infos(self) -> pulumi.Output[Sequence['outputs.DbInstanceInstanceNetInfo']]:
        """
        The net infos for instances.
        """
        return pulumi.get(self, "instance_net_infos")

    @_builtins.property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The lock mode of the instance. Set the value to lock, which specifies that the instance is locked when it automatically expires or has an overdue payment.
        """
        return pulumi.get(self, "lock_mode")

    @_builtins.property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> pulumi.Output[_builtins.str]:
        """
        The reason why the instance is locked.
        """
        return pulumi.get(self, "lock_reason")

    @_builtins.property
    @pulumi.getter(name="memoryPostpaid")
    def memory_postpaid(self) -> pulumi.Output[_builtins.int]:
        """
        The sum of memory resource amount offor every `PayAsYouGo` clusters in DBInstance.
        """
        return pulumi.get(self, "memory_postpaid")

    @_builtins.property
    @pulumi.getter(name="memoryPrepaid")
    def memory_prepaid(self) -> pulumi.Output[_builtins.int]:
        """
        The sum of memory resource amount offor every `Subscription` clusters in DBInstance.
        """
        return pulumi.get(self, "memory_prepaid")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type of the resource. Valid values: `PayAsYouGo`,`Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        It is valid when payment_type is `Subscription`. Valid values are `Year`, `Month`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodTime")
    def period_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration that you will buy DBInstance. It is valid when payment_type is `Subscription`. Valid values: [1~9], 12, 24, 36.
        """
        return pulumi.get(self, "period_time")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the instance.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="securityIpLists")
    def security_ip_lists(self) -> pulumi.Output[Sequence['outputs.DbInstanceSecurityIpList']]:
        """
        The details about each IP address whitelist returned.
        """
        return pulumi.get(self, "security_ip_lists")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource. Valid values: `ACTIVATION`,`STOPPED`,`STARTING`,`RESTART`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subDomain")
    def sub_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The sub domain of DBInstance.
        """
        return pulumi.get(self, "sub_domain")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="upgradedEngineMinorVersion")
    @_utilities.deprecated("""Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.""")
    def upgraded_engine_minor_version(self) -> pulumi.Output[_builtins.str]:
        """
        Field `upgraded_engine_minor_version` has been deprecated from provider version 1.248.0. New field `engine_minor_version` instead.
        """
        return pulumi.get(self, "upgraded_engine_minor_version")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC for DBInstance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of vswitch for DBInstance.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of zone for DBInstance.
        """
        return pulumi.get(self, "zone_id")

