# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProductVersionArgs', 'ProductVersion']

@pulumi.input_type
class ProductVersionArgs:
    def __init__(__self__, *,
                 product_id: pulumi.Input[_builtins.str],
                 product_version_name: pulumi.Input[_builtins.str],
                 template_type: pulumi.Input[_builtins.str],
                 template_url: pulumi.Input[_builtins.str],
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 guidance: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProductVersion resource.
        :param pulumi.Input[_builtins.str] product_id: Product ID
        :param pulumi.Input[_builtins.str] product_version_name: The name of the resource
        :param pulumi.Input[_builtins.str] template_type: Template Type
        :param pulumi.Input[_builtins.str] template_url: Template URL
        :param pulumi.Input[_builtins.bool] active: Whether the version is activated
        :param pulumi.Input[_builtins.str] description: Version description
        :param pulumi.Input[_builtins.str] guidance: Administrator guidance
        """
        pulumi.set(__self__, "product_id", product_id)
        pulumi.set(__self__, "product_version_name", product_version_name)
        pulumi.set(__self__, "template_type", template_type)
        pulumi.set(__self__, "template_url", template_url)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if guidance is not None:
            pulumi.set(__self__, "guidance", guidance)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[_builtins.str]:
        """
        Product ID
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="productVersionName")
    def product_version_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "product_version_name")

    @product_version_name.setter
    def product_version_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "product_version_name", value)

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Input[_builtins.str]:
        """
        Template Type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "template_type", value)

    @_builtins.property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> pulumi.Input[_builtins.str]:
        """
        Template URL
        """
        return pulumi.get(self, "template_url")

    @template_url.setter
    def template_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "template_url", value)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the version is activated
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def guidance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Administrator guidance
        """
        return pulumi.get(self, "guidance")

    @guidance.setter
    def guidance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guidance", value)


@pulumi.input_type
class _ProductVersionState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 guidance: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_version_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 template_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProductVersion resources.
        :param pulumi.Input[_builtins.bool] active: Whether the version is activated
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] description: Version description
        :param pulumi.Input[_builtins.str] guidance: Administrator guidance
        :param pulumi.Input[_builtins.str] product_id: Product ID
        :param pulumi.Input[_builtins.str] product_version_name: The name of the resource
        :param pulumi.Input[_builtins.str] template_type: Template Type
        :param pulumi.Input[_builtins.str] template_url: Template URL
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if guidance is not None:
            pulumi.set(__self__, "guidance", guidance)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if product_version_name is not None:
            pulumi.set(__self__, "product_version_name", product_version_name)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if template_url is not None:
            pulumi.set(__self__, "template_url", template_url)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the version is activated
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def guidance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Administrator guidance
        """
        return pulumi.get(self, "guidance")

    @guidance.setter
    def guidance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guidance", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Product ID
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="productVersionName")
    def product_version_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "product_version_name")

    @product_version_name.setter
    def product_version_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_version_name", value)

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Template Type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_type", value)

    @_builtins.property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Template URL
        """
        return pulumi.get(self, "template_url")

    @template_url.setter
    def template_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_url", value)


@pulumi.type_token("alicloud:servicecatalog/productVersion:ProductVersion")
class ProductVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 guidance: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_version_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 template_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Service Catalog Product Version resource.

        There can be one or more versions of the product.

        For information about Service Catalog Product Version and how to use it, see [What is Product Version](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-createproductversion).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultmae_tc_e = alicloud.servicecatalog.Product("defaultmaeTcE",
            provider_name=name,
            product_name=name,
            product_type="Ros")
        default = alicloud.servicecatalog.ProductVersion("default",
            guidance="Default",
            template_url="oss://servicecatalog-cn-hangzhou/1466115886172051/terraform/template/tpl-bp1x4v3r44u7u7/template.json",
            active=True,
            description="产品版本测试",
            product_version_name=name,
            product_id=defaultmae_tc_e.id,
            template_type="RosTerraformTemplate")
        ```

        ## Import

        Service Catalog Product Version can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:servicecatalog/productVersion:ProductVersion example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active: Whether the version is activated
        :param pulumi.Input[_builtins.str] description: Version description
        :param pulumi.Input[_builtins.str] guidance: Administrator guidance
        :param pulumi.Input[_builtins.str] product_id: Product ID
        :param pulumi.Input[_builtins.str] product_version_name: The name of the resource
        :param pulumi.Input[_builtins.str] template_type: Template Type
        :param pulumi.Input[_builtins.str] template_url: Template URL
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProductVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Service Catalog Product Version resource.

        There can be one or more versions of the product.

        For information about Service Catalog Product Version and how to use it, see [What is Product Version](https://www.alibabacloud.com/help/en/service-catalog/developer-reference/api-servicecatalog-2021-09-01-createproductversion).

        > **NOTE:** Available since v1.230.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        defaultmae_tc_e = alicloud.servicecatalog.Product("defaultmaeTcE",
            provider_name=name,
            product_name=name,
            product_type="Ros")
        default = alicloud.servicecatalog.ProductVersion("default",
            guidance="Default",
            template_url="oss://servicecatalog-cn-hangzhou/1466115886172051/terraform/template/tpl-bp1x4v3r44u7u7/template.json",
            active=True,
            description="产品版本测试",
            product_version_name=name,
            product_id=defaultmae_tc_e.id,
            template_type="RosTerraformTemplate")
        ```

        ## Import

        Service Catalog Product Version can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:servicecatalog/productVersion:ProductVersion example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ProductVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProductVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 guidance: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_version_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 template_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProductVersionArgs.__new__(ProductVersionArgs)

            __props__.__dict__["active"] = active
            __props__.__dict__["description"] = description
            __props__.__dict__["guidance"] = guidance
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            if product_version_name is None and not opts.urn:
                raise TypeError("Missing required property 'product_version_name'")
            __props__.__dict__["product_version_name"] = product_version_name
            if template_type is None and not opts.urn:
                raise TypeError("Missing required property 'template_type'")
            __props__.__dict__["template_type"] = template_type
            if template_url is None and not opts.urn:
                raise TypeError("Missing required property 'template_url'")
            __props__.__dict__["template_url"] = template_url
            __props__.__dict__["create_time"] = None
        super(ProductVersion, __self__).__init__(
            'alicloud:servicecatalog/productVersion:ProductVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[_builtins.bool]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            guidance: Optional[pulumi.Input[_builtins.str]] = None,
            product_id: Optional[pulumi.Input[_builtins.str]] = None,
            product_version_name: Optional[pulumi.Input[_builtins.str]] = None,
            template_type: Optional[pulumi.Input[_builtins.str]] = None,
            template_url: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProductVersion':
        """
        Get an existing ProductVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] active: Whether the version is activated
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] description: Version description
        :param pulumi.Input[_builtins.str] guidance: Administrator guidance
        :param pulumi.Input[_builtins.str] product_id: Product ID
        :param pulumi.Input[_builtins.str] product_version_name: The name of the resource
        :param pulumi.Input[_builtins.str] template_type: Template Type
        :param pulumi.Input[_builtins.str] template_url: Template URL
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProductVersionState.__new__(_ProductVersionState)

        __props__.__dict__["active"] = active
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["guidance"] = guidance
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["product_version_name"] = product_version_name
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["template_url"] = template_url
        return ProductVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the version is activated
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Version description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def guidance(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Administrator guidance
        """
        return pulumi.get(self, "guidance")

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[_builtins.str]:
        """
        Product ID
        """
        return pulumi.get(self, "product_id")

    @_builtins.property
    @pulumi.getter(name="productVersionName")
    def product_version_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "product_version_name")

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[_builtins.str]:
        """
        Template Type
        """
        return pulumi.get(self, "template_type")

    @_builtins.property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> pulumi.Output[_builtins.str]:
        """
        Template URL
        """
        return pulumi.get(self, "template_url")

