# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ServiceMeshExtraConfiguration',
    'ServiceMeshLoadBalancer',
    'ServiceMeshMeshConfig',
    'ServiceMeshMeshConfigAccessLog',
    'ServiceMeshMeshConfigAudit',
    'ServiceMeshMeshConfigControlPlaneLog',
    'ServiceMeshMeshConfigKiali',
    'ServiceMeshMeshConfigKialiOpenIdConfig',
    'ServiceMeshMeshConfigKialiRamOauthConfig',
    'ServiceMeshMeshConfigKialiServerConfig',
    'ServiceMeshMeshConfigOpa',
    'ServiceMeshMeshConfigPilot',
    'ServiceMeshMeshConfigPrometheus',
    'ServiceMeshMeshConfigProxy',
    'ServiceMeshMeshConfigSidecarInjector',
    'ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration',
    'ServiceMeshNetwork',
    'UserPermissionPermission',
    'GetExtensionProvidersProviderResult',
    'GetServiceMeshesMeshResult',
    'GetServiceMeshesMeshEndpointResult',
    'GetServiceMeshesMeshLoadBalancerResult',
    'GetServiceMeshesMeshMeshConfigResult',
    'GetServiceMeshesMeshMeshConfigAccessLogResult',
    'GetServiceMeshesMeshMeshConfigAuditResult',
    'GetServiceMeshesMeshMeshConfigControlPlaneLogResult',
    'GetServiceMeshesMeshMeshConfigKialiResult',
    'GetServiceMeshesMeshMeshConfigOpaResult',
    'GetServiceMeshesMeshMeshConfigPilotResult',
    'GetServiceMeshesMeshMeshConfigPrometheusResult',
    'GetServiceMeshesMeshMeshConfigProxyResult',
    'GetServiceMeshesMeshMeshConfigSidecarInjectorResult',
    'GetServiceMeshesMeshMeshConfigSidecarInjectorInitCniConfigurationResult',
    'GetServiceMeshesMeshNetworkResult',
    'GetVersionsVersionResult',
]

@pulumi.output_type
class ServiceMeshExtraConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crAggregationEnabled":
            suggest = "cr_aggregation_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshExtraConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshExtraConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshExtraConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cr_aggregation_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool cr_aggregation_enabled: Whether the data plane KubeAPI access capability is enabled.
        """
        if cr_aggregation_enabled is not None:
            pulumi.set(__self__, "cr_aggregation_enabled", cr_aggregation_enabled)

    @_builtins.property
    @pulumi.getter(name="crAggregationEnabled")
    def cr_aggregation_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the data plane KubeAPI access capability is enabled.
        """
        return pulumi.get(self, "cr_aggregation_enabled")


@pulumi.output_type
class ServiceMeshLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiServerLoadbalancerId":
            suggest = "api_server_loadbalancer_id"
        elif key == "apiServerPublicEip":
            suggest = "api_server_public_eip"
        elif key == "pilotPublicEip":
            suggest = "pilot_public_eip"
        elif key == "pilotPublicEipId":
            suggest = "pilot_public_eip_id"
        elif key == "pilotPublicLoadbalancerId":
            suggest = "pilot_public_loadbalancer_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_server_loadbalancer_id: Optional[_builtins.str] = None,
                 api_server_public_eip: Optional[_builtins.bool] = None,
                 pilot_public_eip: Optional[_builtins.bool] = None,
                 pilot_public_eip_id: Optional[_builtins.str] = None,
                 pilot_public_loadbalancer_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str api_server_loadbalancer_id: The Instance ID of APIServer Load Balancer
        :param _builtins.bool api_server_public_eip: Indicates whether to use the IP address of a public network exposed API Server
        :param _builtins.bool pilot_public_eip: Indicates whether to use the IP address of a public network exposure Istio Pilot. **Note**: This field has been deprecated and is readonly as of 1.232.0. Use pilot_public_eip_id instead.
        :param _builtins.str pilot_public_eip_id: the EIP instance id of Pilot load balancer.
        :param _builtins.str pilot_public_loadbalancer_id: The Instance ID of Pilot Load Balancer
        """
        if api_server_loadbalancer_id is not None:
            pulumi.set(__self__, "api_server_loadbalancer_id", api_server_loadbalancer_id)
        if api_server_public_eip is not None:
            pulumi.set(__self__, "api_server_public_eip", api_server_public_eip)
        if pilot_public_eip is not None:
            pulumi.set(__self__, "pilot_public_eip", pilot_public_eip)
        if pilot_public_eip_id is not None:
            pulumi.set(__self__, "pilot_public_eip_id", pilot_public_eip_id)
        if pilot_public_loadbalancer_id is not None:
            pulumi.set(__self__, "pilot_public_loadbalancer_id", pilot_public_loadbalancer_id)

    @_builtins.property
    @pulumi.getter(name="apiServerLoadbalancerId")
    def api_server_loadbalancer_id(self) -> Optional[_builtins.str]:
        """
        The Instance ID of APIServer Load Balancer
        """
        return pulumi.get(self, "api_server_loadbalancer_id")

    @_builtins.property
    @pulumi.getter(name="apiServerPublicEip")
    def api_server_public_eip(self) -> Optional[_builtins.bool]:
        """
        Indicates whether to use the IP address of a public network exposed API Server
        """
        return pulumi.get(self, "api_server_public_eip")

    @_builtins.property
    @pulumi.getter(name="pilotPublicEip")
    def pilot_public_eip(self) -> Optional[_builtins.bool]:
        """
        Indicates whether to use the IP address of a public network exposure Istio Pilot. **Note**: This field has been deprecated and is readonly as of 1.232.0. Use pilot_public_eip_id instead.
        """
        return pulumi.get(self, "pilot_public_eip")

    @_builtins.property
    @pulumi.getter(name="pilotPublicEipId")
    def pilot_public_eip_id(self) -> Optional[_builtins.str]:
        """
        the EIP instance id of Pilot load balancer.
        """
        return pulumi.get(self, "pilot_public_eip_id")

    @_builtins.property
    @pulumi.getter(name="pilotPublicLoadbalancerId")
    def pilot_public_loadbalancer_id(self) -> Optional[_builtins.str]:
        """
        The Instance ID of Pilot Load Balancer
        """
        return pulumi.get(self, "pilot_public_loadbalancer_id")


@pulumi.output_type
class ServiceMeshMeshConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLog":
            suggest = "access_log"
        elif key == "controlPlaneLog":
            suggest = "control_plane_log"
        elif key == "customizedZipkin":
            suggest = "customized_zipkin"
        elif key == "enableLocalityLb":
            suggest = "enable_locality_lb"
        elif key == "includeIpRanges":
            suggest = "include_ip_ranges"
        elif key == "outboundTrafficPolicy":
            suggest = "outbound_traffic_policy"
        elif key == "sidecarInjector":
            suggest = "sidecar_injector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_log: Optional['outputs.ServiceMeshMeshConfigAccessLog'] = None,
                 audit: Optional['outputs.ServiceMeshMeshConfigAudit'] = None,
                 control_plane_log: Optional['outputs.ServiceMeshMeshConfigControlPlaneLog'] = None,
                 customized_zipkin: Optional[_builtins.bool] = None,
                 enable_locality_lb: Optional[_builtins.bool] = None,
                 include_ip_ranges: Optional[_builtins.str] = None,
                 kiali: Optional['outputs.ServiceMeshMeshConfigKiali'] = None,
                 opa: Optional['outputs.ServiceMeshMeshConfigOpa'] = None,
                 outbound_traffic_policy: Optional[_builtins.str] = None,
                 pilot: Optional['outputs.ServiceMeshMeshConfigPilot'] = None,
                 prometheus: Optional['outputs.ServiceMeshMeshConfigPrometheus'] = None,
                 proxy: Optional['outputs.ServiceMeshMeshConfigProxy'] = None,
                 sidecar_injector: Optional['outputs.ServiceMeshMeshConfigSidecarInjector'] = None,
                 telemetry: Optional[_builtins.bool] = None,
                 tracing: Optional[_builtins.bool] = None):
        """
        :param 'ServiceMeshMeshConfigAccessLogArgs' access_log: The access logging configuration See `access_log` below.
        :param 'ServiceMeshMeshConfigAuditArgs' audit: Audit information See `audit` below.
        :param 'ServiceMeshMeshConfigControlPlaneLogArgs' control_plane_log: Control plane log collection configuration. See `control_plane_log` below.
        :param _builtins.bool customized_zipkin: Whether or not to enable the use of a custom zipkin
        :param _builtins.bool enable_locality_lb: Whether to enable service can access the service through the nearest node access
        :param _builtins.str include_ip_ranges: The IP ADDRESS range
        :param 'ServiceMeshMeshConfigKialiArgs' kiali: Kiali configuration See `kiali` below.
        :param 'ServiceMeshMeshConfigOpaArgs' opa: The open-door policy of agent (OPA) plug-in information See `opa` below.
        :param _builtins.str outbound_traffic_policy: Out to the traffic policy
        :param 'ServiceMeshMeshConfigPilotArgs' pilot: Link trace sampling information See `pilot` below.
        :param 'ServiceMeshMeshConfigPrometheusArgs' prometheus: Prometheus configuration
        :param 'ServiceMeshMeshConfigProxyArgs' proxy: Proxy configuration, the fields under this structure have service segment default values, if not explicitly specified, you need to manually add them based on the return value of the server after the instance is created. See `proxy` below.
        :param 'ServiceMeshMeshConfigSidecarInjectorArgs' sidecar_injector: Sidecar injector configuration See `sidecar_injector` below.
        :param _builtins.bool telemetry: Whether to enable acquisition Prometheus metrics (it is recommended that you use [Alibaba Cloud Prometheus monitoring](https://arms.console.aliyun.com/)
        :param _builtins.bool tracing: Whether to enable link trace (you need to have [Alibaba Cloud link tracking service](https://tracing-analysis.console.aliyun.com/)
        """
        if access_log is not None:
            pulumi.set(__self__, "access_log", access_log)
        if audit is not None:
            pulumi.set(__self__, "audit", audit)
        if control_plane_log is not None:
            pulumi.set(__self__, "control_plane_log", control_plane_log)
        if customized_zipkin is not None:
            pulumi.set(__self__, "customized_zipkin", customized_zipkin)
        if enable_locality_lb is not None:
            pulumi.set(__self__, "enable_locality_lb", enable_locality_lb)
        if include_ip_ranges is not None:
            pulumi.set(__self__, "include_ip_ranges", include_ip_ranges)
        if kiali is not None:
            pulumi.set(__self__, "kiali", kiali)
        if opa is not None:
            pulumi.set(__self__, "opa", opa)
        if outbound_traffic_policy is not None:
            pulumi.set(__self__, "outbound_traffic_policy", outbound_traffic_policy)
        if pilot is not None:
            pulumi.set(__self__, "pilot", pilot)
        if prometheus is not None:
            pulumi.set(__self__, "prometheus", prometheus)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if sidecar_injector is not None:
            pulumi.set(__self__, "sidecar_injector", sidecar_injector)
        if telemetry is not None:
            pulumi.set(__self__, "telemetry", telemetry)
        if tracing is not None:
            pulumi.set(__self__, "tracing", tracing)

    @_builtins.property
    @pulumi.getter(name="accessLog")
    def access_log(self) -> Optional['outputs.ServiceMeshMeshConfigAccessLog']:
        """
        The access logging configuration See `access_log` below.
        """
        return pulumi.get(self, "access_log")

    @_builtins.property
    @pulumi.getter
    def audit(self) -> Optional['outputs.ServiceMeshMeshConfigAudit']:
        """
        Audit information See `audit` below.
        """
        return pulumi.get(self, "audit")

    @_builtins.property
    @pulumi.getter(name="controlPlaneLog")
    def control_plane_log(self) -> Optional['outputs.ServiceMeshMeshConfigControlPlaneLog']:
        """
        Control plane log collection configuration. See `control_plane_log` below.
        """
        return pulumi.get(self, "control_plane_log")

    @_builtins.property
    @pulumi.getter(name="customizedZipkin")
    def customized_zipkin(self) -> Optional[_builtins.bool]:
        """
        Whether or not to enable the use of a custom zipkin
        """
        return pulumi.get(self, "customized_zipkin")

    @_builtins.property
    @pulumi.getter(name="enableLocalityLb")
    def enable_locality_lb(self) -> Optional[_builtins.bool]:
        """
        Whether to enable service can access the service through the nearest node access
        """
        return pulumi.get(self, "enable_locality_lb")

    @_builtins.property
    @pulumi.getter(name="includeIpRanges")
    def include_ip_ranges(self) -> Optional[_builtins.str]:
        """
        The IP ADDRESS range
        """
        return pulumi.get(self, "include_ip_ranges")

    @_builtins.property
    @pulumi.getter
    def kiali(self) -> Optional['outputs.ServiceMeshMeshConfigKiali']:
        """
        Kiali configuration See `kiali` below.
        """
        return pulumi.get(self, "kiali")

    @_builtins.property
    @pulumi.getter
    def opa(self) -> Optional['outputs.ServiceMeshMeshConfigOpa']:
        """
        The open-door policy of agent (OPA) plug-in information See `opa` below.
        """
        return pulumi.get(self, "opa")

    @_builtins.property
    @pulumi.getter(name="outboundTrafficPolicy")
    def outbound_traffic_policy(self) -> Optional[_builtins.str]:
        """
        Out to the traffic policy
        """
        return pulumi.get(self, "outbound_traffic_policy")

    @_builtins.property
    @pulumi.getter
    def pilot(self) -> Optional['outputs.ServiceMeshMeshConfigPilot']:
        """
        Link trace sampling information See `pilot` below.
        """
        return pulumi.get(self, "pilot")

    @_builtins.property
    @pulumi.getter
    def prometheus(self) -> Optional['outputs.ServiceMeshMeshConfigPrometheus']:
        """
        Prometheus configuration
        """
        return pulumi.get(self, "prometheus")

    @_builtins.property
    @pulumi.getter
    def proxy(self) -> Optional['outputs.ServiceMeshMeshConfigProxy']:
        """
        Proxy configuration, the fields under this structure have service segment default values, if not explicitly specified, you need to manually add them based on the return value of the server after the instance is created. See `proxy` below.
        """
        return pulumi.get(self, "proxy")

    @_builtins.property
    @pulumi.getter(name="sidecarInjector")
    def sidecar_injector(self) -> Optional['outputs.ServiceMeshMeshConfigSidecarInjector']:
        """
        Sidecar injector configuration See `sidecar_injector` below.
        """
        return pulumi.get(self, "sidecar_injector")

    @_builtins.property
    @pulumi.getter
    def telemetry(self) -> Optional[_builtins.bool]:
        """
        Whether to enable acquisition Prometheus metrics (it is recommended that you use [Alibaba Cloud Prometheus monitoring](https://arms.console.aliyun.com/)
        """
        return pulumi.get(self, "telemetry")

    @_builtins.property
    @pulumi.getter
    def tracing(self) -> Optional[_builtins.bool]:
        """
        Whether to enable link trace (you need to have [Alibaba Cloud link tracking service](https://tracing-analysis.console.aliyun.com/)
        """
        return pulumi.get(self, "tracing")


@pulumi.output_type
class ServiceMeshMeshConfigAccessLog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gatewayEnabled":
            suggest = "gateway_enabled"
        elif key == "gatewayLifecycle":
            suggest = "gateway_lifecycle"
        elif key == "sidecarEnabled":
            suggest = "sidecar_enabled"
        elif key == "sidecarLifecycle":
            suggest = "sidecar_lifecycle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigAccessLog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigAccessLog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigAccessLog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 gateway_enabled: Optional[_builtins.bool] = None,
                 gateway_lifecycle: Optional[_builtins.int] = None,
                 project: Optional[_builtins.str] = None,
                 sidecar_enabled: Optional[_builtins.bool] = None,
                 sidecar_lifecycle: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enabled: Enable CNI
        :param _builtins.bool gateway_enabled: Whether collect AccessLog of ASM Gateway to Alibaba Cloud SLS
        :param _builtins.int gateway_lifecycle: Lifecycle of AccessLog of ASM Gateways which have been collected to Alibaba Cloud SLS
        :param _builtins.str project: The name of the SLS Project to which the control plane logs are collected.
        :param _builtins.bool sidecar_enabled: Whether collect AccessLog of ASM Gateway to Alibaba Cloud SLS
        :param _builtins.int sidecar_lifecycle: Lifecycle of AccessLog of ASM Sidecars which have been collected to Alibaba Cloud SLS
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if gateway_enabled is not None:
            pulumi.set(__self__, "gateway_enabled", gateway_enabled)
        if gateway_lifecycle is not None:
            pulumi.set(__self__, "gateway_lifecycle", gateway_lifecycle)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if sidecar_enabled is not None:
            pulumi.set(__self__, "sidecar_enabled", sidecar_enabled)
        if sidecar_lifecycle is not None:
            pulumi.set(__self__, "sidecar_lifecycle", sidecar_lifecycle)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable CNI
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="gatewayEnabled")
    def gateway_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether collect AccessLog of ASM Gateway to Alibaba Cloud SLS
        """
        return pulumi.get(self, "gateway_enabled")

    @_builtins.property
    @pulumi.getter(name="gatewayLifecycle")
    def gateway_lifecycle(self) -> Optional[_builtins.int]:
        """
        Lifecycle of AccessLog of ASM Gateways which have been collected to Alibaba Cloud SLS
        """
        return pulumi.get(self, "gateway_lifecycle")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        """
        The name of the SLS Project to which the control plane logs are collected.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="sidecarEnabled")
    def sidecar_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether collect AccessLog of ASM Gateway to Alibaba Cloud SLS
        """
        return pulumi.get(self, "sidecar_enabled")

    @_builtins.property
    @pulumi.getter(name="sidecarLifecycle")
    def sidecar_lifecycle(self) -> Optional[_builtins.int]:
        """
        Lifecycle of AccessLog of ASM Sidecars which have been collected to Alibaba Cloud SLS
        """
        return pulumi.get(self, "sidecar_lifecycle")


@pulumi.output_type
class ServiceMeshMeshConfigAudit(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 project: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Enable CNI
        :param _builtins.str project: The name of the SLS Project to which the control plane logs are collected.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable CNI
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        """
        The name of the SLS Project to which the control plane logs are collected.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class ServiceMeshMeshConfigControlPlaneLog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logTtlInDay":
            suggest = "log_ttl_in_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigControlPlaneLog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigControlPlaneLog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigControlPlaneLog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 log_ttl_in_day: Optional[_builtins.int] = None,
                 project: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Enable CNI
        :param _builtins.int log_ttl_in_day: Lifecycle of logs has been collected to Alibaba Cloud SLS
        :param _builtins.str project: The name of the SLS Project to which the control plane logs are collected.
        """
        pulumi.set(__self__, "enabled", enabled)
        if log_ttl_in_day is not None:
            pulumi.set(__self__, "log_ttl_in_day", log_ttl_in_day)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable CNI
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="logTtlInDay")
    def log_ttl_in_day(self) -> Optional[_builtins.int]:
        """
        Lifecycle of logs has been collected to Alibaba Cloud SLS
        """
        return pulumi.get(self, "log_ttl_in_day")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        """
        The name of the SLS Project to which the control plane logs are collected.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class ServiceMeshMeshConfigKiali(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aggregatedKialiAddress":
            suggest = "aggregated_kiali_address"
        elif key == "authStrategy":
            suggest = "auth_strategy"
        elif key == "customPrometheusUrl":
            suggest = "custom_prometheus_url"
        elif key == "distributedKialiAccessTokens":
            suggest = "distributed_kiali_access_tokens"
        elif key == "distributedKialiAddresses":
            suggest = "distributed_kiali_addresses"
        elif key == "integrateClb":
            suggest = "integrate_clb"
        elif key == "kialiArmsAuthTokens":
            suggest = "kiali_arms_auth_tokens"
        elif key == "kialiServiceAnnotations":
            suggest = "kiali_service_annotations"
        elif key == "openIdConfig":
            suggest = "open_id_config"
        elif key == "ramOauthConfig":
            suggest = "ram_oauth_config"
        elif key == "serverConfig":
            suggest = "server_config"
        elif key == "usePopulatedArmsPrometheus":
            suggest = "use_populated_arms_prometheus"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigKiali. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigKiali.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigKiali.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregated_kiali_address: Optional[_builtins.str] = None,
                 auth_strategy: Optional[_builtins.str] = None,
                 custom_prometheus_url: Optional[_builtins.str] = None,
                 distributed_kiali_access_tokens: Optional[_builtins.str] = None,
                 distributed_kiali_addresses: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None,
                 integrate_clb: Optional[_builtins.bool] = None,
                 kiali_arms_auth_tokens: Optional[_builtins.str] = None,
                 kiali_service_annotations: Optional[_builtins.str] = None,
                 open_id_config: Optional['outputs.ServiceMeshMeshConfigKialiOpenIdConfig'] = None,
                 ram_oauth_config: Optional['outputs.ServiceMeshMeshConfigKialiRamOauthConfig'] = None,
                 server_config: Optional['outputs.ServiceMeshMeshConfigKialiServerConfig'] = None,
                 url: Optional[_builtins.str] = None,
                 use_populated_arms_prometheus: Optional[_builtins.bool] = None):
        """
        :param _builtins.str aggregated_kiali_address: When the mesh topology is deployed in managed mode and integrated with CLB to provide external access, the external access address is automatically generated.
        :param _builtins.str auth_strategy: The authentication strategy used when logging into the mesh topology. In data plane deployment mode, the mesh topology can use token, openid, or ramoauth authentication strategies; in managed mode, the mesh topology can use openid or ramoauth authentication strategies.
        :param _builtins.str custom_prometheus_url: When the mesh topology cannot automatically use the integrated ARMS Prometheus, you need to use this property to specify a custom Prometheus HTTP API Url. The corresponding Prometheus instance needs to have been configured to collect Istio metrics in the cluster within the service mesh.
        :param _builtins.str distributed_kiali_access_tokens: The login token provided when the mesh topology is deployed in data plane deployment mode. When the mesh topology authentication strategy is token, this token can be used to log in to the mesh topology service. The key of the property is the Kubernetes cluster id, and the value of the property is the login token of the mesh topology service in the cluster.
        :param _builtins.str distributed_kiali_addresses: When the mesh topology is deployed in data plane deployment mode and integrated with CLB to provide external access, the external access address is automatically generated. The key of the attribute is the Kubernetes cluster id, and the value is the external access address of the mesh topology service in the cluster.
        :param _builtins.bool enabled: Enable CNI
        :param _builtins.bool integrate_clb: Whether to integrate CLB for mesh topology services to provide external access.
        :param _builtins.str kiali_arms_auth_tokens: When the mesh topology automatically uses the integrated ARMS Prometheus, if the ARMS Prometheus instance in the cluster has token authentication enabled, you need to use this property to provide the corresponding authentication token for the mesh topology. The key of the property is the Kubernetes cluster id, and the value is the authentication token of the ARMS Prometheus instance corresponding to the cluster. (Service mesh instance version 1.15.3.113 or above is required)
        :param _builtins.str kiali_service_annotations: Annotations for the Service corresponding to the mesh topology service. When the mesh topology service integrates CLB, annotations can be used to control the CLB specifications. The attribute type is map, the key is the Kubernetes cluster id, and the value is the mesh topology service annotation map under the corresponding Kubernetes cluster. When using the managed mode mesh topology, the key is the service mesh instance id. For annotation content, refer to [Configuring traditional load balancing CLB through Annotation](https://www.alibabacloud.com/help/en/ack/serverless-kubernetes/user-guide/use-annotations-to-configure-load-balancing).(Service mesh instance version 1.17.2.19 or above is required)
        :param 'ServiceMeshMeshConfigKialiOpenIdConfigArgs' open_id_config: When the mesh topology's authentication policy is openid, the configuration used when the mesh topology and OIDC application are connected. If the authentication policy is openid, this configuration must be provided. See `open_id_config` below.
        :param 'ServiceMeshMeshConfigKialiRamOauthConfigArgs' ram_oauth_config: When the authentication strategy of the mesh topology is ramoauth, the mesh topology will be connected to the RAM OAuth application to log in with the Alibaba Cloud account. In this case, this attribute must be provided to configure the connection with the RAM OAuth application. See `ram_oauth_config` below.
        :param 'ServiceMeshMeshConfigKialiServerConfigArgs' server_config: When you need to configure external access to the mesh topology through ASM gateway or other means, and access the mesh topology through a custom domain name or address, you need to specify this property. (The service mesh instance version must be 1.16.4.5 or above) See `server_config` below.
        :param _builtins.str url: Kiali service address
        :param _builtins.bool use_populated_arms_prometheus: Whether the mesh topology automatically uses the integrated ARMS Prometheus. When the integrated ARMS Prometheus is automatically used, there is no need to specify the dependent Prometheus HTTP API Url.
        """
        if aggregated_kiali_address is not None:
            pulumi.set(__self__, "aggregated_kiali_address", aggregated_kiali_address)
        if auth_strategy is not None:
            pulumi.set(__self__, "auth_strategy", auth_strategy)
        if custom_prometheus_url is not None:
            pulumi.set(__self__, "custom_prometheus_url", custom_prometheus_url)
        if distributed_kiali_access_tokens is not None:
            pulumi.set(__self__, "distributed_kiali_access_tokens", distributed_kiali_access_tokens)
        if distributed_kiali_addresses is not None:
            pulumi.set(__self__, "distributed_kiali_addresses", distributed_kiali_addresses)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if integrate_clb is not None:
            pulumi.set(__self__, "integrate_clb", integrate_clb)
        if kiali_arms_auth_tokens is not None:
            pulumi.set(__self__, "kiali_arms_auth_tokens", kiali_arms_auth_tokens)
        if kiali_service_annotations is not None:
            pulumi.set(__self__, "kiali_service_annotations", kiali_service_annotations)
        if open_id_config is not None:
            pulumi.set(__self__, "open_id_config", open_id_config)
        if ram_oauth_config is not None:
            pulumi.set(__self__, "ram_oauth_config", ram_oauth_config)
        if server_config is not None:
            pulumi.set(__self__, "server_config", server_config)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if use_populated_arms_prometheus is not None:
            pulumi.set(__self__, "use_populated_arms_prometheus", use_populated_arms_prometheus)

    @_builtins.property
    @pulumi.getter(name="aggregatedKialiAddress")
    def aggregated_kiali_address(self) -> Optional[_builtins.str]:
        """
        When the mesh topology is deployed in managed mode and integrated with CLB to provide external access, the external access address is automatically generated.
        """
        return pulumi.get(self, "aggregated_kiali_address")

    @_builtins.property
    @pulumi.getter(name="authStrategy")
    def auth_strategy(self) -> Optional[_builtins.str]:
        """
        The authentication strategy used when logging into the mesh topology. In data plane deployment mode, the mesh topology can use token, openid, or ramoauth authentication strategies; in managed mode, the mesh topology can use openid or ramoauth authentication strategies.
        """
        return pulumi.get(self, "auth_strategy")

    @_builtins.property
    @pulumi.getter(name="customPrometheusUrl")
    def custom_prometheus_url(self) -> Optional[_builtins.str]:
        """
        When the mesh topology cannot automatically use the integrated ARMS Prometheus, you need to use this property to specify a custom Prometheus HTTP API Url. The corresponding Prometheus instance needs to have been configured to collect Istio metrics in the cluster within the service mesh.
        """
        return pulumi.get(self, "custom_prometheus_url")

    @_builtins.property
    @pulumi.getter(name="distributedKialiAccessTokens")
    def distributed_kiali_access_tokens(self) -> Optional[_builtins.str]:
        """
        The login token provided when the mesh topology is deployed in data plane deployment mode. When the mesh topology authentication strategy is token, this token can be used to log in to the mesh topology service. The key of the property is the Kubernetes cluster id, and the value of the property is the login token of the mesh topology service in the cluster.
        """
        return pulumi.get(self, "distributed_kiali_access_tokens")

    @_builtins.property
    @pulumi.getter(name="distributedKialiAddresses")
    def distributed_kiali_addresses(self) -> Optional[_builtins.str]:
        """
        When the mesh topology is deployed in data plane deployment mode and integrated with CLB to provide external access, the external access address is automatically generated. The key of the attribute is the Kubernetes cluster id, and the value is the external access address of the mesh topology service in the cluster.
        """
        return pulumi.get(self, "distributed_kiali_addresses")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable CNI
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="integrateClb")
    def integrate_clb(self) -> Optional[_builtins.bool]:
        """
        Whether to integrate CLB for mesh topology services to provide external access.
        """
        return pulumi.get(self, "integrate_clb")

    @_builtins.property
    @pulumi.getter(name="kialiArmsAuthTokens")
    def kiali_arms_auth_tokens(self) -> Optional[_builtins.str]:
        """
        When the mesh topology automatically uses the integrated ARMS Prometheus, if the ARMS Prometheus instance in the cluster has token authentication enabled, you need to use this property to provide the corresponding authentication token for the mesh topology. The key of the property is the Kubernetes cluster id, and the value is the authentication token of the ARMS Prometheus instance corresponding to the cluster. (Service mesh instance version 1.15.3.113 or above is required)
        """
        return pulumi.get(self, "kiali_arms_auth_tokens")

    @_builtins.property
    @pulumi.getter(name="kialiServiceAnnotations")
    def kiali_service_annotations(self) -> Optional[_builtins.str]:
        """
        Annotations for the Service corresponding to the mesh topology service. When the mesh topology service integrates CLB, annotations can be used to control the CLB specifications. The attribute type is map, the key is the Kubernetes cluster id, and the value is the mesh topology service annotation map under the corresponding Kubernetes cluster. When using the managed mode mesh topology, the key is the service mesh instance id. For annotation content, refer to [Configuring traditional load balancing CLB through Annotation](https://www.alibabacloud.com/help/en/ack/serverless-kubernetes/user-guide/use-annotations-to-configure-load-balancing).(Service mesh instance version 1.17.2.19 or above is required)
        """
        return pulumi.get(self, "kiali_service_annotations")

    @_builtins.property
    @pulumi.getter(name="openIdConfig")
    def open_id_config(self) -> Optional['outputs.ServiceMeshMeshConfigKialiOpenIdConfig']:
        """
        When the mesh topology's authentication policy is openid, the configuration used when the mesh topology and OIDC application are connected. If the authentication policy is openid, this configuration must be provided. See `open_id_config` below.
        """
        return pulumi.get(self, "open_id_config")

    @_builtins.property
    @pulumi.getter(name="ramOauthConfig")
    def ram_oauth_config(self) -> Optional['outputs.ServiceMeshMeshConfigKialiRamOauthConfig']:
        """
        When the authentication strategy of the mesh topology is ramoauth, the mesh topology will be connected to the RAM OAuth application to log in with the Alibaba Cloud account. In this case, this attribute must be provided to configure the connection with the RAM OAuth application. See `ram_oauth_config` below.
        """
        return pulumi.get(self, "ram_oauth_config")

    @_builtins.property
    @pulumi.getter(name="serverConfig")
    def server_config(self) -> Optional['outputs.ServiceMeshMeshConfigKialiServerConfig']:
        """
        When you need to configure external access to the mesh topology through ASM gateway or other means, and access the mesh topology through a custom domain name or address, you need to specify this property. (The service mesh instance version must be 1.16.4.5 or above) See `server_config` below.
        """
        return pulumi.get(self, "server_config")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        Kiali service address
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="usePopulatedArmsPrometheus")
    def use_populated_arms_prometheus(self) -> Optional[_builtins.bool]:
        """
        Whether the mesh topology automatically uses the integrated ARMS Prometheus. When the integrated ARMS Prometheus is automatically used, there is no need to specify the dependent Prometheus HTTP API Url.
        """
        return pulumi.get(self, "use_populated_arms_prometheus")


@pulumi.output_type
class ServiceMeshMeshConfigKialiOpenIdConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "issuerUri":
            suggest = "issuer_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigKialiOpenIdConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigKialiOpenIdConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigKialiOpenIdConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[_builtins.str] = None,
                 client_secret: Optional[_builtins.str] = None,
                 issuer_uri: Optional[_builtins.str] = None,
                 scopes: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str client_id: The client id provided by the OIDC application
        :param _builtins.str client_secret: The client secret provided by the OIDC application
        :param _builtins.str issuer_uri: OIDC应用的Issuer URI
        :param Sequence[_builtins.str] scopes: The scope of the mesh topology request to the OIDC application
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if issuer_uri is not None:
            pulumi.set(__self__, "issuer_uri", issuer_uri)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        The client id provided by the OIDC application
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[_builtins.str]:
        """
        The client secret provided by the OIDC application
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="issuerUri")
    def issuer_uri(self) -> Optional[_builtins.str]:
        """
        OIDC应用的Issuer URI
        """
        return pulumi.get(self, "issuer_uri")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[_builtins.str]]:
        """
        The scope of the mesh topology request to the OIDC application
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class ServiceMeshMeshConfigKialiRamOauthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redirectUris":
            suggest = "redirect_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigKialiRamOauthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigKialiRamOauthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigKialiRamOauthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 redirect_uris: Optional[_builtins.str] = None):
        """
        :param _builtins.str redirect_uris: The redirect Uri provided to the RAM OAuth application. This needs to be the access address of the mesh topology service. When not provided, the redirect Uri will be automatically inferred based on the ServerConfig or the CLB address of the mesh topology integration.
        """
        if redirect_uris is not None:
            pulumi.set(__self__, "redirect_uris", redirect_uris)

    @_builtins.property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> Optional[_builtins.str]:
        """
        The redirect Uri provided to the RAM OAuth application. This needs to be the access address of the mesh topology service. When not provided, the redirect Uri will be automatically inferred based on the ServerConfig or the CLB address of the mesh topology integration.
        """
        return pulumi.get(self, "redirect_uris")


@pulumi.output_type
class ServiceMeshMeshConfigKialiServerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "webFqdn":
            suggest = "web_fqdn"
        elif key == "webPort":
            suggest = "web_port"
        elif key == "webRoot":
            suggest = "web_root"
        elif key == "webSchema":
            suggest = "web_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigKialiServerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigKialiServerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigKialiServerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 web_fqdn: Optional[_builtins.str] = None,
                 web_port: Optional[_builtins.int] = None,
                 web_root: Optional[_builtins.str] = None,
                 web_schema: Optional[_builtins.str] = None):
        """
        :param _builtins.str web_fqdn: The domain name or address used when accessing the mesh topology in a custom way
        :param _builtins.int web_port: The port used when accessing the mesh topology in a custom way
        :param _builtins.str web_root: The root path of the service when accessing the mesh topology in a custom way
        :param _builtins.str web_schema: The protocol used when accessing the mesh topology in a custom way. Can only be http or https
        """
        if web_fqdn is not None:
            pulumi.set(__self__, "web_fqdn", web_fqdn)
        if web_port is not None:
            pulumi.set(__self__, "web_port", web_port)
        if web_root is not None:
            pulumi.set(__self__, "web_root", web_root)
        if web_schema is not None:
            pulumi.set(__self__, "web_schema", web_schema)

    @_builtins.property
    @pulumi.getter(name="webFqdn")
    def web_fqdn(self) -> Optional[_builtins.str]:
        """
        The domain name or address used when accessing the mesh topology in a custom way
        """
        return pulumi.get(self, "web_fqdn")

    @_builtins.property
    @pulumi.getter(name="webPort")
    def web_port(self) -> Optional[_builtins.int]:
        """
        The port used when accessing the mesh topology in a custom way
        """
        return pulumi.get(self, "web_port")

    @_builtins.property
    @pulumi.getter(name="webRoot")
    def web_root(self) -> Optional[_builtins.str]:
        """
        The root path of the service when accessing the mesh topology in a custom way
        """
        return pulumi.get(self, "web_root")

    @_builtins.property
    @pulumi.getter(name="webSchema")
    def web_schema(self) -> Optional[_builtins.str]:
        """
        The protocol used when accessing the mesh topology in a custom way. Can only be http or https
        """
        return pulumi.get(self, "web_schema")


@pulumi.output_type
class ServiceMeshMeshConfigOpa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "limitCpu":
            suggest = "limit_cpu"
        elif key == "limitMemory":
            suggest = "limit_memory"
        elif key == "logLevel":
            suggest = "log_level"
        elif key == "requestCpu":
            suggest = "request_cpu"
        elif key == "requestMemory":
            suggest = "request_memory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigOpa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigOpa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigOpa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 limit_cpu: Optional[_builtins.str] = None,
                 limit_memory: Optional[_builtins.str] = None,
                 log_level: Optional[_builtins.str] = None,
                 request_cpu: Optional[_builtins.str] = None,
                 request_memory: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Enable CNI
        :param _builtins.str limit_cpu: Sidecar injector Pods on the throttle
        :param _builtins.str limit_memory: Sidecar injector Pods on the throttle
        :param _builtins.str log_level: OPA proxy container log level
        :param _builtins.str request_cpu: Sidecar injector Pods on the requested resource
        :param _builtins.str request_memory: Sidecar injector Pods on the requested resource
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if limit_cpu is not None:
            pulumi.set(__self__, "limit_cpu", limit_cpu)
        if limit_memory is not None:
            pulumi.set(__self__, "limit_memory", limit_memory)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if request_cpu is not None:
            pulumi.set(__self__, "request_cpu", request_cpu)
        if request_memory is not None:
            pulumi.set(__self__, "request_memory", request_memory)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable CNI
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> Optional[_builtins.str]:
        """
        Sidecar injector Pods on the throttle
        """
        return pulumi.get(self, "limit_cpu")

    @_builtins.property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> Optional[_builtins.str]:
        """
        Sidecar injector Pods on the throttle
        """
        return pulumi.get(self, "limit_memory")

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[_builtins.str]:
        """
        OPA proxy container log level
        """
        return pulumi.get(self, "log_level")

    @_builtins.property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> Optional[_builtins.str]:
        """
        Sidecar injector Pods on the requested resource
        """
        return pulumi.get(self, "request_cpu")

    @_builtins.property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> Optional[_builtins.str]:
        """
        Sidecar injector Pods on the requested resource
        """
        return pulumi.get(self, "request_memory")


@pulumi.output_type
class ServiceMeshMeshConfigPilot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "http10Enabled":
            suggest = "http10_enabled"
        elif key == "traceSampling":
            suggest = "trace_sampling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigPilot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigPilot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigPilot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http10_enabled: Optional[_builtins.bool] = None,
                 trace_sampling: Optional[_builtins.float] = None):
        """
        :param _builtins.bool http10_enabled: Whether to support the HTTP1.0
        :param _builtins.float trace_sampling: Link trace sampling percentage
        """
        if http10_enabled is not None:
            pulumi.set(__self__, "http10_enabled", http10_enabled)
        if trace_sampling is not None:
            pulumi.set(__self__, "trace_sampling", trace_sampling)

    @_builtins.property
    @pulumi.getter(name="http10Enabled")
    def http10_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to support the HTTP1.0
        """
        return pulumi.get(self, "http10_enabled")

    @_builtins.property
    @pulumi.getter(name="traceSampling")
    def trace_sampling(self) -> Optional[_builtins.float]:
        """
        Link trace sampling percentage
        """
        return pulumi.get(self, "trace_sampling")


@pulumi.output_type
class ServiceMeshMeshConfigPrometheus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalUrl":
            suggest = "external_url"
        elif key == "useExternal":
            suggest = "use_external"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigPrometheus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigPrometheus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigPrometheus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_url: Optional[_builtins.str] = None,
                 use_external: Optional[_builtins.bool] = None):
        """
        :param _builtins.str external_url: Prometheus service addresses (enabled external Prometheus when the system automatically populates)
        :param _builtins.bool use_external: Whether to enable external Prometheus
        """
        if external_url is not None:
            pulumi.set(__self__, "external_url", external_url)
        if use_external is not None:
            pulumi.set(__self__, "use_external", use_external)

    @_builtins.property
    @pulumi.getter(name="externalUrl")
    def external_url(self) -> Optional[_builtins.str]:
        """
        Prometheus service addresses (enabled external Prometheus when the system automatically populates)
        """
        return pulumi.get(self, "external_url")

    @_builtins.property
    @pulumi.getter(name="useExternal")
    def use_external(self) -> Optional[_builtins.bool]:
        """
        Whether to enable external Prometheus
        """
        return pulumi.get(self, "use_external")


@pulumi.output_type
class ServiceMeshMeshConfigProxy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterDomain":
            suggest = "cluster_domain"
        elif key == "limitCpu":
            suggest = "limit_cpu"
        elif key == "limitMemory":
            suggest = "limit_memory"
        elif key == "requestCpu":
            suggest = "request_cpu"
        elif key == "requestMemory":
            suggest = "request_memory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigProxy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigProxy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigProxy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_domain: Optional[_builtins.str] = None,
                 limit_cpu: Optional[_builtins.str] = None,
                 limit_memory: Optional[_builtins.str] = None,
                 request_cpu: Optional[_builtins.str] = None,
                 request_memory: Optional[_builtins.str] = None):
        """
        :param _builtins.str cluster_domain: Cluster domain name
        :param _builtins.str limit_cpu: Sidecar injector Pods on the throttle
        :param _builtins.str limit_memory: Sidecar injector Pods on the throttle
        :param _builtins.str request_cpu: Sidecar injector Pods on the requested resource
        :param _builtins.str request_memory: Sidecar injector Pods on the requested resource
        """
        if cluster_domain is not None:
            pulumi.set(__self__, "cluster_domain", cluster_domain)
        if limit_cpu is not None:
            pulumi.set(__self__, "limit_cpu", limit_cpu)
        if limit_memory is not None:
            pulumi.set(__self__, "limit_memory", limit_memory)
        if request_cpu is not None:
            pulumi.set(__self__, "request_cpu", request_cpu)
        if request_memory is not None:
            pulumi.set(__self__, "request_memory", request_memory)

    @_builtins.property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> Optional[_builtins.str]:
        """
        Cluster domain name
        """
        return pulumi.get(self, "cluster_domain")

    @_builtins.property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> Optional[_builtins.str]:
        """
        Sidecar injector Pods on the throttle
        """
        return pulumi.get(self, "limit_cpu")

    @_builtins.property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> Optional[_builtins.str]:
        """
        Sidecar injector Pods on the throttle
        """
        return pulumi.get(self, "limit_memory")

    @_builtins.property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> Optional[_builtins.str]:
        """
        Sidecar injector Pods on the requested resource
        """
        return pulumi.get(self, "request_cpu")

    @_builtins.property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> Optional[_builtins.str]:
        """
        Sidecar injector Pods on the requested resource
        """
        return pulumi.get(self, "request_memory")


@pulumi.output_type
class ServiceMeshMeshConfigSidecarInjector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoInjectionPolicyEnabled":
            suggest = "auto_injection_policy_enabled"
        elif key == "enableNamespacesByDefault":
            suggest = "enable_namespaces_by_default"
        elif key == "initCniConfiguration":
            suggest = "init_cni_configuration"
        elif key == "limitCpu":
            suggest = "limit_cpu"
        elif key == "limitMemory":
            suggest = "limit_memory"
        elif key == "requestCpu":
            suggest = "request_cpu"
        elif key == "requestMemory":
            suggest = "request_memory"
        elif key == "sidecarInjectorWebhookAsYaml":
            suggest = "sidecar_injector_webhook_as_yaml"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigSidecarInjector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigSidecarInjector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigSidecarInjector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_injection_policy_enabled: Optional[_builtins.bool] = None,
                 enable_namespaces_by_default: Optional[_builtins.bool] = None,
                 init_cni_configuration: Optional['outputs.ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration'] = None,
                 limit_cpu: Optional[_builtins.str] = None,
                 limit_memory: Optional[_builtins.str] = None,
                 request_cpu: Optional[_builtins.str] = None,
                 request_memory: Optional[_builtins.str] = None,
                 sidecar_injector_webhook_as_yaml: Optional[_builtins.str] = None):
        """
        :param _builtins.bool auto_injection_policy_enabled: Whether to enable by Pod Annotations automatic injection Sidecar
        :param _builtins.bool enable_namespaces_by_default: Whether it is the all namespaces you turn on the auto injection capabilities
        :param 'ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs' init_cni_configuration: CNI configuration See `init_cni_configuration` below.
        :param _builtins.str limit_cpu: Sidecar injector Pods on the throttle
        :param _builtins.str limit_memory: Sidecar injector Pods on the throttle
        :param _builtins.str request_cpu: Sidecar injector Pods on the requested resource
        :param _builtins.str request_memory: Sidecar injector Pods on the requested resource
        :param _builtins.str sidecar_injector_webhook_as_yaml: Other automatic injection Sidecar configuration (in YAML format)
        """
        if auto_injection_policy_enabled is not None:
            pulumi.set(__self__, "auto_injection_policy_enabled", auto_injection_policy_enabled)
        if enable_namespaces_by_default is not None:
            pulumi.set(__self__, "enable_namespaces_by_default", enable_namespaces_by_default)
        if init_cni_configuration is not None:
            pulumi.set(__self__, "init_cni_configuration", init_cni_configuration)
        if limit_cpu is not None:
            pulumi.set(__self__, "limit_cpu", limit_cpu)
        if limit_memory is not None:
            pulumi.set(__self__, "limit_memory", limit_memory)
        if request_cpu is not None:
            pulumi.set(__self__, "request_cpu", request_cpu)
        if request_memory is not None:
            pulumi.set(__self__, "request_memory", request_memory)
        if sidecar_injector_webhook_as_yaml is not None:
            pulumi.set(__self__, "sidecar_injector_webhook_as_yaml", sidecar_injector_webhook_as_yaml)

    @_builtins.property
    @pulumi.getter(name="autoInjectionPolicyEnabled")
    def auto_injection_policy_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable by Pod Annotations automatic injection Sidecar
        """
        return pulumi.get(self, "auto_injection_policy_enabled")

    @_builtins.property
    @pulumi.getter(name="enableNamespacesByDefault")
    def enable_namespaces_by_default(self) -> Optional[_builtins.bool]:
        """
        Whether it is the all namespaces you turn on the auto injection capabilities
        """
        return pulumi.get(self, "enable_namespaces_by_default")

    @_builtins.property
    @pulumi.getter(name="initCniConfiguration")
    def init_cni_configuration(self) -> Optional['outputs.ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration']:
        """
        CNI configuration See `init_cni_configuration` below.
        """
        return pulumi.get(self, "init_cni_configuration")

    @_builtins.property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> Optional[_builtins.str]:
        """
        Sidecar injector Pods on the throttle
        """
        return pulumi.get(self, "limit_cpu")

    @_builtins.property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> Optional[_builtins.str]:
        """
        Sidecar injector Pods on the throttle
        """
        return pulumi.get(self, "limit_memory")

    @_builtins.property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> Optional[_builtins.str]:
        """
        Sidecar injector Pods on the requested resource
        """
        return pulumi.get(self, "request_cpu")

    @_builtins.property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> Optional[_builtins.str]:
        """
        Sidecar injector Pods on the requested resource
        """
        return pulumi.get(self, "request_memory")

    @_builtins.property
    @pulumi.getter(name="sidecarInjectorWebhookAsYaml")
    def sidecar_injector_webhook_as_yaml(self) -> Optional[_builtins.str]:
        """
        Other automatic injection Sidecar configuration (in YAML format)
        """
        return pulumi.get(self, "sidecar_injector_webhook_as_yaml")


@pulumi.output_type
class ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeNamespaces":
            suggest = "exclude_namespaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 exclude_namespaces: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Enable CNI
        :param _builtins.str exclude_namespaces: The excluded namespace
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if exclude_namespaces is not None:
            pulumi.set(__self__, "exclude_namespaces", exclude_namespaces)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enable CNI
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="excludeNamespaces")
    def exclude_namespaces(self) -> Optional[_builtins.str]:
        """
        The excluded namespace
        """
        return pulumi.get(self, "exclude_namespaces")


@pulumi.output_type
class ServiceMeshNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"
        elif key == "vswitcheList":
            suggest = "vswitche_list"
        elif key == "securityGroupId":
            suggest = "security_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: _builtins.str,
                 vswitche_list: _builtins.str,
                 security_group_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str vpc_id: VPC ID
        :param _builtins.str vswitche_list: Virtual Switch ID
        :param _builtins.str security_group_id: Security group ID
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitche_list", vswitche_list)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        VPC ID
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitcheList")
    def vswitche_list(self) -> _builtins.str:
        """
        Virtual Switch ID
        """
        return pulumi.get(self, "vswitche_list")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[_builtins.str]:
        """
        Security group ID
        """
        return pulumi.get(self, "security_group_id")


@pulumi.output_type
class UserPermissionPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isCustom":
            suggest = "is_custom"
        elif key == "isRamRole":
            suggest = "is_ram_role"
        elif key == "roleName":
            suggest = "role_name"
        elif key == "roleType":
            suggest = "role_type"
        elif key == "serviceMeshId":
            suggest = "service_mesh_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPermissionPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPermissionPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPermissionPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_custom: Optional[_builtins.bool] = None,
                 is_ram_role: Optional[_builtins.bool] = None,
                 role_name: Optional[_builtins.str] = None,
                 role_type: Optional[_builtins.str] = None,
                 service_mesh_id: Optional[_builtins.str] = None):
        """
        :param _builtins.bool is_custom: Whether the grant object is a RAM role.
        :param _builtins.bool is_ram_role: Whether the grant object is an entity.
        :param _builtins.str role_name: The permission name. Valid values: `istio-admin`, `istio-ops`, `istio-readonly`.
               - `istio-admin`:  The administrator.
               - `istio-ops`: The administrator of the service mesh resource.
               - `istio-readonly`: The read only permission.
        :param _builtins.str role_type: The role type. Valid Value: `custom`.
        :param _builtins.str service_mesh_id: The service mesh id.
        """
        if is_custom is not None:
            pulumi.set(__self__, "is_custom", is_custom)
        if is_ram_role is not None:
            pulumi.set(__self__, "is_ram_role", is_ram_role)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)
        if service_mesh_id is not None:
            pulumi.set(__self__, "service_mesh_id", service_mesh_id)

    @_builtins.property
    @pulumi.getter(name="isCustom")
    def is_custom(self) -> Optional[_builtins.bool]:
        """
        Whether the grant object is a RAM role.
        """
        return pulumi.get(self, "is_custom")

    @_builtins.property
    @pulumi.getter(name="isRamRole")
    def is_ram_role(self) -> Optional[_builtins.bool]:
        """
        Whether the grant object is an entity.
        """
        return pulumi.get(self, "is_ram_role")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[_builtins.str]:
        """
        The permission name. Valid values: `istio-admin`, `istio-ops`, `istio-readonly`.
        - `istio-admin`:  The administrator.
        - `istio-ops`: The administrator of the service mesh resource.
        - `istio-readonly`: The read only permission.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[_builtins.str]:
        """
        The role type. Valid Value: `custom`.
        """
        return pulumi.get(self, "role_type")

    @_builtins.property
    @pulumi.getter(name="serviceMeshId")
    def service_mesh_id(self) -> Optional[_builtins.str]:
        """
        The service mesh id.
        """
        return pulumi.get(self, "service_mesh_id")


@pulumi.output_type
class GetExtensionProvidersProviderResult(dict):
    def __init__(__self__, *,
                 config: _builtins.str,
                 extension_provider_name: _builtins.str,
                 id: _builtins.str,
                 service_mesh_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str config: The config of the Service Mesh Extension Provider.
        :param _builtins.str extension_provider_name: The name of the Service Mesh Extension Provider.
        :param _builtins.str id: The ID of the Service Mesh Extension Provider. It formats as `<service_mesh_id>:<type>:<extension_provider_name>`.
        :param _builtins.str service_mesh_id: The ID of the Service Mesh.
        :param _builtins.str type: The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "extension_provider_name", extension_provider_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "service_mesh_id", service_mesh_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def config(self) -> _builtins.str:
        """
        The config of the Service Mesh Extension Provider.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="extensionProviderName")
    def extension_provider_name(self) -> _builtins.str:
        """
        The name of the Service Mesh Extension Provider.
        """
        return pulumi.get(self, "extension_provider_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Service Mesh Extension Provider. It formats as `<service_mesh_id>:<type>:<extension_provider_name>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="serviceMeshId")
    def service_mesh_id(self) -> _builtins.str:
        """
        The ID of the Service Mesh.
        """
        return pulumi.get(self, "service_mesh_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceMeshesMeshResult(dict):
    def __init__(__self__, *,
                 clusters: Sequence[_builtins.str],
                 create_time: _builtins.str,
                 edition: _builtins.str,
                 endpoints: Sequence['outputs.GetServiceMeshesMeshEndpointResult'],
                 error_message: _builtins.str,
                 id: _builtins.str,
                 istio_operator_version: _builtins.str,
                 kube_config: _builtins.str,
                 load_balancers: Sequence['outputs.GetServiceMeshesMeshLoadBalancerResult'],
                 mesh_configs: Sequence['outputs.GetServiceMeshesMeshMeshConfigResult'],
                 networks: Sequence['outputs.GetServiceMeshesMeshNetworkResult'],
                 service_mesh_id: _builtins.str,
                 service_mesh_name: _builtins.str,
                 sidecar_version: _builtins.str,
                 status: _builtins.str,
                 version: _builtins.str):
        """
        :param Sequence[_builtins.str] clusters: The Cluster List.
        :param _builtins.str create_time: The created time of the Service Mesh instance.
        :param _builtins.str edition: Grid instance version type. **Note:** `edition` takes effect only if `enable_details` is set to `true`.
        :param Sequence['GetServiceMeshesMeshEndpointArgs'] endpoints: The endpoint details. **Note:** `endpoints` takes effect only if `enable_details` is set to `true`.
        :param _builtins.str error_message: The returned error message.
        :param _builtins.str id: The ID of the Service Mesh instance.
        :param _builtins.str istio_operator_version: (Available since v1.170.0) The Istio Operator Version. **Note:** `istio_operator_version` takes effect only if `enable_details` is set to `true`.
        :param _builtins.str kube_config: The content of Kube config. **Note:** `kube_config` takes effect only if `enable_details` is set to `true`.
        :param Sequence['GetServiceMeshesMeshLoadBalancerArgs'] load_balancers: The configuration of the Load Balancer. **Note:** `load_balancer` takes effect only if `enable_details` is set to `true`.
        :param Sequence['GetServiceMeshesMeshMeshConfigArgs'] mesh_configs: The configuration of the Service grid. **Note:** `mesh_config` takes effect only if `enable_details` is set to `true`.
        :param Sequence['GetServiceMeshesMeshNetworkArgs'] networks: The configuration of the Service grid network. **Note:** `network` takes effect only if `enable_details` is set to `true`.
        :param _builtins.str service_mesh_id: The ID of the Service Mesh instance.
        :param _builtins.str service_mesh_name: The name of the Service Mesh instance.
        :param _builtins.str sidecar_version: (Available since v1.170.0) The SideCar Version. **Note:** `sidecar_version` takes effect only if `enable_details` is set to `true`.
        :param _builtins.str status: The status of the Service Mesh. Valid values: `running`, `initial`.
        :param _builtins.str version: The version of the Service Mesh instance.
        """
        pulumi.set(__self__, "clusters", clusters)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "istio_operator_version", istio_operator_version)
        pulumi.set(__self__, "kube_config", kube_config)
        pulumi.set(__self__, "load_balancers", load_balancers)
        pulumi.set(__self__, "mesh_configs", mesh_configs)
        pulumi.set(__self__, "networks", networks)
        pulumi.set(__self__, "service_mesh_id", service_mesh_id)
        pulumi.set(__self__, "service_mesh_name", service_mesh_name)
        pulumi.set(__self__, "sidecar_version", sidecar_version)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Sequence[_builtins.str]:
        """
        The Cluster List.
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The created time of the Service Mesh instance.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def edition(self) -> _builtins.str:
        """
        Grid instance version type. **Note:** `edition` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetServiceMeshesMeshEndpointResult']:
        """
        The endpoint details. **Note:** `endpoints` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> _builtins.str:
        """
        The returned error message.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Service Mesh instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="istioOperatorVersion")
    def istio_operator_version(self) -> _builtins.str:
        """
        (Available since v1.170.0) The Istio Operator Version. **Note:** `istio_operator_version` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "istio_operator_version")

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> _builtins.str:
        """
        The content of Kube config. **Note:** `kube_config` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "kube_config")

    @_builtins.property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Sequence['outputs.GetServiceMeshesMeshLoadBalancerResult']:
        """
        The configuration of the Load Balancer. **Note:** `load_balancer` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "load_balancers")

    @_builtins.property
    @pulumi.getter(name="meshConfigs")
    def mesh_configs(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigResult']:
        """
        The configuration of the Service grid. **Note:** `mesh_config` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "mesh_configs")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.GetServiceMeshesMeshNetworkResult']:
        """
        The configuration of the Service grid network. **Note:** `network` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter(name="serviceMeshId")
    def service_mesh_id(self) -> _builtins.str:
        """
        The ID of the Service Mesh instance.
        """
        return pulumi.get(self, "service_mesh_id")

    @_builtins.property
    @pulumi.getter(name="serviceMeshName")
    def service_mesh_name(self) -> _builtins.str:
        """
        The name of the Service Mesh instance.
        """
        return pulumi.get(self, "service_mesh_name")

    @_builtins.property
    @pulumi.getter(name="sidecarVersion")
    def sidecar_version(self) -> _builtins.str:
        """
        (Available since v1.170.0) The SideCar Version. **Note:** `sidecar_version` takes effect only if `enable_details` is set to `true`.
        """
        return pulumi.get(self, "sidecar_version")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Service Mesh. Valid values: `running`, `initial`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the Service Mesh instance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetServiceMeshesMeshEndpointResult(dict):
    def __init__(__self__, *,
                 intranet_api_server_endpoint: _builtins.str,
                 intranet_pilot_endpoint: _builtins.str,
                 public_api_server_endpoint: _builtins.str,
                 public_pilot_endpoint: _builtins.str):
        """
        :param _builtins.str intranet_api_server_endpoint: The internal address of the API Server.
        :param _builtins.str intranet_pilot_endpoint: The internal address of the Istio Pilot.
        :param _builtins.str public_api_server_endpoint: The public address of the API Server.
        :param _builtins.str public_pilot_endpoint: The public address of the Istio Pilot.
        """
        pulumi.set(__self__, "intranet_api_server_endpoint", intranet_api_server_endpoint)
        pulumi.set(__self__, "intranet_pilot_endpoint", intranet_pilot_endpoint)
        pulumi.set(__self__, "public_api_server_endpoint", public_api_server_endpoint)
        pulumi.set(__self__, "public_pilot_endpoint", public_pilot_endpoint)

    @_builtins.property
    @pulumi.getter(name="intranetApiServerEndpoint")
    def intranet_api_server_endpoint(self) -> _builtins.str:
        """
        The internal address of the API Server.
        """
        return pulumi.get(self, "intranet_api_server_endpoint")

    @_builtins.property
    @pulumi.getter(name="intranetPilotEndpoint")
    def intranet_pilot_endpoint(self) -> _builtins.str:
        """
        The internal address of the Istio Pilot.
        """
        return pulumi.get(self, "intranet_pilot_endpoint")

    @_builtins.property
    @pulumi.getter(name="publicApiServerEndpoint")
    def public_api_server_endpoint(self) -> _builtins.str:
        """
        The public address of the API Server.
        """
        return pulumi.get(self, "public_api_server_endpoint")

    @_builtins.property
    @pulumi.getter(name="publicPilotEndpoint")
    def public_pilot_endpoint(self) -> _builtins.str:
        """
        The public address of the Istio Pilot.
        """
        return pulumi.get(self, "public_pilot_endpoint")


@pulumi.output_type
class GetServiceMeshesMeshLoadBalancerResult(dict):
    def __init__(__self__, *,
                 api_server_loadbalancer_id: _builtins.str,
                 api_server_public_eip: _builtins.bool,
                 pilot_public_eip: _builtins.bool,
                 pilot_public_loadbalancer_id: _builtins.str):
        """
        :param _builtins.str api_server_loadbalancer_id: The IP address of a public network exposed API Server corresponding to the Load Balance.
        :param _builtins.bool api_server_public_eip: Whether to use the IP address of a public network exposed the API Server.
        :param _builtins.bool pilot_public_eip: Whether to use the IP address of a public network exposure the Istio Pilot.
        :param _builtins.str pilot_public_loadbalancer_id: The IP address of a public network exposure Istio Pilot corresponds to the Load Balance.
        """
        pulumi.set(__self__, "api_server_loadbalancer_id", api_server_loadbalancer_id)
        pulumi.set(__self__, "api_server_public_eip", api_server_public_eip)
        pulumi.set(__self__, "pilot_public_eip", pilot_public_eip)
        pulumi.set(__self__, "pilot_public_loadbalancer_id", pilot_public_loadbalancer_id)

    @_builtins.property
    @pulumi.getter(name="apiServerLoadbalancerId")
    def api_server_loadbalancer_id(self) -> _builtins.str:
        """
        The IP address of a public network exposed API Server corresponding to the Load Balance.
        """
        return pulumi.get(self, "api_server_loadbalancer_id")

    @_builtins.property
    @pulumi.getter(name="apiServerPublicEip")
    def api_server_public_eip(self) -> _builtins.bool:
        """
        Whether to use the IP address of a public network exposed the API Server.
        """
        return pulumi.get(self, "api_server_public_eip")

    @_builtins.property
    @pulumi.getter(name="pilotPublicEip")
    def pilot_public_eip(self) -> _builtins.bool:
        """
        Whether to use the IP address of a public network exposure the Istio Pilot.
        """
        return pulumi.get(self, "pilot_public_eip")

    @_builtins.property
    @pulumi.getter(name="pilotPublicLoadbalancerId")
    def pilot_public_loadbalancer_id(self) -> _builtins.str:
        """
        The IP address of a public network exposure Istio Pilot corresponds to the Load Balance.
        """
        return pulumi.get(self, "pilot_public_loadbalancer_id")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigResult(dict):
    def __init__(__self__, *,
                 access_logs: Sequence['outputs.GetServiceMeshesMeshMeshConfigAccessLogResult'],
                 audits: Sequence['outputs.GetServiceMeshesMeshMeshConfigAuditResult'],
                 control_plane_logs: Sequence['outputs.GetServiceMeshesMeshMeshConfigControlPlaneLogResult'],
                 customized_zipkin: _builtins.bool,
                 enable_locality_lb: _builtins.bool,
                 include_ip_ranges: _builtins.str,
                 kialis: Sequence['outputs.GetServiceMeshesMeshMeshConfigKialiResult'],
                 opas: Sequence['outputs.GetServiceMeshesMeshMeshConfigOpaResult'],
                 outbound_traffic_policy: _builtins.str,
                 pilots: Sequence['outputs.GetServiceMeshesMeshMeshConfigPilotResult'],
                 prometheuses: Sequence['outputs.GetServiceMeshesMeshMeshConfigPrometheusResult'],
                 proxies: Sequence['outputs.GetServiceMeshesMeshMeshConfigProxyResult'],
                 sidecar_injectors: Sequence['outputs.GetServiceMeshesMeshMeshConfigSidecarInjectorResult'],
                 telemetry: _builtins.bool,
                 tracing: _builtins.bool):
        """
        :param Sequence['GetServiceMeshesMeshMeshConfigAccessLogArgs'] access_logs: The configuration of the access logging.
        :param Sequence['GetServiceMeshesMeshMeshConfigAuditArgs'] audits: The configuration of the Service grid audit.
        :param Sequence['GetServiceMeshesMeshMeshConfigControlPlaneLogArgs'] control_plane_logs: (Available since v1.174.0) The configuration of the control plane logging.
        :param _builtins.bool customized_zipkin: Whether or not to enable the use of a custom zipkin.
        :param _builtins.bool enable_locality_lb: Whether to enable service can access the service through the nearest node access.
        :param _builtins.str include_ip_ranges: The IP ADDRESS range.
        :param Sequence['GetServiceMeshesMeshMeshConfigKialiArgs'] kialis: The configuration of the Kiali.
        :param Sequence['GetServiceMeshesMeshMeshConfigOpaArgs'] opas: The open-door policy of agent (OPA) plug-in information.
        :param _builtins.str outbound_traffic_policy: The policy of the Out to the traffic.
        :param Sequence['GetServiceMeshesMeshMeshConfigPilotArgs'] pilots: The configuration of the Link trace sampling.
        :param Sequence['GetServiceMeshesMeshMeshConfigPrometheusArgs'] prometheuses: the configuration of the Prometheus.
        :param Sequence['GetServiceMeshesMeshMeshConfigProxyArgs'] proxies: The configuration of the Proxy.
        :param Sequence['GetServiceMeshesMeshMeshConfigSidecarInjectorArgs'] sidecar_injectors: The configuration of the Sidecar injector.
        :param _builtins.bool telemetry: Whether to enable acquisition Prometheus metrics.
        :param _builtins.bool tracing: Whether to enable link trace.
        """
        pulumi.set(__self__, "access_logs", access_logs)
        pulumi.set(__self__, "audits", audits)
        pulumi.set(__self__, "control_plane_logs", control_plane_logs)
        pulumi.set(__self__, "customized_zipkin", customized_zipkin)
        pulumi.set(__self__, "enable_locality_lb", enable_locality_lb)
        pulumi.set(__self__, "include_ip_ranges", include_ip_ranges)
        pulumi.set(__self__, "kialis", kialis)
        pulumi.set(__self__, "opas", opas)
        pulumi.set(__self__, "outbound_traffic_policy", outbound_traffic_policy)
        pulumi.set(__self__, "pilots", pilots)
        pulumi.set(__self__, "prometheuses", prometheuses)
        pulumi.set(__self__, "proxies", proxies)
        pulumi.set(__self__, "sidecar_injectors", sidecar_injectors)
        pulumi.set(__self__, "telemetry", telemetry)
        pulumi.set(__self__, "tracing", tracing)

    @_builtins.property
    @pulumi.getter(name="accessLogs")
    def access_logs(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigAccessLogResult']:
        """
        The configuration of the access logging.
        """
        return pulumi.get(self, "access_logs")

    @_builtins.property
    @pulumi.getter
    def audits(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigAuditResult']:
        """
        The configuration of the Service grid audit.
        """
        return pulumi.get(self, "audits")

    @_builtins.property
    @pulumi.getter(name="controlPlaneLogs")
    def control_plane_logs(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigControlPlaneLogResult']:
        """
        (Available since v1.174.0) The configuration of the control plane logging.
        """
        return pulumi.get(self, "control_plane_logs")

    @_builtins.property
    @pulumi.getter(name="customizedZipkin")
    def customized_zipkin(self) -> _builtins.bool:
        """
        Whether or not to enable the use of a custom zipkin.
        """
        return pulumi.get(self, "customized_zipkin")

    @_builtins.property
    @pulumi.getter(name="enableLocalityLb")
    def enable_locality_lb(self) -> _builtins.bool:
        """
        Whether to enable service can access the service through the nearest node access.
        """
        return pulumi.get(self, "enable_locality_lb")

    @_builtins.property
    @pulumi.getter(name="includeIpRanges")
    def include_ip_ranges(self) -> _builtins.str:
        """
        The IP ADDRESS range.
        """
        return pulumi.get(self, "include_ip_ranges")

    @_builtins.property
    @pulumi.getter
    def kialis(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigKialiResult']:
        """
        The configuration of the Kiali.
        """
        return pulumi.get(self, "kialis")

    @_builtins.property
    @pulumi.getter
    def opas(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigOpaResult']:
        """
        The open-door policy of agent (OPA) plug-in information.
        """
        return pulumi.get(self, "opas")

    @_builtins.property
    @pulumi.getter(name="outboundTrafficPolicy")
    def outbound_traffic_policy(self) -> _builtins.str:
        """
        The policy of the Out to the traffic.
        """
        return pulumi.get(self, "outbound_traffic_policy")

    @_builtins.property
    @pulumi.getter
    def pilots(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigPilotResult']:
        """
        The configuration of the Link trace sampling.
        """
        return pulumi.get(self, "pilots")

    @_builtins.property
    @pulumi.getter
    def prometheuses(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigPrometheusResult']:
        """
        the configuration of the Prometheus.
        """
        return pulumi.get(self, "prometheuses")

    @_builtins.property
    @pulumi.getter
    def proxies(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigProxyResult']:
        """
        The configuration of the Proxy.
        """
        return pulumi.get(self, "proxies")

    @_builtins.property
    @pulumi.getter(name="sidecarInjectors")
    def sidecar_injectors(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigSidecarInjectorResult']:
        """
        The configuration of the Sidecar injector.
        """
        return pulumi.get(self, "sidecar_injectors")

    @_builtins.property
    @pulumi.getter
    def telemetry(self) -> _builtins.bool:
        """
        Whether to enable acquisition Prometheus metrics.
        """
        return pulumi.get(self, "telemetry")

    @_builtins.property
    @pulumi.getter
    def tracing(self) -> _builtins.bool:
        """
        Whether to enable link trace.
        """
        return pulumi.get(self, "tracing")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigAccessLogResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 project: _builtins.str):
        """
        :param _builtins.bool enabled: Whether to enable CNI.
        :param _builtins.str project: The Service grid audit that to the project.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether to enable CNI.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The Service grid audit that to the project.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigAuditResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 project: _builtins.str):
        """
        :param _builtins.bool enabled: Whether to enable CNI.
        :param _builtins.str project: The Service grid audit that to the project.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether to enable CNI.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The Service grid audit that to the project.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigControlPlaneLogResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 project: _builtins.str):
        """
        :param _builtins.bool enabled: Whether to enable CNI.
        :param _builtins.str project: The Service grid audit that to the project.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether to enable CNI.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The Service grid audit that to the project.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigKialiResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 url: _builtins.str):
        """
        :param _builtins.bool enabled: Whether to enable CNI.
        :param _builtins.str url: The service address of the Kiali.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether to enable CNI.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The service address of the Kiali.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigOpaResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 limit_cpu: _builtins.str,
                 limit_memory: _builtins.str,
                 log_level: _builtins.str,
                 request_cpu: _builtins.str,
                 request_memory: _builtins.str):
        """
        :param _builtins.bool enabled: Whether to enable CNI.
        :param _builtins.str limit_cpu: Sidecar injector Pods on the throttle.
        :param _builtins.str limit_memory: The memory limit  of the Sidecar injector Pods.
        :param _builtins.str log_level: The log level of the OPA proxy container .
        :param _builtins.str request_cpu: The requested cpu the Sidecar injector Pods.
        :param _builtins.str request_memory: The requested memory the Sidecar injector Pods.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "limit_cpu", limit_cpu)
        pulumi.set(__self__, "limit_memory", limit_memory)
        pulumi.set(__self__, "log_level", log_level)
        pulumi.set(__self__, "request_cpu", request_cpu)
        pulumi.set(__self__, "request_memory", request_memory)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether to enable CNI.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> _builtins.str:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_cpu")

    @_builtins.property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> _builtins.str:
        """
        The memory limit  of the Sidecar injector Pods.
        """
        return pulumi.get(self, "limit_memory")

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> _builtins.str:
        """
        The log level of the OPA proxy container .
        """
        return pulumi.get(self, "log_level")

    @_builtins.property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> _builtins.str:
        """
        The requested cpu the Sidecar injector Pods.
        """
        return pulumi.get(self, "request_cpu")

    @_builtins.property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> _builtins.str:
        """
        The requested memory the Sidecar injector Pods.
        """
        return pulumi.get(self, "request_memory")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigPilotResult(dict):
    def __init__(__self__, *,
                 http10_enabled: _builtins.bool,
                 trace_sampling: _builtins.float):
        """
        :param _builtins.bool http10_enabled: Whether to support the HTTP1.0.
        :param _builtins.float trace_sampling: The  percentage of the Link trace sampling.
        """
        pulumi.set(__self__, "http10_enabled", http10_enabled)
        pulumi.set(__self__, "trace_sampling", trace_sampling)

    @_builtins.property
    @pulumi.getter(name="http10Enabled")
    def http10_enabled(self) -> _builtins.bool:
        """
        Whether to support the HTTP1.0.
        """
        return pulumi.get(self, "http10_enabled")

    @_builtins.property
    @pulumi.getter(name="traceSampling")
    def trace_sampling(self) -> _builtins.float:
        """
        The  percentage of the Link trace sampling.
        """
        return pulumi.get(self, "trace_sampling")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigPrometheusResult(dict):
    def __init__(__self__, *,
                 external_url: _builtins.str,
                 use_external: _builtins.bool):
        """
        :param _builtins.str external_url: The  service addresses of the Prometheus.
        :param _builtins.bool use_external: Whether to enable external Prometheus.
        """
        pulumi.set(__self__, "external_url", external_url)
        pulumi.set(__self__, "use_external", use_external)

    @_builtins.property
    @pulumi.getter(name="externalUrl")
    def external_url(self) -> _builtins.str:
        """
        The  service addresses of the Prometheus.
        """
        return pulumi.get(self, "external_url")

    @_builtins.property
    @pulumi.getter(name="useExternal")
    def use_external(self) -> _builtins.bool:
        """
        Whether to enable external Prometheus.
        """
        return pulumi.get(self, "use_external")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigProxyResult(dict):
    def __init__(__self__, *,
                 cluster_domain: _builtins.str,
                 limit_cpu: _builtins.str,
                 limit_memory: _builtins.str,
                 request_cpu: _builtins.str,
                 request_memory: _builtins.str):
        """
        :param _builtins.str cluster_domain: The domain name of the Cluster.
        :param _builtins.str limit_cpu: Sidecar injector Pods on the throttle.
        :param _builtins.str limit_memory: The memory limit  of the Sidecar injector Pods.
        :param _builtins.str request_cpu: The requested cpu the Sidecar injector Pods.
        :param _builtins.str request_memory: The requested memory the Sidecar injector Pods.
        """
        pulumi.set(__self__, "cluster_domain", cluster_domain)
        pulumi.set(__self__, "limit_cpu", limit_cpu)
        pulumi.set(__self__, "limit_memory", limit_memory)
        pulumi.set(__self__, "request_cpu", request_cpu)
        pulumi.set(__self__, "request_memory", request_memory)

    @_builtins.property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> _builtins.str:
        """
        The domain name of the Cluster.
        """
        return pulumi.get(self, "cluster_domain")

    @_builtins.property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> _builtins.str:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_cpu")

    @_builtins.property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> _builtins.str:
        """
        The memory limit  of the Sidecar injector Pods.
        """
        return pulumi.get(self, "limit_memory")

    @_builtins.property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> _builtins.str:
        """
        The requested cpu the Sidecar injector Pods.
        """
        return pulumi.get(self, "request_cpu")

    @_builtins.property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> _builtins.str:
        """
        The requested memory the Sidecar injector Pods.
        """
        return pulumi.get(self, "request_memory")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigSidecarInjectorResult(dict):
    def __init__(__self__, *,
                 auto_injection_policy_enabled: _builtins.bool,
                 enable_namespaces_by_default: _builtins.bool,
                 init_cni_configurations: Sequence['outputs.GetServiceMeshesMeshMeshConfigSidecarInjectorInitCniConfigurationResult'],
                 limit_cpu: _builtins.str,
                 limit_memory: _builtins.str,
                 request_cpu: _builtins.str,
                 request_memory: _builtins.str,
                 sidecar_injector_webhook_as_yaml: _builtins.str):
        """
        :param _builtins.bool auto_injection_policy_enabled: Whether to enable by Pod Annotations automatic injection Sidecar.
        :param _builtins.bool enable_namespaces_by_default: Whether it is the all namespaces you turn on the auto injection capabilities.
        :param Sequence['GetServiceMeshesMeshMeshConfigSidecarInjectorInitCniConfigurationArgs'] init_cni_configurations: The configuration of the CNI
        :param _builtins.str limit_cpu: Sidecar injector Pods on the throttle.
        :param _builtins.str limit_memory: The memory limit  of the Sidecar injector Pods.
        :param _builtins.str request_cpu: The requested cpu the Sidecar injector Pods.
        :param _builtins.str request_memory: The requested memory the Sidecar injector Pods.
        :param _builtins.str sidecar_injector_webhook_as_yaml: Other automatic injection Sidecar configuration (in YAML format).
        """
        pulumi.set(__self__, "auto_injection_policy_enabled", auto_injection_policy_enabled)
        pulumi.set(__self__, "enable_namespaces_by_default", enable_namespaces_by_default)
        pulumi.set(__self__, "init_cni_configurations", init_cni_configurations)
        pulumi.set(__self__, "limit_cpu", limit_cpu)
        pulumi.set(__self__, "limit_memory", limit_memory)
        pulumi.set(__self__, "request_cpu", request_cpu)
        pulumi.set(__self__, "request_memory", request_memory)
        pulumi.set(__self__, "sidecar_injector_webhook_as_yaml", sidecar_injector_webhook_as_yaml)

    @_builtins.property
    @pulumi.getter(name="autoInjectionPolicyEnabled")
    def auto_injection_policy_enabled(self) -> _builtins.bool:
        """
        Whether to enable by Pod Annotations automatic injection Sidecar.
        """
        return pulumi.get(self, "auto_injection_policy_enabled")

    @_builtins.property
    @pulumi.getter(name="enableNamespacesByDefault")
    def enable_namespaces_by_default(self) -> _builtins.bool:
        """
        Whether it is the all namespaces you turn on the auto injection capabilities.
        """
        return pulumi.get(self, "enable_namespaces_by_default")

    @_builtins.property
    @pulumi.getter(name="initCniConfigurations")
    def init_cni_configurations(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigSidecarInjectorInitCniConfigurationResult']:
        """
        The configuration of the CNI
        """
        return pulumi.get(self, "init_cni_configurations")

    @_builtins.property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> _builtins.str:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_cpu")

    @_builtins.property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> _builtins.str:
        """
        The memory limit  of the Sidecar injector Pods.
        """
        return pulumi.get(self, "limit_memory")

    @_builtins.property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> _builtins.str:
        """
        The requested cpu the Sidecar injector Pods.
        """
        return pulumi.get(self, "request_cpu")

    @_builtins.property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> _builtins.str:
        """
        The requested memory the Sidecar injector Pods.
        """
        return pulumi.get(self, "request_memory")

    @_builtins.property
    @pulumi.getter(name="sidecarInjectorWebhookAsYaml")
    def sidecar_injector_webhook_as_yaml(self) -> _builtins.str:
        """
        Other automatic injection Sidecar configuration (in YAML format).
        """
        return pulumi.get(self, "sidecar_injector_webhook_as_yaml")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigSidecarInjectorInitCniConfigurationResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 exclude_namespaces: _builtins.str):
        """
        :param _builtins.bool enabled: Whether to enable CNI.
        :param _builtins.str exclude_namespaces: The excluded namespace of the CNI.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "exclude_namespaces", exclude_namespaces)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether to enable CNI.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="excludeNamespaces")
    def exclude_namespaces(self) -> _builtins.str:
        """
        The excluded namespace of the CNI.
        """
        return pulumi.get(self, "exclude_namespaces")


@pulumi.output_type
class GetServiceMeshesMeshNetworkResult(dict):
    def __init__(__self__, *,
                 security_group_id: _builtins.str,
                 vpc_id: _builtins.str,
                 vswitche_lists: Sequence[_builtins.str]):
        """
        :param _builtins.str security_group_id: The ID of the Security group
        :param _builtins.str vpc_id: The ID of the VPC.
        :param Sequence[_builtins.str] vswitche_lists: The list of Virtual Switch.
        """
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitche_lists", vswitche_lists)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The ID of the Security group
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitcheLists")
    def vswitche_lists(self) -> Sequence[_builtins.str]:
        """
        The list of Virtual Switch.
        """
        return pulumi.get(self, "vswitche_lists")


@pulumi.output_type
class GetVersionsVersionResult(dict):
    def __init__(__self__, *,
                 edition: _builtins.str,
                 id: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str edition: The edition of the ASM instance. Valid values:
               - Default: Standard Edition
               - Pro: Professional Edition
        :param _builtins.str id: The ASM version id. It formats as `<edition>:<version>`.
        :param _builtins.str version: A list of Service Mesh Service Meshes. Each element contains the following attributes:
        """
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def edition(self) -> _builtins.str:
        """
        The edition of the ASM instance. Valid values:
        - Default: Standard Edition
        - Pro: Professional Edition
        """
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ASM version id. It formats as `<edition>:<version>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        A list of Service Mesh Service Meshes. Each element contains the following attributes:
        """
        return pulumi.get(self, "version")


