# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 master_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slave_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[_builtins.str] address: Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the correspond ing switch.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP version of the SLB instance to be created, which can be set to ipv4 or ipv6 . Default to "ipv4". Now, only internet instance support ipv6 address.
        :param pulumi.Input[_builtins.str] address_type: The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be "intranet".
               - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
               - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
        :param pulumi.Input[_builtins.int] bandwidth: Valid
               value is between 1 and 1000, If argument "internet_charge_type" is "paybytraffic", then this value will be ignore.
        :param pulumi.Input[_builtins.str] delete_protection: Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
        :param pulumi.Input[_builtins.str] instance_charge_type: The billing method of the load balancer. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        :param pulumi.Input[_builtins.str] internet_charge_type: Valid
               values are `PayByBandwidth`, `PayByTraffic`. If this value is "PayByBandwidth", then argument "internet" must be "true". Default is "PayByTraffic". If load balancer launched in VPC, this value must be "PayByTraffic".
               Before version 1.10.1, the valid values are "paybybandwidth" and "paybytraffic".
        :param pulumi.Input[_builtins.str] load_balancer_spec: The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance. Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`.
        :param pulumi.Input[_builtins.str] master_zone_id: The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        :param pulumi.Input[_builtins.str] modification_protection_reason: The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
        :param pulumi.Input[_builtins.str] modification_protection_status: The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value: `NonProtection`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36].
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the SLB belongs.
        :param pulumi.Input[_builtins.str] slave_zone_id: The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        :param pulumi.Input[_builtins.str] specification: The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
               Launching "[Performance-guaranteed](https://www.alibabacloud.com/help/en/slb/product-overview/announcements-and-updates)" instance, it is must be specified and it valid values are: "slb.s1.small", "slb.s2.small", "slb.s2.medium",
               "slb.s3.small", "slb.s3.medium", "slb.s3.large" and "slb.s4.large".
        :param pulumi.Input[_builtins.str] status: The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.
               
               > **NOTE:** A "Shared-Performance" instance can be changed to "Performance-guaranteed", but the change is irreversible.
               
               > **NOTE:** To change a "Shared-Performance" instance to a "Performance-guaranteed" instance, the SLB will have a short probability of business interruption (10 seconds-30 seconds). Advise to change it during the business downturn, or migrate business to other SLB Instances by using GSLB before changing.
               
               > **NOTE:** Currently, the alibaba cloud international account does not support creating a PrePaid SLB instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID to launch in. If `address_type` is internet, it will be ignore.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if master_zone_id is not None:
            pulumi.set(__self__, "master_zone_id", master_zone_id)
        if modification_protection_reason is not None:
            pulumi.set(__self__, "modification_protection_reason", modification_protection_reason)
        if modification_protection_status is not None:
            pulumi.set(__self__, "modification_protection_status", modification_protection_status)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name' instead""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name' instead""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if slave_zone_id is not None:
            pulumi.set(__self__, "slave_zone_id", slave_zone_id)
        if specification is not None:
            warnings.warn("""Field 'specification' has been deprecated from provider version 1.123.1. New field 'load_balancer_spec' instead""", DeprecationWarning)
            pulumi.log.warn("""specification is deprecated: Field 'specification' has been deprecated from provider version 1.123.1. New field 'load_balancer_spec' instead""")
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the correspond ing switch.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version of the SLB instance to be created, which can be set to ipv4 or ipv6 . Default to "ipv4". Now, only internet instance support ipv6 address.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_ip_version", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be "intranet".
        - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
        - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Valid
        value is between 1 and 1000, If argument "internet_charge_type" is "paybytraffic", then this value will be ignore.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_protection", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the load balancer. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid
        values are `PayByBandwidth`, `PayByTraffic`. If this value is "PayByBandwidth", then argument "internet" must be "true". Default is "PayByTraffic". If load balancer launched in VPC, this value must be "PayByTraffic".
        Before version 1.10.1, the valid values are "paybybandwidth" and "paybytraffic".
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_name", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance. Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`.
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @_builtins.property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        """
        return pulumi.get(self, "master_zone_id")

    @master_zone_id.setter
    def master_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
        """
        return pulumi.get(self, "modification_protection_reason")

    @modification_protection_reason.setter
    def modification_protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modification_protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value: `NonProtection`.
        """
        return pulumi.get(self, "modification_protection_status")

    @modification_protection_status.setter
    def modification_protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modification_protection_status", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name' instead""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36].
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the SLB belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="slaveZoneId")
    def slave_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        """
        return pulumi.get(self, "slave_zone_id")

    @slave_zone_id.setter
    def slave_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slave_zone_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'specification' has been deprecated from provider version 1.123.1. New field 'load_balancer_spec' instead""")
    def specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
        Launching "[Performance-guaranteed](https://www.alibabacloud.com/help/en/slb/product-overview/announcements-and-updates)" instance, it is must be specified and it valid values are: "slb.s1.small", "slb.s2.small", "slb.s2.medium",
        "slb.s3.small", "slb.s3.medium", "slb.s3.large" and "slb.s4.large".
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.

        > **NOTE:** A "Shared-Performance" instance can be changed to "Performance-guaranteed", but the change is irreversible.

        > **NOTE:** To change a "Shared-Performance" instance to a "Performance-guaranteed" instance, the SLB will have a short probability of business interruption (10 seconds-30 seconds). Advise to change it during the business downturn, or migrate business to other SLB Instances by using GSLB before changing.

        > **NOTE:** Currently, the alibaba cloud international account does not support creating a PrePaid SLB instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vSwitch ID to launch in. If `address_type` is internet, it will be ignore.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 master_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slave_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input[_builtins.str] address: Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the correspond ing switch.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP version of the SLB instance to be created, which can be set to ipv4 or ipv6 . Default to "ipv4". Now, only internet instance support ipv6 address.
        :param pulumi.Input[_builtins.str] address_type: The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be "intranet".
               - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
               - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
        :param pulumi.Input[_builtins.int] bandwidth: Valid
               value is between 1 and 1000, If argument "internet_charge_type" is "paybytraffic", then this value will be ignore.
        :param pulumi.Input[_builtins.str] delete_protection: Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
        :param pulumi.Input[_builtins.str] instance_charge_type: The billing method of the load balancer. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        :param pulumi.Input[_builtins.str] internet_charge_type: Valid
               values are `PayByBandwidth`, `PayByTraffic`. If this value is "PayByBandwidth", then argument "internet" must be "true". Default is "PayByTraffic". If load balancer launched in VPC, this value must be "PayByTraffic".
               Before version 1.10.1, the valid values are "paybybandwidth" and "paybytraffic".
        :param pulumi.Input[_builtins.str] load_balancer_spec: The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance. Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`.
        :param pulumi.Input[_builtins.str] master_zone_id: The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        :param pulumi.Input[_builtins.str] modification_protection_reason: The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
        :param pulumi.Input[_builtins.str] modification_protection_status: The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value: `NonProtection`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36].
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the SLB belongs.
        :param pulumi.Input[_builtins.str] slave_zone_id: The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        :param pulumi.Input[_builtins.str] specification: The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
               Launching "[Performance-guaranteed](https://www.alibabacloud.com/help/en/slb/product-overview/announcements-and-updates)" instance, it is must be specified and it valid values are: "slb.s1.small", "slb.s2.small", "slb.s2.medium",
               "slb.s3.small", "slb.s3.medium", "slb.s3.large" and "slb.s4.large".
        :param pulumi.Input[_builtins.str] status: The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.
               
               > **NOTE:** A "Shared-Performance" instance can be changed to "Performance-guaranteed", but the change is irreversible.
               
               > **NOTE:** To change a "Shared-Performance" instance to a "Performance-guaranteed" instance, the SLB will have a short probability of business interruption (10 seconds-30 seconds). Advise to change it during the business downturn, or migrate business to other SLB Instances by using GSLB before changing.
               
               > **NOTE:** Currently, the alibaba cloud international account does not support creating a PrePaid SLB instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID to launch in. If `address_type` is internet, it will be ignore.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if master_zone_id is not None:
            pulumi.set(__self__, "master_zone_id", master_zone_id)
        if modification_protection_reason is not None:
            pulumi.set(__self__, "modification_protection_reason", modification_protection_reason)
        if modification_protection_status is not None:
            pulumi.set(__self__, "modification_protection_status", modification_protection_status)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name' instead""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name' instead""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if slave_zone_id is not None:
            pulumi.set(__self__, "slave_zone_id", slave_zone_id)
        if specification is not None:
            warnings.warn("""Field 'specification' has been deprecated from provider version 1.123.1. New field 'load_balancer_spec' instead""", DeprecationWarning)
            pulumi.log.warn("""specification is deprecated: Field 'specification' has been deprecated from provider version 1.123.1. New field 'load_balancer_spec' instead""")
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the correspond ing switch.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP version of the SLB instance to be created, which can be set to ipv4 or ipv6 . Default to "ipv4". Now, only internet instance support ipv6 address.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_ip_version", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be "intranet".
        - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
        - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Valid
        value is between 1 and 1000, If argument "internet_charge_type" is "paybytraffic", then this value will be ignore.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_protection", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the load balancer. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid
        values are `PayByBandwidth`, `PayByTraffic`. If this value is "PayByBandwidth", then argument "internet" must be "true". Default is "PayByTraffic". If load balancer launched in VPC, this value must be "PayByTraffic".
        Before version 1.10.1, the valid values are "paybybandwidth" and "paybytraffic".
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_name", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance. Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`.
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @_builtins.property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        """
        return pulumi.get(self, "master_zone_id")

    @master_zone_id.setter
    def master_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
        """
        return pulumi.get(self, "modification_protection_reason")

    @modification_protection_reason.setter
    def modification_protection_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modification_protection_reason", value)

    @_builtins.property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value: `NonProtection`.
        """
        return pulumi.get(self, "modification_protection_status")

    @modification_protection_status.setter
    def modification_protection_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modification_protection_status", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name' instead""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36].
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Id of resource group which the SLB belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="slaveZoneId")
    def slave_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        """
        return pulumi.get(self, "slave_zone_id")

    @slave_zone_id.setter
    def slave_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slave_zone_id", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'specification' has been deprecated from provider version 1.123.1. New field 'load_balancer_spec' instead""")
    def specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
        Launching "[Performance-guaranteed](https://www.alibabacloud.com/help/en/slb/product-overview/announcements-and-updates)" instance, it is must be specified and it valid values are: "slb.s1.small", "slb.s2.small", "slb.s2.medium",
        "slb.s3.small", "slb.s3.medium", "slb.s3.large" and "slb.s4.large".
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.

        > **NOTE:** A "Shared-Performance" instance can be changed to "Performance-guaranteed", but the change is irreversible.

        > **NOTE:** To change a "Shared-Performance" instance to a "Performance-guaranteed" instance, the SLB will have a short probability of business interruption (10 seconds-30 seconds). Advise to change it during the business downturn, or migrate business to other SLB Instances by using GSLB before changing.

        > **NOTE:** Currently, the alibaba cloud international account does not support creating a PrePaid SLB instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vSwitch ID to launch in. If `address_type` is internet, it will be ignore.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


warnings.warn("""This resource has been deprecated in favour of the ApplicationLoadBalancer resource""", DeprecationWarning)


@pulumi.type_token("alicloud:slb/loadBalancer:LoadBalancer")
class LoadBalancer(pulumi.CustomResource):
    warnings.warn("""This resource has been deprecated in favour of the ApplicationLoadBalancer resource""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 master_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slave_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > **NOTE:** Deprecated since v1.123.1.

        > **DEPRECATED:** This resource has been renamed to slb.ApplicationLoadBalancer from version 1.123.1.

        Provides an Application Load Balancer resource.

        > **NOTE:** At present, to avoid some unnecessary regulation confusion, SLB can not support alicloud international account to create "paybybandwidth" instance.

        > **NOTE:** The supported specifications vary by region. Currently not all regions support guaranteed-performance instances.
        For more details about guaranteed-performance instance, see [Guaranteed-performance instances](https://www.alibabacloud.com/help/en/slb/classic-load-balancer/developer-reference/api-createloadbalancer-2#t4182.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraformslbconfig"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        default_load_balancer = alicloud.slb.LoadBalancer("default",
            load_balancer_name=name,
            load_balancer_spec="slb.s2.small",
            vswitch_id=default_switch.id,
            tags={
                "tag_a": "1",
                "tag_b": "2",
                "tag_c": "3",
                "tag_d": "4",
                "tag_e": "5",
                "tag_f": "6",
                "tag_g": "7",
                "tag_h": "8",
                "tag_i": "9",
                "tag_j": "10",
            })
        ```

        ## Import

        Load balancer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:slb/loadBalancer:LoadBalancer example lb-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the correspond ing switch.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP version of the SLB instance to be created, which can be set to ipv4 or ipv6 . Default to "ipv4". Now, only internet instance support ipv6 address.
        :param pulumi.Input[_builtins.str] address_type: The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be "intranet".
               - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
               - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
        :param pulumi.Input[_builtins.int] bandwidth: Valid
               value is between 1 and 1000, If argument "internet_charge_type" is "paybytraffic", then this value will be ignore.
        :param pulumi.Input[_builtins.str] delete_protection: Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
        :param pulumi.Input[_builtins.str] instance_charge_type: The billing method of the load balancer. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        :param pulumi.Input[_builtins.str] internet_charge_type: Valid
               values are `PayByBandwidth`, `PayByTraffic`. If this value is "PayByBandwidth", then argument "internet" must be "true". Default is "PayByTraffic". If load balancer launched in VPC, this value must be "PayByTraffic".
               Before version 1.10.1, the valid values are "paybybandwidth" and "paybytraffic".
        :param pulumi.Input[_builtins.str] load_balancer_spec: The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance. Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`.
        :param pulumi.Input[_builtins.str] master_zone_id: The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        :param pulumi.Input[_builtins.str] modification_protection_reason: The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
        :param pulumi.Input[_builtins.str] modification_protection_status: The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value: `NonProtection`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36].
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the SLB belongs.
        :param pulumi.Input[_builtins.str] slave_zone_id: The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        :param pulumi.Input[_builtins.str] specification: The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
               Launching "[Performance-guaranteed](https://www.alibabacloud.com/help/en/slb/product-overview/announcements-and-updates)" instance, it is must be specified and it valid values are: "slb.s1.small", "slb.s2.small", "slb.s2.medium",
               "slb.s3.small", "slb.s3.medium", "slb.s3.large" and "slb.s4.large".
        :param pulumi.Input[_builtins.str] status: The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.
               
               > **NOTE:** A "Shared-Performance" instance can be changed to "Performance-guaranteed", but the change is irreversible.
               
               > **NOTE:** To change a "Shared-Performance" instance to a "Performance-guaranteed" instance, the SLB will have a short probability of business interruption (10 seconds-30 seconds). Advise to change it during the business downturn, or migrate business to other SLB Instances by using GSLB before changing.
               
               > **NOTE:** Currently, the alibaba cloud international account does not support creating a PrePaid SLB instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID to launch in. If `address_type` is internet, it will be ignore.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LoadBalancerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **NOTE:** Deprecated since v1.123.1.

        > **DEPRECATED:** This resource has been renamed to slb.ApplicationLoadBalancer from version 1.123.1.

        Provides an Application Load Balancer resource.

        > **NOTE:** At present, to avoid some unnecessary regulation confusion, SLB can not support alicloud international account to create "paybybandwidth" instance.

        > **NOTE:** The supported specifications vary by region. Currently not all regions support guaranteed-performance instances.
        For more details about guaranteed-performance instance, see [Guaranteed-performance instances](https://www.alibabacloud.com/help/en/slb/classic-load-balancer/developer-reference/api-createloadbalancer-2#t4182.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraformslbconfig"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        default_switch = alicloud.vpc.Switch("default",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default.zones[0].id,
            vswitch_name=name)
        default_load_balancer = alicloud.slb.LoadBalancer("default",
            load_balancer_name=name,
            load_balancer_spec="slb.s2.small",
            vswitch_id=default_switch.id,
            tags={
                "tag_a": "1",
                "tag_b": "2",
                "tag_c": "3",
                "tag_d": "4",
                "tag_e": "5",
                "tag_f": "6",
                "tag_g": "7",
                "tag_h": "8",
                "tag_i": "9",
                "tag_j": "10",
            })
        ```

        ## Import

        Load balancer can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:slb/loadBalancer:LoadBalancer example lb-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_protection: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 master_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 modification_protection_status: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slave_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""LoadBalancer is deprecated: This resource has been deprecated in favour of the ApplicationLoadBalancer resource""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["address_ip_version"] = address_ip_version
            __props__.__dict__["address_type"] = address_type
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["delete_protection"] = delete_protection
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["load_balancer_name"] = load_balancer_name
            __props__.__dict__["load_balancer_spec"] = load_balancer_spec
            __props__.__dict__["master_zone_id"] = master_zone_id
            __props__.__dict__["modification_protection_reason"] = modification_protection_reason
            __props__.__dict__["modification_protection_status"] = modification_protection_status
            __props__.__dict__["name"] = name
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["slave_zone_id"] = slave_zone_id
            __props__.__dict__["specification"] = specification
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vswitch_id"] = vswitch_id
        super(LoadBalancer, __self__).__init__(
            'alicloud:slb/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            address_ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            address_type: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            delete_protection: Optional[pulumi.Input[_builtins.str]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_name: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
            master_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            modification_protection_reason: Optional[pulumi.Input[_builtins.str]] = None,
            modification_protection_status: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            slave_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            specification: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the correspond ing switch.
        :param pulumi.Input[_builtins.str] address_ip_version: The IP version of the SLB instance to be created, which can be set to ipv4 or ipv6 . Default to "ipv4". Now, only internet instance support ipv6 address.
        :param pulumi.Input[_builtins.str] address_type: The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be "intranet".
               - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
               - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
        :param pulumi.Input[_builtins.int] bandwidth: Valid
               value is between 1 and 1000, If argument "internet_charge_type" is "paybytraffic", then this value will be ignore.
        :param pulumi.Input[_builtins.str] delete_protection: Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
        :param pulumi.Input[_builtins.str] instance_charge_type: The billing method of the load balancer. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        :param pulumi.Input[_builtins.str] internet_charge_type: Valid
               values are `PayByBandwidth`, `PayByTraffic`. If this value is "PayByBandwidth", then argument "internet" must be "true". Default is "PayByTraffic". If load balancer launched in VPC, this value must be "PayByTraffic".
               Before version 1.10.1, the valid values are "paybybandwidth" and "paybytraffic".
        :param pulumi.Input[_builtins.str] load_balancer_spec: The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance. Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`.
        :param pulumi.Input[_builtins.str] master_zone_id: The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        :param pulumi.Input[_builtins.str] modification_protection_reason: The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
        :param pulumi.Input[_builtins.str] modification_protection_status: The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value: `NonProtection`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36].
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.str] resource_group_id: The Id of resource group which the SLB belongs.
        :param pulumi.Input[_builtins.str] slave_zone_id: The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        :param pulumi.Input[_builtins.str] specification: The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
               Launching "[Performance-guaranteed](https://www.alibabacloud.com/help/en/slb/product-overview/announcements-and-updates)" instance, it is must be specified and it valid values are: "slb.s1.small", "slb.s2.small", "slb.s2.medium",
               "slb.s3.small", "slb.s3.medium", "slb.s3.large" and "slb.s4.large".
        :param pulumi.Input[_builtins.str] status: The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.
               
               > **NOTE:** A "Shared-Performance" instance can be changed to "Performance-guaranteed", but the change is irreversible.
               
               > **NOTE:** To change a "Shared-Performance" instance to a "Performance-guaranteed" instance, the SLB will have a short probability of business interruption (10 seconds-30 seconds). Advise to change it during the business downturn, or migrate business to other SLB Instances by using GSLB before changing.
               
               > **NOTE:** Currently, the alibaba cloud international account does not support creating a PrePaid SLB instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance.
        :param pulumi.Input[_builtins.str] vswitch_id: The vSwitch ID to launch in. If `address_type` is internet, it will be ignore.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["address"] = address
        __props__.__dict__["address_ip_version"] = address_ip_version
        __props__.__dict__["address_type"] = address_type
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["delete_protection"] = delete_protection
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["load_balancer_name"] = load_balancer_name
        __props__.__dict__["load_balancer_spec"] = load_balancer_spec
        __props__.__dict__["master_zone_id"] = master_zone_id
        __props__.__dict__["modification_protection_reason"] = modification_protection_reason
        __props__.__dict__["modification_protection_status"] = modification_protection_status
        __props__.__dict__["name"] = name
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["slave_zone_id"] = slave_zone_id
        __props__.__dict__["specification"] = specification
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vswitch_id"] = vswitch_id
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the IP address of the private network for the SLB instance, which must be in the destination CIDR block of the correspond ing switch.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IP version of the SLB instance to be created, which can be set to ipv4 or ipv6 . Default to "ipv4". Now, only internet instance support ipv6 address.
        """
        return pulumi.get(self, "address_ip_version")

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Output[_builtins.str]:
        """
        The network type of the SLB instance. Valid values: ["internet", "intranet"]. If load balancer launched in VPC, this value must be "intranet".
        - internet: After an Internet SLB instance is created, the system allocates a public IP address so that the instance can forward requests from the Internet.
        - intranet: After an intranet SLB instance is created, the system allocates an intranet IP address so that the instance can only forward intranet requests.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Valid
        value is between 1 and 1000, If argument "internet_charge_type" is "paybytraffic", then this value will be ignore.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether enable the deletion protection or not. on: Enable deletion protection. off: Disable deletion protection. Default to off. Only postpaid instance support this function.
        """
        return pulumi.get(self, "delete_protection")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method of the load balancer. Valid values are "PrePaid" and "PostPaid". Default to "PostPaid".
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Valid
        values are `PayByBandwidth`, `PayByTraffic`. If this value is "PayByBandwidth", then argument "internet" must be "true". Default is "PayByTraffic". If load balancer launched in VPC, this value must be "PayByTraffic".
        Before version 1.10.1, the valid values are "paybybandwidth" and "paybytraffic".
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "load_balancer_name")

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> pulumi.Output[_builtins.str]:
        """
        The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance. Launching "Performance-guaranteed" instance, it must be specified. Valid values: `slb.s1.small`, `slb.s2.small`, `slb.s2.medium`.
        """
        return pulumi.get(self, "load_balancer_spec")

    @_builtins.property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The primary zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        """
        return pulumi.get(self, "master_zone_id")

    @_builtins.property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The reason of modification protection. It's effective when `modification_protection_status` is `ConsoleProtection`.
        """
        return pulumi.get(self, "modification_protection_reason")

    @_builtins.property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of modification protection. Valid values: `ConsoleProtection` and `NonProtection`. Default value: `NonProtection`.
        """
        return pulumi.get(self, "modification_protection_status")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'name' has been deprecated from provider version 1.123.1. New field 'load_balancer_name' instead""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field `name` has been deprecated from provider version 1.123.1 New field `load_balancer_name` instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method of the load balancer. Valid values are `PayAsYouGo` and `Subscription`. Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`. Valid values: [1-9, 12, 24, 36].
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Id of resource group which the SLB belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="slaveZoneId")
    def slave_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The standby zone ID of the SLB instance. If not specified, the system will be randomly assigned. You can query the primary and standby zones in a region by calling the DescribeZone API.
        """
        return pulumi.get(self, "slave_zone_id")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field 'specification' has been deprecated from provider version 1.123.1. New field 'load_balancer_spec' instead""")
    def specification(self) -> pulumi.Output[_builtins.str]:
        """
        The specification of the Server Load Balancer instance. Default to empty string indicating it is "Shared-Performance" instance.
        Launching "[Performance-guaranteed](https://www.alibabacloud.com/help/en/slb/product-overview/announcements-and-updates)" instance, it is must be specified and it valid values are: "slb.s1.small", "slb.s2.small", "slb.s2.medium",
        "slb.s3.small", "slb.s3.medium", "slb.s3.large" and "slb.s4.large".
        """
        return pulumi.get(self, "specification")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of slb load balancer. Valid values: `active` and `inactice`. The system default value is `active`.

        > **NOTE:** A "Shared-Performance" instance can be changed to "Performance-guaranteed", but the change is irreversible.

        > **NOTE:** To change a "Shared-Performance" instance to a "Performance-guaranteed" instance, the SLB will have a short probability of business interruption (10 seconds-30 seconds). Advise to change it during the business downturn, or migrate business to other SLB Instances by using GSLB before changing.

        > **NOTE:** Currently, the alibaba cloud international account does not support creating a PrePaid SLB instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A mapping of tags to assign to the resource. The `tags` can have a maximum of 10 tag for every load balancer instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The vSwitch ID to launch in. If `address_type` is internet, it will be ignore.
        """
        return pulumi.get(self, "vswitch_id")

