# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 frontend_port: pulumi.Input[_builtins.int],
                 load_balancer_id: pulumi.Input[_builtins.str],
                 server_group_id: pulumi.Input[_builtins.str],
                 cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_protection_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_connect_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_http_code: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_sync: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler: Optional[pulumi.Input[_builtins.str]] = None,
                 sticky_session: Optional[pulumi.Input[_builtins.str]] = None,
                 sticky_session_type: Optional[pulumi.Input[_builtins.str]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[_builtins.int] frontend_port: The listener frontend port which is used to launch the new forwarding rule. Valid values: [1-65535].
        :param pulumi.Input[_builtins.str] load_balancer_id: The Load Balancer ID which is used to launch the new forwarding rule.
        :param pulumi.Input[_builtins.str] server_group_id: ID of a virtual server group that will be forwarded.
        :param pulumi.Input[_builtins.str] cookie: The cookie configured on the server. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `server`. Otherwise, it will be ignored. Valid value：String in line with RFC 2965, with length being `1` - `200`. It only contains characters such as ASCII codes, English letters and digits instead of the comma, semicolon or spacing, and it cannot start with $.
        :param pulumi.Input[_builtins.int] cookie_timeout: Cookie timeout. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `insert`. Otherwise, it will be ignored. Valid values: [1-86400] in seconds.
        :param pulumi.Input[_builtins.bool] delete_protection_validation: Checking DeleteProtection of SLB instance before deleting. If `true`, this resource will not be deleted when its SLB instance enabled DeleteProtection. Default value: `false`.
        :param pulumi.Input[_builtins.str] domain: Domain name of the forwarding rule. It can contain letters a-z, numbers 0-9, hyphens (-), and periods (.),
               and wildcard characters. The following two domain name formats are supported:
               - Standard domain name: www.test.com
               - Wildcard domain name: *.test.com. wildcard (*) must be the first character in the format of (*.)
        :param pulumi.Input[_builtins.str] health_check: Whether to enable health check. Valid values: `on` and `off`. `TCP` and `UDP` listener's `health_check` is always `on`, so it will be ignore when launching `TCP` or `UDP` listener. **NOTE:** `health_check` is required and takes effect only when `listener_sync` is set to `off`.
        :param pulumi.Input[_builtins.int] health_check_connect_port: Port used for health check. Valid values: [1-65535]. Default value: `None` means the backend server port is used.
        :param pulumi.Input[_builtins.str] health_check_domain: Domain name used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and only characters such as letters, digits, ‘-‘ and ‘.’ are allowed. When it is not set or empty, Server Load Balancer uses the private network IP address of each backend server as Domain used for health check.
        :param pulumi.Input[_builtins.str] health_check_http_code: Regular health check HTTP status code. Multiple codes are segmented by “,”. It is required when `health_check` is `on`. Default value: `http_2xx`. Valid values: `http_2xx`, `http_3xx`, `http_4xx` and `http_5xx`.
        :param pulumi.Input[_builtins.int] health_check_interval: Time interval of health checks. It is required when `health_check` is `on`. Valid values: [1-50] in seconds. Default value: `2`.
        :param pulumi.Input[_builtins.int] health_check_timeout: Maximum timeout of each health check response. It is required when `health_check` is `on`. Valid values: [1-300] in seconds. Default value: `5`. Note: If `health_check_timeout` < `health_check_interval`, its will be replaced by `health_check_interval`.
        :param pulumi.Input[_builtins.str] health_check_uri: URI used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and it must start with /. Only characters such as letters, digits, ‘-’, ‘/’, ‘.’, ‘%’, ‘?’, #’ and ‘&’ are allowed.
        :param pulumi.Input[_builtins.int] healthy_threshold: Threshold determining the result of the health check is success. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        :param pulumi.Input[_builtins.str] listener_sync: Indicates whether a forwarding rule inherits the settings of a health check , session persistence, and scheduling algorithm from a listener. Default value: `on`. Valid values: `on` and `off`.
        :param pulumi.Input[_builtins.str] name: Name of the forwarding rule. Our plugin provides a default name: "tf-slb-rule".
        :param pulumi.Input[_builtins.str] scheduler: Scheduling algorithm. Valid values: `wrr`, `rr` and `wlc`. Default value: `wrr`. **NOTE:** `scheduler` is required and takes effect only when `listener_sync` is set to `off`.
        :param pulumi.Input[_builtins.str] sticky_session: Whether to enable session persistence. Valid values: `on` and `off`. Default value: `off`. **NOTE:** `sticky_session` is required and takes effect only when `listener_sync` is set to `off`.
        :param pulumi.Input[_builtins.str] sticky_session_type: Mode for handling the cookie. If `sticky_session` is `on`, it is mandatory. Otherwise, it will be ignored. Valid values: `insert` and `server`. `insert` means it is inserted from Server Load Balancer; `server` means the Server Load Balancer learns from the backend server.
        :param pulumi.Input[_builtins.int] unhealthy_threshold: Threshold determining the result of the health check is fail. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        :param pulumi.Input[_builtins.str] url: Domain of the forwarding rule. It must be 2-80 characters in length. Only letters a-z, numbers 0-9, and characters '-' '/' '?' '%' '#' and '&' are allowed. URLs must be started with the character '/', but cannot be '/' alone.
        """
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "server_group_id", server_group_id)
        if cookie is not None:
            pulumi.set(__self__, "cookie", cookie)
        if cookie_timeout is not None:
            pulumi.set(__self__, "cookie_timeout", cookie_timeout)
        if delete_protection_validation is not None:
            pulumi.set(__self__, "delete_protection_validation", delete_protection_validation)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if health_check_connect_port is not None:
            pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        if health_check_domain is not None:
            pulumi.set(__self__, "health_check_domain", health_check_domain)
        if health_check_http_code is not None:
            pulumi.set(__self__, "health_check_http_code", health_check_http_code)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if health_check_uri is not None:
            pulumi.set(__self__, "health_check_uri", health_check_uri)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if listener_sync is not None:
            pulumi.set(__self__, "listener_sync", listener_sync)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if sticky_session is not None:
            pulumi.set(__self__, "sticky_session", sticky_session)
        if sticky_session_type is not None:
            pulumi.set(__self__, "sticky_session_type", sticky_session_type)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> pulumi.Input[_builtins.int]:
        """
        The listener frontend port which is used to launch the new forwarding rule. Valid values: [1-65535].
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "frontend_port", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Load Balancer ID which is used to launch the new forwarding rule.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of a virtual server group that will be forwarded.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_group_id", value)

    @_builtins.property
    @pulumi.getter
    def cookie(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cookie configured on the server. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `server`. Otherwise, it will be ignored. Valid value：String in line with RFC 2965, with length being `1` - `200`. It only contains characters such as ASCII codes, English letters and digits instead of the comma, semicolon or spacing, and it cannot start with $.
        """
        return pulumi.get(self, "cookie")

    @cookie.setter
    def cookie(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cookie", value)

    @_builtins.property
    @pulumi.getter(name="cookieTimeout")
    def cookie_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Cookie timeout. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `insert`. Otherwise, it will be ignored. Valid values: [1-86400] in seconds.
        """
        return pulumi.get(self, "cookie_timeout")

    @cookie_timeout.setter
    def cookie_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cookie_timeout", value)

    @_builtins.property
    @pulumi.getter(name="deleteProtectionValidation")
    def delete_protection_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Checking DeleteProtection of SLB instance before deleting. If `true`, this resource will not be deleted when its SLB instance enabled DeleteProtection. Default value: `false`.
        """
        return pulumi.get(self, "delete_protection_validation")

    @delete_protection_validation.setter
    def delete_protection_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_protection_validation", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain name of the forwarding rule. It can contain letters a-z, numbers 0-9, hyphens (-), and periods (.),
        and wildcard characters. The following two domain name formats are supported:
        - Standard domain name: www.test.com
        - Wildcard domain name: *.test.com. wildcard (*) must be the first character in the format of (*.)
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable health check. Valid values: `on` and `off`. `TCP` and `UDP` listener's `health_check` is always `on`, so it will be ignore when launching `TCP` or `UDP` listener. **NOTE:** `health_check` is required and takes effect only when `listener_sync` is set to `off`.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port used for health check. Valid values: [1-65535]. Default value: `None` means the backend server port is used.
        """
        return pulumi.get(self, "health_check_connect_port")

    @health_check_connect_port.setter
    def health_check_connect_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_connect_port", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain name used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and only characters such as letters, digits, ‘-‘ and ‘.’ are allowed. When it is not set or empty, Server Load Balancer uses the private network IP address of each backend server as Domain used for health check.
        """
        return pulumi.get(self, "health_check_domain")

    @health_check_domain.setter
    def health_check_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_domain", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpCode")
    def health_check_http_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Regular health check HTTP status code. Multiple codes are segmented by “,”. It is required when `health_check` is `on`. Default value: `http_2xx`. Valid values: `http_2xx`, `http_3xx`, `http_4xx` and `http_5xx`.
        """
        return pulumi.get(self, "health_check_http_code")

    @health_check_http_code.setter
    def health_check_http_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_http_code", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time interval of health checks. It is required when `health_check` is `on`. Valid values: [1-50] in seconds. Default value: `2`.
        """
        return pulumi.get(self, "health_check_interval")

    @health_check_interval.setter
    def health_check_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_interval", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum timeout of each health check response. It is required when `health_check` is `on`. Valid values: [1-300] in seconds. Default value: `5`. Note: If `health_check_timeout` < `health_check_interval`, its will be replaced by `health_check_interval`.
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_timeout", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckUri")
    def health_check_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and it must start with /. Only characters such as letters, digits, ‘-’, ‘/’, ‘.’, ‘%’, ‘?’, #’ and ‘&’ are allowed.
        """
        return pulumi.get(self, "health_check_uri")

    @health_check_uri.setter
    def health_check_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_uri", value)

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Threshold determining the result of the health check is success. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "healthy_threshold", value)

    @_builtins.property
    @pulumi.getter(name="listenerSync")
    def listener_sync(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether a forwarding rule inherits the settings of a health check , session persistence, and scheduling algorithm from a listener. Default value: `on`. Valid values: `on` and `off`.
        """
        return pulumi.get(self, "listener_sync")

    @listener_sync.setter
    def listener_sync(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_sync", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the forwarding rule. Our plugin provides a default name: "tf-slb-rule".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scheduling algorithm. Valid values: `wrr`, `rr` and `wlc`. Default value: `wrr`. **NOTE:** `scheduler` is required and takes effect only when `listener_sync` is set to `off`.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduler", value)

    @_builtins.property
    @pulumi.getter(name="stickySession")
    def sticky_session(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable session persistence. Valid values: `on` and `off`. Default value: `off`. **NOTE:** `sticky_session` is required and takes effect only when `listener_sync` is set to `off`.
        """
        return pulumi.get(self, "sticky_session")

    @sticky_session.setter
    def sticky_session(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sticky_session", value)

    @_builtins.property
    @pulumi.getter(name="stickySessionType")
    def sticky_session_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mode for handling the cookie. If `sticky_session` is `on`, it is mandatory. Otherwise, it will be ignored. Valid values: `insert` and `server`. `insert` means it is inserted from Server Load Balancer; `server` means the Server Load Balancer learns from the backend server.
        """
        return pulumi.get(self, "sticky_session_type")

    @sticky_session_type.setter
    def sticky_session_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sticky_session_type", value)

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Threshold determining the result of the health check is fail. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "unhealthy_threshold", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain of the forwarding rule. It must be 2-80 characters in length. Only letters a-z, numbers 0-9, and characters '-' '/' '?' '%' '#' and '&' are allowed. URLs must be started with the character '/', but cannot be '/' alone.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_protection_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_connect_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_http_code: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_sync: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sticky_session: Optional[pulumi.Input[_builtins.str]] = None,
                 sticky_session_type: Optional[pulumi.Input[_builtins.str]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input[_builtins.str] cookie: The cookie configured on the server. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `server`. Otherwise, it will be ignored. Valid value：String in line with RFC 2965, with length being `1` - `200`. It only contains characters such as ASCII codes, English letters and digits instead of the comma, semicolon or spacing, and it cannot start with $.
        :param pulumi.Input[_builtins.int] cookie_timeout: Cookie timeout. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `insert`. Otherwise, it will be ignored. Valid values: [1-86400] in seconds.
        :param pulumi.Input[_builtins.bool] delete_protection_validation: Checking DeleteProtection of SLB instance before deleting. If `true`, this resource will not be deleted when its SLB instance enabled DeleteProtection. Default value: `false`.
        :param pulumi.Input[_builtins.str] domain: Domain name of the forwarding rule. It can contain letters a-z, numbers 0-9, hyphens (-), and periods (.),
               and wildcard characters. The following two domain name formats are supported:
               - Standard domain name: www.test.com
               - Wildcard domain name: *.test.com. wildcard (*) must be the first character in the format of (*.)
        :param pulumi.Input[_builtins.int] frontend_port: The listener frontend port which is used to launch the new forwarding rule. Valid values: [1-65535].
        :param pulumi.Input[_builtins.str] health_check: Whether to enable health check. Valid values: `on` and `off`. `TCP` and `UDP` listener's `health_check` is always `on`, so it will be ignore when launching `TCP` or `UDP` listener. **NOTE:** `health_check` is required and takes effect only when `listener_sync` is set to `off`.
        :param pulumi.Input[_builtins.int] health_check_connect_port: Port used for health check. Valid values: [1-65535]. Default value: `None` means the backend server port is used.
        :param pulumi.Input[_builtins.str] health_check_domain: Domain name used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and only characters such as letters, digits, ‘-‘ and ‘.’ are allowed. When it is not set or empty, Server Load Balancer uses the private network IP address of each backend server as Domain used for health check.
        :param pulumi.Input[_builtins.str] health_check_http_code: Regular health check HTTP status code. Multiple codes are segmented by “,”. It is required when `health_check` is `on`. Default value: `http_2xx`. Valid values: `http_2xx`, `http_3xx`, `http_4xx` and `http_5xx`.
        :param pulumi.Input[_builtins.int] health_check_interval: Time interval of health checks. It is required when `health_check` is `on`. Valid values: [1-50] in seconds. Default value: `2`.
        :param pulumi.Input[_builtins.int] health_check_timeout: Maximum timeout of each health check response. It is required when `health_check` is `on`. Valid values: [1-300] in seconds. Default value: `5`. Note: If `health_check_timeout` < `health_check_interval`, its will be replaced by `health_check_interval`.
        :param pulumi.Input[_builtins.str] health_check_uri: URI used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and it must start with /. Only characters such as letters, digits, ‘-’, ‘/’, ‘.’, ‘%’, ‘?’, #’ and ‘&’ are allowed.
        :param pulumi.Input[_builtins.int] healthy_threshold: Threshold determining the result of the health check is success. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        :param pulumi.Input[_builtins.str] listener_sync: Indicates whether a forwarding rule inherits the settings of a health check , session persistence, and scheduling algorithm from a listener. Default value: `on`. Valid values: `on` and `off`.
        :param pulumi.Input[_builtins.str] load_balancer_id: The Load Balancer ID which is used to launch the new forwarding rule.
        :param pulumi.Input[_builtins.str] name: Name of the forwarding rule. Our plugin provides a default name: "tf-slb-rule".
        :param pulumi.Input[_builtins.str] scheduler: Scheduling algorithm. Valid values: `wrr`, `rr` and `wlc`. Default value: `wrr`. **NOTE:** `scheduler` is required and takes effect only when `listener_sync` is set to `off`.
        :param pulumi.Input[_builtins.str] server_group_id: ID of a virtual server group that will be forwarded.
        :param pulumi.Input[_builtins.str] sticky_session: Whether to enable session persistence. Valid values: `on` and `off`. Default value: `off`. **NOTE:** `sticky_session` is required and takes effect only when `listener_sync` is set to `off`.
        :param pulumi.Input[_builtins.str] sticky_session_type: Mode for handling the cookie. If `sticky_session` is `on`, it is mandatory. Otherwise, it will be ignored. Valid values: `insert` and `server`. `insert` means it is inserted from Server Load Balancer; `server` means the Server Load Balancer learns from the backend server.
        :param pulumi.Input[_builtins.int] unhealthy_threshold: Threshold determining the result of the health check is fail. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        :param pulumi.Input[_builtins.str] url: Domain of the forwarding rule. It must be 2-80 characters in length. Only letters a-z, numbers 0-9, and characters '-' '/' '?' '%' '#' and '&' are allowed. URLs must be started with the character '/', but cannot be '/' alone.
        """
        if cookie is not None:
            pulumi.set(__self__, "cookie", cookie)
        if cookie_timeout is not None:
            pulumi.set(__self__, "cookie_timeout", cookie_timeout)
        if delete_protection_validation is not None:
            pulumi.set(__self__, "delete_protection_validation", delete_protection_validation)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if frontend_port is not None:
            pulumi.set(__self__, "frontend_port", frontend_port)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if health_check_connect_port is not None:
            pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        if health_check_domain is not None:
            pulumi.set(__self__, "health_check_domain", health_check_domain)
        if health_check_http_code is not None:
            pulumi.set(__self__, "health_check_http_code", health_check_http_code)
        if health_check_interval is not None:
            pulumi.set(__self__, "health_check_interval", health_check_interval)
        if health_check_timeout is not None:
            pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        if health_check_uri is not None:
            pulumi.set(__self__, "health_check_uri", health_check_uri)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if listener_sync is not None:
            pulumi.set(__self__, "listener_sync", listener_sync)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if server_group_id is not None:
            pulumi.set(__self__, "server_group_id", server_group_id)
        if sticky_session is not None:
            pulumi.set(__self__, "sticky_session", sticky_session)
        if sticky_session_type is not None:
            pulumi.set(__self__, "sticky_session_type", sticky_session_type)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def cookie(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cookie configured on the server. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `server`. Otherwise, it will be ignored. Valid value：String in line with RFC 2965, with length being `1` - `200`. It only contains characters such as ASCII codes, English letters and digits instead of the comma, semicolon or spacing, and it cannot start with $.
        """
        return pulumi.get(self, "cookie")

    @cookie.setter
    def cookie(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cookie", value)

    @_builtins.property
    @pulumi.getter(name="cookieTimeout")
    def cookie_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Cookie timeout. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `insert`. Otherwise, it will be ignored. Valid values: [1-86400] in seconds.
        """
        return pulumi.get(self, "cookie_timeout")

    @cookie_timeout.setter
    def cookie_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cookie_timeout", value)

    @_builtins.property
    @pulumi.getter(name="deleteProtectionValidation")
    def delete_protection_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Checking DeleteProtection of SLB instance before deleting. If `true`, this resource will not be deleted when its SLB instance enabled DeleteProtection. Default value: `false`.
        """
        return pulumi.get(self, "delete_protection_validation")

    @delete_protection_validation.setter
    def delete_protection_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_protection_validation", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain name of the forwarding rule. It can contain letters a-z, numbers 0-9, hyphens (-), and periods (.),
        and wildcard characters. The following two domain name formats are supported:
        - Standard domain name: www.test.com
        - Wildcard domain name: *.test.com. wildcard (*) must be the first character in the format of (*.)
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The listener frontend port which is used to launch the new forwarding rule. Valid values: [1-65535].
        """
        return pulumi.get(self, "frontend_port")

    @frontend_port.setter
    def frontend_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "frontend_port", value)

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable health check. Valid values: `on` and `off`. `TCP` and `UDP` listener's `health_check` is always `on`, so it will be ignore when launching `TCP` or `UDP` listener. **NOTE:** `health_check` is required and takes effect only when `listener_sync` is set to `off`.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port used for health check. Valid values: [1-65535]. Default value: `None` means the backend server port is used.
        """
        return pulumi.get(self, "health_check_connect_port")

    @health_check_connect_port.setter
    def health_check_connect_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_connect_port", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain name used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and only characters such as letters, digits, ‘-‘ and ‘.’ are allowed. When it is not set or empty, Server Load Balancer uses the private network IP address of each backend server as Domain used for health check.
        """
        return pulumi.get(self, "health_check_domain")

    @health_check_domain.setter
    def health_check_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_domain", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpCode")
    def health_check_http_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Regular health check HTTP status code. Multiple codes are segmented by “,”. It is required when `health_check` is `on`. Default value: `http_2xx`. Valid values: `http_2xx`, `http_3xx`, `http_4xx` and `http_5xx`.
        """
        return pulumi.get(self, "health_check_http_code")

    @health_check_http_code.setter
    def health_check_http_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_http_code", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time interval of health checks. It is required when `health_check` is `on`. Valid values: [1-50] in seconds. Default value: `2`.
        """
        return pulumi.get(self, "health_check_interval")

    @health_check_interval.setter
    def health_check_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_interval", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum timeout of each health check response. It is required when `health_check` is `on`. Valid values: [1-300] in seconds. Default value: `5`. Note: If `health_check_timeout` < `health_check_interval`, its will be replaced by `health_check_interval`.
        """
        return pulumi.get(self, "health_check_timeout")

    @health_check_timeout.setter
    def health_check_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_timeout", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckUri")
    def health_check_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and it must start with /. Only characters such as letters, digits, ‘-’, ‘/’, ‘.’, ‘%’, ‘?’, #’ and ‘&’ are allowed.
        """
        return pulumi.get(self, "health_check_uri")

    @health_check_uri.setter
    def health_check_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_uri", value)

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Threshold determining the result of the health check is success. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "healthy_threshold", value)

    @_builtins.property
    @pulumi.getter(name="listenerSync")
    def listener_sync(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether a forwarding rule inherits the settings of a health check , session persistence, and scheduling algorithm from a listener. Default value: `on`. Valid values: `on` and `off`.
        """
        return pulumi.get(self, "listener_sync")

    @listener_sync.setter
    def listener_sync(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_sync", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Load Balancer ID which is used to launch the new forwarding rule.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the forwarding rule. Our plugin provides a default name: "tf-slb-rule".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scheduling algorithm. Valid values: `wrr`, `rr` and `wlc`. Default value: `wrr`. **NOTE:** `scheduler` is required and takes effect only when `listener_sync` is set to `off`.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduler", value)

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of a virtual server group that will be forwarded.
        """
        return pulumi.get(self, "server_group_id")

    @server_group_id.setter
    def server_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_group_id", value)

    @_builtins.property
    @pulumi.getter(name="stickySession")
    def sticky_session(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable session persistence. Valid values: `on` and `off`. Default value: `off`. **NOTE:** `sticky_session` is required and takes effect only when `listener_sync` is set to `off`.
        """
        return pulumi.get(self, "sticky_session")

    @sticky_session.setter
    def sticky_session(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sticky_session", value)

    @_builtins.property
    @pulumi.getter(name="stickySessionType")
    def sticky_session_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Mode for handling the cookie. If `sticky_session` is `on`, it is mandatory. Otherwise, it will be ignored. Valid values: `insert` and `server`. `insert` means it is inserted from Server Load Balancer; `server` means the Server Load Balancer learns from the backend server.
        """
        return pulumi.get(self, "sticky_session_type")

    @sticky_session_type.setter
    def sticky_session_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sticky_session_type", value)

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Threshold determining the result of the health check is fail. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "unhealthy_threshold", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain of the forwarding rule. It must be 2-80 characters in length. Only letters a-z, numbers 0-9, and characters '-' '/' '?' '%' '#' and '&' are allowed. URLs must be started with the character '/', but cannot be '/' alone.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("alicloud:slb/rule:Rule")
class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_protection_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_connect_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_http_code: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_sync: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sticky_session: Optional[pulumi.Input[_builtins.str]] = None,
                 sticky_session_type: Optional[pulumi.Input[_builtins.str]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Lindorm Instance resource.

        For information about Load Balancer Forwarding Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/slb/classic-load-balancer/developer-reference/api-slb-2014-05-15-dir-forwarding-rules).

        > **NOTE:** Available since v1.6.0.

        A forwarding rule is configured in `HTTP`/`HTTPS` listener and it used to listen a list of backend servers which in one specified virtual backend server group.
        You can add forwarding rules to a listener to forward requests based on the domain names or the URL in the request.

        > **NOTE:** One virtual backend server group can be attached in multiple forwarding rules.

        > **NOTE:** At least one "Domain" or "Url" must be specified when creating a new rule.

        > **NOTE:** Having the same 'Domain' and 'Url' rule can not be created repeatedly in the one listener.

        > **NOTE:** Rule only be created in the `HTTP` or `HTTPS` listener.

        > **NOTE:** Only rule's virtual server group can be modified.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        slb_rule_name = config.get("slbRuleName")
        if slb_rule_name is None:
            slb_rule_name = "terraform-example"
        rule = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        rule_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=rule.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        rule_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        rule_network = alicloud.vpc.Network("rule",
            vpc_name=slb_rule_name,
            cidr_block="172.16.0.0/16")
        rule_switch = alicloud.vpc.Switch("rule",
            vpc_id=rule_network.id,
            cidr_block="172.16.0.0/16",
            zone_id=rule.zones[0].id,
            vswitch_name=slb_rule_name)
        rule_security_group = alicloud.ecs.SecurityGroup("rule",
            name=slb_rule_name,
            vpc_id=rule_network.id)
        rule_instance = alicloud.ecs.Instance("rule",
            image_id=rule_get_images.images[0].id,
            instance_type=rule_get_instance_types.instance_types[0].id,
            security_groups=[__item.id for __item in [rule_security_group]],
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=10,
            availability_zone=rule.zones[0].id,
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=rule_switch.id,
            instance_name=slb_rule_name)
        rule_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("rule",
            load_balancer_name=slb_rule_name,
            vswitch_id=rule_switch.id,
            instance_charge_type="PayByCLCU")
        rule_listener = alicloud.slb.Listener("rule",
            load_balancer_id=rule_application_load_balancer.id,
            backend_port=22,
            frontend_port=22,
            protocol="http",
            bandwidth=5,
            health_check_connect_port=20)
        rule_server_group = alicloud.slb.ServerGroup("rule",
            load_balancer_id=rule_application_load_balancer.id,
            name=slb_rule_name)
        rule_rule = alicloud.slb.Rule("rule",
            load_balancer_id=rule_application_load_balancer.id,
            frontend_port=rule_listener.frontend_port,
            name=slb_rule_name,
            domain="*.aliyun.com",
            url="/image",
            server_group_id=rule_server_group.id,
            cookie="23ffsa",
            cookie_timeout=100,
            health_check_http_code="http_2xx",
            health_check_interval=10,
            health_check_uri="/test",
            health_check_connect_port=80,
            health_check_timeout=30,
            healthy_threshold=3,
            unhealthy_threshold=5,
            sticky_session="on",
            sticky_session_type="server",
            listener_sync="off",
            scheduler="rr",
            health_check_domain="test",
            health_check="on")
        ```

        ## Import

        Load balancer forwarding rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:slb/rule:Rule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cookie: The cookie configured on the server. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `server`. Otherwise, it will be ignored. Valid value：String in line with RFC 2965, with length being `1` - `200`. It only contains characters such as ASCII codes, English letters and digits instead of the comma, semicolon or spacing, and it cannot start with $.
        :param pulumi.Input[_builtins.int] cookie_timeout: Cookie timeout. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `insert`. Otherwise, it will be ignored. Valid values: [1-86400] in seconds.
        :param pulumi.Input[_builtins.bool] delete_protection_validation: Checking DeleteProtection of SLB instance before deleting. If `true`, this resource will not be deleted when its SLB instance enabled DeleteProtection. Default value: `false`.
        :param pulumi.Input[_builtins.str] domain: Domain name of the forwarding rule. It can contain letters a-z, numbers 0-9, hyphens (-), and periods (.),
               and wildcard characters. The following two domain name formats are supported:
               - Standard domain name: www.test.com
               - Wildcard domain name: *.test.com. wildcard (*) must be the first character in the format of (*.)
        :param pulumi.Input[_builtins.int] frontend_port: The listener frontend port which is used to launch the new forwarding rule. Valid values: [1-65535].
        :param pulumi.Input[_builtins.str] health_check: Whether to enable health check. Valid values: `on` and `off`. `TCP` and `UDP` listener's `health_check` is always `on`, so it will be ignore when launching `TCP` or `UDP` listener. **NOTE:** `health_check` is required and takes effect only when `listener_sync` is set to `off`.
        :param pulumi.Input[_builtins.int] health_check_connect_port: Port used for health check. Valid values: [1-65535]. Default value: `None` means the backend server port is used.
        :param pulumi.Input[_builtins.str] health_check_domain: Domain name used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and only characters such as letters, digits, ‘-‘ and ‘.’ are allowed. When it is not set or empty, Server Load Balancer uses the private network IP address of each backend server as Domain used for health check.
        :param pulumi.Input[_builtins.str] health_check_http_code: Regular health check HTTP status code. Multiple codes are segmented by “,”. It is required when `health_check` is `on`. Default value: `http_2xx`. Valid values: `http_2xx`, `http_3xx`, `http_4xx` and `http_5xx`.
        :param pulumi.Input[_builtins.int] health_check_interval: Time interval of health checks. It is required when `health_check` is `on`. Valid values: [1-50] in seconds. Default value: `2`.
        :param pulumi.Input[_builtins.int] health_check_timeout: Maximum timeout of each health check response. It is required when `health_check` is `on`. Valid values: [1-300] in seconds. Default value: `5`. Note: If `health_check_timeout` < `health_check_interval`, its will be replaced by `health_check_interval`.
        :param pulumi.Input[_builtins.str] health_check_uri: URI used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and it must start with /. Only characters such as letters, digits, ‘-’, ‘/’, ‘.’, ‘%’, ‘?’, #’ and ‘&’ are allowed.
        :param pulumi.Input[_builtins.int] healthy_threshold: Threshold determining the result of the health check is success. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        :param pulumi.Input[_builtins.str] listener_sync: Indicates whether a forwarding rule inherits the settings of a health check , session persistence, and scheduling algorithm from a listener. Default value: `on`. Valid values: `on` and `off`.
        :param pulumi.Input[_builtins.str] load_balancer_id: The Load Balancer ID which is used to launch the new forwarding rule.
        :param pulumi.Input[_builtins.str] name: Name of the forwarding rule. Our plugin provides a default name: "tf-slb-rule".
        :param pulumi.Input[_builtins.str] scheduler: Scheduling algorithm. Valid values: `wrr`, `rr` and `wlc`. Default value: `wrr`. **NOTE:** `scheduler` is required and takes effect only when `listener_sync` is set to `off`.
        :param pulumi.Input[_builtins.str] server_group_id: ID of a virtual server group that will be forwarded.
        :param pulumi.Input[_builtins.str] sticky_session: Whether to enable session persistence. Valid values: `on` and `off`. Default value: `off`. **NOTE:** `sticky_session` is required and takes effect only when `listener_sync` is set to `off`.
        :param pulumi.Input[_builtins.str] sticky_session_type: Mode for handling the cookie. If `sticky_session` is `on`, it is mandatory. Otherwise, it will be ignored. Valid values: `insert` and `server`. `insert` means it is inserted from Server Load Balancer; `server` means the Server Load Balancer learns from the backend server.
        :param pulumi.Input[_builtins.int] unhealthy_threshold: Threshold determining the result of the health check is fail. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        :param pulumi.Input[_builtins.str] url: Domain of the forwarding rule. It must be 2-80 characters in length. Only letters a-z, numbers 0-9, and characters '-' '/' '?' '%' '#' and '&' are allowed. URLs must be started with the character '/', but cannot be '/' alone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Lindorm Instance resource.

        For information about Load Balancer Forwarding Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/slb/classic-load-balancer/developer-reference/api-slb-2014-05-15-dir-forwarding-rules).

        > **NOTE:** Available since v1.6.0.

        A forwarding rule is configured in `HTTP`/`HTTPS` listener and it used to listen a list of backend servers which in one specified virtual backend server group.
        You can add forwarding rules to a listener to forward requests based on the domain names or the URL in the request.

        > **NOTE:** One virtual backend server group can be attached in multiple forwarding rules.

        > **NOTE:** At least one "Domain" or "Url" must be specified when creating a new rule.

        > **NOTE:** Having the same 'Domain' and 'Url' rule can not be created repeatedly in the one listener.

        > **NOTE:** Rule only be created in the `HTTP` or `HTTPS` listener.

        > **NOTE:** Only rule's virtual server group can be modified.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        slb_rule_name = config.get("slbRuleName")
        if slb_rule_name is None:
            slb_rule_name = "terraform-example"
        rule = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        rule_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=rule.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        rule_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        rule_network = alicloud.vpc.Network("rule",
            vpc_name=slb_rule_name,
            cidr_block="172.16.0.0/16")
        rule_switch = alicloud.vpc.Switch("rule",
            vpc_id=rule_network.id,
            cidr_block="172.16.0.0/16",
            zone_id=rule.zones[0].id,
            vswitch_name=slb_rule_name)
        rule_security_group = alicloud.ecs.SecurityGroup("rule",
            name=slb_rule_name,
            vpc_id=rule_network.id)
        rule_instance = alicloud.ecs.Instance("rule",
            image_id=rule_get_images.images[0].id,
            instance_type=rule_get_instance_types.instance_types[0].id,
            security_groups=[__item.id for __item in [rule_security_group]],
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=10,
            availability_zone=rule.zones[0].id,
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=rule_switch.id,
            instance_name=slb_rule_name)
        rule_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("rule",
            load_balancer_name=slb_rule_name,
            vswitch_id=rule_switch.id,
            instance_charge_type="PayByCLCU")
        rule_listener = alicloud.slb.Listener("rule",
            load_balancer_id=rule_application_load_balancer.id,
            backend_port=22,
            frontend_port=22,
            protocol="http",
            bandwidth=5,
            health_check_connect_port=20)
        rule_server_group = alicloud.slb.ServerGroup("rule",
            load_balancer_id=rule_application_load_balancer.id,
            name=slb_rule_name)
        rule_rule = alicloud.slb.Rule("rule",
            load_balancer_id=rule_application_load_balancer.id,
            frontend_port=rule_listener.frontend_port,
            name=slb_rule_name,
            domain="*.aliyun.com",
            url="/image",
            server_group_id=rule_server_group.id,
            cookie="23ffsa",
            cookie_timeout=100,
            health_check_http_code="http_2xx",
            health_check_interval=10,
            health_check_uri="/test",
            health_check_connect_port=80,
            health_check_timeout=30,
            healthy_threshold=3,
            unhealthy_threshold=5,
            sticky_session="on",
            sticky_session_type="server",
            listener_sync="off",
            scheduler="rr",
            health_check_domain="test",
            health_check="on")
        ```

        ## Import

        Load balancer forwarding rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:slb/rule:Rule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cookie: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 delete_protection_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 frontend_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_connect_port: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_http_code: Optional[pulumi.Input[_builtins.str]] = None,
                 health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 listener_sync: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sticky_session: Optional[pulumi.Input[_builtins.str]] = None,
                 sticky_session_type: Optional[pulumi.Input[_builtins.str]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            __props__.__dict__["cookie"] = cookie
            __props__.__dict__["cookie_timeout"] = cookie_timeout
            __props__.__dict__["delete_protection_validation"] = delete_protection_validation
            __props__.__dict__["domain"] = domain
            if frontend_port is None and not opts.urn:
                raise TypeError("Missing required property 'frontend_port'")
            __props__.__dict__["frontend_port"] = frontend_port
            __props__.__dict__["health_check"] = health_check
            __props__.__dict__["health_check_connect_port"] = health_check_connect_port
            __props__.__dict__["health_check_domain"] = health_check_domain
            __props__.__dict__["health_check_http_code"] = health_check_http_code
            __props__.__dict__["health_check_interval"] = health_check_interval
            __props__.__dict__["health_check_timeout"] = health_check_timeout
            __props__.__dict__["health_check_uri"] = health_check_uri
            __props__.__dict__["healthy_threshold"] = healthy_threshold
            __props__.__dict__["listener_sync"] = listener_sync
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["name"] = name
            __props__.__dict__["scheduler"] = scheduler
            if server_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_group_id'")
            __props__.__dict__["server_group_id"] = server_group_id
            __props__.__dict__["sticky_session"] = sticky_session
            __props__.__dict__["sticky_session_type"] = sticky_session_type
            __props__.__dict__["unhealthy_threshold"] = unhealthy_threshold
            __props__.__dict__["url"] = url
        super(Rule, __self__).__init__(
            'alicloud:slb/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cookie: Optional[pulumi.Input[_builtins.str]] = None,
            cookie_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            delete_protection_validation: Optional[pulumi.Input[_builtins.bool]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            frontend_port: Optional[pulumi.Input[_builtins.int]] = None,
            health_check: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_connect_port: Optional[pulumi.Input[_builtins.int]] = None,
            health_check_domain: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_http_code: Optional[pulumi.Input[_builtins.str]] = None,
            health_check_interval: Optional[pulumi.Input[_builtins.int]] = None,
            health_check_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            health_check_uri: Optional[pulumi.Input[_builtins.str]] = None,
            healthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            listener_sync: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            scheduler: Optional[pulumi.Input[_builtins.str]] = None,
            server_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            sticky_session: Optional[pulumi.Input[_builtins.str]] = None,
            sticky_session_type: Optional[pulumi.Input[_builtins.str]] = None,
            unhealthy_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cookie: The cookie configured on the server. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `server`. Otherwise, it will be ignored. Valid value：String in line with RFC 2965, with length being `1` - `200`. It only contains characters such as ASCII codes, English letters and digits instead of the comma, semicolon or spacing, and it cannot start with $.
        :param pulumi.Input[_builtins.int] cookie_timeout: Cookie timeout. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `insert`. Otherwise, it will be ignored. Valid values: [1-86400] in seconds.
        :param pulumi.Input[_builtins.bool] delete_protection_validation: Checking DeleteProtection of SLB instance before deleting. If `true`, this resource will not be deleted when its SLB instance enabled DeleteProtection. Default value: `false`.
        :param pulumi.Input[_builtins.str] domain: Domain name of the forwarding rule. It can contain letters a-z, numbers 0-9, hyphens (-), and periods (.),
               and wildcard characters. The following two domain name formats are supported:
               - Standard domain name: www.test.com
               - Wildcard domain name: *.test.com. wildcard (*) must be the first character in the format of (*.)
        :param pulumi.Input[_builtins.int] frontend_port: The listener frontend port which is used to launch the new forwarding rule. Valid values: [1-65535].
        :param pulumi.Input[_builtins.str] health_check: Whether to enable health check. Valid values: `on` and `off`. `TCP` and `UDP` listener's `health_check` is always `on`, so it will be ignore when launching `TCP` or `UDP` listener. **NOTE:** `health_check` is required and takes effect only when `listener_sync` is set to `off`.
        :param pulumi.Input[_builtins.int] health_check_connect_port: Port used for health check. Valid values: [1-65535]. Default value: `None` means the backend server port is used.
        :param pulumi.Input[_builtins.str] health_check_domain: Domain name used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and only characters such as letters, digits, ‘-‘ and ‘.’ are allowed. When it is not set or empty, Server Load Balancer uses the private network IP address of each backend server as Domain used for health check.
        :param pulumi.Input[_builtins.str] health_check_http_code: Regular health check HTTP status code. Multiple codes are segmented by “,”. It is required when `health_check` is `on`. Default value: `http_2xx`. Valid values: `http_2xx`, `http_3xx`, `http_4xx` and `http_5xx`.
        :param pulumi.Input[_builtins.int] health_check_interval: Time interval of health checks. It is required when `health_check` is `on`. Valid values: [1-50] in seconds. Default value: `2`.
        :param pulumi.Input[_builtins.int] health_check_timeout: Maximum timeout of each health check response. It is required when `health_check` is `on`. Valid values: [1-300] in seconds. Default value: `5`. Note: If `health_check_timeout` < `health_check_interval`, its will be replaced by `health_check_interval`.
        :param pulumi.Input[_builtins.str] health_check_uri: URI used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and it must start with /. Only characters such as letters, digits, ‘-’, ‘/’, ‘.’, ‘%’, ‘?’, #’ and ‘&’ are allowed.
        :param pulumi.Input[_builtins.int] healthy_threshold: Threshold determining the result of the health check is success. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        :param pulumi.Input[_builtins.str] listener_sync: Indicates whether a forwarding rule inherits the settings of a health check , session persistence, and scheduling algorithm from a listener. Default value: `on`. Valid values: `on` and `off`.
        :param pulumi.Input[_builtins.str] load_balancer_id: The Load Balancer ID which is used to launch the new forwarding rule.
        :param pulumi.Input[_builtins.str] name: Name of the forwarding rule. Our plugin provides a default name: "tf-slb-rule".
        :param pulumi.Input[_builtins.str] scheduler: Scheduling algorithm. Valid values: `wrr`, `rr` and `wlc`. Default value: `wrr`. **NOTE:** `scheduler` is required and takes effect only when `listener_sync` is set to `off`.
        :param pulumi.Input[_builtins.str] server_group_id: ID of a virtual server group that will be forwarded.
        :param pulumi.Input[_builtins.str] sticky_session: Whether to enable session persistence. Valid values: `on` and `off`. Default value: `off`. **NOTE:** `sticky_session` is required and takes effect only when `listener_sync` is set to `off`.
        :param pulumi.Input[_builtins.str] sticky_session_type: Mode for handling the cookie. If `sticky_session` is `on`, it is mandatory. Otherwise, it will be ignored. Valid values: `insert` and `server`. `insert` means it is inserted from Server Load Balancer; `server` means the Server Load Balancer learns from the backend server.
        :param pulumi.Input[_builtins.int] unhealthy_threshold: Threshold determining the result of the health check is fail. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        :param pulumi.Input[_builtins.str] url: Domain of the forwarding rule. It must be 2-80 characters in length. Only letters a-z, numbers 0-9, and characters '-' '/' '?' '%' '#' and '&' are allowed. URLs must be started with the character '/', but cannot be '/' alone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["cookie"] = cookie
        __props__.__dict__["cookie_timeout"] = cookie_timeout
        __props__.__dict__["delete_protection_validation"] = delete_protection_validation
        __props__.__dict__["domain"] = domain
        __props__.__dict__["frontend_port"] = frontend_port
        __props__.__dict__["health_check"] = health_check
        __props__.__dict__["health_check_connect_port"] = health_check_connect_port
        __props__.__dict__["health_check_domain"] = health_check_domain
        __props__.__dict__["health_check_http_code"] = health_check_http_code
        __props__.__dict__["health_check_interval"] = health_check_interval
        __props__.__dict__["health_check_timeout"] = health_check_timeout
        __props__.__dict__["health_check_uri"] = health_check_uri
        __props__.__dict__["healthy_threshold"] = healthy_threshold
        __props__.__dict__["listener_sync"] = listener_sync
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["scheduler"] = scheduler
        __props__.__dict__["server_group_id"] = server_group_id
        __props__.__dict__["sticky_session"] = sticky_session
        __props__.__dict__["sticky_session_type"] = sticky_session_type
        __props__.__dict__["unhealthy_threshold"] = unhealthy_threshold
        __props__.__dict__["url"] = url
        return Rule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cookie(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The cookie configured on the server. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `server`. Otherwise, it will be ignored. Valid value：String in line with RFC 2965, with length being `1` - `200`. It only contains characters such as ASCII codes, English letters and digits instead of the comma, semicolon or spacing, and it cannot start with $.
        """
        return pulumi.get(self, "cookie")

    @_builtins.property
    @pulumi.getter(name="cookieTimeout")
    def cookie_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Cookie timeout. It is mandatory when `sticky_session` is `on` and `sticky_session_type` is `insert`. Otherwise, it will be ignored. Valid values: [1-86400] in seconds.
        """
        return pulumi.get(self, "cookie_timeout")

    @_builtins.property
    @pulumi.getter(name="deleteProtectionValidation")
    def delete_protection_validation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Checking DeleteProtection of SLB instance before deleting. If `true`, this resource will not be deleted when its SLB instance enabled DeleteProtection. Default value: `false`.
        """
        return pulumi.get(self, "delete_protection_validation")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Domain name of the forwarding rule. It can contain letters a-z, numbers 0-9, hyphens (-), and periods (.),
        and wildcard characters. The following two domain name formats are supported:
        - Standard domain name: www.test.com
        - Wildcard domain name: *.test.com. wildcard (*) must be the first character in the format of (*.)
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> pulumi.Output[_builtins.int]:
        """
        The listener frontend port which is used to launch the new forwarding rule. Valid values: [1-65535].
        """
        return pulumi.get(self, "frontend_port")

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable health check. Valid values: `on` and `off`. `TCP` and `UDP` listener's `health_check` is always `on`, so it will be ignore when launching `TCP` or `UDP` listener. **NOTE:** `health_check` is required and takes effect only when `listener_sync` is set to `off`.
        """
        return pulumi.get(self, "health_check")

    @_builtins.property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> pulumi.Output[_builtins.int]:
        """
        Port used for health check. Valid values: [1-65535]. Default value: `None` means the backend server port is used.
        """
        return pulumi.get(self, "health_check_connect_port")

    @_builtins.property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Domain name used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and only characters such as letters, digits, ‘-‘ and ‘.’ are allowed. When it is not set or empty, Server Load Balancer uses the private network IP address of each backend server as Domain used for health check.
        """
        return pulumi.get(self, "health_check_domain")

    @_builtins.property
    @pulumi.getter(name="healthCheckHttpCode")
    def health_check_http_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Regular health check HTTP status code. Multiple codes are segmented by “,”. It is required when `health_check` is `on`. Default value: `http_2xx`. Valid values: `http_2xx`, `http_3xx`, `http_4xx` and `http_5xx`.
        """
        return pulumi.get(self, "health_check_http_code")

    @_builtins.property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Time interval of health checks. It is required when `health_check` is `on`. Valid values: [1-50] in seconds. Default value: `2`.
        """
        return pulumi.get(self, "health_check_interval")

    @_builtins.property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum timeout of each health check response. It is required when `health_check` is `on`. Valid values: [1-300] in seconds. Default value: `5`. Note: If `health_check_timeout` < `health_check_interval`, its will be replaced by `health_check_interval`.
        """
        return pulumi.get(self, "health_check_timeout")

    @_builtins.property
    @pulumi.getter(name="healthCheckUri")
    def health_check_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URI used for health check. When it used to launch TCP listener, `health_check_type` must be `http`. Its length is limited to 1-80 and it must start with /. Only characters such as letters, digits, ‘-’, ‘/’, ‘.’, ‘%’, ‘?’, #’ and ‘&’ are allowed.
        """
        return pulumi.get(self, "health_check_uri")

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Threshold determining the result of the health check is success. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        """
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter(name="listenerSync")
    def listener_sync(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates whether a forwarding rule inherits the settings of a health check , session persistence, and scheduling algorithm from a listener. Default value: `on`. Valid values: `on` and `off`.
        """
        return pulumi.get(self, "listener_sync")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Load Balancer ID which is used to launch the new forwarding rule.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the forwarding rule. Our plugin provides a default name: "tf-slb-rule".
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def scheduler(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Scheduling algorithm. Valid values: `wrr`, `rr` and `wlc`. Default value: `wrr`. **NOTE:** `scheduler` is required and takes effect only when `listener_sync` is set to `off`.
        """
        return pulumi.get(self, "scheduler")

    @_builtins.property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of a virtual server group that will be forwarded.
        """
        return pulumi.get(self, "server_group_id")

    @_builtins.property
    @pulumi.getter(name="stickySession")
    def sticky_session(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to enable session persistence. Valid values: `on` and `off`. Default value: `off`. **NOTE:** `sticky_session` is required and takes effect only when `listener_sync` is set to `off`.
        """
        return pulumi.get(self, "sticky_session")

    @_builtins.property
    @pulumi.getter(name="stickySessionType")
    def sticky_session_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Mode for handling the cookie. If `sticky_session` is `on`, it is mandatory. Otherwise, it will be ignored. Valid values: `insert` and `server`. `insert` means it is inserted from Server Load Balancer; `server` means the Server Load Balancer learns from the backend server.
        """
        return pulumi.get(self, "sticky_session_type")

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Threshold determining the result of the health check is fail. It is required when `health_check` is `on`. Valid values: [1-10] in seconds. Default value: `3`.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Domain of the forwarding rule. It must be 2-80 characters in length. Only letters a-z, numbers 0-9, and characters '-' '/' '?' '%' '#' and '&' are allowed. URLs must be started with the character '/', but cannot be '/' alone.
        """
        return pulumi.get(self, "url")

