# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AssociatedRuleArgs', 'AssociatedRule']

@pulumi.input_type
class AssociatedRuleArgs:
    def __init__(__self__, *,
                 associated_setting_name: pulumi.Input[_builtins.str],
                 status: pulumi.Input[_builtins.str],
                 tag_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AssociatedRule resource.
        :param pulumi.Input[_builtins.str] associated_setting_name: The setting name of the associated resource tag rule. For specific values, see the Rule Setting Name column in [Resources that Support Associated Resource Tag Settings](https://www.alibabacloud.com/help/en/resource-management/tag/user-guide/associated-resource-label-settings)
        :param pulumi.Input[_builtins.str] status: Whether to enable the associated resource tag rule. Valid values: `Enable`, `Disable`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_keys: List of tag keys for the associated resource tag rule.
        """
        pulumi.set(__self__, "associated_setting_name", associated_setting_name)
        pulumi.set(__self__, "status", status)
        if tag_keys is not None:
            pulumi.set(__self__, "tag_keys", tag_keys)

    @_builtins.property
    @pulumi.getter(name="associatedSettingName")
    def associated_setting_name(self) -> pulumi.Input[_builtins.str]:
        """
        The setting name of the associated resource tag rule. For specific values, see the Rule Setting Name column in [Resources that Support Associated Resource Tag Settings](https://www.alibabacloud.com/help/en/resource-management/tag/user-guide/associated-resource-label-settings)
        """
        return pulumi.get(self, "associated_setting_name")

    @associated_setting_name.setter
    def associated_setting_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "associated_setting_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        Whether to enable the associated resource tag rule. Valid values: `Enable`, `Disable`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tagKeys")
    def tag_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tag keys for the associated resource tag rule.
        """
        return pulumi.get(self, "tag_keys")

    @tag_keys.setter
    def tag_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tag_keys", value)


@pulumi.input_type
class _AssociatedRuleState:
    def __init__(__self__, *,
                 associated_setting_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AssociatedRule resources.
        :param pulumi.Input[_builtins.str] associated_setting_name: The setting name of the associated resource tag rule. For specific values, see the Rule Setting Name column in [Resources that Support Associated Resource Tag Settings](https://www.alibabacloud.com/help/en/resource-management/tag/user-guide/associated-resource-label-settings)
        :param pulumi.Input[_builtins.str] status: Whether to enable the associated resource tag rule. Valid values: `Enable`, `Disable`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_keys: List of tag keys for the associated resource tag rule.
        """
        if associated_setting_name is not None:
            pulumi.set(__self__, "associated_setting_name", associated_setting_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tag_keys is not None:
            pulumi.set(__self__, "tag_keys", tag_keys)

    @_builtins.property
    @pulumi.getter(name="associatedSettingName")
    def associated_setting_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The setting name of the associated resource tag rule. For specific values, see the Rule Setting Name column in [Resources that Support Associated Resource Tag Settings](https://www.alibabacloud.com/help/en/resource-management/tag/user-guide/associated-resource-label-settings)
        """
        return pulumi.get(self, "associated_setting_name")

    @associated_setting_name.setter
    def associated_setting_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associated_setting_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable the associated resource tag rule. Valid values: `Enable`, `Disable`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="tagKeys")
    def tag_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tag keys for the associated resource tag rule.
        """
        return pulumi.get(self, "tag_keys")

    @tag_keys.setter
    def tag_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tag_keys", value)


@pulumi.type_token("alicloud:tag/associatedRule:AssociatedRule")
class AssociatedRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_setting_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a TAG Associated Rule resource.

        For information about TAG Associated Rule and how to use it, see [What is Associated Rule](https://www.alibabacloud.com/help/en/resource-management/tag/developer-reference/api-tag-2018-08-28-createassociatedresourcerules).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.tag.AssociatedRule("default",
            status="Enable",
            associated_setting_name="rule:AttachEni-DetachEni-TagInstance:Ecs-Instance:Ecs-Eni",
            tag_keys=["user"])
        ```

        ## Import

        TAG Associated Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:tag/associatedRule:AssociatedRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] associated_setting_name: The setting name of the associated resource tag rule. For specific values, see the Rule Setting Name column in [Resources that Support Associated Resource Tag Settings](https://www.alibabacloud.com/help/en/resource-management/tag/user-guide/associated-resource-label-settings)
        :param pulumi.Input[_builtins.str] status: Whether to enable the associated resource tag rule. Valid values: `Enable`, `Disable`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_keys: List of tag keys for the associated resource tag rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssociatedRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a TAG Associated Rule resource.

        For information about TAG Associated Rule and how to use it, see [What is Associated Rule](https://www.alibabacloud.com/help/en/resource-management/tag/developer-reference/api-tag-2018-08-28-createassociatedresourcerules).

        > **NOTE:** Available since v1.244.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.tag.AssociatedRule("default",
            status="Enable",
            associated_setting_name="rule:AttachEni-DetachEni-TagInstance:Ecs-Instance:Ecs-Eni",
            tag_keys=["user"])
        ```

        ## Import

        TAG Associated Rule can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:tag/associatedRule:AssociatedRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AssociatedRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssociatedRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_setting_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssociatedRuleArgs.__new__(AssociatedRuleArgs)

            if associated_setting_name is None and not opts.urn:
                raise TypeError("Missing required property 'associated_setting_name'")
            __props__.__dict__["associated_setting_name"] = associated_setting_name
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["tag_keys"] = tag_keys
        super(AssociatedRule, __self__).__init__(
            'alicloud:tag/associatedRule:AssociatedRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_setting_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tag_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'AssociatedRule':
        """
        Get an existing AssociatedRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] associated_setting_name: The setting name of the associated resource tag rule. For specific values, see the Rule Setting Name column in [Resources that Support Associated Resource Tag Settings](https://www.alibabacloud.com/help/en/resource-management/tag/user-guide/associated-resource-label-settings)
        :param pulumi.Input[_builtins.str] status: Whether to enable the associated resource tag rule. Valid values: `Enable`, `Disable`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_keys: List of tag keys for the associated resource tag rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssociatedRuleState.__new__(_AssociatedRuleState)

        __props__.__dict__["associated_setting_name"] = associated_setting_name
        __props__.__dict__["status"] = status
        __props__.__dict__["tag_keys"] = tag_keys
        return AssociatedRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="associatedSettingName")
    def associated_setting_name(self) -> pulumi.Output[_builtins.str]:
        """
        The setting name of the associated resource tag rule. For specific values, see the Rule Setting Name column in [Resources that Support Associated Resource Tag Settings](https://www.alibabacloud.com/help/en/resource-management/tag/user-guide/associated-resource-label-settings)
        """
        return pulumi.get(self, "associated_setting_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to enable the associated resource tag rule. Valid values: `Enable`, `Disable`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tagKeys")
    def tag_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tag keys for the associated resource tag rule.
        """
        return pulumi.get(self, "tag_keys")

