# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBgpNetworksResult',
    'AwaitableGetBgpNetworksResult',
    'get_bgp_networks',
    'get_bgp_networks_output',
]

@pulumi.output_type
class GetBgpNetworksResult:
    """
    A collection of values returned by getBgpNetworks.
    """
    def __init__(__self__, id=None, ids=None, networks=None, output_file=None, router_id=None, status=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        pulumi.set(__self__, "networks", networks)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if router_id and not isinstance(router_id, str):
            raise TypeError("Expected argument 'router_id' to be a str")
        pulumi.set(__self__, "router_id", router_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.GetBgpNetworksNetworkResult']:
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "router_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")


class AwaitableGetBgpNetworksResult(GetBgpNetworksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBgpNetworksResult(
            id=self.id,
            ids=self.ids,
            networks=self.networks,
            output_file=self.output_file,
            router_id=self.router_id,
            status=self.status)


def get_bgp_networks(ids: Optional[Sequence[_builtins.str]] = None,
                     output_file: Optional[_builtins.str] = None,
                     router_id: Optional[_builtins.str] = None,
                     status: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBgpNetworksResult:
    """
    This data source provides the Vpc Bgp Networks of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.153.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_bgp_networks(ids=["example_value"])
    pulumi.export("vpcBgpNetworkId1", ids.networks[0].id)
    router_id = alicloud.vpc.get_bgp_networks(router_id="example_value")
    pulumi.export("vpcBgpNetworkId2", router_id.networks[0].id)
    status = alicloud.vpc.get_bgp_networks(status="Available")
    pulumi.export("vpcBgpNetworkId3", status.networks[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Bgp Network IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str router_id: The ID of the router to which the route table belongs.
    :param _builtins.str status: The state of the advertised BGP network. Valid values: `Available`, `Pending`, `Deleting`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['routerId'] = router_id
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getBgpNetworks:getBgpNetworks', __args__, opts=opts, typ=GetBgpNetworksResult).value

    return AwaitableGetBgpNetworksResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        networks=pulumi.get(__ret__, 'networks'),
        output_file=pulumi.get(__ret__, 'output_file'),
        router_id=pulumi.get(__ret__, 'router_id'),
        status=pulumi.get(__ret__, 'status'))
def get_bgp_networks_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            router_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBgpNetworksResult]:
    """
    This data source provides the Vpc Bgp Networks of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.153.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_bgp_networks(ids=["example_value"])
    pulumi.export("vpcBgpNetworkId1", ids.networks[0].id)
    router_id = alicloud.vpc.get_bgp_networks(router_id="example_value")
    pulumi.export("vpcBgpNetworkId2", router_id.networks[0].id)
    status = alicloud.vpc.get_bgp_networks(status="Available")
    pulumi.export("vpcBgpNetworkId3", status.networks[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Bgp Network IDs.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str router_id: The ID of the router to which the route table belongs.
    :param _builtins.str status: The state of the advertised BGP network. Valid values: `Available`, `Pending`, `Deleting`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['routerId'] = router_id
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpc/getBgpNetworks:getBgpNetworks', __args__, opts=opts, typ=GetBgpNetworksResult)
    return __ret__.apply(lambda __response__: GetBgpNetworksResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        networks=pulumi.get(__response__, 'networks'),
        output_file=pulumi.get(__response__, 'output_file'),
        router_id=pulumi.get(__response__, 'router_id'),
        status=pulumi.get(__response__, 'status')))
