# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIpamIpamPoolCidrsResult',
    'AwaitableGetIpamIpamPoolCidrsResult',
    'get_ipam_ipam_pool_cidrs',
    'get_ipam_ipam_pool_cidrs_output',
]

@pulumi.output_type
class GetIpamIpamPoolCidrsResult:
    """
    A collection of values returned by getIpamIpamPoolCidrs.
    """
    def __init__(__self__, cidr=None, cidrs=None, id=None, ipam_pool_id=None, output_file=None):
        if cidr and not isinstance(cidr, str):
            raise TypeError("Expected argument 'cidr' to be a str")
        pulumi.set(__self__, "cidr", cidr)
        if cidrs and not isinstance(cidrs, list):
            raise TypeError("Expected argument 'cidrs' to be a list")
        pulumi.set(__self__, "cidrs", cidrs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipam_pool_id and not isinstance(ipam_pool_id, str):
            raise TypeError("Expected argument 'ipam_pool_id' to be a str")
        pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[_builtins.str]:
        """
        The CIDR address segment to be preset.> currently, only IPv4 address segments are supported.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Sequence['outputs.GetIpamIpamPoolCidrsCidrResult']:
        """
        A list of Ipam Pool Cidr Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "cidrs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> _builtins.str:
        """
        The ID of the IPAM pool instance.
        """
        return pulumi.get(self, "ipam_pool_id")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetIpamIpamPoolCidrsResult(GetIpamIpamPoolCidrsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpamIpamPoolCidrsResult(
            cidr=self.cidr,
            cidrs=self.cidrs,
            id=self.id,
            ipam_pool_id=self.ipam_pool_id,
            output_file=self.output_file)


def get_ipam_ipam_pool_cidrs(cidr: Optional[_builtins.str] = None,
                             ipam_pool_id: Optional[_builtins.str] = None,
                             output_file: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpamIpamPoolCidrsResult:
    """
    This data source provides Vpc Ipam Ipam Pool Cidr available to the user.[What is Ipam Pool Cidr](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/AddIpamPoolCidr)

    > **NOTE:** Available since v1.241.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_ipam = alicloud.vpc.IpamIpam("defaultIpam", operating_region_lists=["cn-hangzhou"])
    default_ipam_pool = alicloud.vpc.IpamIpamPool("defaultIpamPool",
        ipam_scope_id=default_ipam.private_default_scope_id,
        pool_region_id=default_ipam.region_id,
        ip_version="IPv4")
    default_ipam_ipam_pool_cidr = alicloud.vpc.IpamIpamPoolCidr("default",
        cidr="10.0.0.0/8",
        ipam_pool_id=default_ipam_pool.id)
    default = alicloud.vpc.get_ipam_ipam_pool_cidrs_output(cidr="10.0.0.0/8",
        ipam_pool_id=default_ipam_ipam_pool_cidr.ipam_pool_id)
    pulumi.export("alicloudVpcIpamIpamPoolCidrExampleId", default.cidrs[0].id)
    ```


    :param _builtins.str cidr: The CIDR address segment to be preset.> currently, only IPv4 address segments are supported.
    :param _builtins.str ipam_pool_id: The ID of the IPAM pool instance.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['cidr'] = cidr
    __args__['ipamPoolId'] = ipam_pool_id
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getIpamIpamPoolCidrs:getIpamIpamPoolCidrs', __args__, opts=opts, typ=GetIpamIpamPoolCidrsResult).value

    return AwaitableGetIpamIpamPoolCidrsResult(
        cidr=pulumi.get(__ret__, 'cidr'),
        cidrs=pulumi.get(__ret__, 'cidrs'),
        id=pulumi.get(__ret__, 'id'),
        ipam_pool_id=pulumi.get(__ret__, 'ipam_pool_id'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_ipam_ipam_pool_cidrs_output(cidr: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpamIpamPoolCidrsResult]:
    """
    This data source provides Vpc Ipam Ipam Pool Cidr available to the user.[What is Ipam Pool Cidr](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/AddIpamPoolCidr)

    > **NOTE:** Available since v1.241.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_ipam = alicloud.vpc.IpamIpam("defaultIpam", operating_region_lists=["cn-hangzhou"])
    default_ipam_pool = alicloud.vpc.IpamIpamPool("defaultIpamPool",
        ipam_scope_id=default_ipam.private_default_scope_id,
        pool_region_id=default_ipam.region_id,
        ip_version="IPv4")
    default_ipam_ipam_pool_cidr = alicloud.vpc.IpamIpamPoolCidr("default",
        cidr="10.0.0.0/8",
        ipam_pool_id=default_ipam_pool.id)
    default = alicloud.vpc.get_ipam_ipam_pool_cidrs_output(cidr="10.0.0.0/8",
        ipam_pool_id=default_ipam_ipam_pool_cidr.ipam_pool_id)
    pulumi.export("alicloudVpcIpamIpamPoolCidrExampleId", default.cidrs[0].id)
    ```


    :param _builtins.str cidr: The CIDR address segment to be preset.> currently, only IPv4 address segments are supported.
    :param _builtins.str ipam_pool_id: The ID of the IPAM pool instance.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['cidr'] = cidr
    __args__['ipamPoolId'] = ipam_pool_id
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpc/getIpamIpamPoolCidrs:getIpamIpamPoolCidrs', __args__, opts=opts, typ=GetIpamIpamPoolCidrsResult)
    return __ret__.apply(lambda __response__: GetIpamIpamPoolCidrsResult(
        cidr=pulumi.get(__response__, 'cidr'),
        cidrs=pulumi.get(__response__, 'cidrs'),
        id=pulumi.get(__response__, 'id'),
        ipam_pool_id=pulumi.get(__response__, 'ipam_pool_id'),
        output_file=pulumi.get(__response__, 'output_file')))
