# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIpamIpamsResult',
    'AwaitableGetIpamIpamsResult',
    'get_ipam_ipams',
    'get_ipam_ipams_output',
]

@pulumi.output_type
class GetIpamIpamsResult:
    """
    A collection of values returned by getIpamIpams.
    """
    def __init__(__self__, id=None, ids=None, ipam_id=None, ipam_name=None, ipams=None, name_regex=None, names=None, output_file=None, resource_group_id=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if ipam_id and not isinstance(ipam_id, str):
            raise TypeError("Expected argument 'ipam_id' to be a str")
        pulumi.set(__self__, "ipam_id", ipam_id)
        if ipam_name and not isinstance(ipam_name, str):
            raise TypeError("Expected argument 'ipam_name' to be a str")
        pulumi.set(__self__, "ipam_name", ipam_name)
        if ipams and not isinstance(ipams, list):
            raise TypeError("Expected argument 'ipams' to be a list")
        pulumi.set(__self__, "ipams", ipams)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of Ipam IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="ipamId")
    def ipam_id(self) -> Optional[_builtins.str]:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "ipam_id")

    @_builtins.property
    @pulumi.getter(name="ipamName")
    def ipam_name(self) -> Optional[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipam_name")

    @_builtins.property
    @pulumi.getter
    def ipams(self) -> Sequence['outputs.GetIpamIpamsIpamResult']:
        """
        A list of Ipam Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "ipams")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of name of Ipams.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetIpamIpamsResult(GetIpamIpamsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpamIpamsResult(
            id=self.id,
            ids=self.ids,
            ipam_id=self.ipam_id,
            ipam_name=self.ipam_name,
            ipams=self.ipams,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id,
            tags=self.tags)


def get_ipam_ipams(ids: Optional[Sequence[_builtins.str]] = None,
                   ipam_id: Optional[_builtins.str] = None,
                   ipam_name: Optional[_builtins.str] = None,
                   name_regex: Optional[_builtins.str] = None,
                   output_file: Optional[_builtins.str] = None,
                   resource_group_id: Optional[_builtins.str] = None,
                   tags: Optional[Mapping[str, _builtins.str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpamIpamsResult:
    """
    This data source provides Vpc Ipam Ipam available to the user.[What is Ipam](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/CreateIpam)

    > **NOTE:** Available since v1.241.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.resourcemanager.get_resource_groups()
    default_ipam_ipam = alicloud.vpc.IpamIpam("default",
        ipam_description="This is my first Ipam.",
        ipam_name=name,
        operating_region_lists=["cn-hangzhou"])
    default_get_ipam_ipams = pulumi.Output.all(
        id=default_ipam_ipam.id,
        ipam_name=default_ipam_ipam.ipam_name
    ).apply(lambda resolved_outputs: alicloud.vpc.get_ipam_ipams_output(ids=[resolved_outputs['id']],
        name_regex=resolved_outputs['ipam_name'],
        ipam_name=name))

    pulumi.export("alicloudVpcIpamIpamExampleId", default_get_ipam_ipams.ipams[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Ipam IDs.
    :param _builtins.str ipam_id: The first ID of the resource.
    :param _builtins.str ipam_name: The name of the resource.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param Mapping[str, _builtins.str] tags: The tag of the resource.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['ipamId'] = ipam_id
    __args__['ipamName'] = ipam_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getIpamIpams:getIpamIpams', __args__, opts=opts, typ=GetIpamIpamsResult).value

    return AwaitableGetIpamIpamsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        ipam_id=pulumi.get(__ret__, 'ipam_id'),
        ipam_name=pulumi.get(__ret__, 'ipam_name'),
        ipams=pulumi.get(__ret__, 'ipams'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_ipam_ipams_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                          ipam_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          ipam_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpamIpamsResult]:
    """
    This data source provides Vpc Ipam Ipam available to the user.[What is Ipam](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/CreateIpam)

    > **NOTE:** Available since v1.241.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.resourcemanager.get_resource_groups()
    default_ipam_ipam = alicloud.vpc.IpamIpam("default",
        ipam_description="This is my first Ipam.",
        ipam_name=name,
        operating_region_lists=["cn-hangzhou"])
    default_get_ipam_ipams = pulumi.Output.all(
        id=default_ipam_ipam.id,
        ipam_name=default_ipam_ipam.ipam_name
    ).apply(lambda resolved_outputs: alicloud.vpc.get_ipam_ipams_output(ids=[resolved_outputs['id']],
        name_regex=resolved_outputs['ipam_name'],
        ipam_name=name))

    pulumi.export("alicloudVpcIpamIpamExampleId", default_get_ipam_ipams.ipams[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Ipam IDs.
    :param _builtins.str ipam_id: The first ID of the resource.
    :param _builtins.str ipam_name: The name of the resource.
    :param _builtins.str name_regex: A regex string to filter results by Group Metric Rule name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param Mapping[str, _builtins.str] tags: The tag of the resource.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['ipamId'] = ipam_id
    __args__['ipamName'] = ipam_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpc/getIpamIpams:getIpamIpams', __args__, opts=opts, typ=GetIpamIpamsResult)
    return __ret__.apply(lambda __response__: GetIpamIpamsResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        ipam_id=pulumi.get(__response__, 'ipam_id'),
        ipam_name=pulumi.get(__response__, 'ipam_name'),
        ipams=pulumi.get(__response__, 'ipams'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        tags=pulumi.get(__response__, 'tags')))
