# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNatIpsResult',
    'AwaitableGetNatIpsResult',
    'get_nat_ips',
    'get_nat_ips_output',
]

@pulumi.output_type
class GetNatIpsResult:
    """
    A collection of values returned by getNatIps.
    """
    def __init__(__self__, id=None, ids=None, ips=None, name_regex=None, names=None, nat_gateway_id=None, nat_ip_cidr=None, nat_ip_ids=None, nat_ip_names=None, output_file=None, status=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if ips and not isinstance(ips, list):
            raise TypeError("Expected argument 'ips' to be a list")
        pulumi.set(__self__, "ips", ips)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if nat_gateway_id and not isinstance(nat_gateway_id, str):
            raise TypeError("Expected argument 'nat_gateway_id' to be a str")
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if nat_ip_cidr and not isinstance(nat_ip_cidr, str):
            raise TypeError("Expected argument 'nat_ip_cidr' to be a str")
        pulumi.set(__self__, "nat_ip_cidr", nat_ip_cidr)
        if nat_ip_ids and not isinstance(nat_ip_ids, list):
            raise TypeError("Expected argument 'nat_ip_ids' to be a list")
        pulumi.set(__self__, "nat_ip_ids", nat_ip_ids)
        if nat_ip_names and not isinstance(nat_ip_names, list):
            raise TypeError("Expected argument 'nat_ip_names' to be a list")
        pulumi.set(__self__, "nat_ip_names", nat_ip_names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def ips(self) -> Sequence['outputs.GetNatIpsIpResult']:
        return pulumi.get(self, "ips")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> _builtins.str:
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="natIpCidr")
    def nat_ip_cidr(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "nat_ip_cidr")

    @_builtins.property
    @pulumi.getter(name="natIpIds")
    def nat_ip_ids(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "nat_ip_ids")

    @_builtins.property
    @pulumi.getter(name="natIpNames")
    def nat_ip_names(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "nat_ip_names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "status")


class AwaitableGetNatIpsResult(GetNatIpsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNatIpsResult(
            id=self.id,
            ids=self.ids,
            ips=self.ips,
            name_regex=self.name_regex,
            names=self.names,
            nat_gateway_id=self.nat_gateway_id,
            nat_ip_cidr=self.nat_ip_cidr,
            nat_ip_ids=self.nat_ip_ids,
            nat_ip_names=self.nat_ip_names,
            output_file=self.output_file,
            status=self.status)


def get_nat_ips(ids: Optional[Sequence[_builtins.str]] = None,
                name_regex: Optional[_builtins.str] = None,
                nat_gateway_id: Optional[_builtins.str] = None,
                nat_ip_cidr: Optional[_builtins.str] = None,
                nat_ip_ids: Optional[Sequence[_builtins.str]] = None,
                nat_ip_names: Optional[Sequence[_builtins.str]] = None,
                output_file: Optional[_builtins.str] = None,
                status: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNatIpsResult:
    """
    This data source provides the Vpc Nat Ips of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.136.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("vpcNatIpId1", ids.ips[0].id)
    name_regex = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
        name_regex="^my-NatIp")
    pulumi.export("vpcNatIpId2", name_regex.ips[0].id)
    nat_ip_cidr = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
        nat_ip_cidr="example_value",
        name_regex="^my-NatIp")
    pulumi.export("vpcNatIpId3", nat_ip_cidr.ips[0].id)
    nat_ip_name = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
        ids=["example_value"],
        nat_ip_names=["example_value"])
    pulumi.export("vpcNatIpId4", nat_ip_name.ips[0].id)
    nat_ip_ids = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
        ids=["example_value"],
        nat_ip_ids=["example_value"])
    pulumi.export("vpcNatIpId5", nat_ip_ids.ips[0].id)
    status = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
        ids=["example_value"],
        status="example_value")
    pulumi.export("vpcNatIpId6", status.ips[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Nat Ip IDs.
    :param _builtins.str name_regex: A regex string to filter results by Nat Ip name.
    :param _builtins.str nat_gateway_id: The ID of the Virtual Private Cloud (VPC) NAT gateway for which you want to create the NAT IP address.
    :param _builtins.str nat_ip_cidr: NAT IP ADDRESS of the address segment.
    :param Sequence[_builtins.str] nat_ip_names: NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the NAT IP address. Valid values: `Available`, `Deleting` and `Creating`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['natGatewayId'] = nat_gateway_id
    __args__['natIpCidr'] = nat_ip_cidr
    __args__['natIpIds'] = nat_ip_ids
    __args__['natIpNames'] = nat_ip_names
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getNatIps:getNatIps', __args__, opts=opts, typ=GetNatIpsResult).value

    return AwaitableGetNatIpsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        ips=pulumi.get(__ret__, 'ips'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        nat_gateway_id=pulumi.get(__ret__, 'nat_gateway_id'),
        nat_ip_cidr=pulumi.get(__ret__, 'nat_ip_cidr'),
        nat_ip_ids=pulumi.get(__ret__, 'nat_ip_ids'),
        nat_ip_names=pulumi.get(__ret__, 'nat_ip_names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))
def get_nat_ips_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                       name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                       nat_ip_cidr: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       nat_ip_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                       nat_ip_names: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                       output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNatIpsResult]:
    """
    This data source provides the Vpc Nat Ips of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.136.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
        ids=[
            "example_value-1",
            "example_value-2",
        ])
    pulumi.export("vpcNatIpId1", ids.ips[0].id)
    name_regex = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
        name_regex="^my-NatIp")
    pulumi.export("vpcNatIpId2", name_regex.ips[0].id)
    nat_ip_cidr = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
        nat_ip_cidr="example_value",
        name_regex="^my-NatIp")
    pulumi.export("vpcNatIpId3", nat_ip_cidr.ips[0].id)
    nat_ip_name = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
        ids=["example_value"],
        nat_ip_names=["example_value"])
    pulumi.export("vpcNatIpId4", nat_ip_name.ips[0].id)
    nat_ip_ids = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
        ids=["example_value"],
        nat_ip_ids=["example_value"])
    pulumi.export("vpcNatIpId5", nat_ip_ids.ips[0].id)
    status = alicloud.vpc.get_nat_ips(nat_gateway_id="example_value",
        ids=["example_value"],
        status="example_value")
    pulumi.export("vpcNatIpId6", status.ips[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Nat Ip IDs.
    :param _builtins.str name_regex: A regex string to filter results by Nat Ip name.
    :param _builtins.str nat_gateway_id: The ID of the Virtual Private Cloud (VPC) NAT gateway for which you want to create the NAT IP address.
    :param _builtins.str nat_ip_cidr: NAT IP ADDRESS of the address segment.
    :param Sequence[_builtins.str] nat_ip_names: NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str status: The status of the NAT IP address. Valid values: `Available`, `Deleting` and `Creating`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['natGatewayId'] = nat_gateway_id
    __args__['natIpCidr'] = nat_ip_cidr
    __args__['natIpIds'] = nat_ip_ids
    __args__['natIpNames'] = nat_ip_names
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:vpc/getNatIps:getNatIps', __args__, opts=opts, typ=GetNatIpsResult)
    return __ret__.apply(lambda __response__: GetNatIpsResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        ips=pulumi.get(__response__, 'ips'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        nat_gateway_id=pulumi.get(__response__, 'nat_gateway_id'),
        nat_ip_cidr=pulumi.get(__response__, 'nat_ip_cidr'),
        nat_ip_ids=pulumi.get(__response__, 'nat_ip_ids'),
        nat_ip_names=pulumi.get(__response__, 'nat_ip_names'),
        output_file=pulumi.get(__response__, 'output_file'),
        status=pulumi.get(__response__, 'status')))
