# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IpamIpamPoolArgs', 'IpamIpamPool']

@pulumi.input_type
class IpamIpamPoolArgs:
    def __init__(__self__, *,
                 ipam_scope_id: pulumi.Input[_builtins.str],
                 allocation_default_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 allocation_max_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 allocation_min_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 clear_allocation_default_cidr_mask: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pool_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a IpamIpamPool resource.
        :param pulumi.Input[_builtins.str] ipam_scope_id: Ipam scope id.
        :param pulumi.Input[_builtins.int] allocation_default_cidr_mask: The default network mask assigned by the IPAM address pool.
               IPv4 network mask value range: **0 to 32** bits.
        :param pulumi.Input[_builtins.int] allocation_max_cidr_mask: The maximum network mask assigned by the IPAM address pool.
               IPv4 network mask value range: **0 to 32** bits.
        :param pulumi.Input[_builtins.int] allocation_min_cidr_mask: The minimum Network mask assigned by the IPAM address pool.
               IPv4 network mask value range: **0 to 32** bits.
        :param pulumi.Input[_builtins.bool] auto_import: Whether the automatic import function is enabled for the address pool.
        :param pulumi.Input[_builtins.bool] clear_allocation_default_cidr_mask: Whether to clear the default network mask of the IPAM address pool. Value:
        :param pulumi.Input[_builtins.str] ip_version: The IP protocol version. Currently, only `IPv4` is supported * *.
        :param pulumi.Input[_builtins.str] ipam_pool_description: The description of the IPAM address pool.
               It must be 2 to 256 characters in length and must start with an English letter or a Chinese character, but cannot start with 'http:// 'or 'https. If it is not filled in, it is empty. The default value is empty.
        :param pulumi.Input[_builtins.str] ipam_pool_name: The name of the resource.
        :param pulumi.Input[_builtins.str] pool_region_id: The effective region of the IPAM address pool.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] source_ipam_pool_id: The instance ID of the source IPAM address pool.
               
               > **NOTE:**  If this parameter is not entered, the created address pool is the parent address pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        pulumi.set(__self__, "ipam_scope_id", ipam_scope_id)
        if allocation_default_cidr_mask is not None:
            pulumi.set(__self__, "allocation_default_cidr_mask", allocation_default_cidr_mask)
        if allocation_max_cidr_mask is not None:
            pulumi.set(__self__, "allocation_max_cidr_mask", allocation_max_cidr_mask)
        if allocation_min_cidr_mask is not None:
            pulumi.set(__self__, "allocation_min_cidr_mask", allocation_min_cidr_mask)
        if auto_import is not None:
            pulumi.set(__self__, "auto_import", auto_import)
        if clear_allocation_default_cidr_mask is not None:
            pulumi.set(__self__, "clear_allocation_default_cidr_mask", clear_allocation_default_cidr_mask)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if ipam_pool_description is not None:
            pulumi.set(__self__, "ipam_pool_description", ipam_pool_description)
        if ipam_pool_name is not None:
            pulumi.set(__self__, "ipam_pool_name", ipam_pool_name)
        if pool_region_id is not None:
            pulumi.set(__self__, "pool_region_id", pool_region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if source_ipam_pool_id is not None:
            pulumi.set(__self__, "source_ipam_pool_id", source_ipam_pool_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> pulumi.Input[_builtins.str]:
        """
        Ipam scope id.
        """
        return pulumi.get(self, "ipam_scope_id")

    @ipam_scope_id.setter
    def ipam_scope_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ipam_scope_id", value)

    @_builtins.property
    @pulumi.getter(name="allocationDefaultCidrMask")
    def allocation_default_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default network mask assigned by the IPAM address pool.
        IPv4 network mask value range: **0 to 32** bits.
        """
        return pulumi.get(self, "allocation_default_cidr_mask")

    @allocation_default_cidr_mask.setter
    def allocation_default_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocation_default_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="allocationMaxCidrMask")
    def allocation_max_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum network mask assigned by the IPAM address pool.
        IPv4 network mask value range: **0 to 32** bits.
        """
        return pulumi.get(self, "allocation_max_cidr_mask")

    @allocation_max_cidr_mask.setter
    def allocation_max_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocation_max_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="allocationMinCidrMask")
    def allocation_min_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum Network mask assigned by the IPAM address pool.
        IPv4 network mask value range: **0 to 32** bits.
        """
        return pulumi.get(self, "allocation_min_cidr_mask")

    @allocation_min_cidr_mask.setter
    def allocation_min_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocation_min_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="autoImport")
    def auto_import(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the automatic import function is enabled for the address pool.
        """
        return pulumi.get(self, "auto_import")

    @auto_import.setter
    def auto_import(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_import", value)

    @_builtins.property
    @pulumi.getter(name="clearAllocationDefaultCidrMask")
    def clear_allocation_default_cidr_mask(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to clear the default network mask of the IPAM address pool. Value:
        """
        return pulumi.get(self, "clear_allocation_default_cidr_mask")

    @clear_allocation_default_cidr_mask.setter
    def clear_allocation_default_cidr_mask(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "clear_allocation_default_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP protocol version. Currently, only `IPv4` is supported * *.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="ipamPoolDescription")
    def ipam_pool_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the IPAM address pool.
        It must be 2 to 256 characters in length and must start with an English letter or a Chinese character, but cannot start with 'http:// 'or 'https. If it is not filled in, it is empty. The default value is empty.
        """
        return pulumi.get(self, "ipam_pool_description")

    @ipam_pool_description.setter
    def ipam_pool_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_pool_description", value)

    @_builtins.property
    @pulumi.getter(name="ipamPoolName")
    def ipam_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipam_pool_name")

    @ipam_pool_name.setter
    def ipam_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="poolRegionId")
    def pool_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The effective region of the IPAM address pool.
        """
        return pulumi.get(self, "pool_region_id")

    @pool_region_id.setter
    def pool_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceIpamPoolId")
    def source_ipam_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID of the source IPAM address pool.

        > **NOTE:**  If this parameter is not entered, the created address pool is the parent address pool.
        """
        return pulumi.get(self, "source_ipam_pool_id")

    @source_ipam_pool_id.setter
    def source_ipam_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_ipam_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _IpamIpamPoolState:
    def __init__(__self__, *,
                 allocation_default_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 allocation_max_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 allocation_min_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 clear_allocation_default_cidr_mask: Optional[pulumi.Input[_builtins.bool]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pool_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_scope_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering IpamIpamPool resources.
        :param pulumi.Input[_builtins.int] allocation_default_cidr_mask: The default network mask assigned by the IPAM address pool.
               IPv4 network mask value range: **0 to 32** bits.
        :param pulumi.Input[_builtins.int] allocation_max_cidr_mask: The maximum network mask assigned by the IPAM address pool.
               IPv4 network mask value range: **0 to 32** bits.
        :param pulumi.Input[_builtins.int] allocation_min_cidr_mask: The minimum Network mask assigned by the IPAM address pool.
               IPv4 network mask value range: **0 to 32** bits.
        :param pulumi.Input[_builtins.bool] auto_import: Whether the automatic import function is enabled for the address pool.
        :param pulumi.Input[_builtins.bool] clear_allocation_default_cidr_mask: Whether to clear the default network mask of the IPAM address pool. Value:
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] ip_version: The IP protocol version. Currently, only `IPv4` is supported * *.
        :param pulumi.Input[_builtins.str] ipam_pool_description: The description of the IPAM address pool.
               It must be 2 to 256 characters in length and must start with an English letter or a Chinese character, but cannot start with 'http:// 'or 'https. If it is not filled in, it is empty. The default value is empty.
        :param pulumi.Input[_builtins.str] ipam_pool_name: The name of the resource.
        :param pulumi.Input[_builtins.str] ipam_scope_id: Ipam scope id.
        :param pulumi.Input[_builtins.str] pool_region_id: The effective region of the IPAM address pool.
        :param pulumi.Input[_builtins.str] region_id: The ID of the IPAM hosting region.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] source_ipam_pool_id: The instance ID of the source IPAM address pool.
               
               > **NOTE:**  If this parameter is not entered, the created address pool is the parent address pool.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        if allocation_default_cidr_mask is not None:
            pulumi.set(__self__, "allocation_default_cidr_mask", allocation_default_cidr_mask)
        if allocation_max_cidr_mask is not None:
            pulumi.set(__self__, "allocation_max_cidr_mask", allocation_max_cidr_mask)
        if allocation_min_cidr_mask is not None:
            pulumi.set(__self__, "allocation_min_cidr_mask", allocation_min_cidr_mask)
        if auto_import is not None:
            pulumi.set(__self__, "auto_import", auto_import)
        if clear_allocation_default_cidr_mask is not None:
            pulumi.set(__self__, "clear_allocation_default_cidr_mask", clear_allocation_default_cidr_mask)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if ipam_pool_description is not None:
            pulumi.set(__self__, "ipam_pool_description", ipam_pool_description)
        if ipam_pool_name is not None:
            pulumi.set(__self__, "ipam_pool_name", ipam_pool_name)
        if ipam_scope_id is not None:
            pulumi.set(__self__, "ipam_scope_id", ipam_scope_id)
        if pool_region_id is not None:
            pulumi.set(__self__, "pool_region_id", pool_region_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if source_ipam_pool_id is not None:
            pulumi.set(__self__, "source_ipam_pool_id", source_ipam_pool_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="allocationDefaultCidrMask")
    def allocation_default_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default network mask assigned by the IPAM address pool.
        IPv4 network mask value range: **0 to 32** bits.
        """
        return pulumi.get(self, "allocation_default_cidr_mask")

    @allocation_default_cidr_mask.setter
    def allocation_default_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocation_default_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="allocationMaxCidrMask")
    def allocation_max_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum network mask assigned by the IPAM address pool.
        IPv4 network mask value range: **0 to 32** bits.
        """
        return pulumi.get(self, "allocation_max_cidr_mask")

    @allocation_max_cidr_mask.setter
    def allocation_max_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocation_max_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="allocationMinCidrMask")
    def allocation_min_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum Network mask assigned by the IPAM address pool.
        IPv4 network mask value range: **0 to 32** bits.
        """
        return pulumi.get(self, "allocation_min_cidr_mask")

    @allocation_min_cidr_mask.setter
    def allocation_min_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocation_min_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="autoImport")
    def auto_import(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the automatic import function is enabled for the address pool.
        """
        return pulumi.get(self, "auto_import")

    @auto_import.setter
    def auto_import(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_import", value)

    @_builtins.property
    @pulumi.getter(name="clearAllocationDefaultCidrMask")
    def clear_allocation_default_cidr_mask(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to clear the default network mask of the IPAM address pool. Value:
        """
        return pulumi.get(self, "clear_allocation_default_cidr_mask")

    @clear_allocation_default_cidr_mask.setter
    def clear_allocation_default_cidr_mask(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "clear_allocation_default_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP protocol version. Currently, only `IPv4` is supported * *.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="ipamPoolDescription")
    def ipam_pool_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the IPAM address pool.
        It must be 2 to 256 characters in length and must start with an English letter or a Chinese character, but cannot start with 'http:// 'or 'https. If it is not filled in, it is empty. The default value is empty.
        """
        return pulumi.get(self, "ipam_pool_description")

    @ipam_pool_description.setter
    def ipam_pool_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_pool_description", value)

    @_builtins.property
    @pulumi.getter(name="ipamPoolName")
    def ipam_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipam_pool_name")

    @ipam_pool_name.setter
    def ipam_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ipam scope id.
        """
        return pulumi.get(self, "ipam_scope_id")

    @ipam_scope_id.setter
    def ipam_scope_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_scope_id", value)

    @_builtins.property
    @pulumi.getter(name="poolRegionId")
    def pool_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The effective region of the IPAM address pool.
        """
        return pulumi.get(self, "pool_region_id")

    @pool_region_id.setter
    def pool_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_region_id", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IPAM hosting region.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceIpamPoolId")
    def source_ipam_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID of the source IPAM address pool.

        > **NOTE:**  If this parameter is not entered, the created address pool is the parent address pool.
        """
        return pulumi.get(self, "source_ipam_pool_id")

    @source_ipam_pool_id.setter
    def source_ipam_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_ipam_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:vpc/ipamIpamPool:IpamIpamPool")
class IpamIpamPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_default_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 allocation_max_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 allocation_min_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 clear_allocation_default_cidr_mask: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pool_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_scope_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Vpc Ipam Ipam Pool resource.

        IP Address Management Pool.

        For information about Vpc Ipam Ipam Pool and how to use it, see [What is Ipam Pool](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/CreateIpamPool).

        > **NOTE:** Available since v1.234.0.

        ## Import

        Vpc Ipam Ipam Pool can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipamIpamPool:IpamIpamPool example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] allocation_default_cidr_mask: The default network mask assigned by the IPAM address pool.
               IPv4 network mask value range: **0 to 32** bits.
        :param pulumi.Input[_builtins.int] allocation_max_cidr_mask: The maximum network mask assigned by the IPAM address pool.
               IPv4 network mask value range: **0 to 32** bits.
        :param pulumi.Input[_builtins.int] allocation_min_cidr_mask: The minimum Network mask assigned by the IPAM address pool.
               IPv4 network mask value range: **0 to 32** bits.
        :param pulumi.Input[_builtins.bool] auto_import: Whether the automatic import function is enabled for the address pool.
        :param pulumi.Input[_builtins.bool] clear_allocation_default_cidr_mask: Whether to clear the default network mask of the IPAM address pool. Value:
        :param pulumi.Input[_builtins.str] ip_version: The IP protocol version. Currently, only `IPv4` is supported * *.
        :param pulumi.Input[_builtins.str] ipam_pool_description: The description of the IPAM address pool.
               It must be 2 to 256 characters in length and must start with an English letter or a Chinese character, but cannot start with 'http:// 'or 'https. If it is not filled in, it is empty. The default value is empty.
        :param pulumi.Input[_builtins.str] ipam_pool_name: The name of the resource.
        :param pulumi.Input[_builtins.str] ipam_scope_id: Ipam scope id.
        :param pulumi.Input[_builtins.str] pool_region_id: The effective region of the IPAM address pool.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] source_ipam_pool_id: The instance ID of the source IPAM address pool.
               
               > **NOTE:**  If this parameter is not entered, the created address pool is the parent address pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpamIpamPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vpc Ipam Ipam Pool resource.

        IP Address Management Pool.

        For information about Vpc Ipam Ipam Pool and how to use it, see [What is Ipam Pool](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/CreateIpamPool).

        > **NOTE:** Available since v1.234.0.

        ## Import

        Vpc Ipam Ipam Pool can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipamIpamPool:IpamIpamPool example <id>
        ```

        :param str resource_name: The name of the resource.
        :param IpamIpamPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpamIpamPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation_default_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 allocation_max_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 allocation_min_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_import: Optional[pulumi.Input[_builtins.bool]] = None,
                 clear_allocation_default_cidr_mask: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pool_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_scope_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpamIpamPoolArgs.__new__(IpamIpamPoolArgs)

            __props__.__dict__["allocation_default_cidr_mask"] = allocation_default_cidr_mask
            __props__.__dict__["allocation_max_cidr_mask"] = allocation_max_cidr_mask
            __props__.__dict__["allocation_min_cidr_mask"] = allocation_min_cidr_mask
            __props__.__dict__["auto_import"] = auto_import
            __props__.__dict__["clear_allocation_default_cidr_mask"] = clear_allocation_default_cidr_mask
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["ipam_pool_description"] = ipam_pool_description
            __props__.__dict__["ipam_pool_name"] = ipam_pool_name
            if ipam_scope_id is None and not opts.urn:
                raise TypeError("Missing required property 'ipam_scope_id'")
            __props__.__dict__["ipam_scope_id"] = ipam_scope_id
            __props__.__dict__["pool_region_id"] = pool_region_id
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["source_ipam_pool_id"] = source_ipam_pool_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(IpamIpamPool, __self__).__init__(
            'alicloud:vpc/ipamIpamPool:IpamIpamPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation_default_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
            allocation_max_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
            allocation_min_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
            auto_import: Optional[pulumi.Input[_builtins.bool]] = None,
            clear_allocation_default_cidr_mask: Optional[pulumi.Input[_builtins.bool]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            ip_version: Optional[pulumi.Input[_builtins.str]] = None,
            ipam_pool_description: Optional[pulumi.Input[_builtins.str]] = None,
            ipam_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
            ipam_scope_id: Optional[pulumi.Input[_builtins.str]] = None,
            pool_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'IpamIpamPool':
        """
        Get an existing IpamIpamPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] allocation_default_cidr_mask: The default network mask assigned by the IPAM address pool.
               IPv4 network mask value range: **0 to 32** bits.
        :param pulumi.Input[_builtins.int] allocation_max_cidr_mask: The maximum network mask assigned by the IPAM address pool.
               IPv4 network mask value range: **0 to 32** bits.
        :param pulumi.Input[_builtins.int] allocation_min_cidr_mask: The minimum Network mask assigned by the IPAM address pool.
               IPv4 network mask value range: **0 to 32** bits.
        :param pulumi.Input[_builtins.bool] auto_import: Whether the automatic import function is enabled for the address pool.
        :param pulumi.Input[_builtins.bool] clear_allocation_default_cidr_mask: Whether to clear the default network mask of the IPAM address pool. Value:
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] ip_version: The IP protocol version. Currently, only `IPv4` is supported * *.
        :param pulumi.Input[_builtins.str] ipam_pool_description: The description of the IPAM address pool.
               It must be 2 to 256 characters in length and must start with an English letter or a Chinese character, but cannot start with 'http:// 'or 'https. If it is not filled in, it is empty. The default value is empty.
        :param pulumi.Input[_builtins.str] ipam_pool_name: The name of the resource.
        :param pulumi.Input[_builtins.str] ipam_scope_id: Ipam scope id.
        :param pulumi.Input[_builtins.str] pool_region_id: The effective region of the IPAM address pool.
        :param pulumi.Input[_builtins.str] region_id: The ID of the IPAM hosting region.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] source_ipam_pool_id: The instance ID of the source IPAM address pool.
               
               > **NOTE:**  If this parameter is not entered, the created address pool is the parent address pool.
        :param pulumi.Input[_builtins.str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpamIpamPoolState.__new__(_IpamIpamPoolState)

        __props__.__dict__["allocation_default_cidr_mask"] = allocation_default_cidr_mask
        __props__.__dict__["allocation_max_cidr_mask"] = allocation_max_cidr_mask
        __props__.__dict__["allocation_min_cidr_mask"] = allocation_min_cidr_mask
        __props__.__dict__["auto_import"] = auto_import
        __props__.__dict__["clear_allocation_default_cidr_mask"] = clear_allocation_default_cidr_mask
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["ipam_pool_description"] = ipam_pool_description
        __props__.__dict__["ipam_pool_name"] = ipam_pool_name
        __props__.__dict__["ipam_scope_id"] = ipam_scope_id
        __props__.__dict__["pool_region_id"] = pool_region_id
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["source_ipam_pool_id"] = source_ipam_pool_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return IpamIpamPool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allocationDefaultCidrMask")
    def allocation_default_cidr_mask(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The default network mask assigned by the IPAM address pool.
        IPv4 network mask value range: **0 to 32** bits.
        """
        return pulumi.get(self, "allocation_default_cidr_mask")

    @_builtins.property
    @pulumi.getter(name="allocationMaxCidrMask")
    def allocation_max_cidr_mask(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum network mask assigned by the IPAM address pool.
        IPv4 network mask value range: **0 to 32** bits.
        """
        return pulumi.get(self, "allocation_max_cidr_mask")

    @_builtins.property
    @pulumi.getter(name="allocationMinCidrMask")
    def allocation_min_cidr_mask(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The minimum Network mask assigned by the IPAM address pool.
        IPv4 network mask value range: **0 to 32** bits.
        """
        return pulumi.get(self, "allocation_min_cidr_mask")

    @_builtins.property
    @pulumi.getter(name="autoImport")
    def auto_import(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the automatic import function is enabled for the address pool.
        """
        return pulumi.get(self, "auto_import")

    @_builtins.property
    @pulumi.getter(name="clearAllocationDefaultCidrMask")
    def clear_allocation_default_cidr_mask(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to clear the default network mask of the IPAM address pool. Value:
        """
        return pulumi.get(self, "clear_allocation_default_cidr_mask")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[_builtins.str]:
        """
        The IP protocol version. Currently, only `IPv4` is supported * *.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="ipamPoolDescription")
    def ipam_pool_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the IPAM address pool.
        It must be 2 to 256 characters in length and must start with an English letter or a Chinese character, but cannot start with 'http:// 'or 'https. If it is not filled in, it is empty. The default value is empty.
        """
        return pulumi.get(self, "ipam_pool_description")

    @_builtins.property
    @pulumi.getter(name="ipamPoolName")
    def ipam_pool_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipam_pool_name")

    @_builtins.property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> pulumi.Output[_builtins.str]:
        """
        Ipam scope id.
        """
        return pulumi.get(self, "ipam_scope_id")

    @_builtins.property
    @pulumi.getter(name="poolRegionId")
    def pool_region_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The effective region of the IPAM address pool.
        """
        return pulumi.get(self, "pool_region_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the IPAM hosting region.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="sourceIpamPoolId")
    def source_ipam_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instance ID of the source IPAM address pool.

        > **NOTE:**  If this parameter is not entered, the created address pool is the parent address pool.
        """
        return pulumi.get(self, "source_ipam_pool_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

